#ifndef _CREATE_H
#define _CREATE_H
/* 

Copyright (C) 1991, 1992, 1993 by David B. Rosen.  All rights reserved.
Last Modified: 2 May 1993

type *ptr;

create(&ptr)
   Allocates a single object of the type of *ptr and sets ptr to point to it.

ncreate(&ptr,n) 
   Allocates an array of n objects of the type of *ptr and sets ptr to point 
   to 'em.

createvar(&ptr, fieldName, fieldElements)
   Allocates a single object of the type of *ptr and sets ptr to point to it.
   The object has a variable-length final field fieldName[], whose allocated
   length will be fieldElements.

destroy(&ptr)
   Deallocates memory allocated by the allocation functions above.
   and sets ptr = NULL.   ptr may already be NULL, in which case destroy()
   simply returns and has no effect.

*/

#include "protoTyp.h"

void _ncreate proto((void **, unsigned long)); /* avoid needing size_t */
void _destroy proto((void **));

#define create(ptrptr) ncreate((ptrptr),1)
#define ncreate(ptrptr,n) _ncreate((void **)(ptrptr), \
 (unsigned long)((n)*sizeof(**(ptrptr))))
#define createvar(ptrptr,fieldName,fieldElements) \
 _ncreate((void **)(ptrptr), (unsigned long)(sizeof(**(ptrptr)) + \
 (fieldElements)*sizeof((**(ptrptr)).fieldName[0]) ))

#define destroy(ptrptr) _destroy((void **)(ptrptr));

#endif /* _CREATE_H */
