#ifndef _CIND_H
#define _CIND_H

/* cindF -- C INDex using Float.
   Returns C Index of (predict[i],actual[i]), i = 0..n-1.  No side effects. 
   Each value actual[i] should have one of *two* distinct values (one "high",
   the other "low").   Returns a negative (or perhaps NaN-valued on some
   systems) constant if c index is undefined for various reasons.  (See names
   of constants below.)

*/

#include "const.h" /* define const if necessary */
#include "protoTyp.h"

extern float cindF proto((long n, const float *predict, const float *actual));

#define CIND_OVER_TWO_ACTUAL_VALS (-991.0)  /* too many distinct values */
#define CIND_ONE_ACTUAL_VAL (-992.0)  /* only one distinct value */
#define CIND_ZERO_ACTUAL_VALS (-993.0)  /* no values (n == 0) */
/* numeric values above subject to change of course! */

/*
Change log:

04 Mar 1993  DBR  Return 3 distinct exception constants;  tolerate and return
                  CIND_OVER_TWO_ACTUAL_VALS.
*/

#endif /* _CIND_H */
