/* Author: David B. Rosen
   Copyright (C) 1993 by the author and/or University of Nevada.
   All rights reserved. 

Change log:

10 May 1993  DBR  Remember to destroy() before exceptional return
04 Mar 1993  DBR  Return 3 distinct codes defined in .h.  Don't crash.

*/

/* system: */
#include "stdio.h"  /* SunOS 4.1.3 assert.h uses stderr but doesn't define! */
#include "assert.h"

/* general utility: */
#include "const.h" /* define const if necessary */
#include "do.h"
#include "create.h" /* needs create.c */

/* other: */
#include "rank.h" /* needs rank.c */

#include "cind.h" /* this */

float cindF(n, predict, actual)
     long n;
     const float *predict;
     const float *actual;
{
  float *rank;
  register long n1=0; /* will be number of actual==hi points */
  register float sum=0.0;  /* will be sum of ranks of actual==hi points */
  register float hi,lo;  /* the two possible values of actual */

  if (n==0) return CIND_ZERO_ACTUAL_VALS;

  hi=actual[0]; lo=actual[0];
  do0L(i, n,
       if (actual[i] != hi)
       { if (actual[i] < hi)
	   lo = actual[i];
         else
	   hi=actual[i];
	 break;
       }
  );

  if (hi==lo) return CIND_ONE_ACTUAL_VAL;

  /* create and calculate rank array: */
  ncreate(&rank, n);
  rankF(n, predict, rank);

  /* calculate sum, n1 */
  do0(i, n,
    if (actual[i] == hi)
    { n1++;
      sum += rank[i];
    } else if (actual[i]!=lo)
    { destroy(&rank);
      return CIND_OVER_TWO_ACTUAL_VALS;
    }
  );

  destroy(&rank);

  assert((n1 != 0) && (n-n1 != 0)); /* shouldn't happen because we already
				    found distinct hi and lo above */

  { register float mean = sum/n1;  /* mean rank of actual==hi points */
    return (mean - (n1 + 1)*.5 ) / (n - n1) ;
  }
}
