/* program cone.c   simulates fifth-order cone kinetics */


 timinc = .001;

 rhod = 0.0;
 gprt = 0.0;
 gpr2 = 0.0;
 gpr3 = 0.0;
 pdebase = .01;
 pde  = pdebase;
 cycg = .8;
 cond = 1.0;
 totcond = 20.0;
 ca        = .6;
 modca     = .2;
 kca       = .01;
 kdpde     = 1;
 cabuf     = 4;
 cycgbuf   = .5;
 loopgain  = 1;

 rhodgain = timinc * .1;
 ggain1   = timinc * 200.0;
 ggain2   = timinc * 200.0;
 ggain3   = timinc * 200.0;
/* ggain4   = timinc * 100.0; /* */
 pdegain  = timinc * 50.0 / cycgbuf;
 gcygain  = timinc * 20. / cycgbuf * loopgain;
 condgain = timinc * 500.0 * loopgain;
 gca      = timinc * 100. / cabuf * loopgain;
/* modcagain= timinc * 8. * loopgain; */

 rhoddec = 1 - (timinc * 100);
 dec1 = 1 - (timinc * 100);
 dec2 = 1 - (timinc * 100);
 dec3 = 1 - (timinc * 100);
/* dec4 = 1 - (timinc * 100); /* */
 pdedec = 1 - (timinc * 100);
 dec5 = 1 - (timinc * 300);
 capump =    timinc * 250 / cabuf;
 dec6 = 1 - (timinc * 30);

 startfl = 1;
 plotinc = 10;
 endexp = 1000;

 graph X max endexp min 0;
 graph Y max 2 min 0;
 graph Y max 2 min 0;
 graph Y max 2 min 0;
 graph Y max 2 min 0;
 graph Y max 2 min 0;
 graph Y max 2 min 0;
 graph init;

 for (i=0,j=plotinc; i<endexp; i++) {

  if (i == 500) rhod += 1000.0 * rhodgain;			/* */
/*  if (i > 400  && i <= 600) rhod += 100.0 * rhodgain;	/* */
/*  if (i <= 400) rhod += 1.0 * rhodgain;		/* */
  rhod += .50 * rhodgain;					/* */
/*  gpr3 += gpr2 * ggain3; /* */

  gprt += rhod * ggain1;
  gpr2 += gprt * ggain2;
  pde  += gpr2 * ggain3;
/*  pde = pde / (pde + kdpde);   */

  ca4  = ca * ca * ca * ca;
/*  modca += ca4 / (ca4 + kca) * modcagain; */
  modca = ca4 / (ca4 + kca);
  gcyc  = 1.0 - modca;

  cycg -= (pde + pdebase) * cycg / (cycg + 1.0) * pdegain;
  cycg += gcyc * gcygain;

  cond += cycg * cycg * cycg * (totcond - cond) / totcond * condgain;  /* */
  ca   += cond * gca;

  rhod *= rhoddec;
  gprt *= dec1;
  gpr2 *= dec2;
  gpr3 *= dec3;
  pde  =  pde * pdedec;
  ca   -= capump * ca / (ca + 1.0); 
  cond *= dec5;
/*  modca  *= dec6; */

  if (i >= 00) {
    if (startfl) {
	startfl = 0;
	startval = cond;
    };
  if (++j >= plotinc) {
	j = 0;

/*	graph (i,rhod,gprt,gpr2,pde+pdebase,0,0); /* */
	graph (i,cond,pde+pdebase,gcyc,cycg,ca,ca4); /* */

/*	printf ("%d %10.9g %8.5g %8.5g %8.5g %8.5g %8.5g %8.5g\n",
		i,cond,cond-startval,pde+pdebase,gcyc,cycg,ca,modca);
*/

   };
  };
 };


