/* symbol.c */

#include "nc.h"
#include "y.tab.h"

#define HASHSIZ 199                     /* prime number to make better hash */

static Symbol *hashtab[HASHSIZ] = {0};  /* symbol hash table */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
void free(...);

#ifdef __cplusplus
}
#endif

char *emalloc(unsigned int n);

/*---------------------------------------------------*/

void inithash(void)
{
   int i;

   for (i=0; i<HASHSIZ; i++) 
     hashtab[i] = 0;
}

/*---------------------------------------------------*/

int hashsym(char *s)
             

/* make disordered index of symbol name */

{
   int i;

   if (!s) return (0);
   for (i=0; *s; s++) i += *s;
   return (i%HASHSIZ); 
}

/*---------------------------------------------------*/

void hinstall (Symbol *sp)
              

/* Install a symbol in hash table */
/*  Uses "direct chaining". */

{
    int i;
    Symbol *spnt,*slast;

   sp->next = 0;
   i = hashsym(sp->name);               /* initial index into hashtab */ 
   if (!(spnt=hashtab[i]))              /* install directly in table */
      hashtab[i] = sp;
   else {                               /* otherwise, go to end of list */
      for (; spnt; spnt=spnt->next)     /* find last symbol */
          slast = spnt;    
      slast->next = sp;                 /* put new symbol at end of list */
   }
}

/*---------------------------------------------------*/

Symbol *lookup(char *s)       /* find s in symbol table, given its name */
                
{
        Symbol *sp;
        int i;
        
        i = hashsym(s);
        for (sp = hashtab[i]; sp != (Symbol *)0; sp = sp->next) {
                if (sp->name) {
			if (strcmp(sp->name, s) == 0)
                        return sp;
		}
        }
        return NULL;    /* 0 ==> not found */
}

/*---------------------------------------------------*/

Symbol *lookupnt(char *s, int t)       /* find s in symbol table, given its name and type */
                
	      
{
        Symbol *sp;
        int i;
        
        i = hashsym(s);
        for (sp = hashtab[i]; sp != (Symbol *)0; sp = sp->next) {
                if ((strcmp(sp->name, s) == 0) && (sp->type == t))
                        return sp;
        }
        return NULL;    /* 0 ==> not found */
}

/*---------------------------------------------------*/

double lookpv(char *s)        /* Find symbol in symbol table, given its name */
			/*  and return its value */
                
{
        Symbol *sp;
        int i;

        i = hashsym(s);
        for (sp = hashtab[i]; sp != (Symbol *)0; sp = sp->next) {
                if (sp->name)
                  if (strcmp(sp->name, s) == 0)
                        return sp->val;
        }
        fprintf (stderr,"lookupv: can't find '%s'\n",s);
        return 0;       /* not found ==> error, large num */
}

/*---------------------------------------------------*/

char *findsym(int num)              /* find a symbol's name, given its type */
                

{
        Symbol *sp;
        int i;

        for (i=0; i<HASHSIZ; i++) 
          for (sp = hashtab[i]; sp != (Symbol *)0; sp = sp->next)
                if (sp->type == num)
                        return sp->name;
        return 0;       /* 0 ==> not found */
}

/*---------------------------------------------------*/

Symbol *findarg(int num)            /* find an argument given its number */
                

{
        Symbol *sp;
        int i;

        for (i=0; i<HASHSIZ; i++) 
          for (sp = hashtab[i]; sp != (Symbol *)0; sp = sp->next)
                if (sp->argnum == num)
                        return sp;
        return 0;       /* 0 ==> not found */
}

/*---------------------------------------------------*/

void erasarg()                  /* erase all arguments after func def */

{                               /*  erase all local variables, too. */
        Symbol *sp,*oldsp,*next;
        int i;

        for (i=0; i<HASHSIZ; i++) 
          for (oldsp = sp = hashtab[i]; sp != (Symbol *)0; sp = next)
            {
                next = sp->next;
                if (sp->type == ARG || sp->type==LOCALVAR) 
                 {
                   if (sp == hashtab[i]) hashtab[i] = next;
                   else oldsp->next = next;
                   if (sp->name) free(sp->name);
                   free(sp);
                 }
                else
                   oldsp = sp; 
           }
}

/*---------------------------------------------------*/

Symbol *install(char *s, int t, double d)        /* install s in symbol table */
                
{
        Symbol *sp;
        char *emalloc();

        sp = (Symbol *) emalloc(sizeof(Symbol));
        sp->name = emalloc(strlen(s)+1); /* +1 for '\0' */
        strcpy(sp->name, s);
        sp->type = t;
        sp->vtype = 0;
        sp->val = d;
        hinstall (sp);
/*      fprintf (stderr,"'%s' %ld\n",s,sp);     /* */
        return sp;
}

/*---------------------------------------------------*/

void erasymb(void)

/* erase symbol table */

{
   Symbol *next,*spnt;
   int i;
   static int called=0;

 if (!called) inithash();
 else {
   for (i=0; i<HASHSIZ; i++) 
     for (spnt=hashtab[i]; spnt; ) {
       next = spnt->next;
       free (spnt->name);
       free (spnt);
       spnt = next;
     } 
     hashtab[i] = 0;
 }
}


/*---------------------------------------------------*/

double getval(Symbol *sym)              
                    

/* return value of symbol given a pointer to symbol */

{ 
        return sym->val;
}

/*---------------------------------------------------*/

void setval(Symbol *sym, double val, int vtyp)         

/* set value of symbol, given its pointer. */

{ 
    if (sym) {
        if (vtyp==STRING)
	  sym->str = (char*)(int)val;
	else
	  sym->val = val;
	if (vtyp) sym->vtype = (short int)vtyp;	/* if value type is set */
    }
}

        
