/* segment stimsub in program stim */

/* subroutines to make stimulus and blur it by a gaussian.
 Prints array on standard output */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>

#ifdef __cplusplus
}
#endif

#include "adef.h" 
#include "ncelem.h"
#include "ncomp.h"
#include "ncsub.h"
#include "stim.h"
#include "control.h"
#include "wave.h"

#if (CONVSIZE <= 256)			/* if 16 bit compiler */
#define BLURSIZE 89
#else
#define BLURSIZE 256
#endif

extern int convsize;			/* size of stimulus array */

#define DEBUG

#define SCALE 1
#define MPI	3.14159265358979323846264

float *blurarr = 0;
int blursize=0;
int blurmade=0;

double stimdia  = 10.0;
double stimydist = 10.0;
int stimhlp = 0;
extern int runyet;				/* dummy def for ncmain.c */

static int blurzero = 0;		/* =1 -> no blur */

double swavel[2]= {0.0,0.0};

recnod *reclist = 0;                    /* head of recnod list */
recnod *reclend = 0;                    /* tail of recnod list */
extern int reccum;                      /* number of recnod's  */

extern FILE *stimout;

#ifdef __cplusplus
extern "C" {
#endif
  extern double atof(const char *);
  extern double sqrt(double);
  extern double exp(double);
  extern double sin(double);
#ifdef __cplusplus
}
#endif

double getblur(int x, int y);

double readc(int arr, int x, int y);
double setvar(char *s);
char *emalloc(unsigned int n);
char *smalloc(unsigned int n);
void setc(int arr, double val);
void delout (recnod *npt, double delinten, double time);
void absout (recnod *npt, double inten, double time);
int inrect(double x, double y, double maxx, double minx, 
		double maxy, double miny);
void addc(int arr, int x, int y, double val);
int incirc(double x, double y, double circx, double circy, double rad);

/*------------------------------------*/

void printa (int arr)

/* debugging function */

{
  int x,y;
  
  printf ("# slice through center of sim array, along X-axis:\n");
  y = convsize / 2;  
  for (x=0; x<convsize; x++)
     printf ("# %-4d %-8g\n", x, readc (arr, x, y));
}


/*------------------------------------*/

void printb (void)

/* debugging function */

{
  int x,y;
  double getblur(int x, int y);
 
  y = 0;  
  for (x=0; x<blursize; x++)
     printf ("%d %g\n", x, getblur(x,y));
}


/*------------------------------------*/

void recpat(int array, double xoff, double yoff, double scale)

/* Calculate stimulus and background intensities for
   the list of photoreceptor stimulus nodes, given 
   the stimulus and background intensity arrays,
   and an optional (x,y) offset.

   Each stimulus node consists of:

        1) receptor number
        2) (x,y) position of receptor
        3) current receptor intensity
        4) receptor stimulus intensity
        5) receptor background intensity

   xoff and yoff move the stim and backgnd arrays.
*/
 
{
  int j,x,y,bmid,xmid,ymid,amid;
  recnod *npt;
  double blurval, arrtot, getblur(int x, int y);

#ifdef DEBUG
  if (debug & 1 && debugz & 1)
		 fprintf (stderr,"recpat: start, arr %d\n",array);
#endif

  if (scale==0.0) scale = 1.0;
  bmid = 0;					/* getblur has 0,0 center */
  amid = convsize / 2;				/* for 0,0     center */
/*  amid = 0;					/* for 128,128 center */
  for (npt=reclist,j=0; npt; npt=npt->next) {
    xmid = (int)(npt->xpos / scale + amid - bmid - xoff / scale);
    ymid = (int)(npt->ypos / scale + amid - bmid - yoff / scale);
    arrtot = 0.0;
    if (blurzero) 				/* no blur */
       arrtot = readc(array, xmid, ymid);   
    else {
      for (x= -(blursize-1); x<blursize; x++)
       for (y= -(blursize-1); y<blursize; y++) {
         blurval = getblur(x,y);
         arrtot += blurval * readc(array, xmid+x, ymid+y);   
      }
    }
#ifdef DEBUG
  if (debug & 2 && debugz & 1)
	fprintf (stderr,"recep %d %d %d: inten %g\n",
		npt->recnm1,npt->recnm2,npt->recnm3,arrtot);
#endif
    if (array) npt->backgnd = arrtot;
    else       npt->stim    = arrtot;
    npt->wavel = swavel[array];
    if (stimhlp) {
        fprintf (stderr,"s");
        if (++j >= 50) {
            fprintf (stderr,"\n");
            j=0;
        }
    }
  }
  if (stimhlp) fprintf (stderr,"\n");
#ifdef DEBUG
  if (debug & 1 && debugz & 1)
		 fprintf (stderr,"recpat: end.\n");
#endif
}

/*------------------------------------*/

void recback(int array, double inten, double wavel)
             
/* set receptor nodes and array to a diffuse
   background intensity. */
 
{
  recnod *npt;
  int j;

  swavel[array] = wavel;
  for (npt=reclist,j=0; npt; npt=npt->next) {
    if (array) npt->backgnd = inten;
    else       npt->stim    = inten;
    npt->wavel = wavel;
    if (stimhlp) {
        fprintf (stderr,"b");
        if (++j >= 50) {
            fprintf (stderr,"\n");
            j=0;
        }
    }
  }
  if (stimhlp) fprintf (stderr,"\n");
  setc (array,inten);
}

/*------------------------------------*/

void stimlist(double delratio, double time)
                   
/* Make a delta action list for stimulus from the list
   of receptor stimulus nodes.
   An action is an individual event at a receptor
   which consists of:

        1) time of event
        2) receptor number
        3) receptor intensity

    This list is used by "nc" to define the stimuli
    for the photoreceptors during a modeling run.
    It is output to the file "stimout", which may be "stdout".
*/

{
  recnod *npt;
  double newval;

  if (delratio < -1.0 || delratio > 1.0) {
        fprintf (stderr,"stimulus ratio out of range: %g\n",delratio);
        delratio = 0.0;
  }
  for (npt=reclist; npt; npt=npt->next) {
    newval = delratio * npt->stim;
    delout (npt,newval,time);
  }
}

/*------------------------------------*/

void abslist(double ratio, double time)

/* Make an absolute action list for stimulus from the list
   of receptor stimulus nodes.
   An action is an individual event at a receptor
   which consists of:

        1) time of event
        2) receptor number
        3) receptor intensity

    This list is used by "nc" to define the stimuli
    for the photoreceptors during a modeling run.
    It is output to the file "stimout", which may be "stdout".
*/

{
  recnod *npt;
  double newval;

  if (ratio < 0.0 || ratio > 1.0) {
        fprintf (stderr,"stimulus ratio out of range: %g\n",ratio);
        ratio = 1.0;
  }
  for (npt=reclist; npt; npt=npt->next) {
    newval = ratio * npt->stim + (1-ratio) * npt->backgnd;
    absout (npt,newval,time);
  }
}

/*------------------------------------*/

void stcomment (void)
{
 fprintf(stimout,"#time  node              intensity   wavel   action\n");
}

/*------------------------------------*/

void stimfout(double time, recnod *npt, double inten, char *action)
                      
/* Make one like of the stimulus file. */
/* This makes one action at one time for one node. */
/* Make NULLNOD (-32768) into a more elegant number */
/*  to show unused node dimensions in file. */

{
  int node1,node2,node3;

  node1 = npt->recnm1;
  node2 = npt->recnm2;
  node3 = npt->recnm3;
  if (node3 == NULLNOD) node3 = NULND;
  if (node2 == NULLNOD) node2 = NULND;
  if (node1 == NULLNOD) node1 = NULND;

     fprintf(stimout,"%-6.4g %-5d %-5d %-5d %-12.5g %-5g  %s\n",
			time, node1,node2,node3,inten,npt->wavel,action);
     fflush (stimout);
}

/*------------------------------------*/

void absout (recnod *npt, double inten, double time)

/* send out a stimulus action for a receptor node
    if the change is greater than 1e-3.
 */

{
   double oldval,delta;

 npt->curval = inten;
 oldval = npt->actual;
 if (oldval == 0.0) delta = npt->curval;
 else delta = (npt->curval - oldval) / oldval;  /* look for change */
 if (abs(delta) > 1e-3) {                       /* save and output new val */
     npt->actual = npt->curval;
     stimfout(time,npt,inten,"abs");
 }
}

/*------------------------------------*/

void delout (recnod *npt, double delinten, double time)
               
/* Send out a delta stimulus action for a receptor node */

{
 if (delinten == 0.0) return;
 npt->curval += delinten;
 npt->actual = npt->curval;
 stimfout(time,npt,delinten,"del");
}

/*------------------------------------*/

void vclist (double time, int node1, int node2, int node3, double inten, 
		double wavel, char *action)
{
  recnod x;

 x.recnm1 = node1;
 x.recnm2 = node2;
 x.recnm3 = node3;
 x.wavel = wavel;
 stimfout(time,&x,inten,action);
}

/*------------------------------------*/

double gauss(int x, int y, int midpnt, double rad)
                                        /* size is odd so midpnt is middle */
/* Return a gaussian function of (x,y),
   centered in an array of given size. */

{
   double distsq,tempx,tempy;

   tempx = (double)(x - midpnt) * SCALE;
   tempy = (double)(y - midpnt) * SCALE;
   distsq = tempx*tempx + tempy*tempy;
   return (exp(-(distsq) / (rad*rad)));
}

/*------------------------------------*/

double pointsp(int x, int y, int midpnt)
                                        /* size is odd so midpnt is middle */

/* Return the optical point-spread function of 
   the cat eye, according to Robson and Enroth-Cugell (1978).

   I (r) = 1 / (1 + (r/k)^(5/2))

   where r = 4.4 um matches a Gaussian of radius 6.
   The pointspread is normalized to equal volume 
   by multiplying by PFACT.
*/

#define PFACT 0.90
#define RAD 4.4

{
   double tempx,tempy,radius,sqrt(double);
   double k, tempk, tempksq;

   tempx = (double)(x - midpnt) * SCALE;
   tempy = (double)(y - midpnt) * SCALE;
   radius = sqrt(tempx*tempx + tempy*tempy); 
   k = RAD; 
   tempk = radius/k;
   tempksq = tempk * tempk;

   return (PFACT * 1.0 / (1.0 + tempksq * sqrt(tempk)));
}

/*------------------------------------*/

void makblur(double rad, double scale)

/* make the blurring function array */
/*  Determine the size of the array automatically.
    Make it 5 times the standard deviation of the 
    Gaussian blur function.  By this point, the Gaussian 
    function is down to 1e-11 (hopefully safe). 
    Revert to predetermined size if running on a small machine.
*/

{
   int i,j,irow;
   double g,h,gausstot,gauss(int x, int y, int midpnt, double rad),pointsp(int x, int y, int midpnt);
   static int bsize=0;
   extern float *blurarr;
  
  if (!blurmade) { 
     blursize = (int)(rad/scale * 5);	/* make array = 5 std. deviations */
     if (CONVSIZE<=256) blursize = BLURSIZE;
     bsize = sizeof(float) * blursize * blursize; 
     if (!(blurarr = (float *)smalloc(bsize))) {
	fprintf (stderr,"makblur: can't allocate blur array, size %d\n",
					bsize);
        return;
     }
     blurmade = 1;
  }

  if (rad==0.0) {
        blurzero = 1; 
        return;
  }
 
  if (scale==0.0) scale = 1.0;
  scatter = (int)setvar("scatter");
  for (i=0; i<blursize; i++) {                  /* make 1/8 of square */
    irow = i*blursize;
    for (j=0; j<=i; j++) {
      g = gauss(i,j,0,rad/scale);
      if (scatter) {
         h = pointsp(i,j,0);
         if (h > g) g = h;
      }
      if (g < 1e-15) g = 0.0;
      *(blurarr+irow+j) = g;
    }
  }

  for (i=0; i<blursize; i++) {                  /* copy into quadrant */
    irow = i*blursize;
    for (j=0; j<i; j++) {
      *(blurarr+j*blursize+i) = *(blurarr+irow+j);
    }
  }                                              /* prev version copied into */
                                                /*  full plane; now we don't */
  gausstot = 0.0;
  for (i=0; i<blursize; i++) {                    /* total the quadrant */
    irow = i*blursize;
    for (j=1; j<blursize; j++)                  /*  leave out the j=0 line */
      gausstot += *(blurarr+irow+j);
  }

  gausstot *= 4.0;                              /* four quadrants = plane */
  gausstot += *(blurarr+0+0);                   /* add the center */

/* fprintf (stderr,"gausstot %g blursize %d\n",gausstot,blursize); /* */

  if (gausstot <= 0.0) gausstot = 1;            /* normalize to vol = 1 */
  for (i=0; i<blursize; i++) {
    irow = i*blursize;
    for (j=0; j<blursize; j++)
      *(blurarr+irow+j) /= gausstot;
  }

}

/*------------------------------------*/

double getblur(int x, int y)
           
/* The blur array is stored in a one quadrant
   look-up table. 
   Map x and y into this quadrant, then return
   with the blur value. */

{
 if (x < 0) x = -x;
 if (x >= blursize) x = blursize-1;
 if (y < 0) y = -y;
 if (y >= blursize) y = blursize-1;
 if (!blurmade) {
     fprintf (stderr,"getblur: blur array not made yet\n");
     return (0.0);
 }
 return ((double) *(blurarr+x*blursize+y));

}

/*------------------------------------*/

void makrect(int arr, double width, double length, double xoff, double yoff, 
		double scale, double inten, double wavel)

/* Make a rectangle in the stimulus array. 
   If it is a narrow bar, there may be some sampling
   error in the array.  For usual amounts of blur,
   this can be corrected by finding the ratio of the
   wanted to actual bar width and weighting the intensity
   by this factor.  Must make sure to find actual smallest
   width (not necessarily the stated "width", could be "length").
*/
{
   int x,y;
   double halfx,halfy,xcenter,ycenter;
   double totrect,weight,smalldim;
   int xmax,xmin,ymax,ymin;

  if (scale==0.0) scale = 1.0;
  swavel[arr] = wavel;
  xcenter =  xoff / scale + convsize/2;
  ycenter =  yoff / scale + convsize/2;
  halfx = width / 2;
  halfy = length / 2;

  xmax = (int)(xcenter + halfx);	/* actual dimensions limited to array */
  xmax = min(xmax,convsize); 
  xmin = (int)(xcenter - halfx);
  xmin = max(xmin,0); 
  ymax = (int)(ycenter + halfy);
  ymax = min(ymax,convsize); 
  ymin = (int)(ycenter - halfy);
  ymin = max(ymin,0); 
  smalldim = min(width,length);
 
			/* before making rect, add up its area */

  totrect = 0.0;
  for (x=xmin; x<xmax; x++) {
    for (y=ymin; y<ymax; y++) {
       if (inrect((double)x, (double)y, xcenter+halfx, xcenter-halfx,
                        ycenter+halfy, ycenter-halfy))
	totrect++;
    }
  }
  if (totrect==0.0) {
     if (width==0.0 || length==0.0) {
          fprintf (stderr,"Stim: Error: rect has zero width\n");
     }
     else fprintf (stderr,"Stim: Error: rect is outside stimulus array\n");
     return;
  }
			/* then weight rect to correct its intensity */

  if (smalldim > 20) weight = 1.0;
  else weight = (xmax-xmin) * (ymax-ymin) / totrect;

  inten *= weight;
  for (x=xmin; x<xmax; x++) {
    for (y=ymin; y<ymax; y++) {
       if (inrect((double)x, (double)y, xcenter+halfx, xcenter-halfx,
                        ycenter+halfy, ycenter-halfy))
          addc (arr, x, y, inten);
    }
  }
}


/*------------------------------------*/

void maksine(int arr, double period, double xmin, double xmax, 
		double ymin, double ymax, double toff, double orient,
		double xoff, double yoff, double scale, 
		double inten, double contrast, double wavel)

/* Make a sine wave in the stimulus array.  */

{
   int x,y;
   double xcenter,ycenter;
   double theta,sintheta,orientrad,coso,sino;
   double xr,yr;

   if (scale==0.0) scale = 1.0;
   swavel[arr] = wavel;

   xcenter =  xoff / scale + convsize/2;
   xmin /= scale;
   xmax /= scale;
   period /= scale;
   xmin += xcenter;
   xmax += xcenter;

   ycenter =  yoff / scale + convsize/2;
   ymin /= scale;
   ymax /= scale;
   ymin += ycenter;
   ymax += ycenter;

   if (ymin==ymax) {				/* set default y limits */
        ymin = 0;			
        ymax = convsize-1;
   }
   if (ymin<0) ymin = 0;			
   if (ymax>=convsize) ymax = convsize-1;

   if (xmin<0) xmin = 0;
   if (xmax>=convsize) xmax = convsize-1;

   orientrad = 2 * MPI * orient;
   coso = cos(orientrad);
   sino = sin(orientrad);
   for (x=(int)xmin; x<=(int)xmax; x++) {
     for (y=(int)ymin; y<=(int)ymax; y++) {
       xr = (x-xcenter)*coso - (y-ycenter)*sino + xcenter;
       theta = (xr-((int)xmin))/period+toff;
       sintheta = sin(2*MPI * theta);
       addc (arr, x, y, inten * (1 + contrast * sintheta));
     }
   }
  if (debug & 4 && debugz & 32)
    printa(arr); 		/* print slice through center for debugging */
}  

/*------------------------------------*/

void makspot(int arr, double dia, double xoff, double yoff, 
		double scale, double inten, double wavel)

/* Make a spot in the stimulus array.
   If it is a small spot, there may be some sampling
   error in the array.  If blur is larger than the spot 
   size (usually true for a small spot), this error can be 
   corrected by finding the ratio of the wanted to actual 
   spot area and weighting the intensity by this factor.
*/

{
   int x,y;
   double xcenter,ycenter,radius,totspot,weight;
   double xmax,xmin,ymax,ymin;

  if (scale==0.0) scale = 1.0;
  swavel[arr] = wavel;
  radius = dia / scale / 2.0;
  xcenter =  xoff / scale + convsize/2;
  ycenter =  yoff / scale + convsize/2;
  xmax = xcenter + radius + 1;
  xmax = min(xmax,convsize); 
  xmin = xcenter - radius - 1;
  xmin = max(xmin,0); 
  ymax = ycenter + radius + 1;
  ymax = min(ymax,convsize); 
  ymin = ycenter - radius - 1;
  ymin = max(ymin,0); 

			/* before making spot, add up its area */

  totspot = 0;
  for (x=(int)xmin; x<(int)xmax; x++) {
    for (y=(int)ymin; y<(int)ymax; y++) {
      if (incirc((double)x, (double)y, xcenter, ycenter, radius))
        totspot++;
    }
  }
  if (totspot==0.0) {
     if (dia==0.0) {
          fprintf (stderr,"Stim: Error: spot has zero diameter\n");
     }
     else fprintf (stderr,"Stim: Error: spot is outside stimulus array\n");
     return;
  }

  if (dia > 20) weight = 1.0;   /* weight spot to correct its intensity */
  else          weight = MPI * radius * radius / totspot;
  inten *= weight;
  for (x=(int)xmin; x<(int)xmax; x++) {
    for (y=(int)ymin; y<(int)ymax; y++) {
      if (incirc((double)x, (double)y, xcenter, ycenter, radius))
        addc (arr, x, y, inten);
    }
  }
}

/*------------------------------------*/

int incirc(double x, double y, double circx, double circy, double rad)

/* calculate whether point is inside a circle
   of given radius.
*/

{
   double tempx, tempy, sqrt(double);
   int inside;

   tempx = circx - x;
   tempy = circy - y;
   inside = (sqrt(tempx*tempx + tempy*tempy) <= rad);
   return inside;
}

/*------------------------------------*/

int inrect(double x, double y, double maxx, double minx, 
		double maxy, double miny)

/* calculate whether point is inside a rectangle
   of given limits.
*/

{
   int inside;

/*   if (maxx == minx) return 0; /* */
/*   if (maxy == miny) return 0; /* */
   inside = ((minx <= x) && (x <= maxx) && (miny <= y) && (y <= maxy));
   return inside;
}

/*------------------------------------*/

recnod *maksnod(void)

/* make a new stimulus and link it to the list. */

{
    recnod *rpnt;

  if ((rpnt=(recnod *)emalloc(sizeof(recnod))) == NULL) {
     fprintf (stderr,"no space left for recnod %d\n", reccum+1);
     return (NULL);  
  }
  rpnt->next = NULL;
  if (!reclist) reclist = rpnt;         /* save head if first synap */
  if (reclend)
    reclend->next = rpnt;
  reclend = rpnt;

  reccum++;                     /* increment total */
  return (rpnt); 
}

/*------------------------------------*/

/* dummy declarations */

/* in "initchan.cc" */

chanpar natypes[NCHANTYP];
chanpar ktypes[NCHANTYP];
chanpar catypes[NCHANTYP];

void initchan(void) {}

void narate(double v, int typ) {}

void krate(double v, int typ) {}
void carate(double v, int typ) {}
void maktables(double timestep) {}

double akcacalc(double v, double ca, double tau, double d1, double k1) 
	{ return 0.0;}
double bkcacalc(double v, double ca, double tau, double d2, double k2) 
	{ return 0.0;}

double alpham,betam,alphah,betah;
double alphan,betan,alphad,betad,alphac,betac;

/* in "ncomp.cc" */

void dochani(sschan *chpnt, double critc) {}
 
/* in "ncplot.cc" */

void mplot(double yval, double xval, int totplots, int plotpos) {}
void disperr(void) {}
void initpl(int charind) {}
void plotinit(int totplots) {}
void plotrst(int totplots) {}
void plotpen(int pen, int nplot) {}
void plotchar(int lchar, int mode, int nplot) {}
void plotcsiz(double size, int nplot) {}


/* in "ncsub.cc" */

double record (int cnod1, int cnod2, int cnod3, int pmod)
	 {return 0.0;}

/* in "ncrot.c" */

void setrot(double xrot, double yrot, double zrot,
                double xcent, double ycent, double zcent,
                double rxcent, double rycent, double rzcent, double scal)
{}

/* in "ncdisp.cc" */

void ncdisp(int n1a, int n1b, int n1c, int elemtype, int exceptype,
        int na, int nb, int nc, int color, double dscale, int hide, int excl)
{}

void ncdispc(int n1a, int n1b, int n1c,
        int n2a, int n2b, int n2c, int elemtype, int exceptype,
        int na, int nb, int nc, int color, double dscale, int hide)
{}

void ncdispn(int n1a, int n1b, int n1c,
        int n2a, int n2b, int n2c, int elemtype, int exceptype,
        int na, int nb, int nc, int color, double dscale, int hide, int excl)
{}

void ncdispe (int elemnum, int color, double dscale, int hide)
{}

void drcalib(double x, double y, double len, int color)
{}





