

#include "stim.h"

int reccum = 0;
int recepnode = 0;                      /* receptor node from conn() */
int recepn2 = 0;
int recepn3 = 0;

int stimfflg = 0;

FILE *stimout=stdout;           /* stimulus output file */


/*------------------------------------------*/

initmak()       /* in "ncmak.c" */

/* make ready for new branch data to be read in
*/

{
reccum = 0;                     /* reset number of receptors */
initc(2);                       /* make two 256 * 256 arrays */
}

/*------------------------------------------*/

recept()

/* read in data from rod or cone statement:

                1       x position
                2       y position  (optional)
*/

{
  datum d1,d2;
  int i,narg;
  Symbol *param;
  recnod *maksnod(),*npnt;

  param = (Symbol *)*pc++;                      /* receptor type */
  narg  = (int)*pc++;
  d2.val = 0;
  if (narg > 1) {
     d2 = popm();                               /* read in y loc */
  }
  d1 = popm();                                  /* x loc */

  npnt = maksnod();
  npnt->recnm1 = recepnode;             /* recepnode is defined by conn() */
  npnt->recnm2 = recepn2;
  npnt->recnm3 = recepn3;
  npnt->xpos = (int)d1.val;
  npnt->ypos = (int)d2.val;
}

/*------------------------------------------*/

/* variables for xstim below: */

static double start=0.0;
static double dur=0.1;
static double wavel=1.0;
static double inten=100.0;
static double backgr=10.0;
static double blurrad=11.0;
static double speriod = 20;
static double contrast = 0.5;
static double tfreq = 2.0;

static int stype,rnum1,rnum2,rnum3;
static int xstm=0, ystm=0;
static int xcent=0, ycent=0;		/* center coords for stim array */
static int stimflag=0;                  /* start stimulus */
static int blurfl=0;                    /* blur array done */

extern int stimdia;                     /* defined in "stimsub.c" */
extern int stimydist;                   /* defined in "stimsub.c" */

xstim()

/* read in data from stimulus statement:
*/

{
  datum d1,d2,d3;
  Symbol *param;
  int stimarr, backarr;
  int narg, spec;
  FILE *ftemp,*fopen();
  char stimfile[80];

  param  = (Symbol *)*pc++;
  
  switch (param->type)
   {
    case BAR: 
    case SPOT:  d1 = popm();
                stimdia   = d1.val;
                stype = param->type; 
                break;
    case SINE:  d1 = popm();
                speriod   = d1.val;
                stype = param->type; 
                break;
    case RECT:
		narg = (int)*pc++;
  		if (narg > 1) d2 = popm();
		else d2.val = 1.0;
    		d1 = popm();
		stimdia = d1.val;
		stimydist = d2.val;
		stype = param->type; 
		break;
    case NODE:
                narg = (int)*pc++;
                if (narg > 2) d3 = popm();
                else d3.val = 0.0;
                if (narg > 1) d2 = popm();
                else d2.val = 0.0;
                d1 = popm();
                rnum1 = d1.val;                 /* get node number */
                rnum2 = d2.val;
                rnum3 = d3.val;
                break;
    case ROD: 
    case CONE:  narg = (int) *pc++;
                if (narg > 2) d3 = popm();
                else d3.val = 0.0;
                if (narg > 1) d2 = popm();
                else d2.val = 0.0;
                d1 = popm();
                rnum1     = d1.val;
                rnum2     = d2.val;
                rnum3     = d3.val;
                stype = param->type; 
                break;
    case LOC:   narg  = (int)*pc++;
                if (narg > 0) {
                  if (narg > 1) {
                    d2 = popm();                /* read in y loc */
                    ystm = d2.val;
                  }
                d1 = popm();
                xstm = d1.val;
                }
                break;
    case CENTER:narg  = (int)*pc++;
                if (narg > 0) {
                  if (narg > 1) {
                    d2 = popm();                /* read in y center */
                    ycent = d2.val;
                  }
                d1 = popm();
                xcent = d1.val;
                }
                break;
    case START: d1 = popm();
                start = d1.val;
                stimflag = 1;
                break;
    case DUR:   d1 = popm();
                dur   = d1.val;
                break;
    case CONTRAST:  d1 = popm();
                contrast   = d1.val;
                break;
    case TFREQ:   d1 = popm();
                tfreq = d1.val;
                break;
    case WAVEL: spec = (int)*pc++;
		switch (spec) {
		  case 0: 
		    d1 = popm();
		    wavel = d1.val;
		    break;
		  case SUN:
                    wavel = 0;
                    break;
		  case XENON:
                    wavel = 1;
                    break;
		}
		break;
    case INTEN: d1 = popm();
                inten = d1.val;
                break;

    case BACKGR:d1 = popm();
                backgr = d1.val;
                backarr = 1;
                stype = param->type; 
                break;

    case VCLAMP:
    case CCLAMP:d1 = popm();
                inten = d1.val;
                stype = param->type; 
                break;

    case BLUR:  d1 = popm();
                blurrad = d1.val/2;
                break;
    case SFILE: if (*stimfile) fclose (stimout);
                *stimfile = 0;
                strcpy (stimfile,(char *)*pc++);  /* copy filename */
                if (hlp) fprintf (stderr,"stimfil '%s'\n",stimfile);
                if (*stimfile) {
                        stimfflg = 1; 
                        if ((ftemp=fopen(stimfile,"w")) == NULL) {
                          fprintf (stderr,"Can't open file '%s'\n",stimfile);
                          break;
                        }
                        else stimout = ftemp;
                }
                else {
                        stimfflg = 0;
                        stimout = stdout;
                }
                break;

    case STIM:  
        stimarr = 0;
        backarr = 1;
        
        switch (stype) {

        case 0:
        default: break;


        case VCLAMP:
                vclist(start,rnum1,rnum2,rnum3,inten,wavel,"vcl");
                vclist(start+dur,rnum1,rnum2,rnum3,inten,wavel,"eff");
                break;

        case CCLAMP:
                vclist(start,rnum1,rnum2,rnum3,inten,wavel,"ccl");
                vclist(start+dur,rnum1,rnum2,rnum3,inten,wavel,"iof");
                break;


        case BACKGR:
                  recback(stimarr,0.0,wavel);   /* zero recept stim inten */
                  recback(backarr,backgr,wavel); /* set recept backgr inten */
                  abslist(0.0, start);          /* make action list */
                  break;
        case ROD:
        case CONE: 				/* flash one receptor */
                flashrec(rnum1,rnum2,rnum3, inten,wavel,start);
                flashrec(rnum1,rnum2,rnum3,-inten,wavel,start+dur); 
                break;

        case BAR:
                if (!blurfl) {
                        makblur(blurrad);       /* make a blurring function */
                        blurfl = 1;
                }
		makrect(stimarr, stimdia, CONVSIZE,xstm-xcent,ystm-ycent,
							inten,wavel);
                if (stimflag) {
                  stimflag = 0;
                  recpat(stimarr,xcent,ycent);  /* set recept inten */
                  stimlist(1.0, start);         /* make an action list */
                  stimlist(-1.0, start+dur);
                  recback(stimarr,0.0,1.0);   /* zero recept stim inten */
                  recback(backarr,backgr,1.0);/* set recept backgr inten */
                }
                break;

        case RECT:
                if (!blurfl) {
                        makblur(blurrad);       /* make a blurring function */
                        blurfl = 1;
                }
		makrect(stimarr, stimdia, stimydist,xstm-xcent,ystm-ycent,
							inten,wavel);
                if (stimflag) {
                  stimflag = 0;
                  recpat(stimarr,xcent,ycent);  /* set recept inten */
                  stimlist(1.0, start);         /* make an action list */
                  stimlist(-1.0, start+dur);
                  recback(stimarr,0.0,1.0);   /* zero recept stim inten */
                  recback(backarr,backgr,1.0);/* set recept backgr inten */
                }
                break;

        case SPOT:
                if (!blurfl) {
                        makblur(blurrad);       /* make a blurring function */
                        blurfl = 1;
                }
                makspot(stimarr, stimdia,xstm-xcent,ystm-ycent,inten,wavel);
                if (stimflag) {
                  stimflag = 0;
                  recpat(stimarr,xcent,ycent);  /* set recept inten */
                  stimlist(1.0, start); 	/* make an action list */
                  stimlist(-1.0, start+dur);
                  recback(stimarr,0.0,1.0);     /* zero recept stim inten */
                  recback(backarr,backgr,1.0);  /* set recept backgr inten */
                }
                break;

        case SINE:
          if (!blurfl) {
                makblur(blurrad);       /* make a blurring function */
                blurfl = 1;
          }
					/* xmin is xstm; xmax is ystm. */
          if (speriod <= 0.0) speriod = 1;   /* spatial period from user */
          if (tfreq) {		/* drifting grating */
                 double timres,tperiod,tincr,stime;

            timres = .01;		/* time resolution: fractional */
            tperiod = 1.0 / tfreq;	/* temporal period */
            tincr = timres * tperiod;     /* time incr = time res * t period */
            for (stime=start; stime<(start+dur-tincr); stime += tincr) {
              maksine(stimarr,speriod,xstm+(stime-start)/tincr,ystm,
					-xcent,-ycent,inten,wavel); 
              recpat(stimarr,xcent,ycent);  /* set recept inten */
              stimlist(1.0, stime); 	    /* make an action list */
              stimlist(-1.0, stime+tincr);
              recback(stimarr,0.0,1.0);     /* zero recept stim inten */
              recback(backarr,backgr,1.0);  /* set recept backgr inten */

            }   /* for (stime= ; ; ) */
          }   /* if (drate) */
          else {		/* static grating */
              maksine(stimarr,speriod,xstm,ystm,-xcent,-ycent,inten,wavel); 

              if (stimflag) {			/* if start val is given */
                 stimflag = 0;
                 recpat(stimarr,xcent,ycent);  /* set recept inten */
                 stimlist(1.0, start); 	/* make an action list */
                 stimlist(-1.0, start+dur);
                 recback(stimarr,0.0,1.0);     /* zero recept stim inten */
                 recback(backarr,backgr,1.0);  /* set recept backgr inten */
              }
          } /* else */
	  break;

        }       /* switch (stype) */

        break;

  }     /* switch */
}

/*------------------------------------------*/

modrun()

{
  datum d1,d2;
  Symbol *mtyp;
 
  mtyp = (Symbol *)*pc++;
  varcopy();
  findconnect();
  switch (mtyp->type)
    {

     case RUN:  
/*              actrun(); */
                break;
     case STEP:  
                d1 = popm();
/*              actrun(d1.val); */
                break;
    
    }

}

/*------------------------------------*/

