/* Module prcomp in Program nc */

/* displays compartment list */

/*        Feb 91                  R.G. Smith */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <math.h>

#ifdef __cplusplus
}
#endif

#include "nc.h"
#include "y.tab.h"
#include "ncomp.h"
#include "ncelem.h"
#include "ncsub.h"
#include "control.h"

extern comp *compnt;
extern conn *connpnt;

extern double xrot;
extern double yrot;
extern double zrot;
extern double rxcent,rycent,rzcent;
extern double dxcent,dycent,dzcent;
extern double dsize;

int testlin(int nprint);
void setrot(double xrot, double yrot, double zrot, 
		double xcent, double ycent, double zcent, 
		double rxcent, double rycent, double rzcent, double scal);
void drcomp(double xloc, double yloc, double zloc, double dia);
void drcconn (double x1, double y1, double z1, 
		double x2, double y2, double z2);
conn *printconns(comp *pnt, int nprint);
char *findsym(int);
comp *othercomp (comp *pnt,conn *cpnt);
char *prnode (int n1, int n2, int n3); 

/*------------------------------------*/

void prcomp(void)

/* print a list of all compartments, with node number,
    capacitances, and resistances. Label receptors "rec" and
    the node number of the receptor.
*/
  
{
   comp *pnt;
   conn *cpnt;
   conlst *lpnt;
   node *npnt;
   int n,nprint,missing;
   double dia,rm;


if (debug & 1) fprintf (stderr,"prcomp start prmap %d disp %d\n",prmap,disp);

if (prmap&PCOND) printf
 ("# comp  node     nodrm       nodcap        connections (siemens)\n");
else if (prmap&PCOMP) printf
 ("# comp  node     equiv comp dia, rm        connections (ohms)\n");

if (prmap&(PCOND|PCOMP)) 
 for (pnt=compnt; pnt; pnt=pnt->next) {
   printf("#c %-4d ",pnt->num);

						/* print the nodes */
  for (n=0,lpnt=pnt->nodlst; lpnt; lpnt=lpnt->next,n++) {
        if (n) printf ("\n#c %-4d ",pnt->num);    /* second node and up */
        if (lpnt->conpnt) npnt = (node *)lpnt->conpnt;
        if (npnt->nodenm3 > NULLNOD)
		 printf ("%-2d %-2d %-2d",
			npnt->nodenm1,npnt->nodenm2,npnt->nodenm3);
        else if (npnt->nodenm2 > NULLNOD)
		 printf ("%-4d %-3d",npnt->nodenm1,npnt->nodenm2);
	else
                 printf ("%-4d    ",npnt->nodenm1);
  }

  if (!n) printf ("        ");
                                                /*   print capac, resist */
  if (dcap==0) dcap = 1e-6;			/* assume 1 uf / cm2 */
  dia = 2. * sqrt(pnt->cap/(dcap*4*MPI)) * 1e4; /* find sphere dia from cap */
  if ((rm=pnt->rm)==0) rm = 1e-20;
  rm  = MPI * dia * dia / (rm * 1e8);
  missing = (pnt->rm > (LARGERES * .9) || pnt->cap < SMALLCAP * 1.1);

   if (missing) {
     if (prmap&PCOMP) 
       printf ("MISSING dia %-5.3g Rm %-6g ",dia,rm); /* sphere printout*/
     else
      printf(" MISSING gm %-8.3g cap %-8.3g  ",pnt->rm,pnt->cap);/* standard printout */
   }
    else {
     if (prmap&PCOMP) 
       printf (" sphere dia %-5.3g Rm %-6g ",dia,rm); /* sphere printout*/
     else
      printf(" gm %-8.3g cap %-8.3g  ",pnt->rm,pnt->cap);/* standard printout */
     }
   nprint = 3;                                  /* things printed on line */
   cpnt = printconns(pnt,nprint);
   printf ("\n");
   }
  fflush (stdout);
  if (debug & 1) fprintf (stderr,"prcomp end\n");
}

/*------------------------------------*/

conn *printconns(comp *pnt, int nprint)

/* Print the connections to a compartment.  */

{
   conlst *lpnt;
   comp *pnt2;
   conn *cpnt;
   double cond,ri;

   for (lpnt=pnt->clst; lpnt; lpnt=lpnt->next) {  /* find connections */
      if (!(cpnt=lpnt->conpnt)) continue;
      pnt2 = cpnt->comp1;
      switch (cpnt->ctype) {
        case ROD:
                nprint = testlin(nprint);
                if (((recep *)cpnt)->recnm2 != NULLNOD)
		  printf ("rod %-4d %-4d   ",((recep *)cpnt)->recnm1,
						 ((recep *)cpnt)->recnm2);
		else
                  printf ("rod %-4d        ",((recep *)cpnt)->recnm1);
                break;
        case CONE:
                nprint = testlin(nprint);
                if (((recep *)cpnt)->recnm2 != NULLNOD)
		  printf ("cone %-4d %-4d   ",((recep *)cpnt)->recnm1,
						 ((recep *)cpnt)->recnm2);
		else
                  printf ("cone %-4d        ",((recep *)cpnt)->recnm1);
                break;
        case LOAD:
                nprint = testlin(nprint);
                printf ("load %-8.3g   ",((load *)cpnt)->conduct);
                break;
        case NA:
                nprint = testlin(nprint);
                printf ("na %-8.3g     ",((chan *)cpnt)->maxcond);
                break;
        case K:
                nprint = testlin(nprint);
                printf ("k %-8.3g     ",((chan *)cpnt)->maxcond);
                break;
        case CA:
                nprint = testlin(nprint);
                printf ("ca %-8.3g     ",((chan *)cpnt)->maxcond);
                break;
        case SYNAPSE:
      	      pnt2 = ((synap *)cpnt)->comp1;
              if (pnt2 == pnt) {
                pnt2 = ((synap *)cpnt)->comp2;  
                if (!pnt2) break;
                nprint = testlin(nprint);
                printf ("syn to   -> %-4d ",pnt2->num);
              }
              else {
                nprint = testlin(nprint);
                printf ("syn from <- %-4d ",pnt2->num);
              }
                break;
        case GJ:
                if (pnt2 == pnt) pnt2 = cpnt->comp2;  
                if (!pnt2) break;
                nprint = testlin(nprint);
		if (prmap & PCOMP) {
	          if (cpnt->conduct==0) cond = 1e-30;
		  else cond = cpnt->conduct;
		  ri = 1/cond;		
                  printf ("%8.3g gj %-4d ",ri,pnt2->num);
	        }
		else
                  printf ("%8.3g gj %-4d ",cpnt->conduct,pnt2->num);
                break;
        case BUF:
              if (pnt2 == pnt) {
                pnt2 = ((dbuf *)cpnt)->comp2;  
                if (!pnt2) break;
                nprint = testlin(nprint);
                printf ("buf to   -> %-4d ",pnt2->num);
              }
              else {
                nprint = testlin(nprint);
                printf ("buf from -> %-4d ",pnt2->num);
              }
        default:
                if (pnt2 == pnt) pnt2 = cpnt->comp2;  
                if (!pnt2) break;
                nprint = testlin(nprint);
		if (prmap&PCOMP) { 
		  if (cpnt->conduct==0) cond = 1e-30;
		  else cond = cpnt->conduct;
		  ri = 1/cond;		
                  printf ("%8.3g -> %-4d ",ri,pnt2->num);
		}
		else
                  printf ("%8.3g -> %-4d ",cpnt->conduct,pnt2->num);
                break;
      }
   }
  return (cpnt);	/* return pointer to the last connection */
}

/*------------------------------------*/

int nodematch(node *npnt, int n1a, int n1b, int n1c, int except, int na, int nb, int nc)
{
   int match,nomatch;

 match=1;
 if (n1a != NULLNOD) 			/* check node 1 first */	
    if (npnt->nodenm1!=n1a) match=0;
 if (n1b != NULLNOD)
    if (npnt->nodenm2!=n1b) match=0;
 if (n1c != NULLNOD)
    if (npnt->nodenm3!=n1c) match=0;

 if (match) {
   nomatch = 0;
   if (na!=NULLNOD || nb!=NULLNOD || nc!=NULLNOD) {
     nomatch = 1;
     if (na!=NULLNOD && npnt->nodenm1!=na) nomatch=0;     
     if (nb!=NULLNOD && npnt->nodenm1!=nb) nomatch=0;     
     if (nc!=NULLNOD && npnt->nodenm1!=nc) nomatch=0;     
   }
   if (nomatch) match = 0;
 }
 return match;
}

/*------------------------------------*/

void dcomp(int n1a, int n1b, int n1c, int elemtype, int exceptype, 
	int na, int nb, int nc, int color, double dscale, int hide, int excl)
{
   comp *pnt,*pnt1,*pnt2;
   conn *cpnt,*cpnt1,*cpnt2,*cnpnt;
   conlst *lpnt,*nlpnt,*tlpnt;
   node *npnt;
   int j,n,n1,n2;
   int numcomp,num1,num2;
   double dia;
   double avgx,avgy,avgz;
   double xloc,yloc,zloc;
   double x1,y1,z1;
   double x2,y2,z2;
   double oldx,oldy,oldz;
   int match;

#ifdef DEBUG
  if ((debug & 1) && (debugz & 2))
		 fprintf (stderr,"dcomp n1a %d n1b %d n1c %d\n",n1a,n1b,n1c);
#endif

if (disp & DCOMP) {			/* display compartments */

/* to find the location of a compartment, first see if it 
    represents one or more nodes.  If so, find node locations
    and average their location for comp's location.  If comp
    is not at a node, then it must be in a cable.  On the first
    such compartment, find both ends of the cable (comps that
    are at nodes) and calculate the positions of comp by its
    relative location in the cable.  Since compartments inside
    cables are always created sequentially, all the remaining
    compartments can be displayed immediately (in a local "for"
    loop) after calculating their positions.  Note that the
    beginning and end compartments (the ones at nodes) may have
    been created previously, so they are not necessarily sequential
    with the compartments inside the cable.  They must be displayed
    separately in the main loop. 
*/

 if (dcap==0) dcap = 1e-6;			/* assume 1 uf / cm2 */
 setrot(xrot,yrot,zrot,dxcent,dycent,dzcent,rxcent,rycent,rzcent,dsize); 

 for (pnt=compnt; pnt; pnt=pnt->next) {	/* for all comps */

/* fprintf (stderr,"comp # %d\n",pnt->num);  /* */

    avgx=avgy=avgz=0.0;
					/* find nodes that point to comp */
    for (match=n=0,lpnt=pnt->nodlst; lpnt; lpnt=lpnt->next,n++) {
      if (lpnt->conpnt) {
          npnt = (node *)(lpnt->conpnt);
	  match |= nodematch(npnt,n1a,n1b,n1c,exceptype,na,nb,nc);
          avgx += npnt->xloc;			/* find average location */
          avgy += npnt->yloc;
          avgz += npnt->zloc;
      } 
    }
		/* if there are one or more nodes, draw the comp */
		/*   at the nodes' average location: */

   if (n) {
       if (match) {
         xloc = avgx/n;
         yloc = avgy/n;
         zloc = avgz/n;
         dia = 2. * sqrt(pnt->cap/(dcap*4*MPI)) * 1e4; /* sphere dia from cap */
         drcomp(xloc,yloc,zloc,dia*dscale);     /* */
/* fprintf (stderr,"comp %d nodes %d xloc %-5.3g yloc %-5.3g dia %-5.3g\n",
					pnt->num,n,xloc,yloc,dia);   /* */
	 }
     }

		/* otherwise, comp must be inside cable. */
		/*   traverse list of comp -> conn -> comp to find
		/*   end nodes of cable and then compute location
		/*   of comp from end nodes' locs */
		/*   Ignore conns that are not of type AXIALRES */

  else {

   match = 0;
   avgx=avgy=avgz=0.0;
   num1=num2=0;
   for (j=0,lpnt=pnt->clst; lpnt; lpnt=lpnt->next,j++)  {/* find first node */

     if (!(cpnt1=lpnt->conpnt)) break;
     if (cpnt1->ctype!=AXIALRES) {j--;continue;}
     if ((pnt1=cpnt1->comp1)==pnt) pnt1 = cpnt1->comp2;  /* start it off */
       
     for (n=0; pnt1->nodlst==NULL; n++) {		/* traverse cable */

       tlpnt = pnt1->clst;
       if (!(cpnt2=tlpnt->conpnt)) break;		  /* find conn */
       if (cpnt1==cpnt2) {
	  tlpnt = tlpnt->next;
	  cpnt2 = tlpnt->conpnt; 			/* wrong conn? */
       }
       if (!cpnt2) break;
       while (cpnt2->ctype!=AXIALRES) {
         tlpnt = tlpnt->next;
	 cpnt2 = tlpnt->conpnt;
         if (!cpnt2) break;
       }

       if ((pnt2=cpnt2->comp1)==pnt1) pnt2 = cpnt2->comp2;
       pnt1=pnt2;
       cpnt1=cpnt2;
     }
     if (j==0) {		 /* get avg loc of first end compartment */
      num1 = n;
      avgx=avgy=avgz=0.0;
      for (n=0,nlpnt=pnt1->nodlst; nlpnt; nlpnt=nlpnt->next,n++) {

        if (nlpnt->conpnt) {
            npnt = (node *)(nlpnt->conpnt);
	    match |= nodematch(npnt,n1a,n1b,n1c,exceptype,na,nb,nc);
            avgx += npnt->xloc;			/* find average location */
            avgy += npnt->yloc;
            avgz += npnt->zloc;
        } 
      }
      if (n) {
        x1 = avgx / n;			/* average loc of first compartment */
        y1 = avgy / n;
        z1 = avgz / n;
      }
     }  /* if (j==0) */

     else if (j==1) {		 /* add loc of second end compartment */

      num2 = n;
      avgx=avgy=avgz=0.0;
      for (n=0,nlpnt=pnt1->nodlst; nlpnt; nlpnt=nlpnt->next,n++) {

        if (nlpnt->conpnt) {
          if (!(npnt=(node *)(nlpnt->conpnt))) {n--; continue;}
	  match |= nodematch(npnt,n1a,n1b,n1c,exceptype,na,nb,nc);
          avgx = avgx + npnt->xloc;		/* find average location */
          avgy += npnt->yloc;
          avgz += npnt->zloc;
        } 
      }
      if (n) {
        x2 = y2 = z2 = 0.0;
        if (avgx) x2 = avgx / n;	/* average loc of second end comp */
        if (avgy) y2 = avgy / n;
        if (avgz) z2 = avgz / n;
      }
     }   /* if (j==1) */
   }    /* for (j=0;;) */
 
   if (!match) continue;		/* don't draw comp; check next one */

   numcomp = num1 + num2 + 2;		/* number of segments (conns) */

			/* Now display all the compartments in the cable. */
 			/* Interpolate location from end compartment locs. */
   oldx=x1;
   oldy=y1;
   oldz=z1;
   for (j=1; j<numcomp; j++) {
     xloc = (x1 * (numcomp-j) + x2 * j) / numcomp;
     yloc = (y1 * (numcomp-j) + y2 * j) / numcomp;
     zloc = (z1 * (numcomp-j) + z2 * j) / numcomp;
     if (match) {
       dia = 2. * sqrt(pnt->cap/(dcap*4*MPI)) * 1e4; /* sphere dia from cap */
       drcomp(xloc,yloc,zloc,dia*dscale);            /* draw the compartment */
       if (disp&DCONN) drcconn(oldx,oldy,oldz,xloc,yloc,zloc);
     }						 /* draw connection */
     oldx=xloc;
     oldy=yloc;
     oldz=zloc;

/*   fprintf (stderr,"comp %d seg %d xloc %-5.3g yloc %-5.3g dia %-5.3g\n",
				pnt->num,j,xloc,yloc,dia); /* */
    if (j>1) pnt = pnt->next;
   } 
    if (match && disp&DCONN) drcconn(oldx,oldy,oldz,x2,y2,z2);
			        /* draw the last conn in cable */

  } 	/* else if (!n) */

 }     /* for (pnt=compnt;;)  */
 }    /* if (disp&DCOMP) */

				/* Now display all the connections */
				/*  associated with nodes. */
				/* Problem is that we don't want to draw */
				/* them more than once, so we must use */
				/* a loop based on the connection list, */
				/* not the compartment list. */
if (disp & DCONN) {
  for (cnpnt=connpnt; cnpnt; cnpnt=cnpnt->next) {

    if (!(pnt1=cnpnt->comp1)) continue;
    if (!(pnt2=cnpnt->comp2)) continue;

/* fprintf (stderr,"conn c1 %d c2 %d nod %d\n",
			pnt1->num,pnt2->num,pnt1->nodlst);   /* */
     
    avgx=avgy=avgz=0.0;
    for (match=n1=0,nlpnt=pnt1->nodlst; nlpnt; nlpnt=nlpnt->next,n1++) {

      if (nlpnt->conpnt) {
        npnt = (node *)(nlpnt->conpnt);
	match |= nodematch(npnt,n1a,n1b,n1c,exceptype,na,nb,nc);
        avgx += npnt->xloc;			/* find average location */
        avgy += npnt->yloc;
        avgz += npnt->zloc;
      } 
    }
    if (n1) {
      x1 = avgx / n1;			/* average loc of first end comp */
      y1 = avgy / n1;
      z1 = avgz / n1;
    }

    avgx=avgy=avgz=0.0;
    for (n2=0,nlpnt=pnt2->nodlst; nlpnt; nlpnt=nlpnt->next,n2++) {

      if (nlpnt->conpnt) {
        npnt=(node *)(nlpnt->conpnt);
	match |= nodematch(npnt,n1a,n1b,n1c,exceptype,na,nb,nc);
        avgx += npnt->xloc;			/* find average location */
        avgy += npnt->yloc;
        avgz += npnt->zloc;
      } 
    }
    if (n2) {
      x2 = avgx / n2;			/* average loc of second end comp */
      y2 = avgy / n2;
      z2 = avgz / n2;
    }
    if (n1 && n2) 
       if (match) drcconn(x1,y1,z1,x2,y2,z2);        /* draw the connection */

  }     /* for (cnpnt=connpnt;;) */
 }    /* if (disp&DCONN) */

#ifdef DEBUG
  if ((debug & 1) && (debugz & 2))
		fprintf (stderr,"dcomp end\n");
#endif

}
/*------------------------------------*/

int testlin(int nprint)
{
  if (++nprint > 5) {
    nprint=3;
    printf ("\n#c                 ");
  }
  return (nprint);
}

/*------------------------------------*/

void prelem (elem *epnt)

/* print parameter values for an element. */

{
    cable *cepnt;
    sphere *sepnt;
    synapse *sypnt;

  switch (epnt->ctype) {

    case CABLE:
	cepnt = (cable *)epnt;
	printf ("'cable'   %d",cepnt->elnum);
	if (cepnt->length != NULLNOD) printf (" length %-6.3g",cepnt->length);
	if (cepnt->dia    != NULLNOD) printf (" dia %-6.3g",cepnt->dia);
	if (cepnt->Rm     != NULLNOD) printf (" Rm %-6.4g",cepnt->Rm);
	if (cepnt->Ri     != NULLNOD) printf (" Ri %-6.4g",cepnt->Ri);
	if (cepnt->cplam  != NULLNOD) printf (" cplam %-6.3g",cepnt->cplam);
	printf ("\n");
        break;

    case SPHERE:
	sepnt = (sphere *)epnt;
	printf ("'sphere'  %d",sepnt->elnum);
	if (sepnt->dia    != NULLNOD) printf (" dia %-6.3g",sepnt->dia);
	if (sepnt->Rm     != NULLNOD) printf (" Rm %-6.4g",sepnt->Rm);
	printf ("\n");
        break;

    case SYNAPSE:
	sypnt = (synapse *)epnt;
	printf ("'synapse' %d",sypnt->elnum);
	if (sypnt->ntact  != NULLNOD) {
	   if (sypnt->ntact  == OPEN) 
		 printf (" open");
	   else if (sypnt->ntact  == OPEN) 
		 printf (" close");
	}
	if (sypnt->vrev   != NULLNOD) printf (" vrev %-6.3g",sypnt->vrev);
	if (sypnt->thresh != NULLNOD) printf (" thresh %-6.3g",sypnt->thresh);
	if (sypnt->nfilt1 != NULLNOD) printf (" nfilt1 %-6.3g",sypnt->nfilt1);
	if (sypnt->timec1 != NULLNOD) printf (" timec1 %-6.3g",sypnt->timec1);
	if (sypnt->nfilt2 != NULLNOD) printf (" nfilt2 %-6.3g",sypnt->nfilt2);
	if (sypnt->timec2 != NULLNOD) printf (" timec2 %-6.3g",sypnt->timec2);
	if (sypnt->tfall2 != NULLNOD) printf (" tfall2 %-6.3g",sypnt->tfall2);
	if (sypnt->nfilt3 != NULLNOD) printf (" nfilt3 %-6.3g",sypnt->nfilt3);
	if (sypnt->timec3 != NULLNOD) printf (" timec3 %-6.3g",sypnt->timec3);
	if (sypnt->tfall3 != NULLNOD) printf (" tfall3 %-6.3g",sypnt->tfall3);
	if (sypnt->igain  != NULLNOD) printf (" igain  %-6.3g",sypnt->igain);
	if (sypnt->maxcond!= NULLNOD) printf(" maxcond %-6.3g",sypnt->maxcond);
	if (sypnt->kd     != NULLNOD) printf(" kd  %-6.3g",sypnt->kd);
	if (sypnt->curve  != NULLNOD) {
	    if (sypnt->curve == LINEAR)
		 printf("linear   ");
	    else if (sypnt->curve == EXPON)
		 printf("expon  %-6.3g",sypnt->expon);
	    else if (sypnt->curve == DYAD)
		 printf("dyad  %-6.3g",sypnt->expon);
	}
	printf ("\n");
        break;

    case BUF: {
                vbuf *bepnt;

	bepnt = (vbuf *)epnt;
	printf ("'vbuf'    %d",bepnt->elnum);
	if (bepnt->delay  != NULLNOD) printf (" delay %-6.3g",bepnt->delay);
	printf ("\n");
        }
        break;

    case CHAN: {
		attrib *apnt;

        if (!(apnt=epnt->attpnt)) {
		printf ("No channel parameters available.\n");
		break;
        }
	else {
	 printf ("'chan'    %d",epnt->elnum);
	 if (apnt->ctype  != NULLNOD) printf (" %s type %d",
			findsym(apnt->ctype), apnt->stype);
	 if (apnt->vrev   != NULLNOD) printf (" vrev %g",apnt->vrev);
	 if (apnt->maxcond!= NULLNOD) printf (" maxcond %g",apnt->maxcond);
	 printf ("\n");
	}
       }
       break;


    default: break;
  }
}

/*------------------------------------*/
