/* program plotmod */

/* Program to plot output of "nc" on screen */

#include <stdio.h>
#include "ncelem.h"
#include "ncval.h"
#include "ncomp.h"
#include "ncsub.h"
#include "controlx.h"

plotfr plotnod[PLOTNODSIZ];	/* node numbers, zero sample voltage */

int numpl=0;			/* forced number of plots */
int setvid=0;			/* flag to set video mode on output */
int unsetvid=0;
long drseed=0;
int ncerror=0;			/* error flag used by warning for screen disp */
int tabmode=0;			/* print tabs on output */
int numplots=0;
int nonodes=0;			/* =1 -> no node numbers in video display */ 
int rowmode=0;			/* =1 -> numbers for plot in a row, not col */
int nofilfl=0;			/* =1 -> no filename on plot */
int finfl=0;			/* =1 -> final plot, no filename or labels */
int setauto=0;			/* =1 -> set max and min for graph from data */
int charind=0;			/* index for plots with -c option */
int setnox=0;			/* =1 -> no x value, multiple y vals in input */
double charsiz=CHARSIZ;		/* size of label chars */

extern int listplots[PLOTNODSIZ];	/* forced plots from command line */

extern double setymax;		/* override default plot y max */
extern double setymin;		/* override default plot y min */

extern double setxmax;		/* override default plot x max */
extern double setxmin;		/* override default plot x min */


char *infile=0;			/* the input file */
char *srcfile=0;		/* the source file that generated data */
char *stfile=0;			/* stimulus file */

FILE *pictin;

#ifdef __cplusplus
extern "C" {
#endif

  double atof(const char *);
  double strtod(const char *, char **);
  FILE *freopen(const char *, const char *, FILE *);
  void exit (int n);
#ifdef __cplusplus
}
#endif

void plotrun(void);
void initpl(int);
void getplot(FILE *instream, int numpl, int setauto);

/*------------------------------------*/

main(int argc, char **argv)
{
   char *cptr,*strp;
   FILE *temp;
   int i,pstart,pstop,ptemp;
   static double pcsize=0.018;
	 
 pictin = stdin;
 listplots[0] = 0;			/* reset plot order table */
 vidmode = 1;				/* turn on video mode by default */
 do					/* if there are any switches */
  {
   argc--; argv++;
   cptr = *argv;
   if (argc)
    {
     if (*cptr == '-')
      {
       cptr++;
       switch (*cptr)
        {
	  case 'a': setauto = !setauto; break;

	  case 'c': argv++; argc--;
 		    plotnod[charind].charfl = **argv; /* char for plotting */
 		    plotnod[charind].charmode = LINES;    
 		    if (**argv==' ') 		     /* reset if turned off */
     		       plotnod[charind].charmode = PLINES;
 		    plotnod[charind].csize = pcsize;    
		    if (++charind >= PLOTNODSIZ) charind = PLOTNODSIZ-1;
		    break;

	  case 'C': argv++; argc--;
 		    plotnod[charind].charfl = **argv; /* char for plotting */
 		    plotnod[charind].charmode = NOLINES;    
 		    if (**argv==' ') 		      /* reset if turned off */
     		       plotnod[charind].charmode = PLINES;
 		    plotnod[charind].csize = pcsize;    
		    if (++charind >= PLOTNODSIZ) charind = PLOTNODSIZ-1;
		    break;

	  case 'w': argv++; argc--;		/* set plot char size */
 		    pcsize = atof(*argv);	/* use this switch before -c */
		    break;

	  case 'W': argv++; argc--;		/* set label char size */
 		    charsiz = atof(*argv);
		    break;

	  case 'd': dashfl = !dashfl; break;

	  case 's': plsep = 1; break;

	  case 'f': nofilfl = !nofilfl; break;

	  case 'F': finfl = !finfl; break;

	  case 't': vidmode = !vidmode;
	  	    unsetvid = 1;
 		    break;
 
	  case 'x': tabmode = !tabmode; break;
	  
	  case 'n': nonodes = !nonodes; break;	/* no node numbers in display */

	  case 'r': rowmode = !rowmode; break;	/* numbers for plot in a row */
	  
	  case 'y': setnox = !setnox; break;	/* no x values in input */

	  case 'Y': multyax = !multyax; break;	/* multiple y axes for graph */

	  case 'R': rightYax = !rightYax; break;/* mult y axes on right */

	  case 'E': 
		argv++; argc--;
		setxmax = atof(*argv);		/* override xmax */
		break;
 
	  case 'e': 
		argv++; argc--;
		setxmin = atof(*argv);		/* override xmin */
		break;
 
	  case 'M': 
		argv++; argc--;
		setymax = atof(*argv);		/* override ymax */
		break;
 
	  case 'm': 
		argv++; argc--;
		setymin = atof(*argv);		/* override ymin */
		break;
 
 	  case 'p': 				/* specify indiv. plots */
		argv++; argc--;
		pstart = (int)strtod(*argv,&strp);
		if (*strp=='-') {		/*  or specify range: a-b */
		  pstop = (int)strtod((strp+1),&strp);
		  if (pstop < pstart) {		/*  if they're backwards */
			ptemp = pstart;
			pstart = pstop;
			pstop = ptemp;
		  }
		  if ((pstop-pstart) > PLOTNODSIZ) pstop = pstart+PLOTNODSIZ-1;
		  for (i=pstart; i<=pstop; i++) {
			listplots[numpl++] = i;	/* make range of plots */
		  }
		}
		else listplots[numpl++]  = pstart;
		break;

 	/*     	  case 'e': 
		argv++; argc--;
		stop = atof(*argv);
		stopfg = T;
		break;
	*/

	  default:
		fprintf (stderr,"plotmod: unknown switch '%s'\n",*argv);
		exit(1);

        }  /* switch */
      }	   /* if (*cptr) */
     else
      {
       if((temp=fopen(cptr,"r"))==NULL)
         {
           fprintf(stderr,"plotmod: cannot open %s\n",cptr);
	   fflush (stderr);
           continue;
         }
       else  {
	   pictin = temp;
	   infile = cptr;
       };
       plotrun();
       if (argc <= 1) break;
     }	/* else */

    } /* if (argc) */

   else plotrun(); 
  }
 while (argc > 0);
}

/*------------------------------------*/

void plotrun(void)
{
  initpl(charind);
  getplot(pictin,numpl,setauto);
  listplots[0] = 0;
  numpl = 0;
}

/*------------------------------------*/

double ncabs(double arg)
{
  return ((arg<0) ? -(arg) : arg);
}

