/* Header file ncsub.h for ncsub.c */

#ifndef MAXSHORT

#define _VALUES_H 1

#define BITSPERBYTE 8
#define BITS(type)  (BITSPERBYTE * (int)sizeof(type))
  /* Rename the above to __BITS so it doesn't intrude on users' namespace? */

#define CHARBITS    BITS(char)
#define SHORTBITS   BITS(short)
#define INTBITS     BITS(int)
#define LONGBITS    BITS(long)
#define PTRBITS     BITS(char*)
#define DOUBLEBITS  BITS(double)
#define FLOATBITS   BITS(float)

#define MINSHORT    ((short)(1 << (SHORTBITS - 1)))
#define MININT      (1 << (INTBITS - 1))
#define MINLONG     (1L << (LONGBITS - 1))

#define MAXSHORT    ((short)~MINSHORT)
#define MAXINT      (~MININT)
#define MAXLONG     (~MINLONG)

#define HIBITS	MINSHORT
#define HIBITL	MINLONG

#ifndef MAXDOUBLE
#define MAXDOUBLE   1.79769313486231570e+308
#define MINDOUBLE   4.94065645841246544e-324
#endif

#ifndef MAXFLOAT
#define MAXFLOAT    3.40282347e+38F
#define MINFLOAT    1.40129846e-45F
#endif

#elif defined(convex)
#define MAXDOUBLE   8.9884656743115785e+306
#define MAXFLOAT    ((float) 1.70141173e+38)
#define MINDOUBLE   5.5626846462680035e-308
#define MINFLOAT    ((float) 2.93873588e-39)
#endif

#ifndef MAXSHORT
#define MAXSHORT 32767			/* maximum value for short integer */
#endif

#ifndef MINSHORT
#define MINSHORT -32768			/* maximum value for short integer */
#endif

#define RATESIZ 250			/* size of rate const lookup tables */
#define VTOMV  1000.0                   /* conversion from volts to mvolts */
#define TRSCAL 1000.0                   /* conversion from 1000 to 1 (ligand) */
#define DELCONV 1e-5                    /* conversion from .01 mv to volts */
#define TRMAX  1000.0                   /* max value for trans in synapse */
#define TRMIN -1000.0                   /* min value for trans in synapse */
#define MAXPHOT 1e9                     /* maximum photons per sec */
#define BATTCOND 10.                    /* battery conductance (siemens) */
#define NCHANTYP 10                     /* max number of channel types */
#define NUMREC   4                      /* number of pigments for receptors */
#define LIGHTS   4                      /* number of light sources */
#define LUMINS   2                      /* number of standard luminosities */
#define FILTS    2                      /* number of filters */
#define MINWAV   380			/* min wavel for pigm table */
#define MAXWAV   800			/* max wavel for pigm table */
#define WAVINC   5			/* wavel inc for pigm act spec table */
#define PIGMSIZ ((MAXWAV-MINWAV)/WAVINC+1) /* size of pigment act spec. table */
#define SMALLCAP 1e-33			/* small capacitor for blank comp */
#define LARGERES 1e36			/* large capacitor for blank comp */
#define MPI	3.14159265358979323846264
#define LN10	2.30258509299404568402
#define R	8.31441			/* Gas constant       J/mol/degK */
#define Fd	96484.56		/* Faraday's constant Coul/mol   */
#define F2	5.182176e-6		/* 1/2Fd converts amps Ca to moles/s */
#define RF	8.617348e-5		/* R/F */
#define R2F	4.308674e-5		/* R/2F */
#define F2R	23208.997		/* 2F/R */
#define DCa	6e-6			/* Diff const for ca (cm2/sec) */
#define CASHD	1e-5			/* calcium shell depth in cm */
#define CACOMPRAD 5.0			/* calcium comp radius in um */
#define VCOLOR  32768 			/* display color from voltage */
#define NCOLOR  256 			/* NCOLORS for voltage-color */

#define PLOTNODSIZ 100
#define VREC 1                          /* record voltage for graphing node */
#define IREC 2                          /* record current for graphing node */
#define LREC 3                          /* record light for graphing node */
#define GREC 4                          /* number for graphing */
#define SREC 5                          /* symbol variable for graphing */
#define NRECA0 8                         /* filter before nt release */
#define NRECA1 9                         /* neurotransmitter in filter 1 */
#define NRECA2 10                        /* neurotransmitter in filter 2 */
#define NRECA3 11
#define NRECA4 12
#define NRECA9 13			 /* transrate (actual vesicle rate */
#define NRECB0 14                        /* filter after nt release */
#define NRECB1 15                        /* neurotransmitter in filter 1 */
#define NRECB2 16                        /* neurotransmitter in filter 2 */
#define NRECB3 17
#define NRECB4 18

#define NRECC0 19                        /* filter after saturation */
#define NRECC1 20                        /* neurotransmitter in filter 1 */
#define NRECC2 21                        /* neurotransmitter in filter 2 */
#define NRECC3 22
#define NRECC4 23

#define NRECG0 24			 /* total conductance of channel */
#define NRECG1 25			 /* conductance of states, */
#define NRECG2 26			 /*  normalized to 1 */
#define NRECG3 27
#define NRECG4 28
#define NRECG5 29
#define NRECG6 30
#define NRECG7 31
#define NRECG8 32

#define PLINES  'P'			/* plots have only lines */
#define LINES   'L'			/* plots have chars and lines */
#define NOLINES 'N'			/* plots have chars but no lines */
#define CABLFRAC 10000			/* mult. for distance along cable */

					/* comp->miscfl values: */
#define VEXT 1                          /* voltage clamp for compartment */
#define IEXT 2                          /* current clamp for compartment */
#define VBAT 4                          /* voltage clamp is battery */
#define VBUF 8                          /* voltage buffer (remote vclamp) */
#define CCA  16				/* calcium integration in compartment */

