/* Segment ncplot in Program nc */

/* Plots neuronal circuits */

/*      May 88                  R.G. Smith */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <math.h>

#ifdef __cplusplus
}
#endif

#include "adef.h"
#include "nc.h"
#include "y.tab.h"
#include "ncelem.h"
#include "ncomp.h"
#include "ncsub.h"
#include "control.h"
#include "colors.h"
#include "gprim.h"

#define DEBUG

extern plotfr plotnod[PLOTNODSIZ];      /* node numbers, zero sample voltage */

extern int numplots;
int listplots[PLOTNODSIZ];		/* list of command line forced plots */
static int dttplots;			/* total plots read from input file */
static double xplotmargl;		/* X position of left y axis */
static double xplotmargr;		/* margin width to right of X axis */
static double numyaxis;			/* number of Y axes */
extern double charsiz;			/* char size for plot labels */

double setxmax= -1e20;			/* override default plot x max */
double setxmin= -1e20;			/* override default plot x min */
double setymax= -1e20;			/* override default plot y max */
double setymin= -1e20;			/* override default plot y min */

extern int nonodes;                    	/* =1 -> no node numbers in display */
extern int rowmode;                    	/* =1 -> numbers for plot on row */
extern int nofilfl;			/* =1 ->  means no filenamem on plot */
extern int finfl;			/* =1 ->  means final plot, no labels */
extern int setnox;			/* =1 ->  means no x values */

extern int setvid;                      /* vidmode set on */
extern int unsetvid;                    /* vidmode set off */
extern int ncerror;                     /* error flag set by "warning()" */
extern int tabmode;                     /* print tabs on output */


extern char *infile;                    /* input filename pointer */
extern char *srcfile;                   /* source filename pointer */
extern char *stfile;                    /* stimulus filename pointer */
static char stfilnam[40]={0};		/* stimulus file name */
static char infilnam[40]={0};		/* input file name */
static char srcfilnam[40]={0};		/* source file name */
static char complin[80]={0};		/* "#c xx comps" line from infile*/

int pinitfl = 0;                 	/* == 1 means plotinit() run */

#ifdef __cplusplus
extern "C" {
#endif

#include "stdplt.h"
#include "gr.h"
double exp(double), log(double);
void exit(int code);
double strtod(const char *, char **);

#ifdef __cplusplus
}
#endif

double ncabs(double x);
int looklist(int i);
void prtext (char *adj, double csize, char *str);
void prnum (char *adj,double csize,char *fmt,
		double val1,double val2, double val3);
void drsymb (double csize, int ch);
void plotinit (int totplots);
void autograph(FILE *instream, char *inbuf, int numpl);
char *emalloc(unsigned int n);

void drchar (double csize, int ch); 			/* char */
void drcirc (double csize, int fill); 			/* circle */
void drsqr  (double csize, int fill);			/* square */
void drrect (double csize, double aspect, int fill);	/* rect */
void drtri  (double csize, int fill);			/* tri */
void drtriu (double csize, int fill);			/* ups tri */

/*------------------------------------*/


static double yplotmarg=0.0;

static char colortab[8] ={BLUE,GREEN,CYAN,RED,MAGENTA,BROWN,WHITE,YELLOW};
static char color2  [8] ={LTBLUE,LTGREEN,LTCYAN,LTRED,LTMAG,BROWN,WHITE,YELLOW};
static char color3  [8] ={BLUE,GREEN,CYAN,RED,MAGENTA,BROWN,WHITE,YELLOW};
static char color4  [8] ={LTBLUE,LTGREEN,LTCYAN,LTRED,LTMAG,BROWN,WHITE,YELLOW};
static char color5  [8] ={BLUE,GREEN,CYAN,RED,MAGENTA,BROWN,WHITE,YELLOW};
static char color6  [8] ={LTBLUE,LTGREEN,LTCYAN,LTRED,LTMAG,BROWN,WHITE,YELLOW};
static char color7  [8] ={BLUE,GREEN,CYAN,RED,MAGENTA,BROWN,WHITE,YELLOW};
static char color8  [8] ={LTBLUE,LTGREEN,LTCYAN,LTRED,LTMAG,BROWN,WHITE,YELLOW};
static char color9  [8] ={BLUE,GREEN,CYAN,RED,MAGENTA,BROWN,WHITE,YELLOW};
static char color10 [8] ={LTBLUE,LTGREEN,LTCYAN,LTRED,LTMAG,BROWN,WHITE,YELLOW};

/*------------------------------------*/

void mplot(double yval, double xval, int totplots, int plotpos)

/* plot a value from one or more nodes on graph */

{
   double x,y,xaxis,yrange,xrange,yaxis,ybase,csize;
   static int oldplpos= -10;
   int n,pen,plpos;
   int ch;

#ifdef DEBUG
  if (debug & 1) fprintf (stderr,"mplot  ");
#endif

#define XPLOTMARGL .05
#define XPLOTMARGR .05
#define XPLOTLABEL .02
#define YPLOTMARG .08
#define YAXISWIDTH .1
#define YNODEWIDTH .03
#define YLABELPOS   .035
#define YLABELPOSN  .05
#define LARGETIC   .015
#define SMALLTIC   .007
#define LABELTIC   .03
#define LABELAX    .02

if (!pinitfl) return;                   /* return if graph not initialized */

if (!vidmode) {                         /* if no graphics, print numbers */
  if (tabmode) {
   if (plotpos==0) printf ("%-8.5g\t",xval);
   printf ("%-11.6g\t",yval);
 } else {
   if (plotpos==0) printf ("%-8.5g ",xval);
   printf ("%-11.6g ",yval);
 }
  if (plotpos == (totplots-1)) printf ("\n");
  fflush (stdout);
#ifdef DEBUG 
 if (debug & 1) fprintf (stderr,"mplotend1\n");
#endif
  return;
}

 if (totplots == 0) totplots = 1;
 if (!plsep) totplots = 1;              /* if separate plots */

 plpos = looklist(plotpos); 		/*possibly modify plot order */

 yrange = plotnod[plpos].yrange;
 xrange = plotnod[plpos].xrange;
 if (yrange == 0) yrange = 1e-20;
 if (xrange == 0) xrange = 1e-20;
 y  = yval - plotnod[plpos].pymin; 
 y /= yrange;                     		/* normalize y to max of 1 */
 xaxis = 1 - (xplotmargl + xplotmargr);   	/* calc size of plot x axis */
 x = xval  - plotnod[plpos].pxmin;
 x *= xaxis / xrange;
 x += xplotmargl;

 if (plsep) {
        yaxis = (1.0 - yplotmarg) / totplots - YPLOTMARG * numyaxis;
        ybase = ((double)plpos)   / totplots + yplotmarg;
        y *= yaxis;                             /* make y fit into screen */
        y += ybase;                             /* y offset */
        pen = plotnod[plpos].ppen;
	if (pen==0) pen = WHITE;
        cpen (pen);
 }
 else {                         /* draw colors, not separate plots */
        yaxis = (1.0 - yplotmarg) - YPLOTMARG * numyaxis;
   /*     yaxis = 1.0 - 2 * yplotmarg;	/* */
        ybase = yplotmarg;
        y *= yaxis;                       /* make y fit into screen */
        y += ybase;                       /* no offset (too confusing!) */
/*      y += ybase + plpos / 300.0;       /* yoffset */
        n = plpos; 
        pen = plotnod[n].ppen;
        if (pen == 0) pen = colortab[n];
        cpen (pen);
/*        if (dashfl) dash ((long)(pen & 7)); /* */
 }
 x = max(-.5,x); 
 x = min(2.5,x); 
 y = max(-.2,y); 
 y = min(1.2,y); 
 if (plotnod[plpos].charfl==' ')	  /* reset if turned off */
     plotnod[plpos].charmode = PLINES;

 csize = plotnod[plpos].csize;
 if (csize < 0) {
     fprintf (stderr, "mplot: negative size %g\n", csize);
     return;
 }
 ch = plotnod[plpos].charfl;
 switch (plotnod[plpos].charmode) {

    case NOLINES:				/* plot chars with no lines */
       move (x,y);
       drsymb (csize,ch);
       break;

    case   LINES:				/* plot chars with lines */
       if (plotnod[plpos].oldx > -1e10) {
         move (plotnod[plpos].oldx,plotnod[plpos].oldy);  /* plot lines */
         draw (x,y);
         move (plotnod[plpos].oldx,plotnod[plpos].oldy);  /* previous point */
         drsymb (csize,ch);		/* draw symbol at previous point */
         move (x,y);
         drsymb (csize,ch);		/* draw symbol at current point */
       }
       break;

    case   PLINES:				/* plot just lines */
       if (plotnod[plpos].oldx > -1e10) {
          move (plotnod[plpos].oldx,plotnod[plpos].oldy);  /* plot lines */
       draw (x,y);
       }
       else move (x,y);				/* move to first point */
       break;

    default:
       break;

  } /* switch */

 plotnod[plpos].olddx = plotnod[plpos].oldx;
 plotnod[plpos].olddy = plotnod[plpos].oldy;
 plotnod[plpos].oldx = x;
 plotnod[plpos].oldy = y;
 oldplpos = plpos;
 gpurge();
#ifdef DEBUG 
 if (debug & 1) fprintf (stderr,"mplotend2\n");
#endif
}

/*------------------------------------*/

void drsymb (double csize, int ch)

/* draw a symbol at the data point */

{
  if (ch > '@') {
      drchar (csize, ch);
  }
  else 
    switch (ch) {
      case '!':   drcirc (csize, 0); break;	/* open   circle */
      case '@':   drcirc (csize, 1); break;	/* filled circle */
      case '#':   drsqr (csize, 0); break;		/* open   square */
      case '&':   drsqr (csize, 1); break;		/* filled square */
      case '^':   drrect (csize, 3.0, 0);break;	/* open   rect */
      case '~':   drrect (csize, 3.0, 1);break;	/* filled rect */
      case '_':   drrect (csize, 0.33, 0);break;	/* open   rect */
      case '=':   drrect (csize, 0.33, 1);break;	/* filled rect */
      case '(':   drtri (csize, 0);break;		/* open       tri */
      case ')':   drtri (csize, 1);break;		/* filled     tri */
      case '{':   drtriu (csize, 0);break;		/* open   ups tri */
      case '}':   drtriu (csize, 1);break;		/* filled ups tri */
      default:    drchar (csize, ch);break;
  }
}

/*------------------------------------*/

void disperr(void)
{
    static int displayed=0;

 if (vidmode && !displayed) {
   displayed = 1;
   cpen (WHITE);
   move (0.9, 0.9);
   cwidth (.025,".");
   prtext ("l",0.025,"Error\n");
   cwidth (charsiz,".");
 }
}

/*------------------------------------*/

double geticinc(double range)
{
   static int itic;
   static double dtic, ticinc, temp;

#define TFACTOR 5.0

  range = ncabs(range);
  range /= TFACTOR; 
  dtic = log(range) / LN10;		/* take log10 */
  itic = (int)floor(dtic);
  ticinc = exp ((double)itic * LN10);
  return (ticinc); 
}

/*------------------------------------*/

void initpl(int charind)
{
   int i;

 for (i=0; i<PLOTNODSIZ; i++) {
  plotnod[i].cnod1 = 0;
  plotnod[i].cnod2 = 0;
  plotnod[i].cnod3 = 0;
  plotnod[i].pxmax  = -1e20;
  plotnod[i].pxmin  = -1e20;
  plotnod[i].pymax  = -1e20;
  plotnod[i].pymin  = -1e20;
  plotnod[i].olddx  = -1e20;
  plotnod[i].olddy  = -1e20;
  plotnod[i].oldx   = -1e20;
  plotnod[i].oldy   = -1e20;
  plotnod[i].xrange = 0;
  plotnod[i].yrange = 0;
  plotnod[i].pmod   = VREC;
  plotnod[i].ppen   = 0;
  if (i>=charind) plotnod[i].csize  = 0;
  plotnod[i].automax = 0;
  if (plotnod[i].charmode < LINES || plotnod[i].charmode > PLINES) {
    plotnod[i].charfl = 0;
    plotnod[i].charmode  = PLINES;
  }
 }
 numplots = 0;
}

/*------------------------------------*/

void plotpen(int pen, int nplot)
{
 if (nplot>=PLOTNODSIZ) nplot = PLOTNODSIZ-1;
 plotnod[nplot].ppen = pen;

 if (! vidmode) {
    printf ("#dcolor %d plot %d\n",pen,nplot);
 }

}

/*------------------------------------*/

void plotcsiz(double size, int nplot)
{
 if (nplot>=PLOTNODSIZ) nplot = PLOTNODSIZ-1;
 plotnod[nplot].csize = size;

				/* don't allow changing char during plot: */
/* if (! vidmode) {
    printf ("#zcsize %g plot %d\n",size,nplot);
 }			/* */

}

/*------------------------------------*/

void plotchar(int lchar, int mode, int nplot)

{
 if (nplot>PLOTNODSIZ) nplot = PLOTNODSIZ-1;
 if (lchar==' ') 				/* space erases plot char */
   plotnod[nplot].charmode = PLINES; 
 else {						/* set on plot char */
   plotnod[nplot].charfl = (char)lchar;
   plotnod[nplot].charmode = mode; 
 }

				/* don't allow changing char during plot: */
/*
 if (! vidmode) {
    printf ("#lchar '%c' mode %c plot %d\n",lchar,mode,nplot);
 }			/*  */

}

/*------------------------------------*/

void plotrst(int totplots)
{
   int i;

 for (i=0; i<totplots; i++)                     /* restart all graphs */
   plotnod[i].oldy = plotnod[i].oldx = -1e20;

 if (! vidmode) {
    printf ("#restart plot...\n");
 }

}

/*------------------------------------*/

void plotinit (int totplots)
{
    double axmin,axmax,range,naxmin,naxmax,nrange,yaxisX;
    double yaxis,ybase,ticmin,ticinc;
    double plaxis, plticmin, pltic, calibtic;
    double ppmin, ppmax, pxnum, pynum;
    double ticypos,ticymin,ticymax,ynodewidth;
    int ticyminfl,ticymaxfl,lablint,nolabltic; 
    int i,j,n,ttotplots,itic,itici,ntics,hitics,calibmv,calibms;
    int nnodpos,plotype,pen,charfl,charmode,ticdir,yneg;
    char *calstr, *xcalstr, modech, numbuf[20];

#ifdef DEBUG 
 if (debug & 1) fprintf (stderr,"plotinit %d\n",totplots);
#endif

pinitfl = 1;

if (setxmax > -1e10) endexp = setxmax;	     /* set defaults from overrides */
if (setxmin > -1e10) xtime = setxmin;

if (setymax > -1e10) plmax = setymax;
if (setymin > -1e10) plmin = setymin;

if (!vidmode) {                                /* init non-graphics display */
   if (complin[0]=='#')
	printf ("%s",complin);		/* print "#c xx comps..." */
   if (stfile)
        printf ("#f stim file %s\n",stfile);
   if (infile && srcfile) { 
        if (strcmp (infile,srcfile)!=0)
        printf ("#f input file %s\n",infile);
    }
    else if (infile)
        printf ("#f input file %s\n",infile);
    if (srcfile)
        printf ("#f source file %s\n",srcfile);
    printf ("#p %d plots plmax %g plmin %g\n",totplots,plmax,plmin);
    printf ("#e begin %g  endexp %g  rseed  %ld version %-4.2g\n",
					xtime,endexp,drseed,ncversion);
    for (i=0; i<totplots; i++) {
      n = looklist(i);      	/* command line overrides order */

      switch(plotnod[n].pmod) {
         case VREC:     modech = 'V'; break;
         case IREC:     modech = 'I'; break;
         case LREC:     modech = 'L'; break;
         case GREC:     modech = 'X'; break;
         case SREC:     modech = 'S'; break;
	 case NRECA0: case NRECA1: case NRECA2: case NRECA3: case NRECA4:
	 case NRECB0: case NRECB1: case NRECB2: case NRECB3: case NRECB4:
	 case NRECC0: case NRECC1: case NRECC2: case NRECC3:
	 case NRECC4:	modech = 'F'; break; 
         case NRECA9:   modech = 'R'; break;
         case NRECG0:   modech = 'G'; break;
         case NRECG1: case NRECG2: case NRECG3: case NRECG4: case NRECG5:
         case NRECG6: case NRECG7: case NRECG8:
	   		modech = 'C'; break;
         case CABLE:    modech = 'V'; break;
         default:       modech = '0' + plotnod[i].pmod; break;
      }
    nnodpos = 1;
    if (plotnod[n].cnod2 > NULLNOD) nnodpos++;
    if (plotnod[n].cnod3 > NULLNOD) nnodpos++;
    if (plotnod[n].pxmax < -1e10)            /* default values for xmax,xmin? */
    switch (nnodpos) {

  case 3:
   printf("#x node %-4d %-2d %-2d mode %c\n",
                plotnod[n].cnod1, plotnod[n].cnod2, plotnod[n].cnod3, modech);
   break;
  case 2:
   printf("#x node %-4d %-2d %-2d mode %c\n",
                plotnod[n].cnod1, plotnod[n].cnod2, 0, modech);
   break;
  case 1:
   printf("#x node %-4d %-2d %-2d mode %c\n",
                plotnod[n].cnod1, 0, 0, modech);
   break;

    }  /* switch (nnodpos) */

  else
  switch (nnodpos) {
   case 3:
    printf("#x node %-4d %-2d %-2d mode %c xmax %-8.3g xmin %-8.3g\n",
                plotnod[n].cnod1, plotnod[n].cnod2, plotnod[n].cnod3, modech, 
                plotnod[n].pxmax, plotnod[n].pxmin);
   break;
  case 2:
   printf("#x node %-4d %-2d %-2d mode %c xmax %-8.3g xmin %-8.3g\n",
                plotnod[n].cnod1, plotnod[n].cnod2, 0, modech, 
                plotnod[n].pxmax, plotnod[n].pxmin);
   break;
  case 1:
   printf("#x node %-4d %-2d %-2d mode %c xmax %-8.3g xmin %-8.3g\n",
                plotnod[n].cnod1, 0, 0, modech, 
                plotnod[n].pxmax, plotnod[n].pxmin);
   break;
}

    charfl = plotnod[n].charfl;
    if (charfl==0) charfl = ' '; 
    charmode = plotnod[n].charmode;
    if (charmode==PLINES) {
     if (plotnod[n].pymax < -1e10)          /* default values for ymax,ymin? */
       printf("#y           pen %d styl %c\n", plotnod[n].ppen,charmode);
     else
       printf("#y           pen %d styl %c ymax %-8.3g ymin %-8.3g\n",
                plotnod[n].ppen,charmode,plotnod[n].pymax, plotnod[n].pymin);
    } /* if (charmode==) */
    else {
     if (plotnod[n].pymax < -1e10)          /* default values for ymax,ymin? */
       printf("#y           pen %d styl %c char '%c'\n",
			 plotnod[n].ppen,charmode,charfl);
     else
       printf("#y           pen %d styl %c char '%c' ymax %-8.3g ymin %-8.3g\n",
                plotnod[n].ppen,charmode,charfl,
		plotnod[n].pymax, plotnod[n].pymin);
    } /* if (charmode==) */

   }    /* for (i=0; i<totplots; )  */

      printf ("# \n");
      printf ("#node-->  ");
      for (i=0; i<totplots; i++) {
          n = looklist(i);      	/* command line overrides order */

  switch (plotnod[n].pmod) {
    	case  VREC: case  IREC: case  SREC:
    	case  LREC: case  GREC:
    	case  CABLE:
  		if (plotnod[n].cnod2 > NULLNOD) 
		  printf ("%-4d %-2d   ",plotnod[n].cnod1,plotnod[n].cnod2);
  		else
		  printf ("%-4d %-2d   ",plotnod[n].cnod1,0);
		break;
    	case NRECA0: case NRECA1: case NRECA2: case NRECA3: case NRECA4:
    	case NRECA9:
    	case NRECB0: case NRECB1: case NRECB2: case NRECB3: case NRECB4:
    	case NRECC0: case NRECC1: case NRECC2: case NRECC3: case NRECC4:
	case NRECG0: case NRECG1: case NRECG2: case NRECG3: case NRECG4:
	case NRECG5: case NRECG6: case NRECG7: case NRECG8:
  		printf ("%-6d    ",plotnod[n].cnod1);
		break;
	}   /* switch */
       }

        printf ("\n");
        fflush (stdout);
        return;			/* return if not vidmode */

   }  /* if (!vidmode) */

 if (finfl) { nonodes=1; nofilfl=1; }

 plotype = plotnod[0].pmod;
 for (i=0; i<totplots; i++) {
   n = looklist(i);      	/* command line overrides order */
   if (plotnod[n].pxmax < -1e10)                /* find default values for */
        switch (plotype) {
        case VREC: case IREC: case LREC:
	case NRECA0: case NRECA1: case NRECA2: case NRECA3: case NRECA4:
	case NRECA9:
	case NRECB0: case NRECB1: case NRECB2: case NRECB3: case NRECB4:
	case NRECC0: case NRECC1: case NRECC2: case NRECC3: case NRECC4:
	case NRECG0: case NRECG1: case NRECG2: case NRECG3: case NRECG4:
	case NRECG5: case NRECG6: case NRECG7: case NRECG8:
	case CABLE:
                plotnod[n].pxmax  = endexp;     /*  x axis max and min */
                plotnod[n].pxmin  = xtime;
                break;
        case GREC:
                plotnod[n].pxmax  = plotnod[0].pxmax; /*  x axis max and min */
                plotnod[n].pxmin  = plotnod[0].pxmin;
                break;
        case SREC:
                plotnod[n].pxmax  = plotnod[0].pxmax; /*  x axis max and min */
                plotnod[n].pxmin  = plotnod[0].pxmin;
                break;
                
        }  /* switch */

   if (setxmax > -1e10) plotnod[n].pxmax = setxmax; 
   if (setxmin > -1e10) plotnod[n].pxmin = setxmin; 

   plotnod[n].xrange = plotnod[n].pxmax - plotnod[n].pxmin;
 }

 for (i=0; i<totplots; i++) {
   n = looklist(i);      		/* command line overrides order */
   if (plotnod[n].pymax < -1e10)        /* find default values for */
        switch (plotype) {
        case VREC:
        case IREC:
                plotnod[n].pymax  = plmax;      /*  y axis max and min */
                plotnod[n].pymin  = plmin;
                break;
        case LREC:
                plotnod[n].pymax  = 1000; 	/*  y axis max and min */
                plotnod[n].pymin  = 0;
                break;
        case GREC:
                plotnod[n].pymax  = plotnod[0].pymax; /* y axis max and min */
                plotnod[i].pymin  = plotnod[0].pymin;
                break;
        case SREC:
                plotnod[n].pymax  = plotnod[0].pymax; /* y axis max and min */
                plotnod[n].pymin  = plotnod[0].pymin;
                break;
	case NRECA0: case NRECA1: case NRECA2: case NRECA3:
	case NRECA4: case NRECA9:
                plotnod[n].pymax  = plotnod[0].pymax; /*  y axis max and min */
                plotnod[n].pymin  = plotnod[0].pymin;
                break;
	case NRECB0: case NRECB1: case NRECB2: case NRECB3: case NRECB4:
	case NRECC0: case NRECC1: case NRECC2: case NRECC3: case NRECC4:
	case NRECG1: case NRECG2: case NRECG3: case NRECG4: case NRECG5:
	case NRECG6: case NRECG7: case NRECG8:
                plotnod[n].pymax  = 2; 		/*  y axis max and min */
                plotnod[n].pymin  = 0;
                break;
	case NRECG0: 				/* conductance of chan */
                plotnod[n].pymax  = 1e-8;	/*  y axis max and min */
                plotnod[n].pymin  = 0;
		break;
	case CABLE:
                plotnod[n].pymax  = plmax;      /*  y axis max and min */
                plotnod[n].pymin  = plmin;
               	break; 
        }

	/* set actual plot size from overrides */

   if (setymax > -1e10) plotnod[n].pymax = setymax; 
   if (setymin > -1e10) plotnod[n].pymin = setymin; 
   plotnod[n].yrange = plotnod[n].pymax - plotnod[n].pymin;
 }

 for (i=0; i<totplots; i++) {                     /* restart all graphs */
   n = looklist(i);      		/* command line overrides order */
   plotnod[n].oldy = plotnod[n].oldx = -1e20;
 }

 if (totplots == 0) totplots = 1;
 if (plsep) ttotplots = totplots;
 else       ttotplots = 1;
 if (multyax) numyaxis = totplots;
 else         numyaxis = ttotplots;

 /* setmode (fileno(stdout), O_BINARY); 		/* for microsoft C */
 frame ("zzz"); 

 cwidth (charsiz,".");

 if (ncerror) {
    cpen (WHITE);
    move (0.9, 0.9);
    cwidth (.025,".");
    prtext ("l",0.025,"Error\n");
    cwidth (charsiz,".");
 }
 cpen (BLUE);


 n = looklist(0);      		/* command line overrides order */
 yneg = (plotnod[n].pymin < 0);

 yplotmarg = YPLOTMARG + 2*XPLOTLABEL+charsiz*2; /* calculate y axis length */
 yaxis = (1.0 - yplotmarg) / ttotplots - YPLOTMARG * numyaxis;

 ynodewidth = 6*charsiz + YNODEWIDTH; 
 xplotmargl = XPLOTMARGL * nonodes + ynodewidth * !nonodes + 
		(yneg+3) * charsiz + (!rightYax) * (numyaxis-1) * YAXISWIDTH;
 xplotmargr = XPLOTMARGR + (rightYax) * (numyaxis-1) * YAXISWIDTH;

 move (xplotmargl,  yplotmarg);                 /* draw x axis */
 draw (1-xplotmargr,yplotmarg);

 plaxis = 1 - (xplotmargl + xplotmargr);       	/* calc size of plot x axis */


 n = looklist(0);      		/* command line overrides order */
 axmax = plotnod[n].pxmax;
 axmin = plotnod[n].pxmin;
 range = plotnod[n].xrange;
 if (range == 0) range = 1e-20;
 ticinc = geticinc(range);                      /* find tic incr */

 itic   = (int)floor((axmin * 1.000001) / ticinc);
 ticmin = itic * ticinc;  
 naxmin = ticmin;
 itic   = (int)ceil((axmax * .9999999) / ticinc); 
 naxmax = itic * ticinc;  
 nrange = (naxmax - naxmin);

/* plotnod[n].xrange = nrange;			/* rescale x axis */
/* plotnod[n].pxmax = naxmax;
 plotnod[n].pxmin = naxmin;
*/

 for (i=0; i<totplots; i++) {			/* rescale other x axes */
     double trange;

   n = looklist(i); 
   trange = plotnod[n].xrange;
   plotnod[n].xrange *= nrange/range;
   plotnod[n].pxmax += (naxmax-axmax)/range*trange;
   plotnod[n].pxmin += (naxmin-axmin)/range*trange;
 }
 range = nrange;
 axmin = naxmin;
 axmax = naxmax;

 ntics = (int)(range / ticinc + 1.000001); 

 nolabltic = 0;
 lablint = 10;
 if (ntics >= 11) {
    hitics = 1;			/* use big and small tics */
    if (ntics<50) {
      lablint = 5;
      nolabltic = 1;
      if (ntics<30) nolabltic = 0;
    }
 }
 else {
    hitics = 0;
    ticinc/=10.0; 
    ntics = (int)(range / ticinc + 1.000001); 
 }
 itic   = (int)((axmin * 1.000001) / ticinc);
 ticmin = itic * ticinc;  
 plticmin = ((ticmin - axmin) / range) * plaxis;   /* physical loc of xmin */
 plticmin += xplotmargl;
 pltic = (ticinc / range) * plaxis;

 calibtic = ticinc * 10.0;

/* if (hitics) calibtic = ticinc * 10.0;
 else        calibtic = ticinc; */
 
 calibms = 0;
 n = looklist(0); 
 switch (plotnod[n].pmod) {

    case  VREC: case  IREC: case  SREC:
    case NRECA0: case NRECA1: case NRECA2: case NRECA3: case NRECA4:
    case NRECA9: 
    case NRECB0: case NRECB1: case NRECB2: case NRECB3: case NRECB4:
    case NRECC0: case NRECC1: case NRECC2: case NRECC3: case NRECC4:
    case NRECG0: case NRECG1: case NRECG2: case NRECG3: case NRECG4:
    case NRECG5: case NRECG6: case NRECG7: case NRECG8:
    case CABLE:
        if (calibtic < 1) {                     /* x axis calibration units */
             calibms = 1; 
             xcalstr = "msec";
        }
        else xcalstr = "Seconds";
        break;
 
    case  GREC:
         xcalstr = "";
      break;

   } /* switch (plotnod[n].pmod) */
 
 for (itici=itic,j=0; j<ntics; j++,itici++) {     /* draw x axis tics */
   move (plticmin, yplotmarg);
   if ((itici % lablint) == 0) 
        draw (plticmin, yplotmarg - LARGETIC);    /* always draw larger tics */
   else 
   if (hitics) draw (plticmin, yplotmarg - SMALLTIC); /* smaller tics */

   if ((itici % lablint) == 0){
     if (nolabltic && (itici % 10 == 5)) ;
     else {
        cpen (WHITE);
        pxnum = ((int)(axmin/ticinc * 1.000001) + j) * ticinc;
        if (ncabs(pxnum) < (range / 100)) pxnum = 0;
        if (calibms) pxnum *= 1000;
	move(plticmin,yplotmarg-XPLOTLABEL-charsiz*1.1); /* position of label */
	prnum("c",charsiz,"%g",pxnum,0,0);   	 /* label tics */
        cpen (BLUE);
     }
   }
   plticmin += pltic;
 } 

 cpen (WHITE);					/* label the end of axes */

 pxnum = axmin;
 if (ncabs(pxnum) < (range / 100)) pxnum = 0;
 if (calibms) pxnum *= 1000;
 if (hitics && ntics < 61) {
    if ((itic % lablint) < lablint/2 && (itic%lablint) > 0) {
      move (xplotmargl,yplotmarg-XPLOTLABEL-charsiz*1.1);
      prnum("c",charsiz,"%g",pxnum,0,0);	/* label xmin */
    }
 }
 
 pxnum = axmax; 
 if (ncabs(pxnum) < (range / 100)) pxnum = 0;
 if (calibms) pxnum *= 1000;
 if (hitics && ntics < 61) { 
    if ((--itici % lablint) > lablint/2) {
 	move (1-xplotmargr, yplotmarg-XPLOTLABEL-charsiz*1.1); 
 	prnum("c",charsiz,"%g",pxnum,0,0); 		/* label xmax */
    }
 }

 n = looklist(0); 

 if (!finfl) {
  if (plotnod[n].pmod != GREC) {
   move ((1+xplotmargl-xplotmargr)*0.5, yplotmarg-2*XPLOTLABEL-charsiz*2);
   prtext ("c",charsiz,xcalstr);                /* draw x axis calib label */
  }
 }


 for (i=0; i<numyaxis; i++) {               /* draw (maybe multiple) y axis */
   n = looklist(i); 
   if (i) {
      pen = plotnod[n].ppen;
      if (pen == 0) pen = colortab[n];
   }
   else {
     pen = plotnod[0].ppen;
     if (pen == 0) pen = colortab[0];
   }
   cpen (pen);					/* color of y axis */
   if (plsep) ybase = ((double)i)/ttotplots + yplotmarg;
   else       ybase = yplotmarg;
   if (numyaxis>ttotplots) {
     if (i==0) yaxisX = xplotmargl;
     else {
       if (rightYax) yaxisX = 1 - xplotmargr + (i-1) * YAXISWIDTH; /* on right*/
       else          yaxisX = xplotmargl - i * YAXISWIDTH;	/* on left */
     }
   }
   else	       yaxisX = xplotmargl;

   move (yaxisX, ybase);			/* draw y axis */
   draw (yaxisX, ybase+yaxis);

   plaxis = yaxis;                              /* size of plot y axis */
   axmax = plotnod[n].pymax;
   axmin = plotnod[n].pymin;
   range = axmax - axmin;
   if (range == 0) range = 1e-20;
   plotnod[n].yrange = range;
   ticinc = geticinc(range);                    /* find y axis tic incr */

   if (i==0 && plotnod[n].automax) {		/* rescale y axes */
       int k;

     itic   = (int)floor((axmin * 1.000001) / ticinc);
     ticmin = itic * ticinc;  
     naxmin = ticmin;
     itic   = (int)ceil((axmax * .999999) / ticinc);
     naxmax = itic * ticinc;  
     nrange = (naxmax - naxmin);
     plotnod[n].yrange = nrange;		/* first y axis */
     plotnod[n].pymax = naxmax;
     plotnod[n].pymin = naxmin;

     for (k=1; k<totplots; k++) {		/* other y axes */
       double trange;
       int p;

       p = looklist(k); 
       trange = plotnod[p].yrange;
       plotnod[p].pymax += (naxmax-axmax)/range*trange;
       plotnod[p].pymin += (naxmin-axmin)/range*trange;
       plotnod[p].yrange = plotnod[p].pymax - plotnod[p].pymin;
     }
   range = nrange;
   axmin = naxmin;
   axmax = naxmax;
   }  /* if i */

   ntics = (int)(range / ticinc + 1.000001); 
   nolabltic = 0;
   lablint = 10;
   if (ntics >= 11) {
      hitics = 1;		/* use big and small tics */
      if (ntics<50) {
        lablint = 5;
        nolabltic = 1;
        if (ntics<30) nolabltic = 0;
      }
   }
   else {
      hitics = 0;
      ticinc/=10.0; 
      ntics = (int)(range / ticinc + 1.000001); 
   }
   itic  = (int)((axmin * 1.000001) / ticinc);
   ticmin = itic * ticinc;

   plticmin = ((ticmin - axmin) / range) * plaxis;
   plticmin += ybase;
   pltic = (ticinc / range) * plaxis;

   calibtic = ticinc * 10.0;

   /* if (hitics) calibtic = ticinc * 10.0;
   else        calibtic = ticinc; */

   calibmv = 0;
   switch (plotnod[n].pmod) {

    case  VREC:
    case  CABLE:
        if (calibtic < 1) {                     /* y axis calibration units */
             calibmv = 1; 
             if (nonodes) calstr = "mVolts";
             else         calstr = "mV";
        }
        else {
             calibmv = 0;
             if (nonodes) calstr = "Volts";
             else         calstr = "V";
        }
        break;
 
    case  IREC:
          if (nonodes) calstr = "Amperes";
          else         calstr = "A";
      break;

    case NRECA0: case NRECA1: case NRECA2: case NRECA3: case NRECA4:
    case NRECB0: case NRECB1: case NRECB2: case NRECB3: case NRECB4:
    case NRECC0: case NRECC1: case NRECC2: case NRECC3: case NRECC4:
    case NRECG1: case NRECG2: case NRECG3: case NRECG4: case NRECG5:
    case NRECG6: case NRECG7: case NRECG8:
         calstr = "Frac";
	break;
    case NRECA9:
        if (nonodes) calstr = "Rate";
        else         calstr = "R";
	break;

    case NRECG0:
        if (nonodes) calstr = "Siemens";
        else         calstr = "S";
	break;

    case  SREC:
    case  GREC:
         calstr = "";
      break;

   } /* switch (plotnod[n].pmod) */

   ticymin = ybase- charsiz/2;
   ticymax = ybase+yaxis- charsiz/2;
   ticyminfl=ticymaxfl=0;
   if (rightYax && i>0) ticdir = -1;
   else                 ticdir = 1;
   for (itici=itic,j=0; j<ntics; j++,itici++) {   /* draw y axis tics */
     move (yaxisX, plticmin);
     if ((itici % lablint) == 0)
          draw (yaxisX-LARGETIC*ticdir, plticmin); /* always draw larger tics */
     else
      if (hitics) draw (yaxisX-SMALLTIC*ticdir, plticmin);  /* smaller tics */

     if ((itici % lablint) == 0) {
       if (ttotplots < 3) {
         if (nolabltic && (itici % 10 == 5)) ;
         else {
	   cpen (WHITE);
           pynum = ((int)(axmin/ticinc * 1.000001) + j) * ticinc;
           if (ncabs(pynum) < (range / 100)) pynum = 0;
           if (calibmv) pynum *= 1000.0;
	   ticypos = plticmin- charsiz/2;
	   if (ticypos==ticymin) ticyminfl = 1;
	   if (ticypos==ticymax) ticymaxfl = 1;
           move (yaxisX-LABELTIC*ticdir, ticypos); 	/* label tics */
	   if (ticdir>0) prnum ("r",charsiz,"%g",pynum,0,0);
	   else          prnum ("l",charsiz,"%g",pynum,0,0);
           cpen (pen);
         }
       }
     }
     plticmin += pltic;
   } 

   if (!ticyminfl) {
     cpen (WHITE);
     if (calibmv)
          ppmin = plotnod[n].pymin * 1000;
     else ppmin = plotnod[n].pymin;

     if (hitics && ntics < 61) {
        if ((itic % lablint) < lablint/2 && (itic%lablint) > 0) {
     	  move (yaxisX-LABELTIC*ticdir, ticymin);
	  if (ticdir>0) prnum ("r",charsiz,"%g",ppmin,0,0); /* display ymin */
	  else          prnum ("l",charsiz,"%g",ppmin,0,0);
        }
     }

     if (!nonodes) {
       move (yaxisX-LABELAX*ticdir,ticymin+0.035);
       if (ticdir>0) prtext ("r",charsiz,calstr);  /* draw y axis calib label */
       else          prtext ("l",charsiz,calstr);  /*   near bottom of Y axis */
       cpen (pen);
     }
   }

   if (!ticymaxfl) {
     cpen (WHITE);
     if (calibmv)
          ppmax = plotnod[n].pymax * 1000;
     else ppmax = plotnod[n].pymax;

     if (hitics && ntics < 61) {
        if ((--itici % lablint) > lablint/2) {
	  move (yaxisX-LABELTIC*ticdir, ticymax);
	  if (ticdir>0) prnum ("r",charsiz,"%g",ppmax,0,0); /* display ymax */
	  else          prnum ("l",charsiz,"%g",ppmax,0,0);
        }
     }

    if (!finfl) { 
     if (nonodes) { 
       /*move (yaxisX-LABELAX*ticdir,ticymax+YLABELPOSN); /* At top of Y axis,*/
       move (yaxisX,ticymax+YLABELPOSN); /* At top of Y axis, */
       if (ticdir>0) prtext ("r",charsiz,calstr);  /* draw y axis calib label */
       else          prtext ("l",charsiz,calstr);
     }
     else {
       move (yaxisX-LABELAX*ticdir,ticymax-YLABELPOS); 
       if (ticdir>0) prtext ("r",charsiz,calstr);  /* draw y axis calib label */
       else          prtext ("l",charsiz,calstr);
     }
    }
     cpen (pen);
   }
 }              /* for (i; i<ttotplots; ) */

if (!nonodes) {
 if (plsep)
  for (i=0; i<totplots; i++) {                   /* draw node nums */
    n = looklist(i); 
    pen = plotnod[n].ppen;
    if (pen == 0) pen = WHITE;
    cpen (pen);                                  /* change pen for node num */
    if (plsep) ybase = ((double)i)/ttotplots + yplotmarg;
    else       ybase = yplotmarg;
    move (0.001, ybase+yaxis/2);                 /* display node number */
  if (plotnod[n].cnod2 > NULLNOD) {
   prnum ("l",charsiz,"%2g %2g",
		(double)plotnod[n].cnod1,
		(double)plotnod[n].cnod2,0);	 /* (no room for cnod3) */
  }
  else
   prnum ("l",charsiz,"%2g",
   		(double)plotnod[n].cnod1,0,0); 	 /* (no room for cnod3) */
  } 
 else {     /* !plsep */
  for (i=0; i<totplots; i++) {                   /* draw node nums */
    n = looklist(i); 
    pen = plotnod[n].ppen;
    if (pen == 0) pen = colortab[n];             /* default pen is plot num */
    cpen (pen);                                  /* change pen for node num */
    ybase = yplotmarg;
    move (0.001, ybase+yaxis/2+(totplots/2-i)*charsiz*1.2); /* disp node num */
  if (plotnod[n].cnod2 > NULLNOD) {
   prnum ("l",charsiz,"%2g %g  ",
		(double)plotnod[n].cnod1,
		(double)plotnod[n].cnod2,0);	 /* (no room for cnod3) */
  }
  else
   prnum ("l",charsiz,"%2g    ",
   		(double)plotnod[n].cnod1,0,0); 	 /* (no room for cnod3) */
  }      /* for (i;;) */
 }     /* else !plsep */
}    /* if (!nonodes) */

 if (!nofilfl) {
   cpen (WHITE);
   move (0.75, 0.95);
   if (infile && srcfile) {		/* if both infile and srcfil defined */
        prtext ("l",charsiz,infile);	/*  print infile only. */
   }
   else if (srcfile) 
        prtext ("l",charsiz,srcfile);
   else if (infile) 
        prtext ("l",charsiz,infile);
 }

 gpurge();

#ifdef DEBUG 
 if (debug & 1) fprintf (stderr,"plotinitend\n");
#endif

}

/*------------------------------------*/

void prnum (char *adj,double csize,char *fmt,
		double val1,double val2,double val3) 

/* print a number, formatted with either
    left, right, or center justification. */

{
   char numbuf[30];

  sprintf (numbuf,fmt,val1,val2,val3);
  prtext (adj,csize,numbuf);
}

/*------------------------------------*/

void prtext (char *adj, double csize, char *str)

/* print a string, formatted with either
    left, right, or center justification. */

{
    double len,xoffs,yoffs;
    int large,small,caps;
    char *p;

  if (!str) return;
  yoffs = 0;
  len = strlen(str);    		   /* length of number */
  large=small=caps=0;
  for (p=str;*p; p++) {
     if (*p=='m') large++;
     else if (*p=='w') large++;
     else if (*p=='i') small++;
     else if (*p=='.') small++;
     else if (*p==',') small++;
     else if (*p=='-') small++;
     else if (*p==':') small++;
     else if ((*p>='A')&& (*p<='Z')) caps++;
  }
  len += (large+caps)*0.7 - (small*0.5);   /* proportional spacing */

  switch (*adj) {

    case 'c': xoffs=len/2.0;    	   /* center justification */
   	     break;
    case 'l': xoffs=0;    		   /* left justification */
	     break;
    case 'r': xoffs=len;		   /* right justification */
	     break;
    default: fprintf (stderr,"prtext: bad adjust\n");
	      return;
	     break;
  }
  xoffs *= csize * .65;
  rmove (-xoffs, yoffs);
  textf ("%s",str);
}

/*------------------------------------*/

int looklist(int i)
         

/* lookup plot in command line list and possibly
    return different plot number.
    This rearranges order of displayed plots.
*/

{
    extern int listplots[];

   if (i<0) i = 0;
   if (listplots[0]) {
	i=listplots[i]-1;	 /* possibly different order */
  	if (i<0) i = 0;		/*   from command line */
	if (i>=dttplots) i = dttplots - 1;
   }
  return i;
}

/*------------------------------------*/

void getplot(FILE *instream, int numpl, int setauto)

/* reads in data from file for plotting */

{
#define INBUFSIZ 4000

   static char *inbuf,tfil[20];
   int i,f,k,n,ttplots,pmod,pen,npl,nplot,narg,lchar,charmode;
   char *str, *ptr, pmodc, *fgets(char *, int, FILE *);
   double val, xval,csize;
   double x,y;
   static int automode = 1;

 if (!(inbuf = (char *)emalloc (INBUFSIZ))) {
	fprintf (stderr,"Error, getplot: can't allocate line buffer\n");
        exit(1);
 }

  if (setvid) vidmode = 1;
  else if (unsetvid) vidmode = 0;

  for (npl=0; fgets(inbuf,INBUFSIZ,instream); ) {
 
   if (inbuf[0] == '#') {
     if (!setauto)
      switch (inbuf[1])  {

       case 'c':
                strcpy (complin,inbuf);
		break;
       case 'd':
                sscanf(inbuf,"%*s %d %*s %d\n",&pen,&nplot);
                if (nplot>=PLOTNODSIZ) nplot = PLOTNODSIZ-1;
                if (pen == 0) pen = colortab[nplot];
		plotpen(pen,nplot);
                break;
       case 'l':
               sscanf(inbuf,"%*s '%c' %*s %c %*s %d\n",&lchar,&charmode,&nplot);
                if (nplot>=PLOTNODSIZ) nplot = PLOTNODSIZ;
		plotchar(lchar,charmode,nplot);
                break;
       case 'z':
                sscanf(inbuf,"%*s %lg %*s %d\n",&csize,&nplot);
                if (nplot>PLOTNODSIZ) nplot = PLOTNODSIZ-1;
		plotcsiz(csize,nplot);
                break;
       case 'f':
                narg = sscanf(inbuf,"%*s %s %*s\n",tfil);
		if (strcmp(tfil,"stimfile") == 0) {
                   narg = sscanf(inbuf,"%*s stim file %s\n",stfilnam);
		   stfile = stfilnam;
		}
		else if (strcmp(tfil,"input") == 0) {
                   narg = sscanf(inbuf,"%*s input file %s\n",infilnam);
/*		   infile = infilnam;     /* ignore "infile" here, */
		}			  /*  set infile from command line */
		else if (strcmp(tfil,"source") == 0) {
                   narg = sscanf(inbuf,"%*s source file %s\n",srcfilnam);
		   srcfile = srcfilnam;
		}
                break;

       case 'g':

		switch (inbuf[2]) {
   
    		case 'c': switch(inbuf[3]) {

		  case 'i': sscanf (inbuf,"%*s %lg%*[ ,]%d",&x,&f); /* circle */
			  gcirc(x,f);
			  break;

		  case 'r': sscanf (inbuf,"%*s  %lg", &x);
			  gcrotate (x);
			  break;

		  case 't': gctext ();			/* text mode */
			  break;			/* antiquated */

		  case 'g': gcgraphics ();		/* graphics mode */
			  break;			/* antiquated */

		   case 'w': sscanf (inbuf,"%*s  %lg", &x);
			  gcwidth(x);	
			  break;
			}
			break;
		
    		case 'd': switch(inbuf[3]) {

    			case ' ':			/* draw */
			 sscanf (inbuf,"%*s %lg%*[ ,]%lg", &x,&y);
			 gdraw (x,y);
			 break;

			case 'a':			/* dash */
			 sscanf (inbuf,"%*s %lg", &x);
   			 gdash ((int)x);
			 break;

			}  /* case "gd?" */
			break;
	
    		case 'f': sscanf (inbuf,"%*s %s", tfil);	/* frame */
			  gframe (tfil);
			  break;

    		case 'h': switch(inbuf[3]) {

    			case 'i': ghinit ();		/* hidinit */
			 break;

			case 's': ghstart();		/* hidstart */
			 break;

			case 'e': ghend();		/* hidstop */
			 break;

			}  /* case "gh?" */
			break;
	
    		case 'm': sscanf (inbuf,"%*s  %lg%*[ ,]%lg", &x,&y);
			  gmove (x,y);
			  break;

    		case 'o': sscanf (inbuf,"%*s  %lg%*[ ,]%lg", &x,&y);
			  gorigin (x,y);
			  break;

    		case 'r': switch(inbuf[3]) {

			  case 'd':
			   sscanf (inbuf,"%*s  %lg%*[ ,]%lg", &x,&y);
			   grdraw (x,y);
			   break;

			  case 'e': {				/* rectangle */
				double x1,y1,x2,y2,x3,y3,x4,y4;
				int fill;
	
			  sscanf (inbuf,
  "%*s  %lg%*[ ,]%lg%*[ ,]%lg%*[ ,]%lg%*[ ,]%lg%*[ ,]%lg%*[ ,]%lg%*[ ,]%lg%*[ ,]%d",
			 &x1,&y1,&x2,&y2,&x3,&y3,&x4,&y4,&fill);
			    grect (x1,y1,x2,y2,x3,y3,x4,y4,fill);
			   }
			   break;

			  case 'f':
    			   sscanf (inbuf,"%*s %s", tfil);	/* rmframe */
			   grmframe (tfil);
			   break;

			  case 'm':
			   sscanf (inbuf,"%*s  %lg%*[ ,]%lg", &x,&y);
			   grmove (x,y);
			   break;
    		
			  case 'o':
			   sscanf (inbuf,"%*s  %lg", &x);
			   grotate (x);
			  break;

			 }
			 break;  /* case "gr?" */

    		case 'p': switch(inbuf[3]) {

    			case 'e': sscanf (inbuf,"%*s %lg", &x);
			  	  gpen ((int)x);
			  	  break;
    			case 'u': gpurge ();
			  	  break;

		}   /* case "gp?" */
		break;

    		case 's': sscanf (inbuf,"%*s %lg", &x);
			  gsize (x);
			  break;

    		case 't': i = strlen (&inbuf[4]);
			  inbuf[i+3] = 0;
			  gtext (&inbuf[4]);
			  break;

		}  /* switch (inbuf[2] */
		break;		/* case "g?"  (graphics primitives */

      case 'p':
                narg = sscanf(inbuf,"%*s %d %*s %*s %lg %*s %lg\n",
				&dttplots,&plmax,&plmin);
                if (narg<3) {
		    plmax =  .04;
		    plmin = -.07;
		}
		if (numpl) ttplots = numpl;
                else ttplots = dttplots;
                break;
      case 'e':
                narg = sscanf(inbuf,"#e %*s %lg %*s %lg %*s %ld %*s %lg\n",
				&xtime,&endexp,&drseed,&ncversion);
		if (narg < 4) {				/* old version */
                   narg = sscanf(inbuf,"#e %lg %*s %*s %ld %*s %lg\n",
				&endexp,&drseed,&ncversion);
		   xtime = 0;
		}
                break;
      case 'x':
                narg = sscanf(inbuf,"#x %*s %d %d %d %*s %c %*s %lg %*s %lg\n",
                  &plotnod[npl].cnod1,&plotnod[npl].cnod2,&plotnod[npl].cnod3,
		  &pmodc,&plotnod[npl].pxmax,&plotnod[npl].pxmin);

		  if (setxmax > -1e10 && plotnod[npl].pxmax > -1e-10) 
				 plotnod[npl].pxmax = setxmax;
		  if (setxmin > -1e10 && plotnod[npl].pxmin > -1e-10) 
				 plotnod[npl].pxmin = setxmin;

                  switch (pmodc) {
                    case 'V':   pmod = VREC;   break;      
                    case 'I':   pmod = IREC;   break;      
                    case 'L':   pmod = LREC;   break;      
                    case 'G':   pmod = NRECG0; break;      
                    case 'C':   pmod = NRECG1; break;      
                    case 'S':   pmod = SREC;   break;      
                    case 'F':   pmod = NRECA0; break;      
                    case 'R':   pmod = NRECA9; break;      
                    case 'X':   pmod = GREC;   break;      
                  }
                plotnod[npl].pmod = pmod;
                break;
      case 'y':
             narg=sscanf(inbuf, "#y %*s %d %*s %c %*s '%c' %*s %lg %*s %lg\n",
			&pen, &plotnod[npl].charmode, &plotnod[npl].charfl,
			&plotnod[npl].pymax, &plotnod[npl].pymin);

		if (narg < 5)			/* no char */
                  narg = sscanf(inbuf, "#y pen %d styl %c ymax %lg ymin %lg\n",
			&pen, &plotnod[npl].charmode,
			&plotnod[npl].pymax, &plotnod[npl].pymin);
		if (narg < 4)			/* no char */
                  narg = sscanf(inbuf, "#y pen %d mode %c ymax %lg ymin %lg\n",
			&pen, &plotnod[npl].charmode,
			&plotnod[npl].pymax, &plotnod[npl].pymin);

		if (narg < 3)			/* no max min */
                  narg = sscanf(inbuf, "#y pen %d styl %c\n",
			&pen, &plotnod[npl].charmode);

		if (narg < 2) {			/* old version */
                  narg = sscanf(inbuf, "#y pen %d ymax %lg ymin %lg\n",
                      &pen, &plotnod[npl].pymax, &plotnod[npl].pymin);
		  plotnod[npl].charmode = PLINES;
		}
		if (setymax > -1e10 && plotnod[npl].pymax > -1e-10) 
				 plotnod[npl].pymax = setymax;
		if (setymin > -1e10 && plotnod[npl].pymin > -1e-10) 
				 plotnod[npl].pymin = setymin;
		plotnod[npl].ppen = pen;
                if (npl <  dttplots) npl++;
                break;

      case 'r':                         /* restart */
                plotrst (ttplots);
                break;
      case 'n':                         /* node label */
                plotinit (ttplots);
		automode = 0;
                break;

    }  /* switch */ 
   }  /* if (inbuf[]==) */ 

  else {
    int j;
    static double plotval[PLOTNODSIZ];
    static int firstline = 1;

  if (automode && firstline) {
      firstline = 0;
      autograph(instream,inbuf,numpl);
  }
  else {
    str=ptr=inbuf;
    val=strtod(str,&ptr);
    xval = val;
    for (j=k=0; str != ptr && k < PLOTNODSIZ ; k++) {
      str = ptr;
      val=strtod(str,&ptr);
      if (str != ptr) {
         plotval[k] = val;	/* read in plots from one line */
	 j++;
      }
    }  
    if (numpl)
      for (k=0; k<numpl; k++) {	       /* display in possibly different order */
           n = looklist(k);   		/* set by command line */
	   if (n<j) mplot(plotval[n],xval,ttplots,k); 
    }  
    else
      for (k=0; k<j; k++) {	       /* otherwise orig order */
	   mplot(plotval[k],xval,ttplots,k); 
    }  

   }  /* else */
  } /* for */
 }
}

/*------------------------------------*/

void autograph(FILE *instream, char *inbuf, int numpl)
                  
/* Plot a graph from a file with multiple lines, 
    each line containing one x value and one or 
    more y values.  Also works for only one number
    per line, in which case the number is assumed to
    be a y value.  In this case, the x value is assumed
    to be the line number.  The "numpl" parameter
    controls how many of the columns (or rows) are plotted.

 */

{
   int i,j,jstart,k,cols,tcols,lines,nox,totplots,pl,graphsiz;
   char *str,*ptr;
   double val,xval,yval,ymax,ymin,xmax,xmin;
   float *plotarr,*plotp;

#define GRAPHMEM (PLOTNODSIZ*500)

 if (!(plotarr = (float *)emalloc (GRAPHMEM * sizeof(float)))) {
	fprintf (stderr,"Error, autograph: can't allocate memory\n");
        exit(1);
 }
 ptr=inbuf;
 str = 0;
 plotp = plotarr;
 for (cols=k=0; str != ptr && k < PLOTNODSIZ ; k++) {
   str = ptr;
   val=strtod(str,&ptr);
   if (str != ptr) {
      *plotp++ = val;			/* read in plots from first line */
      cols++;
   }
 }  
 if (k>=PLOTNODSIZ) {
	fprintf (stderr,"Error: getplot: %d too many columns  file\n",k);
	return;
 } 
 if (cols==0) {
	fprintf (stderr,"Error: getplot: invalid input file, no cols\n");
	return;
 }
 graphsiz = GRAPHMEM / cols;

 for (lines=1; fgets(inbuf,INBUFSIZ,instream) && lines<graphsiz; lines++) {
   if (inbuf[0] == '#') { lines--; continue; }
    ptr=inbuf;
    str = 0;
    for (k=0; str != ptr && k < cols ; k++) {
      str = ptr;
      val=strtod(str,&ptr);
      if (str != ptr) {
         *plotp++ = val;		/* read in plots from one line */
      }
      else
         *plotp++ = 0.0;		/* if not enough, then insert a 0 */
    }  
  }  /* for (lines=0; fgets; ) */

  if (lines>=graphsiz) {
	fprintf (stderr,"Error: getplot: too many lines %d\n",lines);
	return;
  }

 if (rowmode) {				/* if "rowmode", swap cols with lines */
	tcols = cols;
	cols = lines;
	lines = tcols;
 }
 if (cols>0 && lines>1) {
   if (cols>1) {
      totplots = cols - 1;
      nox = 0;
   }
   else {
     totplots = 1;
     nox = 1;
   } 
   if (setnox) {
      nox = 1;		/* here we want no y val, multiple x values */
      totplots = cols;
   }
				/* find max, min */
   if (nox) jstart = 0;
   else     jstart = 1;
   for (j=jstart; j<cols; j++) {		/* do one column at at time */
     if (nox) pl = j;
     else     pl = j-1;  
     xmax=ymax = -1e30;
     xmin=ymin = 1e30;
     for (i=0; i<lines; i++) {
       if (rowmode) {				/* if rowmode,swap i,j,row,col*/
         if (nox) xval = i+1;			/* xval is line number */
         else     xval = *(plotarr+i);		/* find max, min of x */
         yval = *(plotarr+i+j*lines);		/* find max, min of y */
       }
       else {
         if (nox) xval = i+1;			/* xval is line number */
         else     xval = *(plotarr+i*cols);	/* find max, min of x */
         yval = *(plotarr+i*cols+j);		/* find max, min of y */
       }
       if (xmax<xval) xmax = xval;
       if (xmin>xval) xmin = xval;
       if (ymax<yval) ymax = yval;
       if (ymin>yval) ymin = yval;
     }
    plotnod[pl].pxmax = xmax;
    plotnod[pl].pxmin = xmin;
    plotnod[pl].pymax = ymax;
    plotnod[pl].pymin = ymin;
    plotnod[pl].xrange = xmax - xmin;
    plotnod[pl].yrange = ymax - ymin;
    plotnod[pl].ppen = colortab[looklist(pl)];
    plotnod[pl].pmod = GREC;
    plotnod[pl].automax = 1;
   }

   dttplots = totplots;
   if (numpl) totplots = numpl;		/* override default number of plots */

   if (!nox) {
     xmax=ymax = -1e30;
     xmin=ymin = 1e30;
     for (j=0; j<totplots; j++) {
       pl = looklist(j);         	/* check plots actually used */

       xval = plotnod[pl].pxmax;	/* find overall maxes */
       yval = plotnod[pl].pymax;
       if (xmax<xval) xmax = xval;
       if (ymax<yval) ymax = yval;

       xval = plotnod[pl].pxmin;	/* find overall mins */
       yval = plotnod[pl].pymin;
       if (xmin>xval) xmin = xval;
       if (ymin>yval) ymin = yval;
     }
     if (setxmax > -1e10) xmax = setxmax; /* set defaults from overrides */
     if (setxmin > -1e10) xmin = setxmin;
     if (setymax > -1e10) ymax = setymax;
     if (setymin > -1e10) ymin = setymin;

     plotnod[0].pxmax = xmax; 
     plotnod[0].pxmin = xmin; 

     for (j=0; j<totplots; j++) {	/* set all ymin, ymax to overall vals */
       pl = looklist(j);         	/* check plots actually used */
       plotnod[pl].pymin = ymin; 
       plotnod[pl].pymax = ymax; 
     }
   }    /* if (!nox) */

   nonodes = 1;

   plotinit (totplots);			/* make and label axes of graph */

   if (nox) tcols = totplots;
   else     tcols = totplots+1;
   if (dashfl) {
     for (k=jstart; k<tcols; k++) {
       if (nox) {
         pl = k;
         j = looklist(pl);             /* possibly modify plot order */
       }
       else  {
         pl = k-1;  
         j = looklist(pl) + 1;         /* possibly modify plot order */
       }
       dash ((long)(pl & 7)); /* */
       for (i=0; i<lines; i++) {
         if (rowmode) {			/* if rowmode,swap i,j,row,col */
          if (nox) 
           mplot (*(plotarr+i+j*lines),(double)(i+1),totplots,pl);
	  else
           mplot (*(plotarr+i+j*lines),*(plotarr+i),totplots,pl);
        }
        else {
         if (nox)
           mplot (*(plotarr+i*cols+j),(double)(i+1),totplots,pl);
	 else
           mplot (*(plotarr+i*cols+j),*(plotarr+i*cols),totplots,pl);
      } /* else */
     }  /* for (i=1;;) */
    }  /* for (k=1;;) */
   }
   else {	/* not dashfl */
      for (i=0; i<lines; i++) {
       for (k=jstart; k<tcols; k++) {
        if (nox) {
          pl = k;
          j = looklist(pl);             /* possibly modify plot order */
        }
        else  {
          pl = k-1;  
          j = looklist(pl) + 1;         /* possibly modify plot order */
        }
         if (rowmode) {			/* if rowmode,swap i,j,row,col */
          if (nox) 
           mplot (*(plotarr+i+j*lines),(double)(i+1),totplots,pl);
	  else
           mplot (*(plotarr+i+j*lines),*(plotarr+i),totplots,pl);
        }
        else {
         if (nox)
           mplot (*(plotarr+i*cols+j),(double)(i+1),totplots,pl);
	 else
           mplot (*(plotarr+i*cols+j),*(plotarr+i*cols),totplots,pl);
      } /* else */
     }  /* for (k=1;;) */
    }  /* for (i=1;;) */
  }  /* if (dashfl) {} else {} */

 } /* if (cols) */
/* fprintf (stderr,"lines %d cols %d\n",lines,cols); */
}

