/* ncnode.cc */

#include "nc.h"
#include "y.tab.h"
#include "ncelem.h"
#include "ncsub.h"

#define NHASHSIZ 199                     /* prime number to make better hash */

static node *nhashtab[NHASHSIZ] = {0};  /* node hash table */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
void free(...);

#ifdef __cplusplus
}
#endif

extern node *nodepnt;
extern node *nodend;
extern int cumnode;

char *emalloc(unsigned int n);
void execerror(char *s, char *t);

/*---------------------------------------------------*/

void ninithash(void)
{
   int i;

   for (i=0; i<NHASHSIZ; i++) 
     nhashtab[i] = 0;
}

/*---------------------------------------------------*/

int nodehash(short int nodea, short int nodeb, short int nodec)

/* make disordered index of symbol name */

{
   int i;

   if (nodea!=NULLNOD) i  = nodea; 
   if (nodeb!=NULLNOD) i += nodeb; 
   if (nodec!=NULLNOD) i += nodec; 
   if (i<0) i = -i;
   return (i % NHASHSIZ); 
}

/*---------------------------------------------------*/

void ninstall (node *newnod, short int na, short int nb, short int nc)
              
/* Install a symbol in hash table */
/*  Uses "direct chaining" with field "hnext". */

{
    int i;
    node *npnt,*nlast;
    static int ninitfl=0;

   if (!ninitfl) {			/* initialize table once at start */
        ninitfl = 1;
        ninithash();
   }
   newnod->hnext = 0;
   i=nodehash(na,nb,nc); 		/* initial index into nhashtab*/ 
   if (!(npnt=nhashtab[i]))             /* install directly in table */
      nhashtab[i] = newnod;
   else {                               /* otherwise, go to end of list */
      for (; npnt; npnt=npnt->hnext)    /* find last symbol */
          nlast = npnt;    
      nlast->hnext = newnod;            /* put new symbol at end of list */
   }
}

/*---------------------------------------------------*/

node *maknod(short int nodea, short int nodeb, short int nodec)
                          
/* make a new node, and link it to the
   beginning of the node list. */

{
    node *npnt;
 
  if ((npnt=(node *)emalloc(sizeof(node))) == NULL) {
     fprintf (stderr,"no space left for node %d\n",cumnode+1);
     return (NULL);  
  }
  npnt->next = nodepnt;		/* Set up "next" to connect all nodes. */
  nodepnt = npnt;  		/*  We use "hnext" for hash table. */
  if (!nodend)
    nodend = npnt;


  ninstall(npnt,nodea,nodeb,nodec);		/* install in hash table */

  nodepnt->elemlst = NULL;
  nodepnt->comptr = NULL;
  nodepnt->ctype = NODE;
/*
  if (nodea > MAXSHORT || nodeb > MAXSHORT || nodec > MAXSHORT) {
    fprintf (stderr,"Node number %d %d %d too large\n",nodea,nodeb,nodec);
    execerror ("Bad node value: ","stopping...");
  }
*/
  if (nodea < 0 || nodeb < 0 || nodec < 0) {
    if (nodea > NULLNOD && nodeb > NULLNOD && nodec > NULLNOD) { 
    fprintf (stderr,"Node number %d %d %d is negative\n",nodea,nodeb,nodec);
    execerror ("Bad node value: ","stopping...");
   }
  }
  nodepnt->nodenm1 = nodea;
  nodepnt->nodenm2 = nodeb;
  nodepnt->nodenm3 = nodec;
  nodepnt->xloc = NULLNOD;
  nodepnt->yloc = NULLNOD;
  nodepnt->zloc = NULLNOD;
  cumnode++;                    /* increment total */
  return (nodepnt); 
}

/*---------------------------------------------------*/

node *findnode(short int num1, short int num2, short int num3, char *str)
                      
/* Find node among list of all nodes.
   Once node is found, move it to start of list,
   so it can be found easier the next time.
   The node itself is not moved, therefore only the 
   pointers of the node list need rearranging.
   Pointers in other lists that point to nodes remain correct.
*/

{
   node *npnt;
   int i,found;

        
  i = nodehash(num1,num2,num3);
  for (found=0,npnt = nhashtab[i]; npnt; npnt = npnt->hnext) {
    if ((npnt->nodenm1==num1) && (npnt->nodenm2==num2)&&(npnt->nodenm3==num3)) {
       found = 1;
       break;
    }
  }

  if (found) return npnt;
  else {
    if (str) {
      if (num3 != NULLNOD)
         fprintf (stderr,"%s: can't find node %d %d %d\n",str,num1,num2,num3);
      else if (num2 != NULLNOD)
         fprintf (stderr,"%s: can't find node %d %d\n",str,num1,num2);
      else 
         fprintf (stderr,"%s: can't find node %d\n",str,num1);
    }
   return NULL; 
  }
}

/*---------------------------------------------------*/

