/* segment ncmain in program ncmod */

/* Main routines for interpreter */

#include "nc.h"
#include "ncval.h"
#include "y.tab.h"
#include <ctype.h>

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <math.h>

#ifdef __cplusplus
}
#endif

#include <stdlib.h>
#include "adef.h"

#include <signal.h>
#include <setjmp.h>
jmp_buf begin;

#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/times.h>

/* #ifndef _SYS_TIMES_H_
 long times(struct tms *);
#endif				/* */

void exit(int code);

#ifdef __cplusplus
}
#endif


/* #define TIMECALIB 3600.0	/* times() system call gives 1/60  sec */
#define TIMECALIB 6000.0	/* times() system call gives 1/100 sec */

struct tms timebuf;
struct tms *timepnt;
double runmin=0.0;
double timecalib=TIMECALIB;
double startclk,startu,totmin;

extern char	*progname;
extern char 	*runfile;	/* interactive file name */
extern int stimcode;		/* = 1 -> says we're running "stim", not "nc" */

extern int vidmode;		/* video mode set (defined in control.h) */
int	nofilfl=0;		/* =1 -> no filename in plot */
int	finfl=0;		/* =1 -> no labels in plot */
int     setvid = 0;     	/* set vid mode on output */
int     unsetvid = 0;   	/* unset vid mode on output */
int     setdebug = 0;   	/* set debug level from command line */
int     setdebgz = 0;   	/* set debug mode from command line */
int     setdisp = -1;   	/* set disp mode from command line */
int     setprmap = -1; 		/* set print mode from command line */
double  setlamcrit = -1;	/* set lambda crit from command line */
long int drseed = 0;    	/* random seed set from command line */
int     tabmode = 0;   		/* set tabs on output from command line */
int	nonodes = 0; 		/* =1 -> no nodes in video display */
int	rowmode = 0; 		/* =1 -> numbers for plot in row */
int	setnox = 0; 		/* =1 -> no x value, multiple y vals on input*/
int   disp_ray = 0;           	/* =1 -> render 3D with ray-tracing */
extern int runyet;		/* resets time, in ncsub.c */
double charsiz=CHARSIZ;		/* char size for plot labels */
extern double ncversion;	/* nc version number */
double linewidth=LINEWIDTH;  /* line width for ncdisp.c */

double varval[VVSIZE] = {0};	/* temp values for setting variables */
char *varpnt[VVSIZE] = {0};	/* temp pointers for setting variables */
int vartyp[VVSIZE] = {0};	/* temp type for setting variables */
int varset = 0;			/* index for setting variables */

char    *srcfile = 0;		/* source file name */
char    *infile = "stdin";	/* input file name, used by "plotmod" */
char    *einfile;       	/* input file name for error reports */

extern onintr(void);
int istat;	/* interrupt status upon entering program */

extern FILE *stimout;
extern FILE *stimin;
FILE *fin;

void ncrun(int hlp);
void ncleanup();
void initpl(int charind);
void init();
void run();	
void prtime(FILE *stimout);
void sortstimfile();
void bexit();

/*------------------------------------*/

main(int argc, char **argv)
{
   char *cptr;

 fin = stdin;
 istat = (int)signal(SIGINT, SIG_IGN);	/* save original status */
 runfile = "ncfile";
 einfile = infile;
 progname = argv[0];
 if (argc==1)			/* if user needs help */
   ncrun(1);
 else
 do					/* if there are any switches */
  {
   argc--; argv++;
   cptr = *argv;
   if (argc)
    {
     if (*cptr == '-')
      {
       cptr++;
       switch (*cptr)
        {
        case 'd': argc--; argv++;    		 /* display comps and conns */
		  setdisp = (int) atof(*argv);
                  break;

        case 'l': argc--; argv++;    		/* set lambda crit. */
		  setlamcrit = (int) atof(*argv);
                  break;

        case 'f': nofilfl = !nofilfl;      	 /* =1 -> no filename in disp */
                  break;

        case 'F': finfl = !finfl;      	 	/* =1 -> no labels in disp */
                  break;

        case 'n': nonodes = !nonodes;       /* =1 -> no node numbers in disp */
                  break;

        case 'p': argc--; argv++;
		  setprmap = (int)atof(*argv);      /* print comps and conns */
                  break;

        case 'r': argc--; argv++;
		  drseed = (int)atof(*argv);      /* set random seed */
                  break;

        case 's': argc--; argv++;	        /* set variable */
		  varpnt[varset] = *argv;       /* remember string */
		  argc--; argv++;
		  if (isalpha(**argv)) {
		     varval[varset] = (double)(int)*argv; /* remember string */
		     vartyp[varset] = STRING;
		  }
		  else {
		     varval[varset] = atof(*argv); /* remember value */
		     vartyp[varset] = NUMBER;
		  }
		  varset++;
		  if (varset >= VVSIZE) varset = VVSIZE-1;
                  break;

        case 't': unsetvid = 1;         /* unset vid mode on output */
                  setvid = 0;
                  break;

        case 'v': setvid = 1;           /* set vid mode on output */
                  unsetvid = 0;
                  break;

        case 'w': argc--; argv++;
		  linewidth = atof(*argv);      /* set line width for ncdisp */
                  break;

        case 'W': argc--; argv++;
		  charsiz = atof(*argv);      /* char size for plot labels */
                  break;

        case 'x': tabmode = !tabmode;     /* print tabs on output */
                  break;

        case 'y': argc--; argv++;    		/* set debug level */
		  setdebug = (int)atof(*argv);
                  break;

        case 'z': argc--; argv++;    		/* set debug mode */
		  setdebgz = (int)atof(*argv);
                  break;

	case 'R': disp_ray = !disp_ray;     /* render 3D ray-tracing */
		  break;

	default:
		fprintf (stderr,"nc: unknown switch '%s'\n",*argv);
		exit(1);

        }  /* switch */
      }	   /* if (*cptr=) */
     else
      {
       if((fin=fopen(cptr,"r"))==NULL)
         {
           fprintf(stderr, "%s: can't open %s\n", progname, cptr);
           continue;
         }
       srcfile = cptr;
       infile = srcfile;
       ncrun(0);
       if (argc <= 1) break;
      }			/* else (*cptr != '-') */
     if (argc<=1) ncrun(1);		/* there were arguments but no files */
    }			/* if (argc) */
  }			/* do */
 while (argc > 0);
}

/*------------------------------------*/

void ncrun(int hlp)
{
/*  if(fin==stdin) system ("stty erase \n"); 		/* */
  timepnt = &timebuf;
  startclk = times(timepnt);
  startu = timepnt->tms_utime;
  ncversion = 3.6;
  if (hlp) printf ("## %s version #%-4.1f\n",progname,ncversion);
  runyet = 0;		/* resets time */
  if (srcfile) einfile = srcfile;
  ncleanup();		/* erase lists  (in "ncmak.c")  */
  initpl(0);		/* init plot stuff, in "ncplot.c" */
  init();			/* init variables, symbol table, in "init.c" */
  run();			/* in "ncm.c"    */
  if (stimcode) {
      if (stimout) {
	 prtime(stimout);	/* set file for printout of time */
      	 fclose (stimout);
      }
      if (stimout!=stdout) sortstimfile();
  }
  else bexit();
}

void bexit(void)

/* things to do before exit */

{
  if (!vidmode && !disp_ray) prtime(stdout);  /* print run times */
}


void prtime(FILE *fout)
{
  totmin = (times(timepnt) - startclk) / timecalib;
  runmin = (timepnt->tms_utime - startu) / timecalib;
  fprintf (fout,"## time elapsed: %s %.4g  total %.4g minutes.\n",
					progname,runmin,totmin);
  fflush (fout);
}

datum elap_time(void)
{
   datum d;

  totmin = (times(timepnt) - startclk) / timecalib;
  runmin = (timepnt->tms_utime - startu) / timecalib;
  d.val = runmin;
  d.vtype = NUMBER;
  return (d);			/* return elapsed run time */
}

