/* init.c */

#include "nc.h"
#include "y.tab.h"
#include <math.h>
#include "ncval.h"
#include "ncelem.h"
#include "controlx.h"

extern double varval[VVSIZE];
extern char *varpnt[VVSIZE];
extern int vartyp[VVSIZE];
extern int varset;
extern char *progname;
extern int setdisp;
extern int setprmap;
extern int setvid, unsetvid;

extern datum	ncasin(datum x), ncatan(datum x), nclog(datum x);
extern datum	nclog10(datum x), ncsqrt(datum x), ncexp(datum x);
extern datum	ncsin(datum x), nccos(datum x), nctan(datum x);
extern datum    ncfabs(datum a), ncinteger(datum x), ncrand(void);
extern datum	ncpow(datum x, datum y), ncabs(double x), elap_time(void);
extern datum	setvarval(void), xstrlen(datum d), xstrtok(datum d1, datum d2);

Symbol *timeptr;
Symbol *ncompptr;

#ifdef __cplusplus
extern "C" {
#endif

#include "stdplt.h"
#include "gr.h" 
int getpid(void);

#ifdef __cplusplus
}
#endif

double lookpv(char *s);
Symbol *lookup(char *s);
void erasymb();
void setval(Symbol *sym, double val, int vtyp);
void dinit();
void varcopy();
void initrec();
void dinit();
void setrand (long int rseed);

/*--------------------------------------------------------*/

static struct {		/* Keywords */
	char	*name;
	int	kval;
} keywords[] = {
	"proc",		PROC,
	"func",		FUNC,
	"return",	RETURN,
	"exit",	        EXIT,
	"if",		IF,
	"else",		ELSE,
	"while",	WHILE,
	"print",	PRINT,
	"printf",	PRINTF,
	"fprintf",	FPRINTF,
	"read",		READ,
	"fread",	FREAD,
	"fwrite",	FWRITE,
	"dim",		DIM,
	"fft",		FFT,
	"ifft",		IFFT,
	"pfft",		PFFT,
	"acov",		ACOV,
	"foreach",	FOREACH,
	"for",		FOR,
	"break",	BREAK,
	"continue",	CONTINUE,
	"edit",		EDIT,
	"system",	SYSTEM,
	"include",	INCLUDE,
	"local",	LOCAL,
	"element",	ELEMENT,
	"matching",	MATCHING,
	"except",	EXCEPT,
	"comps",	COMPS,
	"range",	RANGE,
	"cable",	CABLE,
	"sphere",	SPHERE,
	"chan",		CHAN,
	"HH",		HH,
	"Na",		NA,
	"K",		K,
	"type",		TYPE,
	"density",	DENSITY,
	"taum",		TAUM,
	"tauh",		TAUH,
	"taun",		TAUN,
	"tauc",		TAUC,
	"Ca",		CA,
	"cao",		CAO,
	"cai",		CAI,
	"cbound",	CBOUND,
	"vmax",		VMAX,
	"km",		KM,
	"kex",		KEX,
	"capump",	CAPUMP,
	"caexch",	CAEXCH,
	"d1",		D1,
	"d2",		D2,
	"k1",		K1,
	"k2",		K2,
	"gj",		GJ,
	"synapse",	SYNAPSE,
	"load",		LOAD,
	"resistor",	RESISTOR,
	"rod",		ROD,
	"cone",		CONE,
	"maxcond",	MAXCOND,
	"length",	LENGTH,
	"dia",		DIA,
	"radius",	RADIUS,
	"width",	WIDTH,
	"stim",		STIM,
	"bar",		BAR,
	"spot",		SPOT,
	"rect",		RECT,
	"sine",		SINE,
	"xenon",	XENON,
	"sun",		SUN,
	"wavel",	WAVEL,
	"pigm",		PIGM,
	"pathl",	PATHL,
	"attf",		ATTF,
	"filt",		FILT,
	"save",		SAVE,
	"restore",	RESTORE,
	"gndbatt",	GNDBATT,
	"batt",		BATT,
	"cap",		CAP,
	"gndcap",	GNDCAP,
	"node",		NODE,
	"node1a",	NODE1A,
	"node1b",	NODE1B,
	"node1c",	NODE1C,
	"node2a",	NODE2A,
	"node2b",	NODE2B,
	"node2c",	NODE2C,
	"vclamp",	VCLAMP,
	"cclamp",	CCLAMP,
	"loc",		LOC,
	"xloc",		XLOC,
	"yloc",		YLOC,
	"zloc",		ZLOC,
	"center",	CENTER,
	"sscale",	SSCALE,
	"dur",		DUR,
	"tfreq",	TFREQ,
	"orient",	ORIENT,
	"contrast",	CONTRAST,
	"start",	START,
	"inten",	INTEN,
	"backgr",	BACKGR,
	"blur",		BLUR,
	"file",		SFILE,
	"plot",		PLOT,
	"V",		V,
	"I",		I,
	"L",		L,
	"S",		S,
	"FA0",		FA0,
	"FA1",		FA1,
	"FA2",		FA2,
	"FA3",		FA3,
	"FA4",		FA4,
	"FA9",		FA9,
	"FB0",		FB0,
	"FB1",		FB1,
	"FB2",		FB2,
	"FB3",		FB3,
	"FB4",		FB4,
	"FC0",		FC0,
	"FC1",		FC1,
	"FC2",		FC2,
	"FC3",		FC3,
	"FC4",		FC4,
	"G0",		G0,
	"G1",		G1,
	"G2",		G2,
	"G3",		G3,
	"G4",		G4,
	"G5",		G5,
	"G6",		G6,
	"G7",		G7,
	"G8",		G8,
	"display",	DISPLAY,
	"xrot",		XROT,
	"yrot",		YROT,
	"zrot",		ZROT,
	"size",		SIZE,
	"rmove",	RMOVE,
	"dscale",	DSCALE,
	"color",	COLOR,
	"hide",		HIDE,
	"calibline",	CALIBLIN,
	"graph",	GRAPH,
	"pen",		PEN,
	"restart",	RESTART,
	"init",		INIT,
	"X",		X,
	"Y",		Y,
	"Z",		Z,
	"max",		MAX,
	"min",		MIN,
	"rm",		RM,
	"ri",		RI,
	"rg",		RG,
	"cm",		CM,
	"vbuf",		BUF,
	"opamp",	OPAMP,
	"chnoise",	CHNOISE,
	"photnoise",	PHOTNOISE,
	"vesnoise",	VESNOISE,
	"N",		N,
	"vsize",	VSIZE,
	"open",		OPEN,
	"close",	CLOSE,
	"vrev",		VREV,
	"vrest",	VREST,
	"cplam",	CPLAM,
	"thresh",	THRESH,
	"delay",	DELAY,
	"timec1",	TIMEC1,
	"nfilt1",	NFILT1,
	"timec2",	TIMEC2,
	"nfilt2",	NFILT2,
	"tfall2",	TFALL2,
	"timec3",	TIMEC3,
	"nfilt3",	NFILT3,
	"tfall3",	TFALL3,
	"igain",	IGAIN,
	"kd",		KD,
	"linear",	LINEAR,
	"expon",	EXPON,
	"numconn",	NUMCONN,
	"connect",	CONNECT,
	"conn",		CONNECT,
	"only",		ONLY,
	"at",		AT,
	"to",		TO,
	"edist",	EDIST,
	"efrac",	EFRAC,
	"ndist",	NDIST,
	"ename",	ENAME,
	"modify",	MODIFY,
	"offset",	OFFSET,
	"put",		PUT,
	"run",		RUN,	
	"step",		STEP,	
	"erase",	ERASE,
	"gmove",	GMOVE,
	"gdraw",	GDRAW,
	"grdraw",	GRDRAW,
	"grmove",	GRMOVE,
	"gpen",		GPEN,
	"gcwidth",	GCWID,
	"gsize",	GSIZ,
	"gdash",	GDASH,
	"gframe",	GFRAME,
	"grot",		GROT,
	"gorigin",	GORIG,
	"gcrot",	GCROT,
	"gtext",	GTEXT,
	"gcirc",	GCIRC,
	"grect",	GRECT,
	"all",		ALL,
	"model",	MODEL,
	"gausnn",	GAUSNN,
	"mean",		MEAN,
	"stdev",	STDEV,
	"density",	DENSITY,
	"reg",		REG,
	"char",		CHAR,
	"Char",		CCHAR,
	0,		0
};
	
static struct {		/* control vars */
	char	*name;
} controls[] = {
	"vk",
	"vna",
	"vcl",
	"dcap",
	"dnadens",
	"dkdens",
	"dcadens",
	"dcao",
	"dcai",
	"dcabnd",
	"dcaekm",
	"dcapkm",
	"dcavmax",
	"dcakex",
	"dmaxca", 
	"dcathr", 
	"dcatau", 
	"dkcatau", 
	"drg",
	"dri",
	"drm",
	"dfta",
	"dsfa",
	"dftb",
	"dsfb",
	"dscn",
	"dscd",
	"dsvn",
	"dvsz",
	"dst",
	"dsc",
	"dmaxsyn", 
	"dskd",
	"dse", 
	"dsi", 
	"dmaxrod", 
	"dmaxcon", 
	"dmaxna", 
	"dnathr", 
	"dnataum", 
	"dnatauh", 
	"dd1", 
	"dd2", 
	"dk1", 
	"dk2", 
	"dmaxk", 
	"dkthr", 
	"dktau", 
	"tempcel",
	"silent",
	"vidmode",
	"label",
	"disp",	
	"prmap",	
	"stim_elem",	
	"complam",
	"lamcrit",
	"relincr",
	"timinc",	
	"time",	
	"ncomps",	
	"endexp",	
	"ploti",
	"crit",		
	"plmax",
	"plmin",
	"relax",		
	"plsep",		
	"multyax",		
	"rightyax",		
	"dash",		
	"euler",		
	"implicit",		
	"stimelem",		
	"synaptau",		
	"pois",		
	"scatter",
	"debug",
	"debugz",
	"rseed",
	"version",
	0,0
};


static struct {		/* Constants */
	char *name;
	double cval;
} consts[] = {
	"PI", 		3.14159265358979323846,
	"E",		2.71828182845904523536,
	"GAMMA",	0.57721566490153286060,	/* Euler */
	"DEG",	       57.29577951308232087680,	/* deg/radian */
	"PHI",		1.61803398874989484820,	/* golden ratio */
	(char *)0,	0
};

static struct {		/* Built-ins */
	char *name;
	Fpa  func;
} builtins[] = {
	"atan",	(Fpa )ncatan,
	"asin",	(Fpa )ncasin,
	"log",	(Fpa )nclog,	/* checks range */
	"log10", (Fpa )nclog10,/* checks range */
	"exp",	(Fpa )ncexp,	/* checks range */
	"pow",	(Fpa )ncpow,	/* checks range */
	"sin",	(Fpa )ncsin,	/* checks range */
	"cos",	(Fpa )nccos,	/* checks range */
	"tan",	(Fpa )nctan,	/* checks range */
	"sqrt",	(Fpa )ncsqrt,	/* checks range */
	"int",	(Fpa )ncinteger,
	"abs",	(Fpa )ncfabs,
	"rand",	(Fpa )ncrand,
	"setvar", (Fpa )setvarval,
	"elap_time", (Fpa )elap_time,
	"strlen", (Fpa )xstrlen,
	"strtok", (Fpa )xstrtok,
	(char *)0, (Fpa )0
};

void init(void)	/* install constants and built-ins in table */
{
	int i;
	Symbol *s;
	datum d, setvarval(void);

	erasymb();			/* erase previous defs, in "symbol.c" */
	for (i=0; keywords[i].name; i++)
		s= install(keywords[i].name, keywords[i].kval, 0.0);
	for (i=0; controls[i].name; i++)
		s= install(controls[i].name, VAR, 0.0);
	for (i=0; consts[i].name; i++) {
		s = install(consts[i].name, CONST, consts[i].cval);
		setval (s,consts[i].cval,NUMBER);
	}
	for (i=0; builtins[i].name; i++) {
		s = install(builtins[i].name, BLTIN, 0.0);
		s->ptr = builtins[i].func;
	}

	dinit();		/* initialize default values */
	d = setvarval();	/* set variables from command-line */
	varcopy();		/* copy control variables from symbol table */
	initrec();		/* receptor constants */
	frame ("zzy");
}

/****************************************/

double setvar (char *str)
{
  return (lookpv(str));
}

/****************************************/

datum setvarval(void)

/* set variables from command line.
    This overrides what values are set
    in a program.  You call this function
    "setvar()" your script file.

*/
{
   int i;
   Symbol *s;
   static datum d={0};

   for (i=0; i<VVSIZE; i++) {
    if (varpnt[i]) {
      if ((s=lookup(varpnt[i])) == 0)
           s=install(varpnt[i],VAR,varval[i]);
      if (s->type==VAR)  		/* set var from comnd line */
	   setval(lookup(varpnt[i]),varval[i],vartyp[i]);
    }
    else break;
   }
  d.val = i;
  d.vtype = NUMBER;
  return d;
}

/****************************************/

void varcopy(void)
{
  vk	  = setvar ("vk");
  vna	  = setvar ("vna");
  vcl	  = setvar ("vcl");
  dcap    = setvar ("dcap");
  dnadens = setvar ("dnadens");
  dkdens  = setvar ("dkdens");
  dcadens = setvar ("dcadens");
  dcao    = setvar ("dcao");
  dcai    = setvar ("dcai");
  dcabnd  = setvar ("dcabnd");
  dcaekm  = setvar ("dcaekm");
  dcapkm  = setvar ("dcapkm");
  dcavmax = setvar ("dcavmax");
  dcakex  = setvar ("dcakex");
  dmaxca  = setvar ("dmaxca");
  dcathr  = setvar ("dcathr");
  dcatau  = setvar ("dcatau");
  dkcatau = setvar ("dkcatau");
  dri     = setvar ("dri");
  drm     = setvar ("drm");
  drg     = setvar ("drg");
  dsfa    = setvar ("dsfa");
  dfta    = setvar ("dfta");
  dsfb    = setvar ("dsfb");
  dftb    = setvar ("dftb");
  dscn    = setvar ("dscn");
  dscd    = setvar ("dscd");
  dsvn    = setvar ("dsvn");
  dvsz    = setvar ("dvsz");
  dst     = setvar ("dst");
  dsc     = setvar ("dsc");
  dmaxsyn = setvar ("dmaxsyn");
  dskd    = setvar ("dskd");
  dse     = setvar ("dse");
  dsi     = setvar ("dsi");
  dmaxrod = setvar ("dmaxrod");
  dmaxcon = setvar ("dmaxcon");
  dmaxna  = setvar ("dmaxna");
  dnathr  = setvar ("dnathr");
  dmaxk   = setvar ("dmaxk");
  dkthr   = setvar ("dkthr");
  dnataum = setvar ("dnataum");
  dnatauh = setvar ("dnatauh");
  dd1 	  = setvar ("dd1");
  dd2 	  = setvar ("dd2");
  dk1 	  = setvar ("dk1");
  dk2 	  = setvar ("dk2");
  dktau   = setvar ("dktau");
  tempcel = setvar ("tempcel");
  complam = setvar ("complam");
  lamcrit = setvar ("lamcrit");
  relincr = setvar ("relincr");
  timinc  = setvar ("timinc");
  xtime   = setvar ("time");
  endexp  = setvar ("endexp");
  ploti   = setvar ("ploti");
  plmax   = setvar ("plmax");
  plmin   = setvar ("plmin");
  crit    = setvar ("crit");
  relax   = setvar ("relax");
  poisfl  = (int)setvar ("pois");
  scatter = (int)setvar ("scatter");
  euler   = (int)setvar ("euler");
  stimelem= (int)setvar ("implicit");
  implicit= (int)setvar ("implicit");
  synaptau= setvar ("synaptau");

  silent  = (int)setvar ("silent");
  vidmode = (int)setvar ("vidmode");
  plsep   = (int)setvar ("plsep");
  multyax = (int)setvar ("multyax");
  rightYax= (int)setvar ("rightyax");
  dashfl  = (int)setvar ("dash");
  disp    = (int)setvar ("disp");
  prmap   = (int)setvar ("prmap");
  stim_elem = (int)setvar ("stim_elem");
  debug   = (int)setvar ("debug");
  debugz  = (int)setvar ("debugz");
  rseed   = (int)setvar ("rseed");
  setrand ((long int) rseed);		/* set up random number seed */
  ktemp = tempcel + CELSIUS;
}

void dinit()
{

#define NR NUMBER

  int len;

 Symbol *lookup();

 setval (lookup("vk"),-.08,NR);		/* potassium equilibrium potential */
 setval (lookup("vna"),.04,NR);		/* sodium equilibrium potential    */
 setval (lookup("vcl"),-.07,NR);	/* chloride equilibrium potential    */
 setval (lookup("dcap"),1e-6,NR);	/* f/cm-cm     membrane capacitance */
 setval (lookup("dri"),200.,NR);	/* ohm-cm       axial resistance */
 setval (lookup("drm"),40000.,NR);	/* ohm-cm-cm    membrane resistance */
 setval (lookup("drg"),5e6,NR);		/* ohm-um-um    gap junc resistance */
 setval (lookup("dfta"),.2,NR);		/* synaptic time const (msec) */
 setval (lookup("dsfa"),2.0,NR);	/* synaptic number of filters */
 setval (lookup("dftb"),.2,NR);		/* synaptic time const (msec) */
 setval (lookup("dsfb"),0.0,NR);	/* synaptic number of filters */
 setval (lookup("dscn"),50.0,NR);	/* number of chan sites */
 setval (lookup("dscd"),1e-3,NR);	/* duration of channel event */ 
 setval (lookup("dsvn"),5.0,NR);	/* number of syn vesicle rel sites */
 setval (lookup("dvsz"),100.0,NR);	/* size of vesicles released */
 setval (lookup("dst"), -.04,NR);	/* synaptic threshold (volts) */
 setval (lookup("dsc"),(double)EXPON,NR);/* synaptic curve */
 setval (lookup("dmaxsyn"),1e-8,NR);	/* maximum cond for synapse (S) */
 setval (lookup("dskd"),1.0,NR);	/* half-max output saturation (kd) */
 setval (lookup("dse"),2.0,NR);		/* synaptic gain exponent */
 setval (lookup("dsi"),1.0,NR);		/* synaptic input gain */
 setval (lookup("dmaxrod"),6.25e-11,NR);/* dark cond of rod gated channel (S) */
 setval (lookup("dmaxcon"),1.4e-9,NR);	/* dark cond of cone gated channel (S)*/
 setval (lookup("dnadens"),0.25,NR);	/* density of Na V-gated chan (S/cm2)*/
 setval (lookup("dkdens"),0.0707,NR);	/* density of K V-gated chan (S/cm2)*/
 setval (lookup("dcadens"),0.005,NR);	/* density of Ca V-gated chan (S/cm2)*/
 setval (lookup("dcao"),0.005,NR);	/* conc. of external Ca++ (M) */
 setval (lookup("dcai"),50e-9,NR);	/* conc. of internal Ca++ (M) */
 setval (lookup("dcabnd"),5.0,NR);	/* ratio of bound to free calcium */
 setval (lookup("dcaekm"),1e-5,NR);	/* 1/2 sat conc. of Ca++ exchngr (M) */
 setval (lookup("dcapkm"),2e-7,NR);	/* 1/2 sat conc. of Ca++ pump (M) */
 setval (lookup("dcavmax"),1e-2,NR);	/* Vmax for Ca pump (ma/cm2)       */
 setval (lookup("dcakex"),1e-2,NR);	/* Rate for Na/Ca exchanger (S/cm2)*/
 setval (lookup("dmaxca"),1e-10,NR);	/* cond of Ca voltage gated channel */
 setval (lookup("dcathr"),CATHR,NR);	/* activation threshold for Ca chan  */
 setval (lookup("dcatau"),CATAU,NR);	/* activation tau for Ca channel   */
 setval (lookup("dkcatau"),KCATAU,NR);	/* activation tau for KCa channel   */
 setval (lookup("dmaxna"),1e-9,NR);	/* cond of Na voltage gated channel(S)*/
 setval (lookup("dnathr"),NATHR,NR);	/* activation voltage for Na chan */
 setval (lookup("dnataum"),NATAUM,NR);	/* activation tau for Na chan */
 setval (lookup("dnatauh"),NATAUH,NR);	/* inactivation tau for Na chan */
 setval (lookup("dd1"),1.0,NR);		/* voltage multiplier for K chan alph */
 setval (lookup("dd2"),1.0,NR);		/* voltage multiplier for K chan bet  */
 setval (lookup("dk1"),1e-6,NR);	/* ca multiplier for K chan alph */
 setval (lookup("dk2"),1e-6,NR);	/* ca multiplier for K chan bet  */
 setval (lookup("dmaxk"),2e-10,NR);	/* cond of K voltage gated channel(S)*/
 setval (lookup("dkthr"),KTHR,NR);	/* activation voltage for K chan */
 setval (lookup("dktau"),KTAU,NR);	/* activation tau for K chan */
 setval (lookup("tempcel"),6.3,NR);	/* temperature for na, k rate consts */
 setval (lookup("complam"), .1,NR);	/* fraction of lambda for compartment */
 setval (lookup("lamcrit"), .3,NR);	/* criterion for condensing comps */
 setval (lookup("timinc"), 1e-4,NR);	/* time incr for model (sec) */
 setval (lookup("ncomps"), 0.0,NR);	/* number of compartments */
 setval (lookup("endexp"), 50e-3,NR);	/* end of recording for model (sec) */
 setval (lookup("ploti"), 1e-3,NR);	/* plot increment (sec) */
 setval (lookup("plmax"), .04,NR);	/* max for voltage plots (volts) */
 setval (lookup("plmin"), -.08,NR);	/* min for voltage plots (volts) */
 setval (lookup("crit"), 1e-8,NR);	/* criterion for steps (volts) */
 setval (lookup("relax"), .15,NR);	/* over-relaxation constant */
 setval (lookup("relincr"), .002,NR);	/* relax increment */
 setval (lookup("synaptau"), 1.0,NR);	/* synaptic time constant multiplier */
 setval (lookup("stimelem"), 0.0,NR);	/* "stim" understands neural elements */
 setval (lookup("pois"), 0.0,NR);	/* use poisson dist for photon flux */
 setval (lookup("scatter"), 0.0,NR);	/* use point spread func for scatter */
 setval (lookup("time"), 0.0,NR);	/* time at beginning */
 setval (lookup("version"), ncversion,NR);/* nc version number */
  len = strlen(progname);
  if (len) {
    if (*(progname+len-1) == 'd')
     disp |= DISP;
  }

 if (setvid) vidmode=1;
 else if (unsetvid) vidmode=0;
 setval (lookup("vidmode"), (double)vidmode,NR);	/* video display flag */

 if (setdisp>=0) disp = setdisp;	/* command line display flag */
 setval (lookup("disp"), (double)disp,NR); /* display flag */
 if (setprmap>=0) prmap = setprmap;	/* command line print flag */
 setval (lookup("prmap"),(double)prmap,NR); /* display flag */

 if (drseed) {
     if (drseed<0) drseed = getpid();	/* randomize if negative */
     setval (lookup("rseed"),(double)drseed,NR); /* random seed on comnd line*/
 }
 else setval (lookup("rseed"), 123456.0,NR);	/* default random seed */
 timeptr = lookup("time");		/* get pointer to time */
 ncompptr = lookup("ncomps");		/* get pointer to ncomps */

#undef NR
}

/*******************************/

