/* module gprim.c in program nc */

/* graphics primitives for video and text modes */


#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

#include "stdplt.h"
#include "gr.h"

#ifdef __cplusplus
}
#endif

struct _frame *_dotp;

extern int vidmode;

void gtext(char *s)
{
  if (vidmode) textf ("%s",s);			/* in libP.a */
  else printf ("#gt %s\n",s);  			/* text to stdout */
  fflush (stdout);
}

void gmove (double x, double y)
{
   if (vidmode) move (x,y); 			/* in libP.a */
   else printf ("#gm %g %g\n",x,y); 		/* text to stdout */	
   fflush (stdout);
}

void gdraw (double x, double y)
{
   if (vidmode) draw (x,y);			/* in libP.a */
   else printf ("#gd %g %g\n",x,y); 		/* text to stdout */	
   fflush (stdout);
}

void grmove (double x, double y)
{
   if (vidmode) rmove (x,y); 			/* in libP.a */
   else printf ("#grm %g %g\n",x,y); 		/* text to stdout */	
   fflush (stdout);
}

void grdraw (double x, double y)
{
   if (vidmode) rdraw (x,y); 			/* in libP.a */
   else printf ("#grd %g %g\n",x,y); 		/* text to stdout */	
   fflush (stdout);
}

void gpen (int x)
{
   if (vidmode) cpen (x); 			/* in libP.a */
   else printf ("#gpen %d\n",x);		/* text to stdout */	
   fflush (stdout);
}

void gcrotate (double x)
{
   if (vidmode) crotate (x*DEG,"."); 		/* in libP.a */
   else printf ("#gcro %g\n",x); 		/* text to stdout */	
   fflush (stdout);
}

void grotate (double x)
{
 if (vidmode) rotate (x*DEG);
 else printf ("#gro %g\n",x);
 fflush (stdout);
}

void gorigin(double x, double y)
{
 if (vidmode) origin (x,y);
 else printf ("#gor %g %g\n",x,y);
 fflush (stdout);
}

void gframe (char *s)
{
 if (vidmode) frame (s);
 else printf ("#gfr %s\n",s);
 fflush (stdout);
}

void grmframe (char *s)
{
 if (vidmode) rmframe (s);
 else printf ("#grfr %s\n",s);
 fflush (stdout);
}

void gcwidth (double x)
{
 if (vidmode) cwidth (x,".");
 else printf ("#gcw %g\n",x);
 fflush (stdout);
}

void gsize (double x)
{
 if (vidmode) scale (x,x);
 else printf ("#gsiz %g\n",x);
 fflush (stdout);
}

void gdash (int x)
{
 if (vidmode) dash (x);
 else printf ("#gda %d\n",x);
 fflush (stdout);
}

void gcirc (double rad, int fill)
{
 if (vidmode) _drcirc (rad,fill);
 else printf ("#gcirc %g %d\n",rad,fill);
 fflush (stdout);
}

void grect (double x1, double y1, double x2, double y2,
	    double x3, double y3, double x4, double y4, int fill)
{
 if (vidmode) _drrect (x1,y1,x2,y2,x3,y3,x4,y4,fill);
 else printf ("#grect %g %g %g %g %g %g %g %g %d\n",
 			x1,y1,x2,y2,x3,y3,x4,y4,fill);
 fflush (stdout);
}

void gtri (double x1, double y1, double x2, double y2,
	    double x3, double y3, int fill)
{
 if (vidmode) _drtri (x1,y1,x2,y2,x3,y3,fill);
 else printf ("#gtri %g %g %g %g %g %g %d\n",
 			x1,y1,x2,y2,x3,y3,fill);
 fflush (stdout);
}

void gpurge (void)
{
 if (vidmode) purge ();
 else printf ("#gpurg\n");
 fflush (stdout);
}

void ghinit (void)

{
 if (vidmode) hidinit ();
 else printf ("#ghinit\n");
 fflush (stdout);
}

void ghstart (void)

/* start computing hidden line table (in "hide.c") */

{
 if (vidmode) hidstart ();
 else printf ("#ghstart\n");
 fflush (stdout);
}

void ghend (void)

/* stop computing hidden line table (in "hide.c") */

{
 if (vidmode) hidstop ();
 else printf ("#ghend\n");
 fflush (stdout);
}

void gctext (void)

/* change to text mode (for mprint{h,e,v}.c drivers) */

{
 if (vidmode) ctext ();
 else printf ("#gctext\n");
 fflush (stdout);
}

void gcgraphics (void)

/* change to graphics mode (for mprint{h,e,v}.c drivers) */

{
 if (vidmode) cgraphics ();
 else printf ("#gcgraphics\n");
 fflush (stdout);
}

