/* Module gmain in program gausnn */

/* Makes a gaussian nearest-neighbor distance */

/* R.G.Smith */

#include <stdio.h>

double sdensity = 0;
double smean = 0;
double sstdev = 0;
double sms = 0;
double sframex = 0;
double sframey = 0;
double scenterx = 1e38;
double scentery = 1e38;
int snumcells = 0;
long int rseed = 1234;
int printfl = 0;
float *x=0,*y=0;

#ifdef __cplusplus
extern "C" {
#endif

double atof(const char *);

#ifdef __cplusplus
}
#endif

void setrand(long int n);
int gausnn(double mean, double stdev, double density, double ms, 
	double framex, double framey, double xcent, double ycent, 
	int numcells, float **xarr, float **yarr, int filout, int textfl,
	int printfl);
                                                            
extern FILE *outfil;

/* -------------------------------------------------------------- */

main(int argc, char **argv)
{
   char *cptr;
   FILE *freopen(const char *, const char *, FILE *);
         
 outfil = NULL;
 if (argc==1) {                   /* if user needs help */
   fprintf (stderr,"    Usage: gausnn -d density -t regularity file\n");
   fprintf (stderr,"    Usage: gausnn -m mean -s stdev file\n");
   fprintf (stderr,"     Other options: -n ncells -r seed -p (debug)\n");
   fprintf (stderr,"                    -x xsize  -y ysize\n");
   return (0);
 }
 else
 do                                     /* if there are any switches */
  {
   argc--; argv++;
   cptr = *argv;
   if (argc)
    {
     if (*cptr == '-')
      {
       cptr++;
       switch (*cptr)
        {
     
          case 'd': 
                argv++; argc--;
                sdensity = atof(*argv);
                break;

          case 'm': 
                argv++; argc--;
                smean = atof(*argv);
                break;

          case 'n': 
                argv++; argc--;
                snumcells = (int)atof(*argv);
                break;

          case 'p': 
                printfl = !printfl;
                break;

          case 'r': 
                argv++; argc--;
                rseed = (int)atof(*argv);
                break;

          case 's': 
                argv++; argc--;
                sstdev = atof(*argv);
                break;

          case 't': 
                argv++; argc--;
                sms = atof(*argv);
                break;

          case 'x': 
                argv++; argc--;
                sframex = atof(*argv);
                break;

          case 'X': 
                argv++; argc--;
                scenterx = atof(*argv);
                break;

          case 'y': 
                argv++; argc--;
                sframey = atof(*argv);
                break;

          case 'Y': 
                argv++; argc--;
                scentery = atof(*argv);
                break;

          default:
                fprintf (stderr,"gausnn: unknown switch '%s'\n",*argv);
                return(1);

        }  /* switch */
      }    /* if */
     else
      {
       if((outfil=fopen(cptr,"w"))==NULL)
         {
           fprintf(stderr,"gausnn: cannot open %s\n",cptr);
           fflush (stderr);
           continue;
         }
       if (argc <= 1) break;
     }
    }
  }
 while (argc > 0);

 if (rseed) setrand(rseed);	/* initialize random number generator */

 gausnn(smean,sstdev,sdensity,sms,sframex,sframey,scenterx,scentery,
			snumcells,&x,&y,1,1,printfl);
}

/* ---------------------------------------------------------- */

