/* Program fft */

/* computes fast fourier transform */

/* prints transform on standard output */

/* Latest Mod	Nov 87		R.G.Smith */

#include <stdio.h>
#include "mdef.h"

FILE *pictin;

#define PI 3.14159265358979323846264

static int k;
static int w;

double atof();
double cos();
double sin();
double mulreal();
double mulimag();

/****************************************/

main(argc,argv)
   int argc;
   char **argv;

begin
   FAST TEXT *cptr;
   int i;
   FILE *temp,*freopen();
	 
 pictin = stdin;
 if (argc==1)			/* if user needs help */
   begin
 /*   printf ("\nfft program Nov 87\r\n"); */
    run();
   end
 else
 do					/* if there are any switches */
  begin
   argc--; argv++;
   cptr = *argv;
   if (argc)
    begin
     if (*cptr == '-')
      begin
       cptr++;
       switch (*cptr)
        begin

          case 'i':
		signal (2,1);
		break;
     
      	  case 'w': 
		argv++; argc--;
		w = atof(*argv);
		break;

      	  case 'k': 
		argv++; argc--;
		k = atof(*argv);
		break;

        end  /* switch */
      end	   /* if */
     else
      begin
       if((pictin=fopen(cptr,"r"))==NULL)
         begin
           fprintf(stderr,"fft: cannot open %s\n",cptr);
	   fflush (stderr);
           continue;
         end
       run();
       if (argc <= 1) break;
     end
    end
   else run();
  end
 while (argc > 0);
end

/****************************************/

run()

/* On input, z1 and z2 are complex n-vectors,
   n is length of z1 and z2,
   inzee indicates whether z1 or z2 is to be transformed.

   Both z1 and z2 are used as work arrays.
   
   On output, z1 or z2 contains the desired transform
   in the correct order. 
   Inzee indicates whether z1 or z2 contains the transform.
   inzee = 1  => z1 contains transform
   inzee = 2  => z2 contains transform

   Method:  

     The integer n is divided into its prime factors (up to
   a point).  For each such factor p, the p-transform of 
   appropriate p-subvectors of z1 (or z2) is calculated
   in fftstp and stored in a suitable way in z2 (or z1).

   Adapted from fortran routine in:

	 Conte and de Boor,
	 'Elementary Numerical Analysis' 1980
		Chapter 6, "Fast Fourier Transforms", p 283
*/

#define FFTSIZ 2048
 
begin
    static int i,j,n;
    static float z1real[FFTSIZ] = 0;
    static float z1imag[FFTSIZ] = 0;
    static float z2real[FFTSIZ] = 0;
    static float z2imag[FFTSIZ] = 0;
    static int prime[] = {2,3,5,7,11,13,17,19,23,29,31,37};
    static int inzee,after,before,next,nextmx,now;

 inzee = 1;
 nextmx = 12;
 n = readin(z1real,z1imag); 		/* read first list */
 after = 1;
 before = n;
 next = 1;
 while (before != 1) {
   if ((before / prime[next-1]) * prime[next-1] < before) {
    next++;
     if (next <= nextmx) continue;
     else {
	now = before;
	before = 1;
     }
   }
   else {
     now = prime[next-1];
     before = before / prime[next-1];
   }

   if (inzee == 1)
      fftstp(z1real, z1imag, after, now, before, z2real, z2imag);
   else
      fftstp(z2real, z2imag, after, now, before, z1real, z1imag);
   inzee = 3 - inzee;
   if (before != 1) after *= now;

 }    /* while (before ) */

if (inzee==1) {
   for (i=0; i<n; i++) 
     printf("%10g %10g\n",z1real[i],z1imag[i]);
}
else {
   for (i=0; i<n; i++)
     printf("%10g %10g\n",z2real[i],z2imag[i]);
}
}

/****************************************/

fftstp (zinr,zini,after,now,before,zoutr,zouti)
     float *zinr,*zini,*zoutr,*zouti;
     int after, now, before;
{
    int ia,ib,in,j;
    static double angle;
    static double argreal,argimag;
    static double omegreal,omegimag;
    static double valreal,valimag;
    static double tvalreal,targreal;
    int pnt;

 angle = 2 * PI / (now * after);
 omegreal = cos(angle);
 omegimag = -sin(angle); 
 argreal  = 1.0;
 argimag  = 0.0;
 for (j=0; j<now; j++) {
   for (ia=0; ia<after; ia++) {
     for (ib=0; ib<before; ib++) {
       pnt = ((now-1)*before+ib)*after+ia;
       valreal = *(zinr+pnt);
       valimag = *(zini+pnt);
       for (in=now-2; in>=0; in--)  {
	 pnt = (in*before+ib)*after+ia;
	 tvalreal = mulreal(valreal,valimag,argreal,argimag);
	 tvalreal = tvalreal + *(zinr+pnt);
	 valimag = mulimag(valreal,valimag,argreal,argimag);
	 valimag = valimag + *(zini+pnt);
	 valreal = tvalreal;
      }
      pnt = (ib*now+j)*after+ia;
      *(zoutr+pnt) = valreal;
      *(zouti+pnt) = valimag;
    }
    targreal = mulreal(argreal,argimag,omegreal,omegimag);
    argimag = mulimag(argreal,argimag,omegreal,omegimag);
    argreal = targreal;
  }
 }
}

/****************************************/

double mulreal(a,b,c,d)
   double a,b,c,d;

{
 return (a*c - b*d);
}

/****************************************/

double mulimag(a,b,c,d)
   double a,b,c,d;

{
 return (b*c + a*d);
}

/****************************************/

int readin(x,y)
    float x[],y[];

/* skip blank lines and read list of
   x,y values until either a blank line or the
   end of text */

#define STRSIZ 80
 
begin
    static int  i,xx;
    static int np;
    static TEXT str[STRSIZ]=0;
    static BOOL found;
 
 np = 0;
 for(found=F; !found; )			/* look for leading blank lines */
  begin
   if (not fgets (str,STRSIZ,pictin)) return (0);
   if (sscanf(str,"%f%*[ ,]%f",x,y) > 0) break;
  end

 x++; y++; np++;
 for(found=F; !found; )
  begin
   if (not fgets (str,STRSIZ,pictin)) break;
   if ((xx=sscanf(str,"%f%*[ ,]%f",x,y)) > 0)
    begin
     x++,y++,np++;
     if (np >= FFTSIZ) break;
    end
   else found = T;
  end

  return (np);
end

/*****************************************/
   
