/* module drand in program nc */

/* random number function */

#include <stdio.h>

static long int lseed= -1;

double drand(void)
{
   double rand1(int *idum);

  return rand1(&lseed);
}


setrand(long int val)
{
  int getpid(void);

  if (val<0) val = -getpid();
  else if (val>0) val = -val;
  lseed = val;
}


#define M 714025
#define IA 1366
#define IC 150889

double rand2(long int *idum)
                  

/* Returns a uniform random deviate between 0 and 1.
   Set idum to any negative value to initialize
   or reinitialize.  Taken from Press et al., 1988,
   'Numerical Recipes in C', Chapter 7, page 212.

   Not currently used in "nc" because it repeats with
   a period of 714025.
*/

{   
    static long int iy, ir[98];
    static int iff=0;
    int j;
    
  if (*idum<0 || iff == 0) {    
      iff = 1;
      if ((*idum=(IC-(*idum)) % M) < 0) *idum = -(*idum);
      for (j=1; j<=97; j++) {           /* initialize the shuffle table */
        *idum=(IA*(*idum)+IC) % M;
        ir[j] = (*idum);
      }
      *idum=(IA*(*idum)+IC) % M;
      iy = (*idum);
   }
   j = 1 + 97.0 * iy / M;
   if (j > 97 || j < 1) {
        fprintf (stderr,"ran2: This cannot happen...\n"); 
        return (0.5);
   }
   iy = ir[j];
   *idum = (IA*(*idum)+IC) % M;
   ir[j] = (*idum);
   return (((double)iy) / M);
}

srand2(long int seed)
{
   long int dseed;

   dseed = -1;
   drand(dseed);
}


/* Better portable random number generator,
   with a longer period than ran2() above.
   Period is maximum size of "long int" = 2147483648 - 1;

   Returns a uniform random deviate between 0 and 1.
   Set idum to any negative value to initialize
   or reinitialize.  Taken from Press et al., 1988,
   'Numerical Recipes in C', Chapter 7, page 210.
*/

#define M1  259200
#define IA1 7141
#define IC1 54773
#define RM1 (1.0/M1)
#define M2  134456
#define IA2 8121
#define IC2 28411
#define RM2 (1.0/M2)
#define M3  243000
#define IA3 4561
#define IC3 51349

double rand1(int *idum)
{
  static long ix1,ix2,ix3;
  static double r[98];
  double temp;
  static int iff=0;
  int j;

  if (*idum<0 || iff==0) {	/* Initialize on first call even if idum is */
    iff = 1;			/*  not negative. */
    ix1 = (IC1-(*idum)) % M1;	/* Seed the first routine, */
    ix1 = (IA1*ix1+IC1) % M1;
    ix2 = ix1 % M2;		/*  and use it to seed the second */
    ix1 = (IA1*ix1+IC1) % M1;
    ix3 = ix1 % M3;		/*   and third routines */
    for (j=1; j<=97; j++) {	/* Fill the table with ssequential deviates */
       ix1 = (IA1*ix1+IC1) % M1; /* generated by the first two routines */
       ix2 = (IA2*ix2+IC2) % M2;
       r[j] = (ix1+ix2*RM2)*RM1; /* Low and high order pieces combined here */
    }
    *idum = 1;
  }
  ix1 = (IA1*ix1+IC1) % M1; 	/* Except when init, this is where we start */
  ix2 = (IA2*ix2+IC2) % M2;     /* Generate the next number for each seq. */
  ix3 = (IA3*ix3+IC3) % M3;
  j = 1 + ((97*ix3)/M3);	/* Use the third seq. to get int. betw 1-97 */
  if (j > 97 || j < 1) 
        fprintf (stderr,"ran1: This cannot happen...\n"); 
  temp = r[j];			/* Return that table entry, */
  r[j] = (ix1+ix2*RM2) * RM1;   /*  and refill it. */
  return temp;
}


