/* module drand in program nc */

/* random number function */


#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
int getpid(void);

#ifdef __cplusplus
}
#endif

/*-----------------------------------------------------------*/

static long int lseed= -1;

double drand(void)
{
   double rand2(long int *idum);

  return rand2(&lseed);
}

/*-----------------------------------------------------------*/

void setrand(long int val)

{
  if (val<0) val = -getpid();
  else if (val>0) val = -val;
  lseed = val;
}

/*-----------------------------------------------------------*/

#define IM1 2147483563
#define IM2 2147483399
#define AM  (1.0/IM1)
#define IMM1 (IM1-1)
#define IA1 40014
#define IA2 40692
#define IQ1 53668
#define IQ2 52774
#define IR1 12211
#define IR2 3791
#define NTAB 32
#define NDIV (1+IMM1/NTAB)
#define EPS 1e-38
#define RNMX (1.0-EPS)

double rand2(long int *idum)
                  
/* Long period (>2e18) random number generator of L'Ecuyer with
   Bays-Durham shuffle and added safeguards.  Returns a uniform
   random deviate between 0 and 1 (exclusive of the endpoint
   values).  Call with "idum" a negative number to initialize;
   thereafter, do not alter "idum" between successive deviates in
   a sequence.  RNMX should approximate the largest floating value
   that is less than 1.  Taken from Press et al., 1992,
   'Numerical Recipes in C', 2nd Ed., Chapter 7, page 282.
*/

{
   int j;
   long k;
   static long idum2=123456789;
   static long iy=0;
   static long iv[NTAB];
   double temp;

    if (*idum<=0) {			/* Initialize */
	if (-(*idum) < 1) *idum = 1; 	/* Be sure to prevent idum=0 */
	else *idum = -(*idum);
	idum2 = (*idum);
	for (j=NTAB+7; j>=0; j--) {	/* Load the shuffle table  */
	  k=(*idum)/IQ1;		/*  (after 8 warmups)      */
          *idum=IA1*(*idum-k*IQ1)-k*IR1;
	  if (*idum < 0) *idum += IM1;
	  if (j < NTAB) iv[j] = *idum;
	}
	iy = iv[0];
    }
    k=(*idum)/IQ1;			/* Start here when not initializing */
    *idum=IA1*(*idum-k*IQ1)-k*IR1;	/* Compute idum=(IA1*idum) %IM1 */
    if (*idum<0) *idum += IM1;		/* without overflows by Schrage's meth*/
    k = idum2/IQ2;
    idum2=IA2*(idum2-k*IQ2)-k*IR2;	/* Compute idum2=(IA2*idum) % IM2 */
    if (idum2<0) idum2 += IM2;
    j = iy/NDIV;			/* Will be in the range 0->NTAB-1 */
    iy = iv[j]-idum2;			/* Here idum is shuffled, combined */
    iv[j] = *idum;			/*  with idum2 to generate output */ 
    if (iy < 1) iy += IMM1;
    if ((temp=AM*iy) > RNMX) return RNMX; /* Because user's don't expect */ 
    else return temp;			  /*  endpoint values */
}

      
/*-----------------------------------------------------------*/

#define M1  259200
#define JA1 7141
#define JC1 54773
#define RM1 (1.0/M1)
#define M2  134456
#define JA2 8121
#define JC2 28411
#define RM2 (1.0/M2)
#define M3  243000
#define JA3 4561
#define JC3 51349

double rand1(int *idum)
          

/* Returns a uniform random deviate between 0 and 1.
   Set idum to any negative value to initialize
   or reinitialize.  Taken from Press et al., 1988,
   'Numerical Recipes in C', Chapter 7, page 210.

   Period is maximum size of "long int" = 2147483648 - 1;
*/

{
  static long ix1,ix2,ix3;
  static double r[98];
  double temp;
  static int iff=0;
  int j;

  if (*idum<0 || iff==0) {	/* Initialize on first call even if idum is */
    iff = 1;			/*  not negative. */
    ix1 = (JC1-(*idum)) % M1;	/* Seed the first routine, */
    ix1 = (JA1*ix1+JC1) % M1;
    ix2 = ix1 % M2;		/*  and use it to seed the second */
    ix1 = (JA1*ix1+JC1) % M1;
    ix3 = ix1 % M3;		/*   and third routines */
    for (j=1; j<=97; j++) {	/* Fill the table with ssequential deviates */
       ix1 = (JA1*ix1+JC1) % M1; /* generated by the first two routines */
       ix2 = (JA2*ix2+JC2) % M2;
       r[j] = (ix1+ix2*RM2)*RM1; /* Low and high order pieces combined here */
    }
    *idum = 1;
  }
  ix1 = (JA1*ix1+JC1) % M1; 	/* Except when init, this is where we start */
  ix2 = (JA2*ix2+JC2) % M2;     /* Generate the next number for each seq. */
  ix3 = (JA3*ix3+JC3) % M3;
  j = 1 + ((97*ix3)/M3);	/* Use the third seq. to get int. betw 1-97 */
  if (j > 97 || j < 1) 
        fprintf (stderr,"ran1: This cannot happen...\n"); 
  temp = r[j];			/* Return that table entry, */
  r[j] = (ix1+ix2*RM2) * RM1;   /*  and refill it. */
  return temp;
}


