endexp = 2.5;

	/* Cone array Parameters */
conearr = 4;
gapsize = 3.38e-3;
conerm = 15000;
conrest = -0.035;
peddist = 250;
cdia = 4.6;
pdia = 7;
drg = 1.5e7;
cxoff = 4.6;
cyoff = 3.98;
dim csav[conearr][conearr];	/* Array for storing cone values */

/* Various simulation parameters, some from Rob, others from elsewhere */
/* Defined externally:
	consav[conearr][conearr];
	conearr = 15;
	gapsize = 3.38e-3;
	conerm = 15000;
	conrest = -0.035;
	peddist = 250;
	cxoff = 4.6;
        cyoff = 3.98;
        cdia = 4.6;
	pdia = 7;
*/

/* Build cone of the right anatomical dimensions */
/* Makes an "anatomically correct" monkey fovea cone */
/* Cone outer/inner segments are now triangularly packed */
/* Pedicle at [x][y][1] location (pedx,y * pdia) */

proc mcone (xpos, ypos) {

	local pedx, pedy, cx, cy;

        if (ypos & 1) {
                cx = (xpos + 1) * cxoff; /* odd row */
        } else cx = (xpos + 0.5) * cxoff; /* even row */
        cy = (ypos + 0.5) * cyoff;

        pedx = (pdia * xpos) + peddist + 3;
	pedy = (pdia * ypos) + 3;
        at [xpos][ypos][0] cone (cx,cy) dia cdia filt 1 ename csav[xpos][ypos];

	/* Set OS-IS capacitance and load */
        at [xpos][ypos][0] loc (cx,cy)
	     sphere dia 16 rm 500000 vrest conrest; 
        at [xpos][ypos][0] 
	      sphere dia 5 rm conerm vrest conrest;      
	/* Axon */
        conn [xpos][ypos][0] to [xpos][ypos][1]
              cable dia 1.5 length 250 rm conerm vrest conrest;   
	/* Pedicle */
        at [xpos][ypos][1] loc (pedx, pedy) 
	      sphere dia pdia rm conerm vrest conrest;
};

/* Connect pedicle to pedicle down and to the right */
proc gaps1 (xped,yped) {
	
	if (yped + 1 < conearr)
	connect [xped][yped][1] to [xped][yped + 1][1] gj gapsize;
	if (xped + 1 < conearr)
	connect [xped][yped][1] to [xped + 1][yped][1] gj gapsize;
};
/* Make cones */
for (i = 0; i < conearr; i++) {
	for (j = 0; j < conearr; j++)
		mcone(j,i);
};


stim file ctest2.stim;
plot V[1] max -0.03 min -0.08;

stim spot 1 loc (1, 1) blur 2.78 inten 2e5 start .03 dur .001;


run;
