/* segment convarr */

/* subroutines to read and write from large array
*/

#include <sys/types.h>
#include "stim.h" 

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>

#ifdef __cplusplus
}
#endif

#if (CONVSIZE > 256)		/* if 32 bit compiler */


#define XMAX 512			/* make 512 x 512 array */
#define YMAX 512
#define NUMCONV 10			/* max number of conv arrays */

int convsize=XMAX;			/* size of convolution array */
static int cxmax=XMAX;			/* individual x and y dimensions */
static int cymax=YMAX;

float *arrtab[NUMCONV];

#ifdef __cplusplus
extern "C" {
#endif
  char *malloc (unsigned int n);
#ifdef __cplusplus
}
#endif

/*------------------------------------*/

char *smalloc(unsigned int n)	/* check return from malloc() */
	           
{
	char *p, *malloc(size_t);

	p = malloc((size_t)n);
	if (p == 0)
		fprintf(stderr,"Out of memory.\n");
	return p;
}

/*------------------------------------*/

int initc(int num, int size)
{
   unsigned int asize;
   int arr;
   static int called=0;
   extern int convsize;

  if (called) return(0);
  else called = 1;

  convsize=cxmax = cymax = size;
  asize = sizeof(float) * cxmax * cymax; 
  if (num >= NUMCONV) num = NUMCONV-1;
  if (num < 0) num = 0;
  for (arr=0; arr<num; arr++)
      if ((arrtab[arr] = (float *)smalloc(asize))==NULL) {
         return (0);
      }
  return (arr);   /* return number of arrays made */
}

/*------------------------------------*/

double readc(int arr, int x, int y)
{
   int offset;
   float *conarr;

 if (x < 0) x = 0;
 else if (x >= cxmax) x = cxmax-1;
 if (y < 0) y = 0;
 else if (y >= cymax) y = cymax-1;
 conarr = arrtab[arr];
 offset = y * cxmax + x;
 return ((double)*(conarr+offset)); 
}

/*------------------------------------*/

void writec(int arr, int x, int y, double val)
{
   int offset;
   register float *conarr;

 if (x < 0) x = 0;
 else if (x >= cxmax) x = cxmax-1;
 if (y < 0) y = 0;
 else if (y >= cymax) y = cymax-1;
 conarr = arrtab[arr];
 offset = y * cxmax + x;
 *(conarr+offset) = val; 
}

/*------------------------------------*/

void addc(int arr, int x, int y, double val)
{
   int offset;
   register float *conarr;

 if (x < 0) x = 0;
 else if (x >= cxmax) x = cxmax-1;
 if (y < 0) y = 0;
 else if (y >= cxmax) y = cxmax-1;
 conarr = arrtab[arr];
 offset = y * cxmax + x;
 *(conarr+offset) += val; 
}


/*------------------------------------*/

void mulc(int arr, int x, int y, double val)
{
   int offset;
   register float *conarr;

 if (x < 0) x = 0;
 else if (x >= cxmax) x = cxmax-1;
 if (y < 0) y = 0;
 else if (y >= cxmax) y = cxmax-1;
 conarr = arrtab[arr];
 offset = y * cxmax + x;
 *(conarr+offset) *= val; 
}


/*------------------------------------*/

void copyc(int arr1, int arr2)
                 
/* copy arr1 into arr2 */

{
   register float *conarr1,*conarr2,*arrend;

   conarr1 = arrtab[arr1];
   conarr2 = arrtab[arr2];
   arrend = conarr1 + (cxmax*cymax);
   for ( ; conarr1<arrend; ) 
       *conarr2++ = *conarr1++; 
}

/*------------------------------------*/

void setc(int arr, double val)

/* set arr to val */

{
   register float *conarr,*arrend;

   conarr = arrtab[arr];
   arrend = conarr + (cxmax*cymax);
   for ( ; conarr<arrend; ) *conarr++ = val; 
}

/*------------------------------------*/

#else		/* 16 bit compiler, not 32bit */


#define NUMCONV 10			/* max number of conv arrays */
#define CONVSIZ 8			/* number of sub-arrays per conv arr */

#define YMASK 0x1f 
#define XMAX 256			/* make 256 x 256 array */
#define YMAX 256

static int cxmax=XMAX;
static int cymax=YMAX;

float *arrtab[NUMCONV][CONVSIZ];

/*------------------------------------*/

char *smalloc(unsigned int n)	/* check return from malloc() */
	           
{
	char *p, *malloc(size_t);

	p = malloc((size_t)n);
	if (p == 0)
		fprintf(stderr,"out of memory\n");
	return p;
}

/*------------------------------------*/

void initc(int num, int size)
{
   unsigned int asize;
   int arr,i;

  size = 32768; 
  asize = size; 
  if (num >= NUMCONV) num = NUMCONV-1;
  if (num < 0) num = 0;
  for (arr=0; arr<num; arr++)
    for (i=0; i<CONVSIZ; i++)
      if ((arrtab[arr][i] = (float *)smalloc(asize))==NULL) {
         return (0);
      }
  return (arr);		/* return number of arrays made */
}

/*------------------------------------*/

double readc(int arr, int x, int y)
{
   int offset,subarr;
   float *conarr;

 if (x < 0) x = 0;
 else if (x >= cxmax) x = cxmax-1;
 if (y < 0) y = 0;
 else if (y >= cymax) y = cymax-1;
 offset = ((y & YMASK) << 8) | x;
 subarr = y >> 5;
 conarr = arrtab[arr][subarr];
 return ((double)*(conarr+offset)); 
}

/*------------------------------------*/

void writec(int arr, int x, int y, double val)
{
   int offset,subarr;
   register float *conarr;

 if (x < 0) x = 0;
 else if (x >= cxmax) x = cxmax-1;
 if (y < 0) y = 0;
 else if (y >= cymax) y = cymax-1;
 offset = ((y & YMASK) << 8) | x;
 subarr = y >> 5;
 conarr = arrtab[arr][subarr];
 *(conarr+offset) = val; 
}

/*------------------------------------*/

void addc(int arr, int x, int y, double val)
{
   int offset,subarr;
   register float *conarr;

 if (x < 0) x = 0;
 else if (x >= cxmax) x = cxmax-1;
 if (y < 0) y = 0;
 else if (y >= cxmax) y = cxmax-1;
 offset = ((y & YMASK) << 8) | x;
 subarr = y >> 5;
 conarr = arrtab[arr][subarr];
 *(conarr+offset) += val; 
}


/*------------------------------------*/

void mulc(int arr, int x, int y, double val)
{
   int offset,subarr;
   register float *conarr;

 if (x < 0) x = 0;
 else if (x >= cxmax) x = cxmax-1;
 if (y < 0) y = 0;
 else if (y >= cxmax) y = cxmax-1;
 offset = ((y & YMASK) << 8) | x;
 subarr = y >> 5;
 conarr = arrtab[arr][subarr];
 *(conarr+offset) *= val; 
}


/*------------------------------------*/

copyc(int arr1, int arr2)
                 

/* copy arr1 into arr2 */

{
   int x,y;

   for (x=0; x<cxmax; x++)
     for (y=0; y<cymax; y++)
        writec (arr2, x, y, readc(arr1, x, y)); 		/* */
}

/*------------------------------------*/

void setc(int arr, double val)

/* set arr to val */

{
   int x,y;

   for (x=0; x<cxmax; x++)
     for (y=0; y<cymax; y++)
        writec (arr, x, y, val); 		/* */
}

/*------------------------------------*/

#endif			/* end of not BIT32 */

