/* control.h */

extern int nrecrd;
extern int nstim;
extern int silent;
extern int vidmode;
extern int disp;
extern int prmap;
extern int stim_elem;

/* default values for some constants */

extern double vk;
extern double vna;
extern double vcl;
extern double dcap;
extern double ddia;
extern double dlen;
extern double dri;		/* axial resistance */
extern double drg;		/* gap junction resistance */
extern double drm;		/* membrane resistance */
extern double dsfa;		/* synaptic filters 1 */
extern double dfta;		/* synaptic time constant */
extern double dsfb;		/* synaptic filters 2 */
extern double dftb;		/* synaptic time constant */
extern double dscn;		/* number of channel sites */
extern double dscd;		/* duration of channel events */
extern double dsvn;		/* number of vesicle release sites */
extern double dvsz;		/* size of vesicles released */
extern double dscq;		/* channel quantal size */
extern double dsvq;		/* vesicle quantal size */
extern double dst;		/* synaptic threshold */
extern double dsc;		/* synaptic curve */
extern double dskd;		/* half-max saturation gain */
extern double dmaxsyn;		/* maximum cond for synapse      */
extern double dse;		/* synaptic gain exponent */
extern double dsi;		/* synaptic input gain */
extern double dsei;		/* synaptic input gain for expon  */
extern double dmaxrod;		/* maximum cond for rod           */
extern double dmaxcon;		/* maximum cond for cone          */
extern double dnadens;		/* density for Na chan (S/cm2)    */
extern double dkdens;		/* density for K chan (S/cm2)    */
extern double dcadens;		/* density for Ca chan (S/cm2)    */
extern double dmaxna;		/* maximum cond for Na channel    */ 
extern double dnathr;		/* activation voltage for NA chan */
extern double dmaxk;		/* maximum cond for K channel     */ 
extern double dkthr;		/* activation voltage for K chan  */
extern float dnataum;		/* act. tau for NA chan (must be float)*/
extern float dnatauh;		/* inactivation tau for NA chan */
extern float dktau;		/* activation tau for K chan */
extern float dcatau;		/* Time const for Ca c3 conductance */
extern float dkcatau;		/* Time const for KCa conductance */
extern double dcao;		/* external calcium concentration */
extern double dcai;		/* internal calcium concentration */
extern double dcapkm;		/* 1/2 sat Ca conc for pump */
extern double dcavmax;		/* Vmax for Ca pump (ma/cm2) */
extern double dcakex;		/* Rate for Na/Ca exchanger */
extern double dcaekm;		/* 1/2 sat Ca conc for exch */
extern double dcabnd;		/* Ratio of bound to free calcium */
extern double dcathr;		/* Voltage activation threshold for ca chan */
extern double dmaxca;		/* maximum cond for Ca channel    */ 
extern double dd1;		/* default d1 for KCa channel    */ 
extern double dd2;		/* default d2 for KCa channel    */ 
extern double dk1;		/* default k1 for KCa channel    */ 
extern double dk2;		/* default k2 for KCa channel    */ 

extern double complam;
extern double lamcrit;
extern double xtime;
extern double timinc;
extern double tempcel;
extern double ktemp;
extern double endexp;
extern double psplen;
extern double recrd;
extern double plmax;
extern double plmin;
extern double ploti;
extern double rate;
extern double stloc;
extern double crit;
extern double relax;
extern double relincr;
extern double ncversion;
extern double synaptau;
extern int    debug;
extern int    debugz;
extern int    poisfl;
extern int    scatter;
extern int    plsep;
extern int    multyax;
extern int    rightYax;
extern int    dashfl;
extern int    euler;
extern int    implicit;
extern int    stimelem;
extern long int rseed;
extern long int drseed;

