

func gauss(x,k,r) {

return (k * exp(-x*x/(r*r)));
};

proc printz (a,b) {
  print a,b;
};

proc drgauss(h,w,locx,locy) {

wid=w*2;
incr = w / 20;
gmove (-wid+locx,gauss(-wid,h,w)+locy);
for (i= -wid; i<=wid; i += incr) {
  gdraw (i+locx,gauss(i,h,w)+locy);
};

};

proc rpmove(dr,t)	{ grmove(dr*cos(t), dr*sin(t)); };
proc rpdraw(dr,t)	{ grdraw(dr*cos(t), dr*sin(t)); };

proc circ(rad) {

 rpmove (-rad,PI/2);
 if (rad > .05) chord = .02
 else chord = .1;
 for (theta=0.0; theta < PI*2; theta += chord)
   rpdraw (rad*chord,theta);
 rpmove (rad,PI/2);
};


/*-------------------------------*/

scale = 1;
offx = 0;
offy = 0;

proc drcirc (locx,locy,rad) { 
 gmove (locx/scale+offx,locy/scale+offy);
 circ (rad);
};

proc sphr (rpangle) {

  rad = .04;
  endseg = .04;
  rpdraw (endseg,rpangle);
  rpmove (rad,rpangle);
  circ (rad);
  rpmove (-rad,rpangle);
  rpmove (-endseg,rpangle);
};


proc rpcable (drlen, rpangle, rpwid) {

  endseg = .04;
  rpdist = drlen - 2 * endseg;

  rpdraw (endseg,rpangle);
  rpdraw (rpwid/2,rpangle+PI/2);
  rpdraw (rpdist,rpangle);
  rpdraw (rpwid/2,rpangle-PI/2);

  rpdraw (endseg,rpangle);
  rpdraw (endseg,rpangle+PI);

  rpdraw (rpwid/2,rpangle-PI/2);
  rpdraw (rpdist,rpangle+PI);
  rpdraw (rpwid/2,rpangle+PI/2);
  rpdraw (endseg,rpangle+PI);

};


proc drcable (locx1,locy1, locx2,locy2, cablwid) {

  endseg = .03;
  xd = locx2-locx1;
  yd = locy2-locy1;
  if (xd != 0) {
     slope = (locy2-locy1) / (locx2-locx1);
     cabldist = sqrt(xd*xd+yd*yd);
     angle = atan(slope);
  }
  else {
     angle = PI/2;
  };

  gmove (locx1,locy1);
 
  rpcable (cabldist,angle,cablwid);
  rpcable (cabldist,angle+PI,cablwid);
 
};


ang = 0;
gmove (.3,.5);
rpcable (.2, ang,.05);

rpmove (.2,ang);
rpcable (.2, ang,.05);

sphr (ang+PI/2);
sphr (ang-PI/2);

rpmove (-.2,ang);

gtext ("abc");
