
#include <stdio.h>
#include <math.h>

#define PI 3.141592653589793

main(void)
{

   int i,k,n;
   double val, p, tot;
   double bnldev(double pp, int n);

  tot = 0.0;  
  k = 100;
  p = .010;
  n = 50;
  for (i=0; i<k; i++) {

   val = bnldev(p,n);
   tot += val;

  }
printf ("avg %g p %g n %d\n",tot/k,p,n);
}

/*------------------------------------------*/

double bnldev(double pp, int n)
              
          

/* Taken from Press et al. 1988, "Numerical Recipes in C", p 223.
   Returns as a floating point number an integer value 
   that is a random deviate drawn from a binomial distribution
   of n trials each of probability pp, using drand() as a
   source of uniform random deviates.
*/

{
   int j;
   static int nold = -1;  			     /* must be static */
   static double am,em,g,angle,p,bnl,sq,t,y;
   static double pold = -1, pc, plog,pclog,en,oldg;  /* must be static */
   double drand(void), gammln(double xx), floor(double),tan(double);

   if (pp > 1.0) pp = 1.0;
   if (pp < 0.0) pp = 0.0;
   p = (pp <= 0.5? pp : 1-pp);
   am = n * p;				/* am = mean of deviate */
   if (n < 25) {			/* use direct method if n is small */
      bnl = 0.0;
      for (j=1; j<=n; j++) 
	 if (drand() < p) bnl += 1.0;
   }
   else if (am < 1.0) {			/* if fewer than 1 event is expected */
      g = exp(-am);			/*  in 25 or more trials, then */
      t = 1.0;				/*  use Poisson method */
      for (j=0; j<=n; j++) {
         t *= drand();
	 if (t < g) break;
      }
      bnl = (j <= n ? j : n);
   }
   else {				/* use rejection method */
      if (n != nold) {
	 en = n;
	 oldg = gammln(en+1.0);
	 nold = n;
      }
      if (p != pold) {			/* if p has changed */
	pc = 1.0 - p;
	plog = log(p);
	pclog = log(pc);
	pold = p;
      }
      sq = sqrt(2.0*am*pc);		/* rejection method with Lorentzian */
      do {				/* comparison function */
	do {
	   angle = drand();
	   if (angle == 0.5) angle = 0.4999999999;
	   y = tan(PI*angle);
	   em = sq*y+am;
	} while (em < 0.0 || em >= (en+1.0));	/* reject */
	em = floor(em);
	t = 1.2 * sq * (1.0+y*y) * exp(oldg-gammln(em+1.0)
		- gammln(en-em+1) + em * plog+ (en-em) * pclog);

      } while (drand() > t);		/* reject. This happens about 1.5 */
      bnl = em;				/* times per deviate, on average. */
   }
   if (p != pp) bnl = n -bnl;
   return bnl;
}

/*------------------------------------*/

double gammln(double xx)
{
   double x,tmp,ser,log(double);
   static double cof[6]={76.18009173,-86.50532033,24.01409822,
			-1.231739516, 0.120858003e-2,-0.536382e-5};
   int j;

   x = xx - 1.0;
   tmp = x + 5.5;
   tmp -= (x+0.5) * log(tmp);
   ser = 1.0;
   for (j=0; j<=5; j++) {
     x += 1.0;
     ser += cof[j]/x;
   }
   return -tmp+log(2.50662827465*ser);
}



double drand(void)
{
   double drand48(void);
   double rand2(long int *idum);
   static long int lseed= -1;

  return (drand48());
  return rand2(&lseed);
}


dsrand(long int val)
{
}


#define M 714025
#define IA 1366
#define IC 150889

double rand2(long int *idum)
                  

/* Returns a uniform random deviate between 0 and 1.
   Set idum to any negative value to initialize
   or reinitialize.  Taken from Press et al., 1988,
   'Numerical Recipes in C', Chapter 7, page 212.
*/

{   
    static long int iy, ir[98];
    static int iff=0;
    int j;
    
  if (*idum<0 || iff == 0) {	
      iff = 1;
      if ((*idum=(IC-(*idum)) % M) < 0) *idum = -(*idum);
      for (j=1; j<=97; j++) {		/* initialize the shuffle table */
        *idum=(IA*(*idum)+IC) % M;
        ir[j] = (*idum);
      }
      *idum=(IA*(*idum)+IC) % M;
      iy = (*idum);
   }
   j = 1 + 97.0 * iy / M;
   if (j > 97 || j < 1) {
	fprintf (stderr,"ran2: This cannot happen...\n"); 
	return (0.5);
   }
   iy = ir[j];
   *idum = (IA*(*idum)+IC) % M;
   ir[j] = (*idum);
   return (((double)iy) / M);
}

srand2(long int seed)
{
   long int dseed;

   dseed = -1;
   drand(dseed);
}

