
/***************************************************/
/*                                                 */
/*                     MPRINTX                     */
/*                                                 */
/*                                                 */ 
/*                     Wei  Han                    */
/*                                                 */
/*                     July, 90                    */
/*                                                 */ 
/***************************************************/

/* New modifications by Andrew the Hsu
		11/90
*/
#include <X11/Xlib.h> 
#include <X11/Xutil.h>
/* #include <X11/Xos.h>  */
/* #include <X11/Xatom.h> */

#include <stdio.h>
#include <math.h>

#include "icon_bitmap"
#include "colors.h"
#define BITMAPDEPTH 1

#define XSCALE 18
#define YSCALE 18
#define XHHI 1000
#define XHI 1000
#define YHI 1000 
#define STDSIZ 16383.

static Display *display;
static unsigned long foreground_pixel, background_pixel, border_pixel;
static char *progname;
static int screen_num;
static Window win;
static GC gc;
static XFontStruct *font_info;
static unsigned int width, height;
static XSizeHints size_hints;
static int window_size = 0;
static Screen *screen_ptr;
static Pixmap pix;
static Colormap default_cmap;
static char *color_name[] = {
 /*       "black","magenta","green","cyan","red","orange","brown","white",
        "grey","LightBlue","aquamarine","CadetBlue","firebrick","blue",
        "yellow","SpringGreen"};
*/
        "black","blue","green","cyan","red","magenta","brown","white",
        "gray60","LightBlue","aquamarine","CadetBlue","firebrick",
	"VioletRed","yellow", "snow"};
static XColor exact_def;

#define NCOLORS 256
static unsigned long col_val[NCOLORS];

static int xpos, ypos;
static int xscale=XSCALE;
static int yscale=XSCALE;
static int yhi=YHI;
static int xoffset = 30;
static int yoffset = 30;

#define CWIDTH  (.017 * STDSIZ)       /* char matrix size for enh graph */
#define CHEIGHT (.04 * STDSIZ)
static int cwidth=CWIDTH;
static int cheight=CHEIGHT;

extern char *display_name;
extern int scrcolor;
extern int backgr;
extern int scrrev;
extern double scrsiz;
extern int pargc;
extern char **pargv;
extern int multfl;
static int gmodefl=0;

txinit(void)
{

  if (!gmodefl || multfl) {
    gmodefl = 1;
    gmodex(pargc,pargv);
  }
}

txexit(void)
{
  gmodefl = 0;
  tmodex();
}

xyconx(int x, int y)
{
  int xloc,yloc;

#define XMAX 80
#define YMAX 27
 x = (x<XMAX? x : XMAX);
 y = (y<YMAX? y : YMAX);
 x = (x<0? 0 : x);
 y = (y<0? 0 : y);
 xloc = x * cwidth;
 yloc = y * cheight;
 xyvidx(xloc,yloc);
}

xyvidx(int x, int y)
{
movex (x,y);
setorg(x,y);
}

putstrx (char *str)
{
  int width,len;

   len = strlen(str);
   width=XTextWidth(font_info,str,len);
   XDrawString(display,pix,gc,xpos,ypos,str,len);
   XDrawString(display,win,gc,xpos,ypos,str,len);
   XFlush(display);
}

xdot(int xd, int yd)
{
 extern int scrrev;

 xd/=xscale;
 yd/=yscale;
 if  (!scrrev) yd=yhi-yd;
 linsegx(xd,yd,xd,yd);
 xpos = xd;
 ypos = yd;
}
 
setxcol(int pen)
{
  static int oldcol=0, temp;

  temp = oldcol;
  XSetForeground(display,gc,col_val[pen]);
  oldcol = pen;
  return temp;
}
 
movex(int x, int y)
{
 extern int scrrev;

 x/=xscale;
 y/=yscale;
 xpos = x;
 ypos= y;
 if (!scrrev) ypos = yhi-ypos;
}
 
drawx(int x, int y)
{
 extern int scrrrev;

 x/=xscale;
 y/=yscale;
 if  (!scrrev) y=yhi-y;

 if (x>XHHI) x=XHHI;
 if (x<0) x=0;
 if (y>yhi) y=yhi;
 if (y<0) y=0;
 if (xpos >XHHI) xpos=XHHI;
 if (xpos <0) xpos=0;
 if (ypos >yhi) ypos=yhi;
 if (ypos <0) ypos=0;


 linsegx(xpos, ypos, x,y);
 xpos=x;
 ypos=y;
}

double xscalex (double size)
{
   double temp;

   temp = xscale;
   xscale = STDSIZ / size;
   return(temp);
}

double yscalex (double size)
{
   double temp;

   temp = yscale;
   yscale = STDSIZ / size;
   yhi = size;
   return(temp);
}

/**********************************************/

txxsize(void)
{ return STDSIZ; }

/**********************************************/

txysize(void)
{ return STDSIZ; }

/**********************************************/

#define SMALL 1
#define OK 0


gmodex(int argc, char **argv)
{
     int x = 0, y = 0;            /* window position */
     unsigned int border_width = 4; /* border fourn pixels wide */
     unsigned int display_width,display_height; 
     char *window_name = "XVid";
     char *icon_name = "XVid";
     Pixmap icon_pixmap;
     XEvent report;
     int i;
     int count = 5;
     double winscal = .90;

     /* connect to X server */

     progname = argv[0];
     if ((display=XOpenDisplay(display_name))==NULL)
     {
	(void) fprintf(stderr,
		  "basicwin:cannot connect to X server %s\n",
		  XDisplayName(display_name));
        exit(-1);
     }
     /* get screen size form display structure macro */
     screen_num=DefaultScreen(display);
     screen_ptr=DefaultScreenOfDisplay(display);

     display_width=DisplayWidth(display,screen_num);
     display_height=DisplayHeight(display,screen_num);
     
     /*size window with enough room for text */
     height= display_height * 0.5 * scrsiz;
     width=  height;
     xscalex((double) (width*winscal));
     yscalex((double) (height*winscal));

 /* fprintf (stderr, "width == %d, height == %d\n", width, height); /* */

/**************************/
/* Allocates colors for the colormap */

        for(i = 0; i < NCOLORS; i++) {
                col_val[i] = i % 64;		/* set colors roughly first */
        }
        default_cmap = DefaultColormap(display,screen_num);
        for(i = 0; i < 16; i++) {
/*              fprintf(stderr,"allocating color %s\n",color_name[i]); */
                if(!XParseColor(display,default_cmap,color_name[i],&exact_def)) {
                        fprintf(stderr,"can't parse\n");
                        exit(0);
                }

                if (!XAllocColor(display, default_cmap,&exact_def)) {
                     fprintf(stderr,"can't allocate '%s'\n",color_name[i]);
                        /* exit(0); */
                }

                col_val[i] = exact_def.pixel;
        }
/* fprintf(stderr,"Colors allocated successfully\n"); */

     /* create opaque window */
     win=XCreateSimpleWindow(display,RootWindow(display,screen_num),
	     x,y,width,height,border_width,
	     col_val[WHITE],
	     col_val[backgr]);
	
     /* Create Pixmap to display graphs */
     pix = XCreatePixmap(display,
			RootWindow(display,screen_num),
			width,
			height,
			DefaultDepth(display,screen_num));

     /* create pixmap of depth 1 (bitmap) for icon */
     icon_pixmap = XCreateBitmapFromData(display, win, icon_bitmap_bits,
		icon_bitmap_width, icon_bitmap_height);

     /* initialize size hint property for window manager */
/*
     size_hints.flags=PPosition |PSize|PMinSize;
     size_hints.x=x;
     size_hints.y=y;
     size_hints.width=2*width;
     size_hints.height=2*height;
     size_hints.min_width=1000;
     size_hints.min_height=1000;
*/

/* New and improved size hints! */
     size_hints.flags=PPosition |PSize|PMinSize;
     size_hints.x=200;
     size_hints.y=200;
     size_hints.width=2*width;
     size_hints.height=2*height;
     size_hints.min_width=400*scrsiz;
     size_hints.min_height=400*scrsiz;

     /* set properties for window manager (always before mapping) */
     XSetStandardProperties(display,win,window_name,icon_name,
	  icon_pixmap, argv, argc, &size_hints);

     /* select event types wanted */
     /* XSelectInput(display, win, ExposureMask|KeyPressMask |
	      ButtonPressMask | StructureNotifyMask); */
      XSelectInput(display, win, ExposureMask| 
  	      ButtonPressMask | StructureNotifyMask); 

     load_font(&font_info);

     /* create GC for text and drawing */
     get_GC();

    /* Now fill the Pixmaps with Black since some servers default
                to a White background */
    setxcol(backgr);
    XFillRectangle(display, pix, gc, 0, 0, width, height);


     /* Display window */
     XMapWindow(display, win);

/********************************/
        report.type = 0;
    while (count-- > 0) {

 	XNextEvent(display,&report);
	switch(report.type) {
	case Expose:
		XClearWindow(display,win);
/*
     		draw_text(width,height);
     		draw_graphics(width, height);
*/
		XCopyArea(display,pix,win,gc,0,0,width,height,0,0);
           break;
        case ConfigureNotify:
            width = report.xconfigure.width;
	    height = report.xconfigure.height;
	    xscalex((double) width*winscal);
	    yscalex((double) height*winscal);
	    if ((width< size_hints.min_width) ||
		 ( height< size_hints.min_height))
               window_size=SMALL;
            else
	       window_size=OK;
            break;
         default:
	    break;
         }
    }
}
/*******************************/
dealwithwindow(int parm)
{
XEvent	report;
int count = 1;
int newevent;

/*  The trick here is to make sure that the process that called this
    subroutine sleeps when the display is otherwise done but the
    user is looking at the picture.   The window continues to need display
    events because it may be moved and covered by other windows.  If
    we don't sleep, then this process takes up cpu time, polling
    for new events.
*/
  
do {

   if (parm) {	/* Finished displaying window. wait here for user to look */
      XMaskEvent(display, ExposureMask| 
	ButtonPressMask | StructureNotifyMask, &report); 
      newevent = 1;

    }
    else {   /* parm == 0, when displaying moves and draws */
      count--;
      newevent = XCheckMaskEvent(display, ExposureMask | 
		ButtonPressMask | StructureNotifyMask, &report); 
   }

   if (newevent) {
        switch(report.type) {
        case ButtonPress:
        case Expose:
		XClearWindow(display,win);
		XCopyArea(display,pix,win,gc,0,0,width,height,0,0);
		XFlush(display);
           break;
        case ConfigureNotify:
            width = report.xconfigure.width;
            height = report.xconfigure.height;
            if ((width< size_hints.min_width) ||
                 ( height< size_hints.min_height))
               window_size=SMALL;
            else
               window_size=OK;
            break;
         default:
            break;
         }
	}
     } while (count > 0); 
}


/*******************************/
tmodex(void)
{
	     getchar();
             XUnloadFont(display, font_info->fid); 
	     XFreeGC(display, gc);
             XCloseDisplay(display); 
             exit(0);
}

 
/********************************/
get_GC(void)
{

   unsigned long valuemask = 0; /* ignore XGCvalues and use defaults */
   XGCValues values;
   unsigned int line_width = 1;
   int line_style = LineSolid;
   int cap_style = CapRound;
   int join_style = JoinRound;
   int dash_offset =0;
   static char dash_list[] = {
	12,24   };
   int list_length = 2;

   /* Create default graphics contect */
   gc = XCreateGC (display, win, valuemask, &values);

   /* specify font */
   XSetFont(display, gc, font_info->fid);

   XSetForeground(display,gc, col_val[WHITE]); 

   /* set line attributes */
   XSetLineAttributes(display,gc,line_width,line_style,cap_style,join_style);

   /* set dashes to be line_width in length */
   XSetDashes(display, gc,dash_offset,dash_list,list_length);

}

/***************************/
load_font(XFontStruct **font_info)
{
   char *fontname= "fixed";

   /* access font */
   if ((*font_info=XLoadQueryFont(display,fontname)) == NULL)
   {
      (void) fprintf(stderr, "Basic: Cannot open fixed font\n");
      exit(-1);
   }

} 

/***************************/
draw_text(unsigned int win_width, unsigned int win_height)
{
   int y=20;   /* offset form corner of window */
   char *string1 = "Vid";
   char *string2 = "X11 version";
   char *string3 = "Feb 1994";
   int len1, len2, len3;
   int width1, width2, width3;
   char cd_height[50], cd_width[50], cd_depth[50];

   /* need length for both XTextWidth and XDrawString */
   len1 = strlen(string1);
   len2 = strlen(string2);
   len3 = strlen(string3);
   
   /* get string widths for centering */
   width1=XTextWidth(font_info,string1,len1);
   width2=XTextWidth(font_info,string2,len2);
   width3=XTextWidth(font_info,string3,len3);

   /* output text, centered on each line */
   XDrawString(display,pix,gc,(win_width - width1)/2,y,string1,len1);
   XDrawString(display,pix,gc,(win_width - width2)/2,
	     (int)(win_height -30), string2,len2);
   XDrawString(display, pix, gc,(win_width-width3)/2,
             (int)(win_height -15), string3,len3);
}
/***********************/

draw_graphics(unsigned int window_width, unsigned int window_height)
{
   int x,y;
   unsigned int width, height;

   height =window_height;
   width = window_width;
   x = window_width/2 - width/2;
   y = window_height/2 - height/2;

   XDrawRectangle(display, pix, gc, x, y, width, height);

   while (x <= window_width/2+width/2-10) {
   x+=10;
   linsegx(x, window_height/2+height/2-10, x, window_height/2+height/2);
   }
   x = window_width/2 - width/2;
   while (x <= window_width/2+width/2-100) {
   x+=100;
   linsegx(x, window_height/2+height/2-20, x, window_height/2+height/2);
   }
   while (y <= window_height/2+height/2-10) {
   y+=10;
   linsegx(window_width/2-width/2, y, window_width/2-width/2+10, y);
   }
   y = window_height/2 - height/2;
   while (y <= window_height/2+height/2-100) {
   y+=100;
   linsegx(window_width/2-width/2, y, window_width/2-width/2+20, y);

   }
}
/**************************/
linsegx(unsigned int x1, unsigned int y1, unsigned int x2, unsigned int y2)
{
  x1 += xoffset;
  x2 += xoffset;

  y1 += yoffset;
  y2 += yoffset;

   XDrawLine(display, pix, gc, x1, y1, x2, y2);
   XDrawLine(display, win, gc, x1, y1, x2, y2);
   XFlush(display);
}


/*************************/
polygon(int x, int y, int radius, int vertex)
            /*center*/ 
                   
{
    int index=0;
    unsigned int x1=0, y1=0, x2=0, y2=0; 
    double angle;

    angle=3.1415926*2/vertex;
    x1=x+(int)(radius*sin(angle/2));
    y1=y-(int)(radius*cos(angle/2));
    while (index++ !=vertex) {
       x2=x1+(int)(radius*sin(angle/2)*2*cos(index*angle));
       y2=y1+(int)(radius*sin(angle/2)*2*sin(index*angle));
       linsegx (x1, y1, x2, y2);
       x1=x2; y1=y2;
    }
}
/*************************/
xerase(void)
{
   int oldcol;

  oldcol = setxcol(backgr);			/* set to background for erase */
  XFillRectangle(display, pix, gc, 0, 0, width, height); 
  XClearWindow(display, win);
/* 
  draw_text(width, height);
  draw_graphics(width, height);
*/
  XFlush(display); 
  oldcol = setxcol(oldcol);			/* set the color back again */
  xyconx (0,24);				/* home up cursor */
}
/*************************/

xcircle(int x, int y, int radius, int fill)
                          

/* Draw a circle at location (x,y) with "radius".
*/

{

 x/=xscale;
 y/=yscale;
 radius/=yscale;
 if  (!scrrev) y=yhi-y;

 if (x>XHHI) x=XHHI;
 if (x<0) x=0;
 if (y>yhi) y=yhi;
 if (y<0) y=0;

 x += xoffset - radius;
 y += yoffset - radius;  

   XDrawArc(display, pix, gc, x, y, 2*radius, 2*radius, 0, 64*360); 
   XDrawArc(display, win, gc, x, y, 2*radius, 2*radius, 0, 64*360); /* */

  if (fill) {
    XFillArc(display, pix, gc, x, y, 2*radius, 2*radius, 0, 64*360);
    XFillArc(display, win, gc, x, y, 2*radius, 2*radius, 0, 64*360);
  }  /*  */

   XFlush(display);
}
/*************************/

xrect (int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int fill)
{
 x1 /= xscale;
 y1 /= yscale;
 x2 /= xscale;
 y2 /= yscale;
 x3 /= xscale;
 y3 /= yscale;
 x4 /= xscale;
 y4 /= yscale;
 if  (!scrrev) y1=yhi-y1;
 if  (!scrrev) y2=yhi-y2;
 if  (!scrrev) y3=yhi-y3;
 if  (!scrrev) y4=yhi-y4;

 x1 += xoffset;
 y1 += yoffset;
 x2 += xoffset;
 y2 += yoffset;
 x3 += xoffset;
 y3 += yoffset;
 x4 += xoffset;
 y4 += yoffset;

  XDrawLine(display, pix, gc, x1, y1, x2, y2);          /* draw rectangle */
  XDrawLine(display, pix, gc, x2, y2, x3, y3);
  XDrawLine(display, pix, gc, x3, y3, x4, y4);
  XDrawLine(display, pix, gc, x4, y4, x1, y1);

  XDrawLine(display, win, gc, x1, y1, x2, y2);          /* draw rectangle */
  XDrawLine(display, win, gc, x2, y2, x3, y3);
  XDrawLine(display, win, gc, x3, y3, x4, y4);
  XDrawLine(display, win, gc, x4, y4, x1, y1);

 if (fill) {

#define NUMXPT 4

    static XPoint xpnt[NUMXPT] = {0};

   xpnt[0].x = x1;
   xpnt[0].y = y1;
   xpnt[1].x = x2;
   xpnt[1].y = y2;
   xpnt[2].x = x3;
   xpnt[2].y = y3;
   xpnt[3].x = x4;
   xpnt[3].y = y4;

   XFillPolygon(display, pix, gc, xpnt, NUMXPT, Convex, CoordModeOrigin);
   XFillPolygon(display, win, gc, xpnt, NUMXPT, Convex, CoordModeOrigin);


 }
 XFlush(display);
}

/*************************/
/*EOF */

