drm = 5000;
endexp = .1;

con1 = 1;                                    /* node defs */ 
bip_hyp = 10;
bip_dep = 20;
gang = 30;
gang_dend1 = 40;
gang_dend2 = 50;

at con1 cone (0,0);                          /* make single cone */
at con1 sphere dia 5;
                                     /* hyperpolarizing, inhibitory bipolar: */
at bip_hyp sphere dia 5;
conn con1    to bip_hyp    synapse open expon 2 maxcond 2e-9 vrev -.01;
conn bip_hyp to gang_dend1 synapse open expon 5 maxcond 1e-7 vrev -.07;

                                     /* depolarizing, excitatory bipolar: */
at bip_dep sphere dia 5;
conn con1    to bip_dep    synapse close expon 2 maxcond 2e-9 vrev -.01;
conn bip_dep to gang_dend2 synapse open  expon 5 maxcond 1e-7 vrev -.01;


at gang sphere dia 30;                       /* make ganglion cell */
conn gang to gang_dend1 cable length 50 dia 1;
conn gang to gang_dend2 cable length 50 dia 1;


stim spot 1 loc (0,0) inten 1e7 start .02 dur .001;

plot V[con1] max 0 min -.07;
plot V[bip_hyp] max 0 min -.07;
plot V[bip_dep] max 0 min -.07;
plot V[gang_dend1] max 0 min -.07;
plot V[gang_dend2] max 0 min -.07;
plot V[gang] max 0 min -.07;

step .1;
