/* amacrine dendrite with varicosities */
/*  spatial plot */

drm = 5000;

nsegs = 10;
seglen = 10;
totlen = seglen * nsegs;
varicos = 4;
synap = 100;

for (i=1; i<=nsegs; i++) {
  at   [i][synap] sphere dia 3;
  conn [i][synap] to [i] synapse expon 5 maxcond 5e-9 thresh -.04 vrev -.01;
  at i sphere dia varicos;			/* the varicosity */
  conn i to i+1 cable length seglen dia 0.1;	/* the fine cable */
  if (i==5) stim node [i][synap] vclamp -.025 start 0 dur .01
  else      stim node [i][synap] vclamp -.030 start 0 dur .05;  
};
at i sphere dia 5;

graph X max totlen min 0;
graph Y max -.01 min -.04;
graph init;
gpen (7);                                 /* labels for graph */
gmove (0.02,0.85);
gtext ("Volts");
gmove (0.45,0.01);
gtext ("microns");


graph pen 2;
stepsiz=.001;
for (t=0; t<.02; t+=stepsiz) {
   step stepsiz;
   graph restart;
   if (t>=.01) graph pen 4;
   if (t==.01) stim node [i][synap] vclamp -.045 start .01 dur .02;
   for (i=0; i<=nsegs; i++) {
      graph (i*seglen, V[i+1]);     	  /* graph volts vs. distance */
   };
};

