endexp = .15;
drm = 5000;

drg = 1;                               /* calibration for gsiz in Siemens */ 
gsiz = 1e-8;

for (row=0; row<35; row+=5)                  /* create cone array */
      for (col=0; col<35; col+=5) {
          at [row][col] cone (row,col) maxcond 1e-9; 
          at [row][col] sphere dia 10;
      };

for (row=0; row<30; row+=5)            /* connect gj's between rows */
      for (col=0; col<35;  col+=5) {
          conn [row][col] to [row+5][col] gj gsiz;
      };

for (row=0; row<35; row+=5)             /* connect gj's between columns*/
      for (col=0; col<30; col+=5) {
          conn [row][col] to [row][col+5] gj gsiz;
      };

cent = 15;
stim spot 1 loc (cent,cent) inten 1e7 start .01 dur 1e-3;

step .07;

graph X max 30 min 0;                   /* commands to scale graph */
graph Y max -.031 min -.035;
graph init;

graph pen 12;
graph (0, V[0][0]);                     /* corner cone */
for (dist=0; dist<35; dist += 5) {      /* plot line though center */
      graph (dist, V[cent][dist]);      /* graph volts vs. distance */
};

gpen (7);                               /* labels for graph */
gmove (0.02,0.85);
gtext ("Volts");
gmove (0.45,0.01);
gtext ("microns");

