/* Header file ncomp.h for program "nc". */
/* Contains low-level data structures for runtime */

#define NUMSTATE 8                      /* max number of states in channel */
#define MINSTATE 4                      /* min number of state variables */
#define NUMTRANS 4                      /* number of transitions to other sts */
#define NUMFILT  4                      /* number of lowp filters for lpfilt */
#define NUMCASH	11			/* number of calcium shells + 1 */

struct conn; 
struct dbuf;
struct chan;
struct hhchan; 
struct kcachan;
struct stconc;
struct sschan;
struct chanstate;
struct chanpar;
struct lpfilt;
struct synap;
struct load;
struct recep;
struct recpar;
struct recstim;
struct plotfr;
struct cacomp;
struct conlst;

typedef struct comp {                   /* structure for compartment */
        short int ctype;                /* type of comp: 0=>compartment */
        short int miscfl;               /* misc flags: VEXT IEXT VBAT CA ... */
        int num;			/* comp number */
        double v;                       /* voltage */
        double oldv;                    /* voltage at previous time step */
        double vest;                    /* volt estimate */
        double implf;                   /* implicit factor */
        double nodc;                    /* node current not varying w/vest */
        double tcond;                   /* total static comp conductance */ 
        double tcondn;                  /* total cond not varying w/vest */ 
        float verr;                     /* abs value of voltage error */
        float k;                        /* calculation constant */
        float rm;                       /* membrane conductance in comp */
        float cap;                      /* capacitance in comp */
        float extv;                     /* voltage clamp voltage */
        float extvi;                    /* voltage clamp current */
        float exti;                     /* current clamp value */
        float vrev;                     /* membrane reversal potential */
        short int g;               	/* verr greater than zero */
        short int t;               	/* total verr calculated */
	float relax;			/* relax for this comp only */
	struct cacomp *capnt;			/* pointer to calcium compartment */
        struct conlst *clst;           	/* connections to other comps */
        struct conlst *nodlst;         	/* (possible) nodes for this comp */
        struct comp *next;             	/* pointer to next compartment */
        struct comp *last;             	/* pointer to last compartment */
        } comp;

typedef struct conn {                   	/* structure for comp connection */
        short int ctype;                /* type of connection: series, gj */
        struct conn *next;             	/* pointer to next connection (gj) */
        struct conn *last;             	/* pointer to last connection (gj) */
        float conduct;                  /* conductance of connection */
        struct comp *comp1;                    /* first compartment connection */
        struct comp *comp2;                    /* second compartment connection */
        }conn;

typedef struct dbuf {                  	/* structure for delayed buffer */
        short int ctype;                /* type of connection: series, gj */
        struct dbuf *next;             	/* pointer to next connection (gj) */
        struct dbuf *last;             	/* pointer to last connection (gj) */
        float conduct;                  /* conductance of connection */
        struct comp *comp1;             /* first compartment connection */
        struct comp *comp2;             /* second compartment connection */

        float delay;               	/* size of delay buffer */
	short *delbuf;			/* circular buffer pointer */
	short *delpnt;			/* input/output buffer pointer */
        }dbuf;

typedef struct chan {                  		/* basis stuct for membrane channel */

        short int ctype;                /* type of channel: na, k, etc. */
        short int stype;                /* subtype of channel: na, na2, etc. */
        struct chan *next;            	/* pointer to next channel */
        float conduct;                  /* conductance of channel  */
        struct comp *comp1;             /* compartment for channel conductance*/
        struct comp *comp2;       		/* compartment for extra volt. sens.*/
	float maxcond;			/* maximum total channel conductance */
        float vrev;                     /* reversal potential */
        float vthr;                     /* activation threshold voltage */
	struct chanpar *consts;		/* channel constants */
        float cq;                 	/* = ampl of indiv channel quanta */
        short int csites;              	/* number of chan noise release sites */
        float taum;                     /* activation tau */
        float tauh;                     /* inactivation tau */
        }chan;

typedef struct hhchan {                	/* structure for membrane channel */
        short int ctype;                /* type of channel: na, k, etc. */
        short int stype;                /* subtype of channel: na, na2, etc. */
        struct chan *next;            	/* pointer to next channel */
        float conduct;                  /* conductance of channel  */
        struct comp *comp1;             /* compartment for channel conductance*/
        struct comp *comp2;       	/* compartment for extra volt. sens.*/
	float maxcond;			/* maximum total channel conductance */
        float vrev;                     /* reversal potential */
        float vthr;                     /* activation threshold voltage */
	struct chanpar *consts;		/* channel constants */
        float cq;                 	/* = ampl of indiv channel quanta */
        short int csites;              	/* number of chan noise release sites */
        float taum;                     /* activation tau */
        float tauh;                     /* inactivation tau */

        double m;                       /* m,n activation, range 0 - 1 */
        double h;                  	/* h inactivation  range 0 - 1 */
        }hhchan;

typedef struct kcachan {             	/* structure for KCa membrane channel */
        short int ctype;                /* type of channel: na, k, etc. */
        short int stype;                /* subtype of channel: na, na2, etc. */
        struct chan *next;            		/* pointer to next channel */
        float conduct;                  /* conductance of channel  */
        struct comp *comp1;                    /* compartment for channel conductance*/
        struct comp *comp2;       		/* compartment for extra volt. sens.*/
	float maxcond;			/* maximum total channel conductance */
        float vrev;                     /* reversal potential */
        float vthr;                     /* activation threshold voltage */
	struct chanpar *consts;		/* channel constants */
        float cq;                 	/* = ampl of indiv channel quanta */
        short int csites;              	/* number of chan noise release sites */
        float taum;                     /* activation tau */
        float tauh;                     /* inactivation tau */

        double m;                       /* m,n activation, range 0 - 1 */
        double h;                  	/* h inactivation  range 0 - 1 */
        float d1;                  	/* voltage multiplier for alpha */
        float d2;                  	/* voltage multiplier for beta */
        float k1;                  	/* Ca multiplier for alpha */
        float k2;                  	/* Ca multiplier for beta */
        short initfl;                  	/* 1=> m initialized, 0=> m not init */
        }kcachan;

typedef struct stconc {                 	/* structure for state concentration */
	double cval;			/* state concentr */
	double cest;			/* state concentr estimate */
	double dcon;			/* change in state concentr estimate */
        }stconc;

typedef struct sschan {                 	/* structure for sequen-state chan */
        short int ctype;                /* type of channel: na, k, etc. */
        short int stype;                /* subtype of channel: na, na2, etc. */
        struct chan *next;            		/* pointer to next channel */
        float conduct;                  /* conductance of channel  */
        struct comp *comp1;                    /* compartment for channel conductance*/
        struct comp *comp2;       		/* compartment for extra volt. sens.*/
	float maxcond;			/* maximum total channel conductance */
        float vrev;                     /* reversal potential */
        float vthr;                     /* activation threshold voltage */
	struct chanpar *consts;		/* channel constants */
        float cq;                 	/* = ampl of indiv channel quanta */
        short int csites;              	/* number of chan noise release sites */
        float taum;                     /* activation tau */
        float tauh;                     /* inactivation tau */

        short int numstate;             /* number of states used */
	struct stconc conc[MINSTATE];		/* state concentr (variable size arr) */
        }sschan;

typedef struct chanstate {              	/* structure for chan state constants*/
        float cond;                     /* normalized conductance of state */
	short int numtrans;		/* number of transitions from state */
	char     trans[NUMTRANS];	/* four possible state transitions */
	double (*trate[NUMTRANS])
		  (double v, int typ);	/* function returning rate for trans */
	float  ratemul[NUMTRANS];	/* rate multiplier for transition */
	char   ratev[NUMTRANS];		/* comp. for transition volt sens */
	}chanstate;			/* ratev=0 -> comp1; ratev=1 -> comp2*/

typedef struct chanpar {                	/* structure for channel constants */
        short int ctype;                /* type of channel: na, k, etc. */
        short int numstate;             /* number of states used */
	struct chanstate state[NUMSTATE];	/* state definitions */	
	}chanpar;


typedef struct cacomp {				/* structure for calcium comp/chan */
        short int ctype;                /* type of channel: na, k, ca, etc. */
	struct cacomp *next;			/* pointer to next ca comp/chan */
        struct conlst *clst;            	/* list of calcium chans */
        struct comp *comp1;                    /* voltage compartment     */
	double cais[NUMCASH+1];		/* calcium conc. in shells */
	float cao;			/* calcium concentration outside */
	float cai;			/* starting calcium conc inside */
	float ica;			/* current through calcium chan */
	float casf0;			/* shell fact for caflux */
	float casfn;			/* shell factor = 1/(dr*dr) */
	float casfc;			/* shell factor for core */
	float vrev;			/* calcium reversal potential */
	float vmax;			/* calcium pump Vmax */
	float pkm;			/* calcium pump half-max */
	float kex;			/* Na-calcium exchange rate const */
	float ekm;			/* calcium exchanger half-max */
	float cabnd;			/* ratio of bound to free calcium */
	float ipump;			/* total current from pump and exch */
	}cacomp;

typedef struct synap {               	/* structure for synaptic connection */
        short int ctype;                /* type of connection: series, gj */
        struct synap *next;            	/* pointer to next connection (gj) */
        struct synap *last;            	/* pointer to last connection (gj) */
        float conduct;                  /* conductance of connection */
        struct comp *comp1;             /* first compartment connection */
        struct comp *comp2;             /* second compartment connection */

        float vrev;                     /* reversal potential */
        float thresh;                   /* offset (threshold) for lookup tab */
        float igain;                    /* gain (multiplier) before sat. */
        float kd;                       /* dissociation constant (half max) */
        float maxcond;                  /* maximum conductance (num of chans) */
        float expon;                    /* = 1/b (mvolts for efold increase) */
        float cdur;                     /* duration of channel event */
        float vsize;                    /* vesicle size (in terms of trel) */
        short int vsites;              	/* number of ves noise release sites */
        short int csites;              	/* number of chan noise release sites */
        short int ntact;               	/* open or closed */
        short int curve;               	/* linear or exponential */
        struct synap *sdyad;            	/* pointer to dyad (correl. synapse) */
	struct lpfilt *filt1;			/* low pass filter before tr release */
	struct lpfilt *filt2;			/* low pass filter after tr release */
	struct lpfilt *filt3;			/* low pass filter after saturation */
        }synap;

typedef struct lpfilt {				/* low pass filter for synapse */
        short int nfilt;                /* number of low-pass filters  */
        float ftau;                     /* filter time constant */
        float lfilt[NUMFILT+1];         /* array of filters to delay psp */
        float tfall;                    /* falling phase time constant */
	}lpfilt;

typedef struct load {                  		/* structure for synaptic connection */

        short int ctype;                /* type of connection: gj, syn, load */
        struct load *next;	            	/* pointer to next load */
        float conduct;                  /* conductance of channel */
        struct comp *comp1;                    /* first compartment connection */
        float vrev;                     /* reversal potential */
	}load;

typedef struct recep {                  	/* structure for receptor */
        short int ctype;                /* type of connection: gj, syn, load */
        struct recep *next;	            	/* pointer to next load */
        float conduct;                  /* conductance of channel */
        struct comp *comp1;                    /* first compartment connection */
        float vrev;                     /* reversal potential */

        struct recpar *consts;          	/* receptor constants */
        float xloc;                     /* location of receptor */
        float yloc;
	float pathl;			/* path length through pigment */
	float attf;			/* attenuation factor */
	float timec;			/* time speed factor */
	short int filt;			/* filter number (0=none,1=mac pigm)*/
	short int pnois;		/* poisson noise from photon flux */
        float area;                     /* photon collecting area of recept */
        double flux;                    /* average photon flux */
        float rhod;                     /* rhodopsin */
        float gpr1;                     /* G protein */
        float gpr2;                     /* second G prot for delay */
        float gpr3;                     /* third G prot for delay */
        float pde;                      /* phosphodiesterase */
        float gcyc;                     /* G cyclase enzyme activation level */
        float cycg;                     /* cyclic G level */
        float cond;                     /* dark conductance normalized 0 to 1 */
        float ca;                       /* calcium level */
        float cax;                      /* delayed calcium level */
        float maxcond;                  /* multiplier to get true conductance */
        short int recnm1;               /* receptor node num1 */ 
        short int recnm2;               /* receptor number 2 */ 
        short int recnm3;               /* receptor number 3 */ 
        }recep;

typedef struct recpar {                 	/* structure for receptor constants */

        short int ctype;                /* type of receptor: rod, cone */
	short int pigm;			/* pigment type (0 - 10) */
	float pathl;			/* default pigment path length */
        float rhod;                     /* rhodopsin */
        float gpr1;                     /* G protein */
        float gpr2;                     /* second G prot for delay */
        float gpr3;                     /* third G prot for delay */
        float pde;                      /* phosphodiesterase */
        float gcyc;                     /* G cyclase enzyme activation level */
        float cycg;                     /* cyclic G level */
        float cond;                     /* dark conductance normalized 0 to 1 */
        float totcond;                  /* absolute conductance (20 x dark) */
        float ca;                       /* calcium level */
        float cax;                      /* delayed calcium level */
        float rhodgain;                 /* rhodopsin gain */
        float ggain1;                   /* G protein gain */
        float ggain2;                   /* G protein gain */
        float ggain3;                   /* G protein gain */
        float ggain4;                   /* G protein gain */
        float pdebase;                  /* dark level of PDE */
        float pdegain;
        float gcygain;
        float condgain;
        float capump;
        float gca;
        float cxgain;
        float kdgcyc;
        float dec1;                     /* decay constants */
        float dec2;
        float dec3;
        float dec4;
        float pdedec;
        float dec5;
        float dec6;
        float vrev;                     /* gated channel reversal potential */
        }recpar;

typedef struct recstim {                	/* structure for receptor stimulus */

        short int ctype;                /* type of stimulus: ROD,CONE,VCLAMP..*/
        struct recstim *next;         		/* pointer to next rec stim */
        short int mode;                 /* absolute or delta */
        short int recnm1;               /* receptor number num 1*/
        short int recnm2;               /* receptor number 2 */
        short int recnm3;               /* receptor number 3 */
        double time;                    /* time of stimulus */
        float val;                      /* stimulus intensity */
        float wavel;                    /* stimulus wavelength */
        }recstim;

typedef struct plotfr {                 /* node numbers, vmin, vmax voltages */
        int cnod1;
        int cnod2;
        int cnod3;
        double pxmax;
        double pxmin;
        double pymax;
        double pymin;
        double xrange;
        double yrange;
        double oldx;
        double oldy;
        char *spnt;             /* pointer to symbol for plotting */
        short int pmod;
        short int ppen;
        short charmode;		/* mode of char plot */
        short automax;		/* maxmin from automatic scaling */
        double csize;		/* size of char for plot */
        char charfl[2];		/* char to be plotted */
        }plotfr;
        
