/* ncelem.h */
/* neural element structures for "nc" */


struct elem;
struct attrib;
struct cattrib;
struct node;
struct conlst;
struct comp;
struct conn;

typedef struct elem {
	short int ctype;		/* element type used to establish id */
	short int saved;		/* =1 -> save element */
	int elnum;			/* the element number */
	struct elem *next;		/* pointer to next element */
	short int node1a;		/* nodes at ends of branch */
	short int node1b;		/* second dim */
	short int node1c;		/* third dim */
	short int node2a;
	short int node2b;
	short int node2c;
	struct node *nodp1;			/* pointer to node 1 */
	struct node *nodp2;			/* pointer to node 2 */
	struct attrib *attpnt;			/* pointer to attributes */
	int modif;			/* nonzero -> modification of element */
	struct elem *lptr;			/* pntr to low level struc for modif */
	}elem;

typedef struct sphere  {
	short int ctype;		/* element type used to establish id */
	short int saved;		/* =1 -> save element */
	int elnum;			/* the element number */
	struct elem *next;			/* pointer to next element */
	short int node1a;		/* nodes at ends of branch */
	short int node1b;		/* second dim */
	short int node1c;		/* third dim */
	short int node2a;
	short int node2b;
	short int node2c;
	struct node *nodp1;			/* pointer to node 1 */
	struct node *nodp2;			/* pointer to node 2 */
	struct attrib *attpnt;			/* pointer to attributes */
	int modif;			/* nonzero -> modification of element */
	struct elem *lptr;			/* pntr to low level struc for modif */

	float dia;			/* diameter of sphere */
	float Rm;			/* Rm for sphere membrane  */
	float Cm;			/* Cm for sphere membrane  */
	float vrev; 			/* membrane reversal potential    */
	float vrest; 			/* membrane initial resting pot   */
	}sphere;

typedef struct cable {
	short int ctype;		/* element type used to establish id */
	short int saved;		/* =1 -> save element */
	int elnum;			/* the element number */
	struct elem *next;			/* pointer to next element */
	short int node1a;		/* nodes at ends of branch */
	short int node1b;		/* second dim */
	short int node1c;		/* third dim */
	short int node2a;
	short int node2b;
	short int node2c;
	struct node *nodp1;			/* pointer to node 1 */
	struct node *nodp2;			/* pointer to node 2 */
	struct attrib *attpnt;			/* pointer to attributes */
	int modif;			/* nonzero -> modification of element */
	struct elem *lptr;			/* pntr to low level struc for modif */

	float dia;			/* diameter of cable */
	float Ri;			/* Ri for branch */
	float Rm;			/* Rm for branch */
	float Cm;			/* Cm for branch */
	float vrev; 			/* membrane reversal potential    */
	float vrest; 			/* membrane initial resting pot   */
	float length;		
	float cplam;			/* space constant for compartments */
	}cable;

typedef struct synapse {
	short int ctype;		/* element type used to establish id */
	short int saved;		/* =1 -> save element */
	int elnum;			/* the element number */
	struct elem *next;			/* pointer to next element */
	short int node1a;		/* nodes at ends of branch */
	short int node1b;		/* second dim */
	short int node1c;		/* third dim */
	short int node2a;
	short int node2b;
	short int node2c;
	struct node *nodp1;			/* pointer to node 1 */
	struct node *nodp2;			/* pointer to node 2 */
	struct attrib *attpnt;			/* pointer to attributes */
	int modif;			/* nonzero -> modification of element */
	struct elem *lptr;			/* pntr to low level struc for modif */

	float thresh;			/* impedance looking into branch  */
	float timec1; 			/* time const for syn filter */
	float nfilt1; 			/* num of filters for synapse */
	float timec2; 			/* time const for syn filter */
	float nfilt2; 			/* num of filters for synapse */
	float tfall2; 			/* falling tau for synapse */
	float timec3; 			/* time const for syn filter */
	float nfilt3; 			/* num of filters for synapse */
	float tfall3; 			/* falling tau for synapse */
	float igain; 			/* gain for synapse */
	float maxcond; 			/* max conductance for synapse */
	float vrev; 			/* membrane reversal potential    */
	float kd; 			/* Kd for synapse */
	float expon; 			/* value of xfer func */
	short int ntact;		/* neurotrans action: open, close */
	short int curve;		/* transfer curve type: lin, expon */
	}synapse;

typedef struct photrec {
	short int ctype;		/* element type used to establish id */
	short int saved;		/* =1 -> save element */
	int elnum;			/* the element number */
	struct elem *next;			/* pointer to next element */
	short int node1a;		/* nodes at ends of branch */
	short int node1b;		/* second dim */
	short int node1c;		/* third dim */
	short int node2a;
	short int node2b;
	short int node2c;
	struct node *nodp1;			/* pointer to node 1 */
	struct node *nodp2;			/* pointer to node 2 */
	struct attrib *attpnt;			/* pointer to attributes */
	int modif;			/* nonzero -> modification of element */
	struct elem *lptr;			/* pntr to low level struc for modif */

	float xpos;
	float ypos;
	float zpos;
	float dia;
	float maxcond;
	float pigm;
	float pathl;
	float attf;
	float timec1;
	char  filt;
	char  photnoise;
	char  save;
	char  restore;
	}photrec;

typedef struct gapjunc {
	short int ctype;		/* element type used to establish id */
	short int saved;		/* =1 -> save element */
	int elnum;			/* the element number */
	struct elem *next;			/* pointer to next element */
	short int node1a;		/* nodes at ends of branch */
	short int node1b;		/* second dim */
	short int node1c;		/* third dim */
	short int node2a;
	short int node2b;
	short int node2c;
	struct node *nodp1;			/* pointer to node 1 */
	struct node *nodp2;			/* pointer to node 2 */
	struct attrib *attpnt;			/* pointer to attributes */
	int modif;			/* nonzero -> modification of element */
	struct elem *lptr;			/* pntr to low level struc for modif */

	float area;
	float specres;
	}gapjunc;

typedef struct resistor {
	short int ctype;		/* element type used to establish id */
	short int saved;		/* =1 -> save element */
	int elnum;			/* the element number */
	struct elem *next;			/* pointer to next element */
	short int node1a;		/* nodes at ends of branch */
	short int node1b;		/* second dim */
	short int node1c;		/* third dim */
	short int node2a;
	short int node2b;
	short int node2c;
	struct node *nodp1;			/* pointer to node 1 */
	struct node *nodp2;			/* pointer to node 2 */
	struct attrib *attpnt;			/* pointer to attributes */
	int modif;			/* nonzero -> modification of element */
	struct elem *lptr;			/* pntr to low level struc for modif */

	float z;			/* resistance */
	}resistor;

typedef struct loadelem {
	short int ctype;		/* element type used to establish id */
	short int saved;		/* =1 -> save element */
	int elnum;			/* the element number */
	struct elem *next;			/* pointer to next element */
	short int node1a;		/* nodes at ends of branch */
	short int node1b;		/* second dim */
	short int node1c;		/* third dim */
	short int node2a;
	short int node2b;
	short int node2c;
	struct node *nodp1;			/* pointer to node 1 */
	struct node *nodp2;			/* pointer to node 2 */
	struct attrib *attpnt;			/* pointer to attributes */
	int modif;			/* nonzero -> modification of element */
	struct elem *lptr;			/* pntr to low level struc for modif */

	float z;			/* resistance to gnd */
	float vrev; 			/* membrane reversal potential    */
	float vrest; 			/* membrane reversal potential    */
	}loadelem;

typedef struct capac {
	short int ctype;		/* element type used to establish id */
	short int saved;		/* =1 -> save element */
	int elnum;			/* the element number */
	struct elem *next;			/* pointer to next element */
	short int node1a;		/* nodes at ends of branch */
	short int node1b;		/* second dim */
	short int node1c;		/* third dim */
	short int node2a;
	short int node2b;
	short int node2c;
	struct node *nodp1;			/* pointer to node 1 */
	struct node *nodp2;			/* pointer to node 2 */
	struct attrib *attpnt;			/* pointer to attributes */
	int modif;			/* nonzero -> modification of element */
	struct elem *lptr;			/* pntr to low level struc for modif */

	float c;			/* capacitance */
	float vrest;
	}capac;

typedef struct batt {
	short int ctype;		/* element type used to establish id */
	short int saved;		/* =1 -> save element */
	int elnum;			/* the element number */
	struct elem *next;			/* pointer to next element */
	short int node1a;		/* nodes at ends of branch */
	short int node1b;		/* second dim */
	short int node1c;		/* third dim */
	short int node2a;
	short int node2b;
	short int node2c;
	struct node *nodp1;			/* pointer to node 1 */
	struct node *nodp2;			/* pointer to node 2 */
	struct attrib *attpnt;			/* pointer to attributes */
	int modif;			/* nonzero -> modification of element */
	struct elem *lptr;			/* pntr to low level struc for modif */

	float v;			/* voltage */
	}batt;

typedef struct vbuf {
	short int ctype;		/* element type used to establish id */
	short int saved;		/* =1 -> save element */
	int elnum;			/* the element number */
	struct elem *next;			/* pointer to next element */
	short int node1a;		/* nodes at ends of branch */
	short int node1b;		/* second dim */
	short int node1c;		/* third dim */
	short int node2a;
	short int node2b;
	short int node2c;
	struct node *nodp1;			/* pointer to node 1 */
	struct node *nodp2;			/* pointer to node 2 */
	struct attrib *attpnt;			/* pointer to attributes */
	int modif;			/* nonzero -> modification of element */
	struct elem *lptr;			/* pntr to low level struc for modif */

	float delay;			/* delay in msec */
	}vbuf;

typedef struct attrib {				/* part of an element */

	short int ctype;		/* type of attrib */
	short int stype;		/* channel sub-type */
	struct attrib *attpnt;			/* pointer to attributes */
	struct elem *lptr;			/* pntr to low level struc for modif */
	float vrev;
	float thresh;
	float maxcond;
	float density;
	float taum;
	float tauh;
	float d1;
	float d2;
	float k1;
	float k2;
	}attrib;

typedef struct cattrib {			/* part of an element */
	short int ctype;		/* type of attrib */
	short int stype;		/* channel sub-type */
	struct cattrib *attpnt;		/* pointer to attributes */
	struct elem *lptr;			/* pntr to low level struc for modif */
	float vrev;
	float thresh;
	float maxcond;
	float density;
	float taum;
	float tauh;
	
	short int exch;
	short int pump;
	float cao;
	float cai;
	float kex;
	float ekm;
	float vmax;
	float pkm;
	float cabnd;
	}cattrib;

typedef struct node {
	short int ctype;		/* type of node = 1 */
	short int nodenm1;		/* node dimension 1 */
	short int nodenm2;		/* node dimension 2 */
	short int nodenm3;		/* node dimension 3 */
	float xloc;			/* location of node */
	float yloc;
	float zloc;
	struct conlst *elemlst;		/* element list for connections */
	struct comp *comptr;			/* compartment which represents node */
	struct node *hnext;			/* pointer to next node in hash table */
	struct node *next;			/* pointer to next node for foreach */
	}node;

typedef struct conlst {				/* list of connections */
	struct conlst *next;			/* next in list */
	struct conn *conpnt;			/* pointer to conn */
	}conlst;

#define NLABELS 20
#define NULLNOD (-32768)
#define NULND (-1)

#define NATHR (-0.050)                  /* sodium activation voltage */
#define NATAUM (0.5e-3)			/* sodium activation time constant */
#define NATAUH  (1e-3)			/* sodium inactivation tau */
#define KTHR  (-0.070)                  /* potassium activation voltage */
#define KTAU  (1.25e-3)			/* potassium activation tau */
#define CATHR  (-0.045)			/* calcium activation voltage */
#define CATAU  (1e-3)			/* calcium activation tau */
#define KCATAU  (2e-3)			/* calcium-sens K activation tau */
#define CELSIUS  (273)			/* add to deg celsius for kelvin */

