/* nc.y */
%{
#include <stdio.h>
#include "nc.h"
#define code2(c1,c2)	code(c1); code(c2)
#define code3(c1,c2,c3)	code(c1); code(c2); code(c3)
#define code4(c1,c2,c3,c4) code(c1); code(c2); code(c3); code(c4)
extern int indef, inlocal, argcount, formal;
%}
%union { Symbol	*sym;	/* symbol table pointer */
	Inst	*inst;	/* machine instructions */
	int	narg;	/* number of arguments */
}
%token	<sym>	NUMBER STRING PRINT PRINTF FPRINTF SCANF
%token	<sym>	CONST VAR BLTIN UNDEF WHILE IF ELSE 
%token	<sym>	FUNCTION PROCEDURE RETURN EXIT FUNC PROC READ FREAD FWRITE
%token	<sym>   FOR BREAK CONTINUE EDIT INCLUDE COMNDLINE SYSTEM FOREACH
%token	<sym>	INCROP DECROP PFIELD ARG LOCAL LOCALVAR DIM ARRAY 
%token	<sym>	FFT IFFT PFFT ACOV
%token  <sym>   SFILE PLOT V I L S MAX MIN CHAR CCHAR
%token  <sym>   LITCHAR 
%token  <sym>   DISPLAY GRAPH INIT PEN RESTART
%token	<sym>   X Y Z XLOC YLOC ZLOC
%token	<sym>   FA0 FA1 FA2 FA3 FA4 FA9 FB0 FB1 FB2 FB3 FB4 FC0 FC1 FC2 FC3 FC4
%token	<sym>   G0 G1 G2 G3 G4 G5 G6 G7 G8 
%token	<sym>	GMOVE GDRAW GRMOVE GRDRAW GPEN GFRAME GSIZ GROT GCROT GCWID
%token	<sym>	GDASH GTEXT GORIG GCIRC GRECT RMOVE
%token	<sym>	ELEMENT EXCEPT RANGE SIZE DSCALE COLOR HIDE COMPS
%token	<sym>	XROT YROT ZROT CALIBLIN
%token	<sym>	CABLE SPHERE GJ SYNAPSE LOAD RESISTOR AXIALRES MATCHING
%token	<sym>	MAXCOND CENTER RECT WAVEL SUN XENON PIGM PATHL ATTF
%token	<sym>	ROD CONE PHOTREC DYAD 
%token	<sym>	STIM BAR SPOT SINE WIDTH LOC DUR TFREQ CONTRAST SSCALE
%token	<sym>	START INTEN BACKGR BLUR FILT SAVE RESTORE
%token	<sym>	LENGTH DIA RADIUS VCLAMP CCLAMP GNDBATT BATT GNDCAP CAP NODE
%token	<sym>	CHAN HH NA K CA CAO CAI CAPUMP VMAX KM CAEXCH KEX CBOUND
%token	<sym>	TYPE DENSITY RM RI RG CM OPAMP BUF
%token	<sym>	CONNECT AT TO EDIST EFRAC NDIST ONLY NUMCONN
%token	<sym>	NODE1A NODE1B NODE1C NODE2A NODE2B NODE2C
%token	<sym>	CHNOISE PHOTNOISE VESNOISE N VSIZE
%token	<sym>	GAUSNN MEAN STDEV REG
%token	<sym>	TIMEC1 NFILT1 TIMEC2 NFILT2 TFALL2 TIMEC3 TFALL3 NFILT3
%token	<sym>	OPEN CLOSE THRESH VREV VREST DELAY IGAIN KD LINEAR EXPON
%token	<sym>	TAUM TAUH TAUN TAUC D1 D2 K1 K2
%token	<sym>	MODIFY ENAME PLACE CPLAM OFFSET PUT
%token	<sym>	RUN STEP ERASE MODEL ALL 
%type	<inst>	cexpr commaexpr setexpr expr stmt asgn prlist stmtlist stmtls
%type	<inst>	cond while if begin end defn filename
%type	<inst>  for forexpr var foreach elemtype
%type	<inst>	elemlist geometry buf
%type	<inst>	stimulus stimtype stiminten stimfile stimwave
%type	<inst>  graphlist graphtype maxmin
%type	<inst>	cableparam sphereparam membrtype connect 
%type	<inst>	chantype noisetype stimparm
%type	<inst>	synaptype receptype plotype displist disptype rotatype capump
%type	<inst>	cachan caexch capump
%type	<inst>	elemfield nodefield elemnum plotlist gnnlist gnnterm plltyp
%type	<sym>	procname listerm arrname synparm memparm fftparm
%type	<sym>	chanparm receparm caparm
%type	<narg>	arglist parglist formarg localvar vararg prflist prfargs
%type	<narg>	scnflist,scnfargs
%type	<narg>	dimlist nodenum snode 
%right	'='
%right	ADDEQ SUBEQ MULEQ DIVEQ
%left	OR AND XOR BITAND BITOR 
%left	GT GE LT LE EQ NE
%left	'+' '-'
%left	'*' '/'
%left	UNARYMINUS NOT
%right	'^'
%%


list:	  /* nothing */
	| list listerm		{ code(STOP); return 1; }
	| list defn listerm	{ code(STOP); return 1; }
	| list asgn listerm	{ code2(expop,STOP); return 1; }
	| list stmt listerm	{ code(STOP); return 1; }
	| list expr listerm	{ code2(print, STOP); return 1; }
	| list error listerm	{ yyerrok; }
	;
listerm: ';'			{}
	;
elemlist: connect		{}
	| elemlist geometry	{}
	| elemlist membrtype	{}
	| elemlist ENAME var	{ code2(xmod,(Inst)$2); }
	;
geometry: CABLE cableparam	{ $$=$2; }
	| SPHERE sphereparam	{ $$=$2; } 
	| synaptype		{ $$=$1; }
	| CHAN chantype		{ $$=$2; }
	| CHAN cachan		{ $$=$2; }
	| receptype		{ $$=$1; }
	| GJ expr		{ $$=$2; code(xgj); } 
	| LOAD expr		{ $$=$2; code(rload); }
	| RESISTOR expr		{ $$=$2; code(xresistor); }
	| CAP  expr		{ $$=$2; code(rcap); }
	| GNDCAP  expr		{ $$=$2; code(xgcap); }
	| BATT expr		{ $$=$2; code(rbatt); }
	| GNDBATT expr		{ $$=$2; code(xgbatt); }
	| buf			{ } 
	;
buf:	  BUF			{ $$=(Inst *)code(xvbuf); } 
	| buf DELAY setexpr 	{ $$=$1; code(xvbufd); }
 	;
cableparam: LENGTH setexpr		{ $$=$2; code2(xcable,(Inst)$1); }
	| DIA setexpr			{ $$=$2; code2(xcable,(Inst)$1); }
	| CPLAM setexpr			{ $$=$2; code2(xcable,(Inst)$1); }
	| cableparam LENGTH setexpr	{ code2(xcable,(Inst)$2); }
	| cableparam DIA setexpr	{ code2(xcable,(Inst)$2); }
	| cableparam CPLAM setexpr	{ code2(xcable,(Inst)$2); }
	;
sphereparam: expr 		{ code2(xsphere,(Inst)0); }
	| DIA setexpr		{ $$=$2; code2(xsphere,(Inst)$1); }
	;
chantype:  HH 			{ $$=(Inst *)code2(xchan,(Inst)$1);}
	|  NA 			{ $$=(Inst *)code2(xchan,(Inst)$1);}
	|  K  			{ $$=(Inst *)code2(xchan,(Inst)$1);}
	|  chantype chanparm setexpr  { code2(xchan,(Inst)$2); }
	|  chantype noisetype	     { }
	;
cachan:    CA 			{ $$=(Inst *)code2(xcachan,(Inst)$1);}
	|  cachan caparm setexpr	{ code2(xcachan,(Inst)$2);}
	|  cachan chanparm setexpr	{ code2(xcachan,(Inst)$2);}
	|  cachan caexch	     { }
	|  cachan capump	     { }
	;
caparm:    CAO 
	|  CAI 
	|  CBOUND 
	;
caexch:	   CAEXCH		     { $$=(Inst *)code2(xcachan,(Inst)$1);}
	|  caexch KEX setexpr 	     { code2(xcachan, (Inst)$2); }
	|  caexch KM setexpr 	     { code2(xcachan, (Inst)$2); }
	;
capump:	   CAPUMP		     { $$=(Inst *)code2(xcachan,(Inst)$1);}
	|  capump VMAX setexpr 	     { code2(xcachan, (Inst)$2); }
	|  capump KM setexpr   	     { code2(xcachan, (Inst)$2); }
	;
chanparm:  TYPE 
	|  VREV 
	|  THRESH 
	|  TAUM 
	|  TAUH 
	|  TAUN 
	|  TAUC 
	|  MAXCOND 
	|  DENSITY 
	|  K1 
	|  K2 
	|  D1 
	|  D2 
	;
membrtype: chantype		{ }
	|  cachan		{ }
	|  memparm setexpr		{ $$=$2; code2(membtyp,(Inst)$1); }
	|  membrtype memparm setexpr   	{ code2(membtyp,(Inst)$2); }
	|  membrtype chantype	{ }
	|  membrtype cachan	{ }
	;
memparm:   RM 
	|  CM 
	|  RI 
	|  RG 
	|  VREV 
	|  VREST 
	;
connect:   AT begin nodenum  	{ $$=$2; code2(conn1,(Inst)$3); } 
	|  AT begin nodenum LOC parglist     /* args backwards here: */ 
				{ $$=$2; code3(conn1l,(Inst)$5,(Inst)$3); } 

	|  AT begin nodenum ':' elemnum OFFSET setexpr PUT nodenum
				{ $$=$2; code3(conn1m,(Inst)$9, (Inst)$3); }

	|  CONNECT begin nodenum TO nodenum   /* args backwards here */
				{ $$=$2; code2(conn2d,(Inst)$5);
					 code2(conn2s,(Inst)$3); } 

	|  CONNECT begin nodenum LOC parglist TO nodenum
				{ $$=$2; code2(conn2d,(Inst)$7);
					 code3(conn2sl,(Inst)$5,(Inst)$3); }

	|  CONNECT begin nodenum TO nodenum LOC parglist
				{ $$=$2; code3(conn2dl,(Inst)$7,(Inst)$5);
					 code2(conn2s,(Inst)$3); }

					/* args backwards here: */	
	|  CONNECT begin nodenum LOC parglist TO nodenum LOC parglist
				{ $$=$2; code3(conn2dl,(Inst)$9,(Inst)$7);
					 code3(conn2sl,(Inst)$5,(Inst)$3); } 
	|  MODIFY expr		{ $$=$2; code2(xmod,(Inst)$1); }
	;
synaptype: SYNAPSE begin		{ $$=$2; }
	|  synaptype OPEN		{ code2(xsynapse,(Inst)$2); }
	|  synaptype CLOSE	 	{ code2(xsynapse,(Inst)$2); }
	|  synaptype synparm setexpr 	{ code2(xsynapse,(Inst)$2); }
	|  synaptype LINEAR	 	{ code2(xsynapse,(Inst)$2); }
	|  synaptype noisetype	 	{ }
	;
synparm:   VREV			/* list of params that take on values */
	|  THRESH 
	|  TIMEC1 
	|  NFILT1 
	|  TIMEC2 
	|  NFILT2 
	|  TFALL2
	|  TIMEC3 
	|  NFILT3 
	|  TFALL3
	|  IGAIN 
	|  MAXCOND 
	|  KD 
	|  EXPON 
	|  DYAD 
	;
noisetype: CHNOISE 			{ $$=(Inst *)code2(noise,(Inst)$1); }
	|  VESNOISE 	 		{ $$=(Inst *)code2(noise,(Inst)$1); }
	|  noisetype N setexpr 		{ code2(noise,(Inst)$2); }
	|  noisetype VSIZE setexpr 	{ code2(noise,(Inst)$2); }
	|  noisetype DUR setexpr 	{ code2(noise,(Inst)$2); }
	;
receptype: ROD  begin parglist 	{ $$=$2;code3(xrecept,(Inst)$1,(Inst)$3);}
	|  CONE begin parglist  { $$=$2;code3(xrecept,(Inst)$1,(Inst)$3);}
	|  receptype receparm setexpr	{ code2(xrecparm, (Inst)$2); }
	|  receptype SAVE 		{ code2(xrecparm, (Inst)$2); }
	|  receptype RESTORE 		{ code2(xrecparm, (Inst)$2); }
	|  receptype PHOTNOISE 		{ code2(xrecparm, (Inst)$2); }
	;
receparm:  MAXCOND 	{}
	|  DIA 		{}
	|  PIGM 	{}
	|  PATHL 	{}
	|  ATTF 	{}
	|  FILT		{}
	|  TIMEC1	{}
	;
stimulus:  stimparm	{}
	|  stimulus stimparm {}
	;
stimparm:  stimtype     {}
	|  LOC    begin parglist { $$=$2; code3(xstim,(Inst)$1,(Inst)$3); }
	|  CENTER begin parglist { $$=$2; code3(xstim,(Inst)$1,(Inst)$3); }
	|  START  setexpr        { $$=$2; code2(xstim,(Inst)$1); }
	|  DUR setexpr 	         { $$=$2; code2(xstim,(Inst)$1); }
	|  TFREQ setexpr         { $$=$2; code2(xstim,(Inst)$1); }
	|  BLUR setexpr          { $$=$2; code2(xstim,(Inst)$1); }
	|  SSCALE setexpr        { $$=$2; code2(xstim,(Inst)$1); }
	|  stimwave	{}
	|  stiminten	{}
	|  stimfile	{}
	;
stimtype:  BAR expr 	{ $$=$2; code2(xstim,(Inst)$1); }
	|  SPOT expr	{ $$=$2; code2(xstim,(Inst)$1); }
	|  SINE expr	{ $$=$2; code2(xstim,(Inst)$1); }
	|  RECT begin arglist 	{ $$=$2; code3(xstim,(Inst)$1,(Inst)$3); }
	|  ROD  expr 		{ $$=$2; code3(xstim,(Inst)$1,(Inst)1);}
	|  ROD  begin dimlist 	{ $$=$2; code3(xstim,(Inst)$1,(Inst)$3);}
	|  CONE expr 		{ $$=$2; code3(xstim,(Inst)$1,(Inst)1);}
	|  CONE begin dimlist 	{ $$=$2; code3(xstim,(Inst)$1,(Inst)$3);}
	|  NODE expr 		{ $$=$2; code3(xstim,(Inst)$1,(Inst)1);}
	|  NODE begin dimlist 	{ $$=$2; code3(xstim,(Inst)$1,(Inst)$3);}
	;
stimwave:  WAVEL setexpr    { $$=$2; code3(xstim,(Inst)$1,(Inst)0); }
	|  WAVEL SUN 	   { $$=(Inst *)code3(xstim,(Inst)$1,(Inst)$2); }
	|  WAVEL '=' SUN   { $$=(Inst *)code3(xstim,(Inst)$1,(Inst)$3); }
	|  WAVEL XENON 	   { $$=(Inst *)code3(xstim,(Inst)$1,(Inst)$2); }
	|  WAVEL '=' XENON { $$=(Inst *)code3(xstim,(Inst)$1,(Inst)$3); }
	;
stiminten: INTEN setexpr   { $$=$2; code2(xstim,(Inst)$1); }
	|  BACKGR setexpr  { $$=$2; code2(xstim,(Inst)$1); }
	|  VCLAMP setexpr  { $$=$2; code2(xstim,(Inst)$1); }
	|  CCLAMP setexpr  { $$=$2; code2(xstim,(Inst)$1); }
	|  CONTRAST setexpr { $$=$2; code2(xstim,(Inst)$1); }
	;
stimfile: SFILE filename {$$=$2; (Inst *)code2(xstim,(Inst)$1);} 
	;
asgn:	  var '=' expr 	 { code(assign); }
	| var ADDEQ expr { code(addeq); }
	| var SUBEQ expr { code(subeq); }
	| var MULEQ expr { code(muleq); }
	| var DIVEQ expr { code(diveq); } 
	;
stmt:     expr { code(expop); } 
	| LOCAL { inlocal=1; } localvar 
	    {inlocal=0; defnonly("local"); $$=(Inst *)code2(local,(Inst)$3);}
	| RETURN { defnonly("return"); code(procret); }
	| RETURN expr 
		{defnonly("return"); $$=$2; code(funcret); }
	| PROCEDURE begin parglist 
		{ $$=$2; code3(call, (Inst)$1, (Inst)$3); }
	| EXIT { $$=code(xexit); }
	| PRINT prlist { $$ = $2; code(crlf); }
	| PRINTF  begin '(' prflist ')'{ $$=$2; code2(pprintf,(Inst)$4);}
	| FPRINTF begin '(' prflist ')'{ $$=$2; code2(dprintf,(Inst)$4);}
	| SCANF   begin '(' scnflist ')'{ $$=$2; code2(pscanf,(Inst)$4);}
	| for '(' forexpr ';' forexpr ';' forexpr ')' stmt end {
		($1)[1] = (Inst)$5;	/* body of loop */
		($1)[2] = (Inst)$7;	/* body of loop */
		($1)[3] = (Inst)$9;	/* body of loop */
		($1)[4] = (Inst)$10; }	/* end expr */
	| BREAK end { $$ = (Inst *)code(breakcode); }
	| CONTINUE end { $$ = (Inst *)code(contcode); }
	| while cond stmt end {
		($1)[1] = (Inst)$3;	/* body of loop */
		($1)[2] = (Inst)$4; }	/* end, if cond fails */
	| if cond stmt end {	 	/* else-less if */
		($1)[1] = (Inst)$3;	/* thenpart */
		($1)[3] = (Inst)$4; }	/* end, if cond fails */
	| if cond stmt end ELSE stmt end { /* if with else */
		($1)[1] = (Inst)$3;	/* thenpart */
		($1)[2] = (Inst)$6;	/* elsepart */
		($1)[3] = (Inst)$7; }	/* end, if cond fails */
	| foreach stmt end 		{ /* look through all nodes */
		($1)[2] = (Inst)0;
		($1)[3] = (Inst)0;
		($1)[4] = (Inst)0;
		($1)[5] = (Inst)0;
		($1)[6] = (Inst)$2;	/* body of loop */
		($1)[7] = (Inst)$3; }	/* end, when done */
	| foreach NODE snode end stmt end { /* look through all nodes */
		($1)[2] = (Inst)1;
		($1)[3] = (Inst)$3;
		($1)[4] = (Inst)0;
		($1)[5] = (Inst)0;
		($1)[6] = (Inst)$5;	/* body of loop */
		($1)[7] = (Inst)$6; }	/* end, when done */
	| foreach NODE snode snode end stmt end {
		($1)[2] = (Inst)2;
		($1)[3] = (Inst)$3;
		($1)[4] = (Inst)$4;
		($1)[5] = (Inst)0;
		($1)[6] = (Inst)$6;	/* body of loop */
		($1)[7] = (Inst)$7; }	/* end, when done */
	| foreach NODE snode snode snode end stmt end {
		($1)[2] = (Inst)3;
		($1)[3] = (Inst)$3;
		($1)[4] = (Inst)$4;
		($1)[5] = (Inst)$5;
		($1)[6] = (Inst)$7;	/* body of loop */
		($1)[7] = (Inst)$8; }	/* end, when done */
	| stmtlist 		{ }
	| EDIT filename		{ $$=$2; code(edit); }
	| INCLUDE filename	{ $$=$2; code(pushfil); }
	| COMNDLINE		{ system ((char *)$1); } 
	| SYSTEM STRING		{ system ($2->name); } 
	| elemlist		{ }
	| STIM stimulus		{ $$=$2;    code2(xstim,(Inst)$1); }
	| PLOT plotlist		{ $$=$2;    code(incrpl); }
	| DISPLAY displist	{ $$=$2;    code2(dispnod,(Inst)$1); }
	| GRAPH graphlist	{ $$=$2; }
	| GMOVE begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GDRAW begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GRMOVE begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GRDRAW begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GCIRC begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GRECT begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GPEN  begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GROT  begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GORIG begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GCWID begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GCROT begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GDASH begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GSIZ begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GFRAME begin parglist	{ $$=$2;    code3(gplot,(Inst)$1,(Inst)$3); }
	| GTEXT begin '(' prflist ')'{ $$=$2; code2(txtf,(Inst)$4);}
	| FREAD begin '(' filename ',' VAR ',' vararg ')'
		{ $$=$2; code3(xfread,(Inst)$6,(Inst)$8); }
	| FWRITE begin '(' filename ',' ARRAY ')'
		{ $$=$2; code2(xfwrite,(Inst)$6); }
	| DIM begin arrname dimlist  { $$=$2; 
			 code3(darray,(Inst)$3,(Inst)$4); $3->type=ARRAY; }
	| fftparm begin '(' ARRAY ')' { $$=$2; code3(dofft,(Inst)$1,(Inst)$4); }
	| ERASE ARRAY { $$=(Inst *)code2(erarr,(Inst)$2); }
	| ERASE MODEL		{ eramod(); }
	| RUN 	 		{ $$ = (Inst *)code2(modrun,(Inst)$1); }
	| STEP expr  		{ $$ = $2;     code2(modrun,(Inst)$1); }
	;
gnnlist:  gnnterm		{  }
	| gnnlist ',' gnnterm	{  }
	;
gnnterm:  MEAN setexpr		{ $$=$2; code2(xgausnn,(Inst)$1); } 
	| STDEV setexpr		{ $$=$2; code2(xgausnn,(Inst)$1); } 
	| DENSITY setexpr	{ $$=$2; code2(xgausnn,(Inst)$1); } 
	| REG setexpr		{ $$=$2; code2(xgausnn,(Inst)$1); } 
	| SIZE begin parglist	{ $$=$2; code3(xgausnn,(Inst)$1,(Inst)$3); } 
	| CENTER begin parglist	{ $$=$2; code3(xgausnn,(Inst)$1,(Inst)$3); } 
	;
fftparm:  FFT			{ }
	| IFFT			{ }
	| PFFT			{ }
	| ACOV			{ }
	;
plotype:  V 			{ }
	| I			{ }
	| L			{ }
	| FA0			{ }
	| FA1			{ }
	| FA2			{ }
	| FA3			{ }
	| FA4			{ }
	| FA9			{ }
	| FB0			{ }
	| FB1			{ }
	| FB2			{ }
	| FB3			{ }
	| FB4			{ }
	| FC0			{ }
	| FC1			{ }
	| FC2			{ }
	| FC3			{ }
	| FC4			{ }
	| G0			{ }
	| G1			{ }
	| G2			{ }
	| G3			{ }
	| G4			{ }
	| G5			{ }
	| G6			{ }
	| G7			{ }
	| G8			{ }
	;
plotlist:
	plotype begin nodenum	{ $$=$2; code3(vplot,(Inst)$1,(Inst)$3); }
	| V begin '@' CABLE elemnum ':' expr 
					 { $$=$2;code3(vplot,(Inst)$4,(Inst)2);}
	| S var 		{ $$=$2; code4(incrpl,vplot,(Inst)$1,(Inst)1); }
	| plotlist ',' plotype nodenum
				{ $$=$1; code4(incrpl,vplot,(Inst)$3,(Inst)$4);}
	| plotlist ',' V begin '@' CABLE elemnum ':' expr 
				{ $$=$1; code4(incrpl,vplot,(Inst)$6,(Inst)2);}
	| plotlist ',' S var 	{ $$=$1; code3(vplot,(Inst)$3,(Inst)1); }
	| plotlist maxmin	{ $$=$1; code(vplotm); } 
	| plotlist plltyp 	{ $$=$1; }
	;
graphlist: graphtype		{ $$=$1; }
	| graphlist graphtype 	{ $$=$1; }
	;
graphtype: begin parglist 	{ $$=$1;      code3 (grph, 0L,(Inst)$2);}
	| INIT			{ $$=(Inst *) code3 (grph,(Inst)$1, 0L); }
	| RESTART		{ $$=(Inst *) code3 (grph,(Inst)$1, 0L); }
	| PEN expr		{ $$=$2;      code3 (grph,(Inst)$1,(Inst)1); }
	| PEN begin parglist	{ $$=$2;      code3 (grph,(Inst)$1,(Inst)$3);}
	| X maxmin 		{ $$=$2;      code3 (grph,(Inst)$1, 0L); }
	| Y maxmin		{ $$=$2;      code3 (grph,(Inst)$1, 0L); }
	;
maxmin:   MAX setexpr MIN setexpr { $$=$2; }
	| maxmin plltyp 	{ $$=$1; }
	;
plltyp:   CHAR expr		{ $$=$2; code3 (grph,(Inst)$1, (Inst)-1); }
	| CCHAR expr		{ $$=$2; code3 (grph,(Inst)$1, (Inst)-1); }
	| PEN expr		{ $$=$2; code3 (grph,(Inst)$1, (Inst)-1); }
	| SIZE expr		{ $$=$2; code3 (grph,(Inst)$1, (Inst)-1); } 
	;
displist: disptype		{ $$=$1; }
	| displist disptype 	{ $$=$1; }
disptype: MATCHING begin nodenum
			  { $$=$2; code4(dispnod,(Inst)$1,(Inst)0,(Inst)$3); }
	| CONNECT begin nodenum TO nodenum
			  { $$=$2; code4(dispnod,(Inst)$1,(Inst)$5,(Inst)$3); }
	| RANGE begin nodenum TO nodenum
			  { $$=$2; code4(dispnod,(Inst)$1,(Inst)$5,(Inst)$3); }
	| ELEMENT elemnum { $$=$2; code4(dispnod,(Inst)$1,(Inst)0,(Inst)1); }
	| elemtype        { $$=(Inst *)code2(dispnod,(Inst)$1); }
	| COMPS           { $$=(Inst *)code2(dispnod,(Inst)$1); }
	| EXCEPT 	  { $$=code2(dispnod,(Inst)$1); } 
	| rotatype setexpr{ $$=$2; code2(dispnod,(Inst)$1); }
	| SIZE setexpr	  { $$=$2; code2(dispnod,(Inst)$1); } 
	| DSCALE setexpr  { $$=$2; code2(dispnod,(Inst)$1); } 
	| COLOR setexpr	  { $$=$2; code2(dispnod,(Inst)$1); } 
	| CALIBLIN setexpr { $$=$2; code3(dispnod,(Inst)$1,0); } 
	| CALIBLIN setexpr LOC parglist
			   { $$=$2; code3(dispnod,(Inst)$1,(Inst)$4);} 
	| HIDE 	 	  { $$=(Inst *)code2(dispnod,(Inst)$1); } 
	| CENTER begin parglist { $$=$2; code3(dispnod,(Inst)$1,(Inst)$3); } 
	| RMOVE  begin parglist { $$=$2; code3(dispnod,(Inst)$1,(Inst)$3); } 
	| ONLY		  { $$=(Inst *)code2(dispnod,(Inst)$1); }
	| NODE	 	 { $$=(Inst *)code2(dispnod,(Inst)$1); }
	| STIM AT expr 	 { $$=$3; code2(dispnod,(Inst)$1); }
	;
filename: expr 	     	{ $$ = $1; }
	;
cond:	'(' cexpr ')'	{code(STOP); $$ = $2; }
	;
while:	  WHILE { $$ = (Inst *)code3(whilecode,STOP,STOP); }
	;
forexpr:  cexpr 	{code(STOP); $$ = $1; }
	;
for:	  FOR { $$ = (Inst *)code(forcode); code4(STOP,STOP,STOP,STOP); }
	;
if:	  IF	{ $$ = (Inst *)code(ifcode); code3(STOP,STOP,STOP); }
	;
foreach:  FOREACH 		  { $$ = (Inst *)code(foreacode);
				    code3((Inst)0,STOP,STOP);
				    code4(STOP,STOP,STOP,STOP); }
	| FOREACH elemtype '?' var { $$ = (Inst *)code(foreacode);
				    code3((Inst)$2,STOP,STOP);
				    code4(STOP,STOP,STOP,STOP); }
	| FOREACH ELEMENT '?' var { $$ = (Inst *)code(foreacode);
				    code3((Inst)$2,STOP,STOP);
				    code4(STOP,STOP,STOP,STOP); }
	;
elemtype: CABLE 		{ }
	| SPHERE		{ }
	| SYNAPSE		{ }
	| CHAN 			{ }
	| ROD			{ }
	| CONE			{ }
	| GJ			{ }
	| LOAD 			{ }
	| RESISTOR 		{ }
	| CAP  			{ }
	| GNDCAP  		{ }
	| BATT 			{ }
	| GNDBATT 		{ }
	| BUF			{ }
	;	
begin:	  /* nothing */		{ $$ = progp; }
	;
end:	  /* nothing */		{ code(STOP); $$ = progp; }
	;
stmtlist: '{' stmtls '}'	{ $$ = $2; }
	;
stmtls:   /* nothing */		{ $$ = progp; }
	| stmtls stmt listerm 
	;
expr:	  NUMBER     { $$ = (Inst *)code2(constpush, (Inst)$1); }
	| CONST	     { $$ = (Inst *)code3(varpush,(Inst)$1,evalvar); }
	| LITCHAR    { $$ = (Inst *)code2(constpush,(Inst)$1); }
	| STRING     { $$ = (Inst *)code2(constpush,(Inst)$1); }
	| var  	     { $$ = $1; code(evalvar); }
	| var INCROP { $$ = $1; code(postinc); } 
	| var DECROP { $$ = $1; code(postdec); }
	| INCROP var { $$ = $2; code(preinc); }
	| DECROP var { $$ = $2; code(predec); }
	| asgn
	| FUNCTION begin parglist
		     { $$ = $2; code3(call,(Inst)$1,(Inst)$3); }
	| READ '(' var ')' { $$=$3; (Inst *)code(varread); }
	| BLTIN begin parglist { 
			 $$=$2; code3(bltin,(Inst)$3,(Inst)$1->u.ptr);}
	| GAUSNN begin '(' VAR ',' gnnlist ')'
			 { $$=$2; code3(xgausnn,(Inst)$1,(Inst)$4); }
	| plotype begin nodenum
				 { $$=$2; code3(xrecord, (Inst)$1, (Inst)$3); }
	| V begin '@' CABLE elemnum ':' expr 
				 { $$=$2;code3(xrecord,(Inst)$4,(Inst)2);}
	| EDIST begin '(' nodenum ',' elemnum ')'
				 { $$=$2; code2(edist, (Inst)$4); }
	| EFRAC begin '(' nodenum ',' elemnum ')'
				 { $$=$2; code2(efrac, (Inst)$4); }
	| NDIST begin '(' nodenum ',' nodenum ')'  /* args are backward here: */
				 { $$=$2; code3(ndist, (Inst)$6, (Inst)$4); }
	| ELEMENT elemnum PFIELD elemfield { $$=$2; code2(efield, (Inst)$4); }
	| NODE begin nodenum PFIELD nodefield 
				{ $$=$2; code3(nfield,(Inst)$5, (Inst)$3);}
	| '(' cexpr ')'	{ $$ = $2; }
	| expr '+' expr { code (add); }
	| expr '-' expr { code (sub); }
	| expr '*' expr { code (mul); }
	| expr '/' expr { code (xdiv); }
	| expr '^' expr { code (power); }
	| '-' expr %prec UNARYMINUS	{ $$=$2; code(negate); }
	| expr GT expr  { code (gt); }
	| expr GE expr  { code (ge); }
	| expr LT expr  { code (lt); }
	| expr LE expr  { code (le); }
	| expr EQ expr  { code (eq); }
	| expr NE expr  { code (ne); }
	| expr AND expr { code (xand); }
	| expr OR expr  { code (orx); }
	| expr BITAND expr { code (bitand); }
	| expr BITOR expr { code (bitor); }
	| NOT expr 	{ $$ = $2; code (xnot); }
	;
commaexpr: expr     ',' expr	{ code(popone); } 
	| commaexpr ',' expr	{ code(popone); } 
	;
cexpr:	  expr			{ }
	| commaexpr		{ }
	;
setexpr:  expr		{ $$ = $1; }
	| "=" expr	{ $$ = $2; }
	;
var:	  VAR			{ $$ = (Inst *)code2 (varpush, (Inst)$1); }
	| ARRAY begin dimlist	{ $$ = $2; code3 (varpush,(Inst)$1,(Inst)$3);}
/*	| ARRAY 	{ $$ = (Inst *)code3 (varpush,(Inst)$1,(Inst)0);} */
	| ARG			{$$=(Inst *)code2(varpush,(Inst)$1->u.argnum);}
	| LOCALVAR		{$$=(Inst *)code2(varpush,(Inst)$1->u.argnum);}
	;
prlist:	  expr			{ code(prexpr); }
	| prlist ',' expr	{ code(prexpr); }
	;
prflist:  expr 			{ $$ =  0; }
        | expr ',' prfargs 	{ $$ = $3; }
	;
prfargs:  expr			{ $$ = 1; }
	| prfargs ',' expr	{ $$ = $1 + 1; }	/* how many args? */
	;
scnflist:  expr 		{ $$ =  0; }
        | expr ',' scnfargs 	{ $$ = $3; }
	;
scnfargs:  var			{ $$ = 1; }
	| scnfargs ',' var	{ $$ = $1 + 1; }	/* how many args? */
	;
defn:	  FUNC procname { $2->type=FUNCTION; indef=1; formal=1; }
	 '(' formarg ')' { formal=0; }
          stmt {code(procret); define($2,(int)$5); erasarg();indef=0; }
	| PROC procname { $2->type=PROCEDURE; indef=1; formal=1; }
	 '(' formarg ')' { formal=0; }
	 stmt {code(procret); define($2,$5); erasarg();indef=0; }
	;
dimlist:  '[' expr ']'		{ $$ = 1; }
	| dimlist '[' expr ']' 	{ $$ = $1 + 1; }
	;
nodenum: expr			{ $$ = 1; }
	| dimlist		{ $$ = $1; }
	;
elemnum: expr			{ $$ = $1; }
	;
snode: 	  '?' var		{ $$ = 1; }
	| '[' expr ']'		{ $$ = 0; }
	;
elemfield: TYPE			{ }
	|  LENGTH		{ }
	|  NDIST		{ }
	|  DIA			{ }
	|  RM			{ }
	|  RI			{ }
	|  CPLAM		{ }
	|  NODE1A		{ }
	|  NODE1B		{ }
	|  NODE1C		{ }
	|  NODE2A		{ }
	|  NODE2B		{ }
	|  NODE2C		{ }
	;
nodefield: NUMCONN		{ }
	| XLOC			{ }
	| YLOC			{ }
	| ZLOC			{ }
	| expr			{ $$ = (Inst *)0; }	/* relative elem # */
	;
procname: VAR
	| FUNCTION
	| PROCEDURE
	;
rotatype: XROT			{ }
	| YROT			{ }
	| ZROT			{ }
	;
arrname:  VAR
	;
arglist:   /* nothing */	{ $$ = 0; }
	| expr 			{ $$ = 1; }
	| arglist ',' expr	{ $$ = $1 + 1; }
	;
parglist: '(' arglist ')'	{ $$ = $2; }
	;
formarg:  /* nothing */		{ $$ = 0; argcount=0; }
	| ARG			{ $$ = $1->u.argnum = 1; argcount=1; } 
	| formarg ',' ARG	{ $$ = $3->u.argnum = $1 + 1; argcount++; }
	;
localvar:  /* nothing */	{ $$ = 0; }
	| LOCALVAR  		{ $$ = 1; $1->u.argnum = ++argcount; } 
	| localvar ',' LOCALVAR { $$ = $1 + 1; $3->u.argnum = ++argcount; }
	;
vararg:  var			{ $$ = 1; }
	| vararg ',' var	{ $$ = $1 + 1; }
	;
%%
	/* end of grammar */
