/* nc.h */

typedef struct datum {			/* interpreter stack type */
	short type;			/* UNDEF,CONST,VAR,ARRAY, etc. */
	short vtype;			/* NUMBER, LITCHAR, STRING, etc. */
	union {
		double val; 
		char  *str; 
		struct Symbol *sym;
	}u;
} datum;

typedef void (*Inst)();
typedef datum (*Fpa)(...);
#define STOP	((Inst) 0) 

typedef struct Symbol { 		/* symbol table entry */
	char *name;
	short type;			/* UNDEF,CONST,VAR,ARRAY, etc. */
	short vtype;			/* NUMBER, LITCHAR, STRING, etc. */
	union {
		double	val;		/* VAR */
		int     *arrp;		/* pointer to array */
		Fpa 	ptr;		/* BLTIN */
		Inst 	*defn;		/* FUNCTION, PROCEDURE */
		int	argnum;		/* ARG number for formal def */
		char	*str;		/* STRING */
	}u;
	struct Symbol	*next;		/* pointer to next Symbol */
} Symbol;
 
Symbol *install(char *, int, double), *lookup(char *), *lookupnt(char *, int);


#define LARGENUM 1e38
#define VVSIZE 10			/* number of command line var sets */
#define PCOND 1                         /* print compartments (conductances) */
#define PCOMP 2                         /* print compartments (as spheres) */

#define DISP  1                         /* allow "display" statement to run */
#define DCOMP 2                         /* display compartments */
#define DCONN 4                         /* display connections */
#define DSTIM 8                         /* display stimulus */

#define LINEWIDTH .001			/* line width for ncdisp.c */

int yylex(void);            /* interp */
void yyerror(char *s);      /* report compile-time error */

/* int system(const char *str); */

void expop();
datum pop(void);
void evalvar(void), add(void), sub(void), mul(void), xdiv(void);
void negate(void), power(void);
void preinc(void), predec(void), postinc(void), postdec(void);
void popone(void);
void addeq(void), subeq(void), muleq(void), diveq(void);
void dprintf(void), pprintf(void), pscanf(void), crlf(void);
void darray(void), erarr(void); 
void xcable(void), xgj(void), xsynapse(void), xrecept(void); 
void xrecparm(void);
void rload(void), xresistor(void), xsphere(void), xvbuf(void);
void xvbufd(void);
void conn1(void), conn1l(void), conn2s(void), conn2sl(void);
void conn2d(void), conn2dl(void);
void xnode(), relative(), modrun(void), xstim(void), membtyp(void);
void vplot(void), vplotm(void);
void rbatt(void), xgbatt(void), xgcap(void), rcap(void), xrecord(void);
void grph(void), gplot(void); 
void txtf(void), xfread(void), xfwrite(void), xchan(void), xcachan(void);
void noise(void), xmod(void);
void edist(void), efrac(void), ndist(void), xgausnn(void), incrpl(void);
void dispnod(void), dispndn(), disprot(), efield(void), nfield(void);
void conn1m(void), dofft(void);
void defnonly(char *s);
void define(Symbol *sp, int narg);
void erasarg();

extern Inst *progp, *progbase, prog[], *code(Inst f);
void assign(void), bltin(void), varpush(void), constpush(void);
void print(void), local(void);
void prexpr(void), prstr(), bitand(void), bitor(void), varread(void);
void gt(void), lt(void), eq(void), ge(void), le(void), ne(void);
void xand(void), orx(void), xnot(void);
void ifcode(void), whilecode(void), call(void), arg(), argassign();
void funcret(void), procret(void), forcode(void),breakcode(void),contcode(void);
void extern xexit(), edit(), eramod(void), pushfil(void), foreacode(void);
