#include <math.h>
#include <bool.h>
#include <GetOpt.h>
#include <double.Matrix.h>
#define  matrix doubleMatrix
#define  array  doubleArray

int
main (int argc, char **argv)
  {
    int		verbose  = FALSE;		// verbose reporting off
    int		xgraph   = FALSE;		//  graph style output
    GetOpt	getopt (argc, argv, "vx");

  int option;
  while ((option = getopt()) != EOF)
    switch (option)
      {
        case 'v':				// verbose reporting on
	  verbose	= TRUE;
          break;
        case 'x':				// xgraph style output
	  xgraph	= TRUE;
          break;
        case '?':
          cerr << "Unrecognized option!\n";
      };

    int		layers; cin >> layers;		// number of layers
#ifdef	__GNUC__
    matrix	b[layers];			// threshold  biases
    matrix	W[layers];			// connection weights
    matrix	x[layers+1];			// inputs/outputs
#else
    matrix *const b	 = new matrix[layers];	// threshold  biases
    matrix *const W	 = new matrix[layers];	// connection weights
    matrix *const x	 = new matrix[layers+1];// inputs/outputs
#endif
    int		outputs; cin >> outputs;	// number of outputs
    int		inputs = outputs;		// number of  inputs
    if (verbose)
      cerr << "N(" << inputs;
    for (int layer = 0; layer < layers; layer++)
      {
	int inputs = outputs;
	cin >> outputs;
	if (verbose)
	  cerr << ", " << outputs;
	x[layer].resize(inputs);
	W[layer].resize(outputs, inputs);
        b[layer].resize(outputs);
	for (int output = 0; output < outputs; output++)
          cin >> b[layer][0][output] >> W[layer].s(output);
      };
    x[layers].resize(outputs);

    int		examples; cin >> examples;	// number of examples
    if (verbose)
      cerr << ")\t" << examples << " examples\n";
    matrix	X(examples,  inputs);		//  inputs
    matrix	Y(examples, outputs);		// outputs
    for (int example = 0; example < examples; example++)
      cin >> X.s(example) >> Y.s(example);

    for (int output = 0; output < outputs; output++)
      {
	if (xgraph)
	  cout << "\"" << output << "\"\n";
	for (int example = 0; example < examples; example++)
	  {
	    x[0]	 = X.s(example);

	  //for (int layer = 0; layer < layers; layer++)
	  //  x[layer+1] = tanh(b[layer] + x[layer]%W[layer]);
	    for (int layer = 0; layer < layers-1; layer++)
	      x[layer+1] = tanh(b[layer] + x[layer]%W[layer]);
	    x[layers] = b[layers-1] + x[layers-1]%W[layers-1];

	    cout << form("%10.3e\t", Y[example][output])
		 << form("%10.3e\n", x[layers][0][output]);
	  };
	cout << "\n";
      };
    cout.flush();
  }
