#include <signal.h>
#include <math.h>
#include <bool.h>
#include <MLCG.h>
#include <Normal.h>
#include <GetOpt.h>
#include <double.Matrix.h>
#define  matrix doubleMatrix
#define  array  doubleArray

int
main (int argc, char **argv) {
  int		verbose  = FALSE;		// verbose reporting off
  long		seedval	 = 43;			// random number seed value
  double	sigma	 = 0.0;			// noise variance
  GetOpt	getopt (argc, argv, "n:s:v");

  int option;
  while ((option = getopt()) != EOF)
    switch (option) {
      case 'n':				// noise level
	sigma	= atof(getopt.optarg);
        break;
      case 's':				// seed value
	seedval	= atoi(getopt.optarg);
        break;
      case 'v':				// verbose reporting on
	verbose	= TRUE;
        break;
      case '?':
        cerr << "Unrecognized option!\n";
      };

  if (verbose)
    cerr	<< " seedval = "	<< seedval
		<< " sigma = "		<< sigma << "\n";

  int		layers; cin >> layers;		// number of layers
#ifdef	__GNUC__
  matrix	b[layers];			// threshold  biases
  matrix	W[layers];			// connection weights
#else
  matrix *const b	 = new matrix[layers];	// threshold  biases
  matrix *const W	 = new matrix[layers];	// connection weights
#endif
  int		outputs; cin >> outputs;	// number of outputs
  int		inputs = outputs;		// number of  inputs
  if (verbose)
    cerr << "N(" << inputs;
  int layer;
  for (layer = 0; layer < layers; layer++) {
    int inputs = outputs;
    cin >> outputs;
    if (verbose)
      cerr << ", " << outputs;

    MLCG	gen(13, 1023);
    Normal	rnd (0.0, 1.0, &gen);
    b[layer].resize(outputs);
    W[layer].resize(outputs, inputs);
    for (int output = 0; output < outputs; output++) {
      b[layer][0][output] = rnd()*sigma/(inputs+1);
      for (int input = 0; input < inputs; input++)
	W[layer][output][input] = rnd()*sigma/(inputs+1);
      }
    };
  if (verbose)
    cerr << ")\n";

  format("%12.5e", 6, " ");

  cout << layers << "\n";
  cout << inputs << "\n";
  for (layer = 0; layer < layers; layer++) {
    int outputs = b[layer].n();
    cout << outputs << "\n";
    for (int output = 0; output < outputs; output++)
      cout << form("%12.5e\n", b[layer][0][output])
	   << W[layer].s(output);
    };
  cout.flush();
  return 0;
  }
