#include <stdio.h>
#include <strings.h>
#include "sim-basics.h"

typedef int 	(* func_ptr)();    	/* pointer to integer function */

typedef struct COMMAND {
  char 	   *name;
  char	   *help;
  func_ptr fn;
} Command;

#define GREET	"Basic Net Simulator BSN.1, 17 Apr 89"
static char 	*StartMsg="Your message here";
static char 	*Prompt="HoP> ";

#define CMD_CHAR 	'#'
#define SEPS 		" \t"

func_ptr ba_get_cmd();

#define MAX_COMS 100
static Ncoms=0;
static Command Coms[MAX_COMS];

/*===========================================================================*/
#define Hba_quit "end the simulation"
/*===========================================================================*/
ba_quit()
{ return QUIT; }

/*===========================================================================*/
#define Hba_source "FILE\n\
  read commands from FILE. They can be nested."
/*===========================================================================*/
#define SO_FILE argv[1]
ba_source( argc, argv )
     int argc; char *argv[];
{
  FILE *SoFile;
 
  if( argc != 2 )
    nerror1( return OK, "%s: wrong number of arguments\n", argv[0] );
  if( NULL == ( SoFile = fopen( SO_FILE, "r" ) ))
    nerror2( return OK, "%s: Can't open file '%s'\n", argv[0], SO_FILE );
  return( ba_interpreter_loop( SoFile ) );
}
   
/*===========================================================================*/
#define Hba_help "print commands and their descriptions"
/*===========================================================================*/
ba_help()
{
  int com;

  for( com=0; com < Ncoms; ++com )
    printf( "%s %s\n", Coms[com].name, Coms[com].help );
}

func_ptr ba_get_cmd( Name )
     char *Name;
{
  int com;

  for( com=0; com < Ncoms; ++com )
    if( strEQ( Name, Coms[com].name ) ) break;
  if( com==Ncoms ) return NULL;
  return( Coms[com].fn );
}

ba_start_msg( msg )
     char *msg;
{ StartMsg = msg; }

ba_prompt( msg )
     char *msg;
{ Prompt = msg; }

ba_install_cmd( Name, func, Help )
     char *Name, *Help;
     func_ptr	func;
{
  if( Ncoms >= MAX_COMS )
    nerror1( exit(1),"install_cmd: too many commands, '%s'\n", Name );
  if( NULL != ba_get_cmd( Name ) )
    nerror1( exit(1),"install_cmd: duplicate command name, '%s'\n", Name );
  
  Coms[Ncoms].name = Name;
  Coms[Ncoms].help = Help;
  Coms[Ncoms].fn   = func;
  Ncoms++;
}

static int status = INIT;

ba_interpreter_loop( file )
     FILE *file;
{
  int iargc, fread_buf;
  char cmd_line[BUF_LGT], *iargv[ARG_MAX];

  if( status == INIT ) {
    status = OK;
    ba_install_cmd( "help", 	ba_help, 	Hba_help );
    ba_install_cmd( "h", 	ba_help, 	Hba_help );
    ba_install_cmd( "quit", 	ba_quit,	Hba_quit );
    ba_install_cmd( "q", 	ba_quit,	Hba_quit );
    ba_install_cmd( "source", 	ba_source,	Hba_source );
    ba_install_cmd( "so", 	ba_source,	"abrev for 'source'" );

    if( file == stdin ) printf( "%s\n%s\n", GREET, StartMsg );
  }

  fread_buf = TRUE; 
  while( status != QUIT ) {
    if( file == stdin && fread_buf ) {
      fprintf( stdout, "%s", Prompt );
      fflush( stdout );
    }
    if( EOF == (fread_buf = ba_fread_cmd( file, BUF_LGT, cmd_line ) )) break;
    (void) ba_parse_cmd( cmd_line, ARG_MAX, &iargc, iargv );
    status = ba_execute_command( iargc, iargv );
  }
  return status;
}

#define EAT_REST {while( (c=getc(file)) != EOF && c != '\n' );}
#define EO_CMD ';'
int ba_fread_cmd( file, Lim, line )
     FILE *file;
     int   Lim; 
     char *line;
{
  int c, i;

  i = 0;
  /* search  for end-of cmd; EOF, end-of-line or ';'  */
  while( i < Lim-1 && (c=getc(file)) != EOF && c != '\n' && c != EO_CMD )
    if( c == CMD_CHAR ) {
      EAT_REST;
      break;
    }
    else line[i++] = c;
  if( i >= Lim-1 ) { /* didn't find eol before limit */
    fprintf( stderr, "Line too long (max= %d), ignored\n->%s.\n", Lim-1,line );
    EAT_REST;
    i = 0;
  }
  /* add null char pointer at end */
  line[i] = NULL_CHAR;
  return( c == EOF ? EOF : c == EO_CMD ? FALSE : TRUE );
}

#define ARGSEPS " \t"

ba_parse_cmd( cmd, arg_max, iargcp, iargv )
     int  *iargcp, arg_max;
     char *cmd, *iargv[];
{
  char *tokp;
  int count;

  tokp = strtok( cmd, ARGSEPS );
  for( count=0; tokp != NULL && count < arg_max; ++count ) {
    iargv[ count ] =tokp;
    tokp = strtok( CNULL, SEPS );
  }
  if( count >= arg_max ) {
    fprintf( stderr, "too many arguments (max= %d), ignored\n", arg_max );
    *iargcp = 0;
  }
  else {
    *iargcp = count;
    for( ; count < arg_max; ++count ) iargv[count]="";
  }
}

ba_execute_command( argc, argv )
     int argc; char *argv[];
{
  char bbuf[BUF_LGT], *ParN;
  int pt;
  func_ptr fn_ptr;

  if( argc <= 0 ) return OK;     /* empty command line */
  fn_ptr = ba_get_cmd( argv[0] );
  if( NULL == fn_ptr )
    nerror1( return OK, "Can't find command '%s'\n", argv[0] );
  return( (*fn_ptr) (argc, argv ) );
}
