#include "stdio.h"
#include "strings.h"

char * initstate();
long random();

/* =========================================================================
   Should have same semantics as drand48() and srand48(seed) in Suns. i.e.
   drand48() returns non-negative double-precision floating-point values 
   uniformly distributed over the interval [0.0, 1.0).
   srand48(seed) sets the seed for drand48(). srand() should be called 
   before using drand48().
   ========================================================================= */
static long state1[32]  =  {       
            3, 0x9a319039, 0x32d9c024,  0x9b663182,  0x5da1f342, 
   0x7449e56b, 0xbeb1dbb0, 0xab5c5918,  0x946554fd,  0x8c2e680f,
   0xeb3d799f, 0xb11ee0b7, 0x2d436b86,  0xda672e2a,  0x1588ca88,  
   0xe369735d, 0x904f35f7, 0xd7158fd6,  0x6fa6f051,  0x616e6b96,  
   0xac94efdc, 0xde3b81e0, 0xdf0a6fb5,  0xf103bc02,  0x48f340fb,       
   0x36413f93, 0xc622c298, 0xf5a42ab8,  0x8a88d77b,  0xf5ad9d0e,
   0x8999220b, 0x27fb47b9      };
 
#define STATE_SIZE 128
void srand48(seedval)
     long seedval;
{
  initstate( (int) seedval, state1, STATE_SIZE );
}

/* 2^31 - 1 = 2147483647 */
#define MAX_RAND 2147483648.0
double drand48()
{
  return( (double) random() / MAX_RAND );
}

/* =========================================================================
   Should have same semantics as nint in Suns. i.e.
   nint() converts x into int format rounding  to  the  nearest
   int value, except halfway cases are rounded to the int value
   larger in magnitude.  This corresponds to the  Fortran  gen-
   eric intrinsic function nint.
   ========================================================================= */
int nint( x )
     double x;
{
  return( ( x > 0) ? (int) (x + 0.5) : (int) (x - 0.5) );
}

/* =========================================================================
   should have same semantics as strtok in Suns. 
   writen by Steve Crane.
   ========================================================================= */
char * strtok( str, delimiters)
     char *str, *delimiters;
{
  char *dlim, *cptr, *tptr;
  static char *strptr = NULL;
  
  if (str != NULL) strptr = str;
/*printf("strtokn->%s<-\n",strptr);*/
  /* skip to next token */
  for (cptr = strptr ; *cptr ; cptr++) {
    for (dlim = delimiters ; *dlim ; dlim++) {
      if (*dlim == *cptr) break;
    }
    if (*dlim) continue;
    tptr = cptr;
    break;
  }
  if (!(*cptr)) return(NULL);
  /* find end of token */
  for ( ; *cptr ; cptr++) {
    for (dlim = delimiters ; *dlim ; dlim++) {
      if (*dlim == *cptr) break;
    }
    if (*dlim) {
      *cptr = 0;
      strptr = cptr+1;
      return(tptr);
    }
  }
  strptr = NULL;
  return(tptr);
}
