#ifndef JA_misc

#define JA_misc 0

extern char *strtok();

#define NULL_CHAR '\0'
#define CNULL 	( (char *) NULL)
#define TRUE 	1
#define FALSE 	0

#define strEQ(A,B) 	(! strcmp(A,B))
#define strNE(A,B) 	(strcmp(A,B))

#define nerror( ACT,MSG ) {fprintf(stderr,MSG); ACT;}
#define nerror1( ACT,MSG,V ) {fprintf(stderr,MSG,V); ACT;}
#define nerror2( ACT,MSG,V1,V2 ) {fprintf(stderr,MSG,V1,V2); ACT;}
#define nerror3( ACT,MSG,V1,V2,V3 ) {fprintf(stderr,MSG,V1,V2,V3); ACT;}

#define SCAN_INT_ARGV(A,N,V) \
  {if(argc<=N || 1!=sscanf(argv[N]," %d",& V ) ) \
     nerror2( A,"%s: arg '%d'; expected int\n",argv[0],N);}

#define SCAN_POS_INT_ARGV(A,N,V) \
  SCAN_COND_INT_ARGV(A,N,V, V>0," >0")

#define SCAN_POSP_INT_ARGV(A,N,V) \
  SCAN_COND_INT_ARGV(A,N,V, V>=0," >=0")

#define SCAN_INT_IN_ARGV(A,N,V,Low,Up) \
  SCAN_COND_INT_ARGV(A,N,V,(V>=Low && V<=Up), "in bounded interval" )

#define SCAN_COND_INT_ARGV(A,N,V,C,CN) \
  {if(argc<=N || 1!=sscanf(argv[N]," %d",& V) || !(C) ) \
     nerror3( A,"%s: arg '%d'; expected int %s\n",argv[0],N,CN);}

#define FSCAN_INT_IN(FN,F,A,V,Low,Up) \
  FSCAN_COND_INT(FN,F,A,V,(V>=Low && V<=Up), "in bounded interval" )

#define FSCAN_COND_INT(FN,F,A,V,C,CN) \
  {if(1!=fscanf(F," %d",& V) || !(C) ) \
     nerror3( A,"%s: in file %s; expected int %s\n",argv[0],FN,CN);}

#define SHOW_HELP_TEST(A,REQ,MSG) \
  {if(argc<(REQ+1)) nerror2(A,"%s %s\n",argv[0],MSG);}

#endif
