#include <stdio.h>
#include "ja_misc.h"
#include "ja_random.h"

#define MAX_SIZE 1000

#define MAIN_USE "\
N LOAD [SEED]\n\
  Create a random binary vector of length N. LOAD indicates the probability\n\
  of 1's (e.g. 30 will generate approx 30% of 1 versus 70% of 0's).\n\
  SEED is optional."
#define SIZE 1
#define LOAD 2
#define SEED 3

main( argc, argv )
     int argc; char *argv[];
{ 
  int Size, Seed, Load, i;
  double Cut;

  SHOW_HELP_TEST( exit(1), 2, MAIN_USE );
  SCAN_INT_IN_ARGV( exit(1), SIZE, Size, 0, MAX_SIZE -1 );
  SCAN_INT_IN_ARGV( exit(1), LOAD, Load, 0, 100 );
  if(argc > SEED ) {SCAN_INT_ARGV( exit(1), SEED, Seed );}
  else 		   Seed = sys_clock();
  set_seed( Seed );

  Cut = (double) Load / 100.0;
  for( i=0; i < Size; ++i ) 
    printf( "%d ", (double_uniform_dev0()<= Cut )? 1 : 0 );
  printf( "\n" );
}
