/* -------------------------------------------------------------------------
   print the n-th Fibonacci number (iterative and recursive)

   F_0 = 0, 
   F_1 = 1, 
   F_n = F_{n-1} + F_{n-2}  (n>=2)
   ------------------------------------------------------------------------- */
#include <stdio.h>

/* -- Macros defined in ja_misc.h file (selection) ------------------------- */

#define nerror1( ACT,MSG,V ) {fprintf(stderr,MSG,V); ACT;}
#define nerror3( ACT,MSG,V1,V2,V3 ) {fprintf(stderr,MSG,V1,V2,V3); ACT;} 

#define SCAN_COND_INT_ARGV(A,N,V,C,CN) \
{if(argc<=N || 1!=sscanf(argv[N]," %d",& V) || !(C) ) \
        nerror3( A,"%s: arg '%d'; expected int %s\n",argv[0],N,CN);}

/* ------------------------------------------------------------------------- */
#define F_0 0			/* values for 0-th and 1-th Fibo numbers */
#define F_1 1

/* -- recursive Fibonacci -------------------------------------------------- */
int fibo_rec( n )
     int n;
{
  if( n == 0 ) return F_0;
  else if( n == 1 ) return F_1;
  else return( fibo_rec(n-1) + fibo_rec(n-2) );
}

/* -- Iterative Fibonacci -------------------------------------------------- */
int fibo_iter( n )
     int n;
{
  int k, Fk, Fk_1, temp;

  if( n == 0 ) return F_0;
  else {
    for( k=1, Fk=F_1, Fk_1=F_0; k < n; ++k ) {
      temp = Fk;
      Fk = Fk + Fk_1;
      Fk_1 = temp;
    }
    return Fk;
  }
}

/* -- Main body ------------------------------------------------------------ */
#define DESCR   "Usage: %s N, to print the N-th FIbonacci number\n"
#define N 	1

main( argc, argv )
               int   argc;
               char *argv[];
{
  int n, scan_return;
  
  if( argc != 2 ) nerror1( exit(1), DESCR, argv[0] );
  SCAN_COND_INT_ARGV( exit(1), N, n, n >= 0, ">=0" );
  
  printf("Fibo(%d) = iterative %d ", n, fibo_iter(n) );
  fflush( stdout );
  printf( "recursive %d\n", fibo_rec(n));
}
