/* -------------------------------------------------------------------------
   print the n-th Fibonacci number (iterative and recursive)

   F_0 = 0, 
   F_1 = 1, 
   F_n = F_{n-1} + F_{n-2}  (n>=2)
   ------------------------------------------------------------------------- */
#include <stdio.h>

/* ------------------------------------------------------------------------- */
#define F_0 0			/* values for 0-th and 1-th Fibo numbers */
#define F_1 1

/* -- recursive Fibonacci -------------------------------------------------- */
int fibo_rec( n )
     int n;
{
  if( n == 0 ) return F_0;
  else if( n == 1 ) return F_1;
  else return( fibo_rec(n-1) + fibo_rec(n-2) );
}

/* -- Iterative Fibonacci -------------------------------------------------- */
int fibo_iter( n )
     int n;
{
  int k, Fk, Fk_1, temp;

  if( n == 0 ) return F_0;
  else {
    for( k=1, Fk=F_1, Fk_1=F_0; k < n; ++k ) {
      temp = Fk;
      Fk = Fk + Fk_1;
      Fk_1 = temp;
    }
    return Fk;
  }
}

/* -- Main body ------------------------------------------------------------ */
main( argc, argv )
          int   argc;
          char *argv[];
{
  int n, scan_return;
  
  if( argc != 2 ) {	      	/* should have exactly one argument */
    fprintf( stderr, "Usage: %s N, to print the N-th Fibonacci number\n", 
	     argv[0] );
    exit( 1 );			/* exit code 1, error found */
  }
  scan_return = sscanf( argv[1], " %d ", &n );  /* note use of pointer &n */
  if( scan_return != 1  || n < 0 ) {
    fprintf(stderr, "%s : expected integer >=0 on first argument\n", argv[0] );
    exit( 1 );			/* exit code 1, error found */
  }
  printf("Fibo(%d) = iterative %d ", n, fibo_iter(n) );
  fflush( stdout );
  printf( "recursive %d\n", fibo_rec(n));
}

