/*
 *    Symboltable management:       symtab.c
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "util.h"
#include "Error.h"

#define ALLOC(typ)      (typ *)calloc(1,sizeof(typ))

extern FILE *yyout;

extern STRING   credim[MAXFDIM];
extern S_OBJECT *s_actual,
                *current_proc;

short     l_aptr        = 0;
S_OBJECT  *s_root       = 0;
S_CHAIN   *s_chain_root = 0;
ST_OBJECT *st_root      = 0;
L_OBJECT  *l_root       = 0,
          *l_act_def    = 0,
          *l_actual[MAXNEST];

ST_OBJECT ch    = {S_CHAR};
ST_OBJECT def[] = {
                     {S_BOOL       },  /*  0 */
                     {S_CHAR       },  /*  1 */
                     {S_CONST      },  /*  2 */
                     {S_ENUM       },  /*  3 */
                     {S_EXPR       },  /*  4 */
                     {S_INT        },  /*  5 */
                     {S_LCONST     },  /*  6 */
                     {S_NET        },  /*  7 */
                     {S_PROC       },  /*  8 */
                     {S_REAL       },  /*  9 */
                     {S_STRING, &ch},  /* 10 */
                     {S_UDEC       },  /* 11 */
                     {S_UNIT       },  /* 12 */
                     {S_UPROC      },  /* 13 */
                     {S_USEL       },  /* 14 */
                     {S_UVEC       },  /* 15 */
                     {S_VECT       },  /* 16 */
                     {S_VPROC      },  /* 17 */
                     {S_PTR        }   /* 18 */
                  };

ST_OBJECT *st_ptr(int typus)
{
        switch (typus)
        {
          case S_BOOL:    return &(def[0]);
          case S_CHAR:    return &(def[1]);
          case S_CONST:   return &(def[2]);
          case S_ENUM:    return &(def[3]);
          case S_EXPR:    return &(def[4]);
          case S_INT:     return &(def[5]);
          case S_LCONST:  return &(def[6]);
          case S_NET:     return &(def[7]);
          case S_PROC:    return &(def[8]);
          case S_REAL:    return &(def[9]);
          case S_STRING:  return &(def[10]);
          case S_UDEC:    return &(def[11]);
          case S_UNIT:    return &(def[12]);
          case S_UPROC:   return &(def[13]);
          case S_USEL:    return &(def[14]);
          case S_UVEC:    return &(def[15]);
          case S_VECT:    return &(def[16]);
          case S_VPROC:   return &(def[17]);
          case S_PTR:     return &(def[18]);
        }

        return &(def[18]);
}

ST_OBJECT *s_getp_type(ST_OBJECT* typus)
{
    if(typus && typus->st_type == S_PTR)
      return typus->st_next;

    return st_ptr (S_UDEC);
}

void init_symtab ()
/*
 *
 *  read_vec, create_vec, resize_vec und scanf werden in die Symbol-
 *  tabelle eingetragen.
 *
 */
{
        int i;
        S_OBJECT *con;
        S_REFLIST *x,
                  *y=0;

        con = ALLOC(S_OBJECT);

        if (!con)
            FatalError (ERR_MEMORY);

        con->s_name = strsave ("read_vec");
        con->s_type = st_ptr (S_PROC    );

        con->s_descriptor.funct.anzpar        = 1;
        con->s_descriptor.funct.refi          = ALLOC(S_REFLIST);
        con->s_descriptor.funct.refi->ref     = 1;
        con->s_descriptor.funct.refi->sr_next = 0;

        con->s_next = s_root; /* link into the list as */
        s_root      = con;    /* the first item.       */

        con = ALLOC(S_OBJECT);

        if(!con)
            FatalError (ERR_MEMORY);

        con->s_name = strsave ("create_vec");
        con->s_type = st_ptr (S_PROC      );

        con->s_descriptor.funct.anzpar                 = 2;
        con->s_descriptor.funct.refi                   = ALLOC(S_REFLIST);
        con->s_descriptor.funct.refi->ref              = 1;
        con->s_descriptor.funct.refi->sr_next          = ALLOC(S_REFLIST);
        con->s_descriptor.funct.refi->sr_next->ref     = 0;
        con->s_descriptor.funct.refi->sr_next->sr_next = 0;

        con->s_next = s_root; /* link into the list as */
        s_root      = con;    /* the first item.       */

        con = ALLOC(S_OBJECT);

        if(!con)
            FatalError (ERR_MEMORY);

        con->s_name                                    = strsave("resize_vec");
        con->s_type                                    = st_ptr(S_PROC);
        con->s_descriptor.funct.anzpar                 = 2;
        con->s_descriptor.funct.refi                   = ALLOC(S_REFLIST);
        con->s_descriptor.funct.refi->ref              = 1;
        con->s_descriptor.funct.refi->sr_next          = ALLOC(S_REFLIST);
        con->s_descriptor.funct.refi->sr_next->ref     = 0;
        con->s_descriptor.funct.refi->sr_next->sr_next = 0;

        con->s_next = s_root; /* link into the list as */
        s_root      = con;    /* the first item.       */

        con = ALLOC(S_OBJECT);

        if(!con)
            FatalError (ERR_MEMORY);

        con->s_name                       = strsave("scanf");
        con->s_type                       = st_ptr(S_PROC);
        con->s_descriptor.funct.anzpar    = -1;
        con->s_descriptor.funct.refi      = ALLOC(S_REFLIST);
        con->s_descriptor.funct.refi->ref = 0;

        con->s_next = s_root; /* link into the list as */
        s_root      = con;    /* the first item.       */

        for(i=0;i<10;i++)
		{
			x=ALLOC(S_REFLIST);
			x->ref=1;
			x->sr_next=y;
			y=x;
		}
        con->s_descriptor.funct.refi->sr_next=y;
}

void st_insert(STRING newid, ST_OBJECT* ttype)
{
        ST_OBJECT *newobj=ALLOC(ST_OBJECT);

        if(!newobj)
           FatalError (ERR_MEMORY);

        newobj->st_type      = S_TYPE;
        newobj->symt.st_desc = ttype;
        newobj->st_typid     = strsave(newid);
        newobj->st_next      = st_root;
        st_root              = newobj;
}

ST_OBJECT *st_lookup(STRING id, ST_OBJECT *ntype)
{
        ST_OBJECT *aux;

        for (aux=st_root; aux; aux=aux->st_next)
           if(!strcmp(id,aux->st_typid))
               return aux->symt.st_desc;

        if(ntype)
            st_insert(id, ntype);

        return 0;
}

void s_insert(STRING newid, int idtype)
{
        S_OBJECT *newobj=ALLOC(S_OBJECT);

        if(!newobj)
            FatalError (ERR_MEMORY);

        newobj->s_name = strsave (newid );
        newobj->s_type = st_ptr (idtype);
        newobj->s_next = s_root;
        s_root         = newobj;

        switch(idtype)
        {
          case S_PROC:  s_actual = newobj; break;
          case S_VPROC: s_actual = newobj; break;
          case S_UPROC:
            s_actual                          = 0;
            newobj->s_descriptor.funct.refi   = 0;
            newobj->s_descriptor.funct.anzpar = 0;
            break;
        }
}

BOOL s_CheckObject (STRING id, int idtype, S_OBJECT* aux)
{
    if (strcmp(id, aux->s_name))
        return FALSE;

    if(
        aux->s_type->st_type == S_NET ||
        (
          idtype==S_UPROC &&
          (
            aux->s_type->st_type==S_PROC ||
            aux->s_type->st_type==S_VPROC
          )
        )
    )
        s_actual=aux;

    return TRUE;
}

ST_OBJECT *s_lookup (STRING id, int idtype)
{
    /*
     * liefert den typ des ID (wenn bekannt)
     * und bei S_NET oder einer S_PROC oder S_VPROC
     * wird s_actual auf das S_OBJECT gesetzt
     *
     */

    S_OBJECT *aux;

    /* Local ? */

    if (current_proc)
        for (aux=current_proc; aux; aux=aux->s_next)
            if (s_CheckObject (id, idtype, aux))
                return aux->s_type;

    /* Global ? */

    for (aux=s_root; aux; aux=aux->s_next)
        if (s_CheckObject (id, idtype, aux))
            return aux->s_type;

    if(idtype != S_ENQ)
        s_insert (id, idtype);

    return st_ptr(S_UDEC);
}

void s_insert_chain(S_OBJECT *new)
{
     S_CHAIN *newobj=ALLOC(S_CHAIN);

     if (!newobj)
         FatalError (ERR_MEMORY);

     newobj->sc_next = s_chain_root;
     newobj->s_next  = new;
     s_chain_root    = newobj;
}

void s_updatetyp(short anz, ST_OBJECT *typus, short ref)
{
     S_OBJECT *aux  = s_root;
     BOOL      insc = ref && typus->st_type != S_ARR     &&
                             typus->st_type != S_PTR     &&
                             typus->st_type != S_STRING;
     for (aux=s_root; aux; aux=aux->s_next)
         if(aux->s_type->st_type==S_UDEC)
         {
             aux->s_type=typus;

             if(typus->st_type==S_NET)
             {
                int i=0;

                aux->s_descriptor.netw.net_descriptor=l_act_def;

                for (i=0; credim[i] && i<MAXFDIM; i++)
                {
                    if(i>=MAXFDIM)
                        Error(400+i);
                    else
                        aux->s_descriptor.netw.s_dim[i]=strsave(credim[i]);
                }
                for(i=0; i<MAXFDIM; i++)
                    if(credim[i])
                    {
                        free(credim[i]);
                        credim[i]=0;
                    }
             }

             if(insc)
                 s_insert_chain(aux);

             if(!--anz)
                  return;
         }
}

/* lokal definierte konstanten loeschen um side effects zu vermeiden */
void s_free_all (S_OBJECT* p)
{
    while (p)
    {
        S_OBJECT* pNext = p->s_next;

        if (p->s_type->st_type==S_LCONST)
            fprintf (yyout,"#undef %s\n",p->s_name);

        free (p);

        p = pNext;
    }
}

void sc_free_all(S_CHAIN* p)
{
    while (p)
    {
        S_CHAIN* pNext = p->sc_next;

        free (p);

        p = pNext;
    }
}

void s_append (S_OBJECT* proc, BOOL byref, short anz)
{
        S_REFLIST *newref, *aux;
        int        i;

        for(aux=0, i=1; i<=anz; i++)
        {
            newref = ALLOC(S_REFLIST);

            if(!newref)
                FatalError (ERR_MEMORY);

            newref->ref     = byref;
            newref->sr_next = aux;
            aux             = newref;
        }

        if(!proc->s_descriptor.funct.refi)
        {
            proc->s_descriptor.funct.refi=newref;
            return;
        }

        for (
            aux = proc->s_descriptor.funct.refi;
            aux->sr_next;
            aux = aux->sr_next
        );

        aux->sr_next=newref;
}

void s_cleanup (S_OBJECT* start)
{
    s_free_all  (start       );
    sc_free_all (s_chain_root);

    s_chain_root = 0;
}

BOOL s_search_chain(STRING id)
{
    S_CHAIN *aux;

    for (aux=s_chain_root; aux; aux=aux->sc_next)
        if(!strcmp (id,aux->s_next->s_name))
            return TRUE;

    return FALSE;
}

void l_insert(STRING newid, short ltyp)
{
    L_OBJECT *newobj = ALLOC(L_OBJECT);

    if(!newobj)
        FatalError (ERR_MEMORY);

    newobj->l_name=strsave(newid);

    if(ltyp==L_NETLAY)
    {
        newobj->l_next=l_root;

        if(l_aptr>=MAXNEST)
            Error(300+l_aptr);
        else
            l_root            =
            l_actual [l_aptr] = newobj;

        return;
    }

    if      (l_aptr  >=MAXNEST)
        Error(300+l_aptr);

    else if (l_aptr+1>=MAXNEST)
        Error(300+l_aptr+1);

    else
        newobj->l_next = l_actual[l_aptr]->l_desc.l_desc1.l_sublay;

    l_actual [l_aptr  ]->l_desc.l_desc1.l_sublay = newobj;
    l_actual [l_aptr+1]                          = newobj;
}

L_OBJECT *l_lookup(STRING newlayer, short ltyp)
{
    L_OBJECT *aux;

    for (aux=l_root; aux; aux=aux->l_next)
        if(!strcmp(newlayer,aux->l_name))
        {
            l_act_def=aux;
            return aux;
        }

    if(ltyp!=L_ENQ)
        l_insert(newlayer, ltyp);

    l_act_def=0;

    return 0;
}


L_OBJECT *in_netlay (L_OBJECT* sl, STRING sub_name)
{
    for (; sl; sl=sl->l_next)
        if (!strcmp(sub_name, sl->l_name))
            break;

    return sl;
}

BOOL in_upper_lay(STRING newlay)
{
    short i;

    for (i=l_aptr; i; i--)
    {
        if(i>=MAXNEST)
            Error (300+i);

        if(!strcmp(newlay,l_actual[i]->l_name))
            return TRUE;
    }

    return FALSE;
}

BOOL dupl_lay (STRING newlay)
{
    L_OBJECT *aux;

    if(l_aptr>=MAXNEST)
    {
        Error(300+l_aptr);
        return FALSE;
    }

    for (aux=l_actual[l_aptr]->l_desc.l_desc1.l_sublay; aux; aux=aux->l_next)
        if(!strcmp(newlay, aux->l_name))
            return TRUE;

    return FALSE;
}

BOOL unit_check(L_OBJECT* start, short anzdim)
/* true wenn alle notwendigen field dim vorhanden. */
{
        if(anzdim==-1)
            return TRUE;
        if(anzdim==0)
            return FALSE;

        if(start->l_descflg)
            return (BOOL)start->l_desc.l_desc1.l_fielddim[anzdim-1];

        return unit_check(start->l_desc.l_ptr, anzdim);
}
