/*
 *    Additional String Handling Procedures: strings.c
 *
 */

#include <string.h>
#include <stdlib.h>
#include "util.h"
#include "Error.h"

#if defined(vax)

#include <ctype.h>

STRING strdup (STRING sOld)
{
    STRING sNew = malloc (strlen (sOld)+1);

    if (!sNew)
        FatalError (ERR_MEMORY);

    return strcpy (sNew, sOld);
}

STRING strupr (STRING sOld)
{
    STRING sNew;

    for (sNew=sOld; *sNew; sNew++)
        *sNew = (char) toupper (*sNew);

    return sOld;
}

STRING strlwr (STRING sOld)
{
    STRING sNew;

    for (sNew=sOld; *sNew; sNew++)
        *sNew = (char) tolower (*sNew);

    return sOld;
}
#endif

STRING strcat2 (STRING p1, STRING p2)
{
    STRING pNew;

    if (!p1) p1 ="";
    if (!p2) p2 ="";

    pNew = malloc (strlen (p1)+strlen (p2)+1);

    if (!pNew)
        FatalError (ERR_MEMORY);

    strcpy (pNew, p1);
    strcat (pNew, p2);

    return pNew;
}

STRING strcat3 (STRING p1, STRING p2, STRING p3)
{
    STRING pNew;

    if (!p1) p1 ="";
    if (!p2) p2 ="";
    if (!p3) p3 ="";

    pNew = malloc (strlen (p1)+strlen (p2)+strlen (p3)+1);

    if (!pNew)
        FatalError (ERR_MEMORY);

    strcpy (pNew, p1);
    strcat (pNew, p2);
    strcat (pNew, p3);

    return pNew;
}

STRING strcat4 (STRING p1, STRING p2, STRING p3, STRING p4)
{
    STRING pNew;

    if (!p1) p1 ="";
    if (!p2) p2 ="";
    if (!p3) p3 ="";
    if (!p4) p4 ="";

    pNew = malloc (strlen (p1)+strlen (p2)+strlen (p3)+strlen (p4)+1);

    if (!pNew)
        FatalError (ERR_MEMORY);

    strcpy (pNew, p1);
    strcat (pNew, p2);
    strcat (pNew, p3);
    strcat (pNew, p4);

    return pNew;
}

STRING strcat5 (STRING p1, STRING p2, STRING p3, STRING p4, STRING p5)
{
    STRING pNew;

    if (!p1) p1 ="";
    if (!p2) p2 ="";
    if (!p3) p3 ="";
    if (!p4) p4 ="";
    if (!p5) p5 ="";

    pNew = malloc (strlen (p1)+strlen (p2)+strlen (p3)+strlen (p4)+strlen (p5)+1);

    if (!pNew)
        FatalError (ERR_MEMORY);

    strcpy (pNew, p1);
    strcat (pNew, p2);
    strcat (pNew, p3);
    strcat (pNew, p4);
    strcat (pNew, p5);

    return pNew;
}

STRING strcat6 (STRING p1, STRING p2, STRING p3, STRING p4, STRING p5, STRING p6)
{
    STRING pNew;

    if (!p1) p1 ="";
    if (!p2) p2 ="";
    if (!p3) p3 ="";
    if (!p4) p4 ="";
    if (!p5) p5 ="";
    if (!p6) p6 ="";

    pNew = malloc (strlen (p1)+strlen (p2)+strlen (p3)+strlen (p4)+strlen (p5)+strlen (p6)+1);

    if (!pNew)
        FatalError (ERR_MEMORY);

    strcpy (pNew, p1);
    strcat (pNew, p2);
    strcat (pNew, p3);
    strcat (pNew, p4);
    strcat (pNew, p5);
    strcat (pNew, p6);

    return pNew;
}

STRING strsave (STRING s)
{
    if (!s)
        return 0;

    return strdup(s);
}

STRING upstr (STRING s)
{
    if (!s)
        return 0;

    return strupr (strdup(s));
}
