/************************************************************************
                MAKE PREFS
 *      Create a free-standing Widg for the preferences - settings
        for linewidth, pointsize, offset, delay, etc.
 ************************************************************************/

#include "animator.h"
void extern change_speed();
void extern change_linewidth();
void extern change_pointsize();
void extern change_skipinterval();
void extern change_beginskip();
void extern change_yoffset();
void extern change_xoffset();
void extern change_compress();
void extern change_demomode();
void extern change_tplabel();
void extern show_more();
void extern show_epochs();

void extern close_prefs();

void make_prefs(w, data, call_data)
        Widget          w;
        line_data       *data;
        XmAnyCallbackStruct *call_data;
{
        Widget      toprc, rc2,  separator, intervallabel,
		epochbutton, closebutton,
                speedscroll, linescroll, pointscroll,
                beginskipscroll, skipintervalscroll, beginlabel, skiplabel, morebutton,
                yoffsetscroll, xoffsetscroll, compressscroll,demotoggle,tplabeltoggle,
		yaxislabel,    xaxislabel,    compresslabel;
        WidgetList      pref;
        Arg             args[5];
        int             n;

                                /*Create stand-alone shell and vertical RC Widg to hold slider info */
/*
prefshell = XmCreateBulletinBoardDialog(toplevel, "Preferences", NULL, 0);
prefshell =  XtCreateManagedWidget("Preferences", xmBulletinBoardWidgetClass, toplevel, NULL, 0);
*/

prefshell = XtCreatePopupShell("Preferences", topLevelShellWidgetClass, toplevel, NULL, 0);

XtSetArg(args[0], XmNorientation, XmVERTICAL);
toprc = XtCreateManagedWidget("TopRC", xmRowColumnWidgetClass, prefshell, args, 1);

/**********************************CREATE SLIDER PREFERENCES*******************************/
XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
rc2 = XtCreateManagedWidget("rc2", xmRowColumnWidgetClass, toprc, args, 1);
closebutton  = XtCreateManagedWidget("   Close   ",    xmPushButtonWidgetClass, rc2, NULL, 0);
epochbutton  = XtCreateManagedWidget("Show Epochs",    xmPushButtonWidgetClass, rc2, NULL, 0);
morebutton  =  XtCreateManagedWidget("  <<MORE>> ",    xmPushButtonWidgetClass, rc2, NULL, 0);

n=0;
XtSetArg(args[n], XmNtitleString, XmStringCreate("Delay", XmSTRING_DEFAULT_CHARSET)); n++;
speedscroll = XtCreateManagedWidget("SPEED", xmScaleWidgetClass, toprc, args, 1);

n=0;
XtSetArg(args[n], XmNminimum,           1           );          n++;
XtSetArg(args[n], XmNmaximum,           5           );          n++;
XtSetArg(args[n], XmNvalue,             1           );          n++;
XtSetArg(args[n], XmNorientation,       XmHORIZONTAL);          n++;
XtSetArg(args[n], XmNtitleString, XmStringCreate("Line Width", XmSTRING_DEFAULT_CHARSET)); n++;
linescroll = XtCreateManagedWidget("LINES", xmScaleWidgetClass, toprc, args, n);

n=0;
XtSetArg(args[n], XmNminimum,           2           );          n++;
XtSetArg(args[n], XmNmaximum,           6           );          n++;
XtSetArg(args[n], XmNvalue,             3           );          n++;
XtSetArg(args[n], XmNorientation,       XmHORIZONTAL);          n++;
XtSetArg(args[n], XmNtitleString, XmStringCreate("Point Size", XmSTRING_DEFAULT_CHARSET)); n++;
pointscroll = XtCreateManagedWidget("POINTS", xmScaleWidgetClass, toprc, args, n);


separator = XtCreateManagedWidget("separator", xmSeparatorWidgetClass, toprc, NULL, 0);

beginlabel   = XtCreateManagedWidget("BEGINSKIP", xmLabelWidgetClass, toprc, NULL, 0);
xs_wprintf(beginlabel, "BeginSkip");

n=0;
XtSetArg(args[n], XmNminimum,           1           );          n++;
XtSetArg(args[n], XmNmaximum,           5000        );          n++;
XtSetArg(args[n], XmNorientation,       XmHORIZONTAL);          n++;
beginskipscroll = XtCreateManagedWidget("BEGINSKIP",xmScrollBarWidgetClass, toprc, args, n);

intervallabel   = XtCreateManagedWidget("INTERVAL", xmLabelWidgetClass, toprc, NULL, 0);
xs_wprintf(intervallabel, "Skip 1 Epoch, Starting at Epoch  1 ");

n=0;
XtSetArg(args[n], XmNminimum,           1           );          n++;
XtSetArg(args[n], XmNmaximum,           50          );          n++;
XtSetArg(args[n], XmNorientation,       XmHORIZONTAL);          n++;
skipintervalscroll = XtCreateManagedWidget("SKIPINTERVAL",xmScrollBarWidgetClass, toprc, args, n);

skiplabel   = XtCreateManagedWidget("INTERVALSKIP", xmLabelWidgetClass, toprc, NULL, 0);
xs_wprintf(skiplabel, "SkipIntervals");

/************************************************************************************************
 * Create the rest of the sliders which go are managed when user chooses MORE from Prefs widget *
 ************************************************************************************************/
moreprefshell = XmCreateBulletinBoardDialog(prefshell, "Preferences", NULL, 0);

XtSetArg(args[0], XmNorientation, XmVERTICAL);
toprc = XtCreateManagedWidget("TopRC", xmRowColumnWidgetClass, moreprefshell, args, 1);

n=0;
XtSetArg(args[n], XmNminimum,          -800         );          n++;
XtSetArg(args[n], XmNmaximum,           800         );          n++;
XtSetArg(args[n], XmNvalue,             0           );          n++;
XtSetArg(args[n], XmNorientation,       XmHORIZONTAL);          n++;
yoffsetscroll = XtCreateManagedWidget("YOFFSET",xmScrollBarWidgetClass, toprc, args, n);

yaxislabel   = XtCreateManagedWidget("   Y Axis   ", xmLabelWidgetClass, toprc, NULL, 0);


n=0;
XtSetArg(args[n], XmNminimum,          -800           );          n++;
XtSetArg(args[n], XmNmaximum,           800           );          n++;
XtSetArg(args[n], XmNvalue,             0             );          n++;
XtSetArg(args[n], XmNorientation,       XmHORIZONTAL  );          n++;
xoffsetscroll = XtCreateManagedWidget("XOFFSET",xmScrollBarWidgetClass, toprc, args, n);

xaxislabel   = XtCreateManagedWidget("   X Axis    ", xmLabelWidgetClass, toprc, NULL, 0);


n=0;
XtSetArg(args[n], XmNminimum,           1             );          n++;
XtSetArg(args[n], XmNmaximum,           2*COMPFACT    );          n++;
XtSetArg(args[n], XmNvalue,             COMPFACT      );          n++;
XtSetArg(args[n], XmNorientation,       XmHORIZONTAL  );          n++;
compressscroll = XtCreateManagedWidget("COMPRESS",xmScrollBarWidgetClass, toprc, args, n);

compresslabel   = XtCreateManagedWidget("  Compress/Expand  ", xmLabelWidgetClass, toprc, NULL, 0);

demotoggle = XtCreateManagedWidget("Demo Mode", xmToggleButtonWidgetClass, toprc, NULL,0);

n=0;
XtSetArg(args[n], XmNset,		TRUE		);	n++;
tplabeltoggle = XtCreateManagedWidget("Show Label/Points", xmToggleButtonWidgetClass, toprc, args, n);


/*******************************Add CALLBACKS***********************************************/
XtAddCallback(morebutton,        XmNactivateCallback,     show_more,           data);
XtAddCallback(epochbutton,       XmNactivateCallback,     show_epochs,         data);
XtAddCallback(closebutton,       XmNactivateCallback,     close_prefs,         data);

XtAddCallback(speedscroll,       XmNvalueChangedCallback, change_speed,       data);
XtAddCallback(linescroll,        XmNvalueChangedCallback, change_linewidth,   data);
XtAddCallback(pointscroll,       XmNvalueChangedCallback, change_pointsize,   data);
XtAddCallback(beginskipscroll,   XmNvalueChangedCallback, change_beginskip,   intervallabel);
XtAddCallback(skipintervalscroll,XmNvalueChangedCallback, change_skipinterval,intervallabel);
XtAddCallback(yoffsetscroll,     XmNvalueChangedCallback, change_yoffset,      data);
XtAddCallback(xoffsetscroll,     XmNvalueChangedCallback, change_xoffset,      data);
XtAddCallback(compressscroll,    XmNvalueChangedCallback, change_compress,     data);
XtAddCallback(demotoggle,        XmNvalueChangedCallback, change_demomode,     data);
XtAddCallback(tplabeltoggle,	 XmNvalueChangedCallback, change_tplabel,   data);
}

