/* Routines related to user preference changes.  Also those routines which manage the widgets for
 * prefs, colors, epochs.
 */

#include "animator.h"
#include "prefchanges.h"


void redisplay();
void change_screensize();

		/*Callbacks for user preferences */
void    change_speed();
void    change_pointsize();
void    change_linewidth();
void	change_yoffset();
void	change_xoffset();
void	change_compress();
void    change_beginskip();
void    change_skipinterval();
void	change_demomode();
void	change_tplabel();
void	change_showline();
void	init_showline();
void	redraw();

/************************************************************************
 *     CHANGES in POINT, LINE, and SPEED 
 ************************************************************************/

void change_speed(w, data, call_data)
        Widget                  w;
        line_data               *data;
        XmScaleCallbackStruct   *call_data;
{
data->delay = call_data->value * 10 + 5;
}

void change_linewidth(w, data, call_data)
        Widget                  w;
        line_data               *data;
        XmScaleCallbackStruct   *call_data;
{
	int i;
for (i=0 ; i<MaxHu ; i++)
       {
				/*only want to change line width, through the call_data->value
				 *Not sure if all args are required for SetAttributes
				 */
	XSetLineAttributes(canvas, data->gc[i],      call_data->value, LineSolid, CapButt, JoinMiter);
	XSetLineAttributes(canvas, data->erasegc[i],  call_data->value, LineSolid, CapButt, JoinMiter);
	}
redraw(data);
}

void change_pointsize(w, data, call_data)
        Widget                  w;
        line_data               *data;
        XmScaleCallbackStruct   *call_data;
{
pointsize = call_data->value;
redraw(data);
}

/************************************************************************
 *       Changes in INTERVAL SKIP, BEGIN SKIP, OFFSETS and COMPRESS
 ************************************************************************/
void change_beginskip(w, labelwidget, call_data)
        Widget                  w;
        Widget                  labelwidget;
        XmScaleCallbackStruct   *call_data;
{
beginskip =  call_data->value;
xs_wprintf(labelwidget, "Skip %i  Epoch, Starting at Epoch %i   ", skipinterval, beginskip);
}

void change_skipinterval(w, labelwidget, call_data)
        Widget                  w;
        Widget                  labelwidget;
        XmScaleCallbackStruct   *call_data;
{
skipinterval =  call_data->value;
xs_wprintf(labelwidget, "Skip %i  Epoch, Starting at Epoch %i   ", skipinterval, beginskip);
}

void change_yoffset(w, data, call_data)
	Widget			w;
	line_data		*data;
	XmScaleCallbackStruct	*call_data;
{
y_offset = (float) call_data->value;
redraw(data);
}
void change_xoffset(w, data, call_data)
        Widget                  w;
        line_data               *data;
        XmScaleCallbackStruct   *call_data;
{
x_offset = (float) call_data->value;
redraw(data);
}
void change_compress(w, data, call_data)
        Widget                  w;
        line_data               *data;
        XmScaleCallbackStruct   *call_data;
{
compress = (float) call_data->value/COMPFACT;
redraw(data);
}
/************************************************************************
 *           Change DEMOMODE and TPLABELS and SHOWLINE
 ************************************************************************/
void change_demomode(w, data, call_data)
        Widget          w;
        line_data               *data;
        XmToggleButtonCallbackStruct     *call_data;
{
DemoMode = call_data->set;
}
void change_tplabel(w, data, call_data)
        Widget          w;
        line_data               *data;
        XmToggleButtonCallbackStruct     *call_data;
{
ShowPoints = call_data->set;
redraw(data);
}
void change_showline(w, data, call_data)
        Widget                          w;
        line_data                       *data;
        XmToggleButtonCallbackStruct    *call_data;
{
        int i;
                                /*recover number of HU label which was clicked on */
XtSetArg(args[0], XmNuserData, &i);
XtGetValues(w, args, 1);

ShowLine[i] = call_data->set;
redraw(data);
}

void init_showline()
{
	int i;
 for (i=0; i< MaxHu; i++)
        ShowLine[i]=TRUE;       /* init Booleans for showing line */
}

/************************************************************************
 *            REDISPLAY and CHANGE SCREEN SIZE
 ************************************************************************/
void redisplay(w, data, call_data)
	Widget				w;
	line_data			data;
	XmDrawingAreaCallbackStruct 	*call_data;

{
if (XtIsRealized(w))
	redraw(data);
}
void change_screensize(w, data, call_data)
        Widget                          w;
        line_data                       data;
        XmDrawingAreaCallbackStruct     *call_data;
{
	Dimension	width;
	Dimension	height;
if (XtIsRealized(w))
	{
	XtSetArg(args[0], XtNwidth, &width );
	XtSetArg(args[1], XtNheight,&height);
	XtGetValues(w, args, 2);
	if (width < height)
	   {
	   ScreenSize = (float) width/2;
	}
 	else
	   {
	   ScreenSize = (float) height/2;
	}
	redraw(data);
	}
}
