#include "animator.h"

Boolean  FileError;
float	 pmax;			/* max x or y coord of Training Points */

void generate_points();
void generate_endPts();

void file_read(char *fname, int *totalEpoch, int *totalHU, int *totalTP)
{
void generate_endPts();
void generate_points();

FILE       *patternfile;        /* name of the input file */
FileError   = FALSE;

if ((patternfile = fopen(fname, "r")) != NULL)
   {
        	/* generate_points does the file read and conversion of TP
        	 * generate_endPts does the file read of HU and calls
        	 * find_endPts,which does the conversion of HU endpoints */

	generate_points(patternfile,  totalHU, totalTP);
	if (!FileError)
	   {
	   generate_endPts(patternfile,  totalEpoch, totalHU);
	   }
	else
	   {
	   *totalEpoch = 0;
	   *totalHU    = 0;
	   *totalTP    = 0;                /*init to 0 to if file opening error*/
	   }

   }
}

/*****************************************************************
		GENERATE_ENDPTS
*  gets coordinates for the each hidden unit lines for all the epochs  
*  does file read on A,B,C of form Ax + By = C, then calls
*  find_endPts() which converts these points.

*  This code was ported from code written for a Hyperplane Animator to run on a Sun platform.
*  The author of that code mentioned that it was given to him by someone else.  We have modified
*  this section only by stripping away some parts we thought were confusing.  
*****************************************************************/
void generate_endPts(patternfile,  totalEpoch, totalHU)
	FILE	*patternfile;
	int	*totalEpoch;
	int	*totalHU;
{
   int       NumHU;
   int       EpochNum = 0;
   float     a, b, c, max;
   int       index;
   void      find_endPts();
   max = pmax;

  while ((fscanf(patternfile,"%f %f %f", &a, &b, &c) >0)
		&& (*totalEpoch < MaxEpochs))
    {
      index = 0;
      
      if (*totalHU >= 1)	/* Must process first hidden unit. outside of loop since read first unit
				 * in the loop statement.  {Comments by previous author}*/

        find_endPts(a, b, -c, max, &index, EpochNum);

	for (NumHU = 1; NumHU < *totalHU; NumHU++)  /* Process remainder of HUs. */
	{
	  fscanf(patternfile,"%f %f %f", &a, &b, &c);
						/*A little confusing, c is passed in as -c */
	  find_endPts(a, b, -c, max, 
		      &index, EpochNum);
	}
      EpochNum++;
    }

*totalEpoch = EpochNum-1;  /*Probably a horrible kludge, but balances the epoch */
} 			   


/****************************************************************
			FIND_ENDPTS
 * find end points of the lines to draw on the screeen       
 * From: the code Lori gave me playinsp.c
 *****************************************************************/
void find_endPts(a, b, c, max, index, EpochNum)
     float a, b, c, max;
     int *index;
     int EpochNum;
{
  float tempx[4], tempy[4];
  float xa, xb, xc, xd, ya, yb, yc, yd;
  int pt;

				/*loading dummy values in temp so that if values inside the box
				 *bounded by max and -max are not found, will draw line outside
				 *of screen coordinates */
  tempx[0] = tempy[0] = 0.0; 
  tempx[1] = tempy[1] = 0.0; 

		/*check for horizontal or vertical lines */
  if (a==0.0)		
    { 
      tempx[0] = -max;
      tempx[1] = max;
      if (b==0.0)
	tempy[0] = tempy[1] = 0; /* a=0 and b=0; x axis */
      else
	tempy[0] = tempy[1] = c/b; /* a=0 and b<>0; horizontal line */
    }
  else 
    if (b==0.0)
      {  /* a<>0 and b=0; vertical line */
	tempy[0] = -max;
	tempy[1] = max;
	tempx[0] = tempx[1] = c/a;
      }
    else
      { 				/* else have a diagonal line, a<>0 and b<>0 
					 * now compute x at "y-intercept" of bounded data,
					 * ie,  x at maximum y */
	xa = -max; ya = (c-a*xa)/b;	
	yb = -max; xb = (c-b*yb)/a;
	xc = max;  yc = (c-a*xc)/b;
	yd = max;  xd = (c-b*yd)/a;
	pt = 0;

	/* check to make sure that they are within the screen 
	 * compare x and y computed at max and -max to see if the line will fall within
	 * the "box" of the bounded data.   */ 

	if ((ya < max) && (ya > -max))
	  {
	    tempx[pt] = xa;
	    tempy[pt] = ya;
	    pt += 1;
	  }
	if ((xb < max) && (xb > -max))
	  {
	    tempx[pt] = xb;
	    tempy[pt] = yb;
	    pt += 1;
	  }
	if ((yc < max) && (yc > -max))
	  {
	    tempx[pt] = xc;
	    tempy[pt] = yc;
	    pt += 1;
	  }	
	if ((xd < max) && (xd > -max))
	  {
	    tempx[pt] = xd;
	    tempy[pt] = yd;
	    pt += 1;
	  }
      }
  
  /* store end points in the array after translation 
   */
  endPts[EpochNum][*index].x = tempx[0]/max;
  endPts[EpochNum][*index].y = tempy[0]/max;
  *index = *index + 1;
								
  endPts[EpochNum][*index].x = tempx[1]/max;
  endPts[EpochNum][*index].y = tempy[1]/max; 
  *index = *index + 1;
}
/************************************************************************
 *		GENERATE_POINTS
 * ROUTINE: generate_points		GENERATE_POINTS
 * Reads the coordinates for the training data from the file
 * Ported from previously written code.  Current programmers never entirely deciphered 
 * the reason for the use of "trash_string", but it worked so we kept it largely unaltered.
************************************************************************/

void generate_points(patternfile, totalHU, totalTP)
	FILE		*patternfile;
	int		*totalHU;
	int		*totalTP;
{
   int        datanum;
   int        j,k;
   char       rstring[5];
   int        trash_int;
   char       trash_string [100];
   char       classes_list [100] [100];
   float      bias;			/*not used*/
   float      xpt;
   float      ypt;
   int        InputU;	
   float      max_float();


  fscanf(patternfile,"%s", trash_string); /* read title of network */
               /* reads the number of patterns, number of input units, number of 
                * hidden units and the bias (largest integer greater than all 
                * the coordinate points) of the training data */

  fscanf(patternfile,"%d %d %d %f", totalTP, &InputU, totalHU, &bias);

  if (!((*totalTP < MaxPts) && (InputU==2) && (*totalHU < MaxHu)))
	{
	FileError = TRUE;
	return;
	} 

  pmax = 1.0;		/*will hold abs value of max TP, if max TP is > 1.0, used to scale */
  totalClasses = 0;

  for (datanum = 0; datanum < *totalTP; datanum++)
  {
      fscanf(patternfile,"%f %f %s", &xpt, &ypt, rstring);

      pmax = max_float(pmax, max_float(xpt, ypt));

      TrainPts[datanum].x = xpt; /* x coordinate */
      TrainPts[datanum].y = ypt; /* y coordinate */

	     /* read string for class of current training datum */
      j = 0;
      while ((TrainPts[datanum].result[j] = rstring[j]) != '\0')
        j++;
                                /* Check to add result (or "class") to list
                                 * of classes. */
      strncpy (trash_string, rstring, j);
      trash_string[j] = '\0';
      trash_int = totalClasses;
			/*if class not on list, (new class), add to list */
      if (lfind (trash_string, classes_list, &trash_int, 100, strcmp) == NULL)
         {
         totalClasses = totalClasses + 1;
         strcpy (&classes_list [totalClasses - 1][0], trash_string);
         }

					/*then assign appropriate integer to class */
      for (k = 0 ; k < totalClasses ; k++)
	   { 
	   if (strcmp(trash_string, classes_list[k])==0)
		{
		   TrainPts[datanum].result_class = k;
		}	
	   }

      TrainPts[datanum].reslength = j; /* length of output string */
  }
			/*scale all points to between -1.0 and 1.0 */
  if (pmax > 1.0)
  {
	for (j=0; j< *totalTP; j++)
	{
		TrainPts[j].x = TrainPts[j].x / pmax;
		TrainPts[j].y = TrainPts[j].y / pmax;
	}
  }
}


/*returns max of abs val of two num's*/
float max_float(x, y)
   float x;
   float y;
   {
   if (x < 0.0) x = -x;
   if (y < 0.0) y = -y;
   if (x > y) return x;
   else return y;
   }
