
/* two simple routines to save and load colors for the Animator */

#include "animator.h"

void save_color(w, data, call_data)
	Widget		w;
	line_data	*data;
        XmAnyCallbackStruct  *call_data;
{
FILE   *colorfile;
XColor color;
int i,red,green,blue,pixel;
char  cf[]="color.cfg";
Arg	args[10];

color.flags = DoRed | DoGreen | DoBlue;

if ((colorfile = fopen(cf, "w")) == NULL)
	{	
	}
else
	{
					/*Save Hidden Unit RGB components*/
	for (i = 0; i<MaxHu; i++)
		{
		color.pixel = data->pixelno[i];
		XQueryColor(XtDisplay(toplevel), my_colormap, &color);
		red = (int)color.red; green = (int)color.green; blue = (int)color.blue; pixel = (int)color.pixel;
		fprintf(colorfile, "%i %i %i\n",
			red, green, blue);
	}
					/*Save Training Point RGB components*/
	for (i = MaxHu; i<MaxHu+MaxClasses; i++)
                {
                color.pixel = data->pixelno[i];
                XQueryColor(XtDisplay(toplevel), my_colormap, &color);
                red = (int)color.red; green = (int)color.green; blue = (int)color.blue; pixel = (int)color.pixel;
                fprintf(colorfile, "%i %i %i\n",
                        red, green, blue);
        }

	fclose(colorfile);
}
}

void load_color(w, data, call_data)
        Widget          w;
        line_data       *data;
        XmAnyCallbackStruct  *call_data;
{
FILE   	*colorfile;
XColor 	color;
XGCValues	gcvals;
int 	i,red,green,blue,pixel;
char  	cf[]="color.cfg";

color.flags = DoRed | DoGreen | DoBlue;

if ((colorfile = fopen(cf, "r")) == NULL)
        {
printf ("error opening file\n");
        }
else
        {
        for (i = 0; i<MaxHu; i++)
                {
		fscanf(colorfile, "%i %i %i", &red, &green, &blue);

			/*change the RGB components in the colormap*/
                color.red = (short)red ; color.green = (short)green; color.blue = (short)blue;
		color.pixel = LINE_PIXELINIT + i;
                XStoreColor(XtDisplay(toplevel), my_colormap, &color);

			/*change the GC contexts for line to the pixel number of the
			 *altered colors
			 */
		gcvals.foreground =LINE_PIXELINIT + i;
	   	XChangeGC(XtDisplay(canvas), data->gc[i], GCForeground, &gcvals);
		data->pixelno[i] = LINE_PIXELINIT + i;   /*duplicate foreground info in pixelno*/

			/*change the foreground color of the HU label */
		XtSetArg(args[0], XtNbackground, LINE_PIXELINIT + i);
		XtSetValues(legend[i], args, 1);

        }

	for (i = MaxHu; i<MaxHu+MaxClasses; i++)
                {
                fscanf(colorfile, "%i %i %i", &red, &green, &blue);

                        /*change the RGB components in the colormap*/
                color.red = (short)red ; color.green = (short)green; color.blue = (short)blue;
                color.pixel = LINE_PIXELINIT + i;
                XStoreColor(XtDisplay(toplevel), my_colormap, &color);

                        /*change the GC contexts for training point to the pixel number of the
                         *altered colors
                         */
                gcvals.foreground =LINE_PIXELINIT + i;
                XChangeGC(XtDisplay(canvas), data->train_gc[i-MaxHu], GCForeground, &gcvals);
                data->pixelno[i] = LINE_PIXELINIT + i;   /*duplicate foreground info in pixelno*/

                        /*change the foreground color of the HU label */
                XtSetArg(args[0], XtNbackground, LINE_PIXELINIT + i);
                XtSetValues(legend[i], args, 1);

        }

        fclose(colorfile);
}
}


