/************************************************************
	COLOR EDITOR
**************************************************************/
/********************************************************
        COLOR EDITOR
This editor was typed from sample code from:
        The X Window System
        Programming and Applications with Xt, OSF/Motif Edition
        by Douglas Young        Prentice Hall    p. 167-188
        
We gratefully acknowledge his well-written code, and highly recommend his book.
Parts of the code which have been modified are clearly marked
**********************************************************/
/**********************************************************
COLOREDIT creates a popup window, and creates widget labels for the
training point(TP) and hidden unit (HU) colors.  Allows the user to 
alter a color with slider bars, or click on a color label to replace
the HU or TP color with the color in the color label.
Refer to the Widget Tree in the Programmers Manual. 
**********************************************************/

#include "animator.h"

void extern save_color();
void extern load_color();
void extern close_color();
void extern init_show_line();

make_coloredit(data)
   line_data    *data;
{
Widget	        bb,sliders,rc, ls, savebutton, loadbutton, closebutton;
Colormap	def_colormap;			/*default colormap*/
XColor		Colors[MAXCOLORS];
int		i;

void    red_slider_moved();
void    green_slider_moved();
void    blue_slider_moved();
void    set_current_color();
void    set_pixel_to_currentlabel();
void    change_showline();
Widget  make_slider();
Widget  create_color_bar();
Widget  create_legend_color_bar();

n=0;
XtSetArg(args[n], XtNwidth,   300                 );	n++;
XtSetArg(args[n], XtNheight,  600                 );	n++;
XtSetArg(args[n], XmNtitle, " Color Edit & Legend"); 	n++;

colorshell = XtCreatePopupShell("ColorEdit & Legend", topLevelShellWidgetClass, toplevel, args, 3);

dpy  = XtDisplay(toplevel);
cdpy = XtDisplay(canvas);

/* Determine the number of colors to be edited. */

ncolors = DisplayCells(dpy, DefaultScreen(dpy));

if (ncolors > MAXCOLORS) ncolors = MAXCOLORS;

rc = XtCreateManagedWidget("base",xmRowColumnWidgetClass, colorshell, NULL, 0);

/********************************SAVE & LOAD w/ Callbacks*******************************/
XtSetArg(args[0], XmNorientation,       XmHORIZONTAL);          
ls = XtCreateManagedWidget("load-save",xmRowColumnWidgetClass, rc, args, 1);

closebutton= XtCreateManagedWidget("  CLOSE    ",   xmPushButtonWidgetClass, ls, NULL, 0);
loadbutton = XtCreateManagedWidget("LOAD Colors",   xmPushButtonWidgetClass, ls, NULL, 0);
savebutton = XtCreateManagedWidget("SAVE Colors",   xmPushButtonWidgetClass, ls, NULL, 0);

XtAddCallback(closebutton,  XmNactivateCallback, close_color,    data);
XtAddCallback(savebutton,   XmNactivateCallback, save_color,     data);
XtAddCallback(loadbutton,   XmNactivateCallback, load_color,     data);


create_legend_color_bar(rc,data); 	/*create labels which show the color
					 *of each HU and TP
					 */

XtCreateManagedWidget("sep2", xmSeparatorWidgetClass, rc, NULL, 0);

/*********************************BULLETIN BOARD FOR SLIDERS***********************/
bb = XtCreateManagedWidget("controls", xmBulletinBoardWidgetClass, rc, NULL, 0);

/*
color_display_panel = XtCreateManagedWidget("display here ", xmLabelWidgetClass, bb, NULL, 0);
*/

create_color_bar(rc,data);		/*create labels for up to 64 available pixel
					 * colors
					 */
sliders = XtCreateManagedWidget("sliderpanel", xmRowColumnWidgetClass, bb, NULL, 0);

			/*make 3 sliders
			 *include callback for each one ("red_slider_moved", etc)
			 */
red_slider    = make_slider("red", sliders, red_slider_moved);
green_slider  = make_slider("green", sliders, green_slider_moved); 
blue_slider   = make_slider("blue", sliders, blue_slider_moved);
 

  /* Get the ID of the default colormap */

  def_colormap = DefaultColormap(dpy, DefaultScreen(dpy));
  for ( i=0 ;i < ncolors; i++)
  {
   Colors[i].pixel =i;
   Colors[i].flags = DoRed|DoGreen|DoBlue;
   }
XQueryColors(dpy, def_colormap, Colors, ncolors);
 
my_colormap = XCreateColormap(dpy, DefaultRootWindow(dpy),
   	DefaultVisual(dpy, DefaultScreen(dpy)), AllocAll);

XStoreColors(dpy, my_colormap, Colors, ncolors);
/*
XSetWindowColormap(XtDisplay(colorshell), XtWindow(colorshell), my_colormap);
*/


		/* Initialize to first pixel member of global color struct */ 
current_color.pixel = 0;

}

/********************************************************
 *create one slider. 3 sliders total will be created, for red, green, blue. 
********************************************************/
Widget  make_slider(name, parent, callback)
	char 	*name;
	Widget   	 parent;
	void	 (*callback) ();
{
   Widget	w;
   int	n;
   Arg	wargs[10];
   
   		/* create an XmScale widget. */
   n = 0; 
   XtSetArg(wargs[n],  XmNminimum,  0);  n++;
   XtSetArg(wargs[n],  XmNmaximum,  65535);  n++;
   
   w = XtCreateManagedWidget(name, xmScaleWidgetClass,  
      			parent,  wargs,  n);
   
		   /* Add callbacks to be invoked when the slider moves. */

   XtAddCallback (w,  XmNvalueChangedCallback,  callback,  NULL);
   XtAddCallback (w,  XmNdragCallback,  callback,  NULL);

   return (w);
   }

/********************************************************
*      SLIDER_MOVED and UPDATE_COLOR
*******************************************************/
void red_slider_moved(w, client_data, call_data)
  Widget			w;
  caddr_t			client_data;
  XmScaleCallbackStruct		*call_data;
   { 
	   /* Set the red color components of the global current_color structure */
   current_color.red = call_data->value;

   	/* Update the digital rgb display and the current color label */
   
   update_color();
   }

void blue_slider_moved(w, client_data, call_data)
   Widget			   w;
   caddr_t			   client_data;
   XmScaleCallbackStruct	*call_data;
   { 
   current_color.blue = call_data->value;
   
   update_color();
   } 

void green_slider_moved(w, client_data, call_data)
   Widget			   w;
   caddr_t			   client_data;
   XmScaleCallbackStruct	*call_data;
   { 
   current_color.green = call_data->value;
   
   update_color();
   }
/***********************/
update_color()
{
   Arg	wargs[1];
   char	str[25];
   XStoreColor(dpy, my_colormap, &current_color);
}
/**************************************************************
	CREATE COLOR LABELS 	
modified slightly from Young
***************************************************************/
Widget create_color_bar(parent,data)
   Widget parent;
   line_data    *data;
{
   Widget       panel;
   WidgetList   colors;
   int          i, n;
   char         name[10];
   Arg          wargs[10];

   colors = (WidgetList) XtMalloc(ncolors * sizeof(Widget));
/* Create the Row and Column manager to hold all the color buttons */

   n = 0;
   XtSetArg(wargs[n], XmNorientation,   XmHORIZONTAL);  n++;
   panel= XtCreateManagedWidget( "colorpanel", xmRowColumnWidgetClass,
                        parent, wargs, n);

      /* Create ncolors widgets. Use the relative color
            cell number as the name of each color. Add a
            XmNactiveCallback for each cell with the color
             index as client_data.    */

      for (i=0; i< MAXCOLORCHOICE; i++)
      {
		/*altered from Young.  CP_DISPLAYCOLUMNS should be 5 or 6.
		 * This line creates a new row for the labels. */

 	if (i % CP_DISPLAYCOLUMNS == 0)  {
                XtSetArg(wargs[0], XmNorientation,   XmHORIZONTAL);  n++;
       		panel= XtCreateManagedWidget( "colorpanel", 
					xmRowColumnWidgetClass, parent, wargs, 1);
        }
         n = 0;
         XtSetArg(wargs[n], XtNbackground, i); n++;
         XtSetArg(wargs[n], XmNuserData, i);   n++;
         sprintf(name, "%d",i);
         colors[i] = XtCreateWidget(name, xmLabelWidgetClass,
                                panel, wargs, n);
         XtAddEventHandler(colors[i],ButtonPressMask,FALSE,
 				set_pixel_to_currentlabel, data);

	XtManageChild(colors[i]);

     }
return panel;	/*not used*/
} 
/*******************************************************
 *		CREATE LEGEND COLOR BAR
 *similar to create_color_bar() above
*******************************************************/

Widget create_legend_color_bar(parent, data)
   Widget parent;
   line_data    *data;
{
   Widget       panel;
   int          i,j, k, n;
   char         name[20];
   Arg          wargs[10];

		/*malloc enough for maximum allowed by app*/
   legend =     (WidgetList) XtMalloc((MaxHu+MaxClasses+2) * sizeof(Widget));
   linetoggle=  (WidgetList) XtMalloc((MaxHu             ) * sizeof(Widget));

      /* Create the Row and Column manager to hold all the color buttons */

   XtSetArg(wargs[0], XmNorientation,   XmHORIZONTAL);
   panel= XtCreateManagedWidget( "colorpanel", xmRowColumnWidgetClass, parent, wargs, 1);


      for (i=0; i< MaxHu; i++)       /* Create for all possible HU  */
      {
        if (i % HU_DISPLAYCOLUMNS == 0)  {
                XtSetArg(wargs[0], XmNorientation,   XmHORIZONTAL); 
                panel= XtCreateManagedWidget( "colorpanel", 
				xmRowColumnWidgetClass, parent, wargs, 1);
        }
				/*Create and add Callback for the toggle button
				 *used to show/hide the Hidden Unit. change_showline
				 *Callback is currently in this file                  */

	n=0;
        XtSetArg(wargs[n], XmNuserData, i);n++;
	XtSetArg(wargs[n], XmNset,               TRUE            );      n++;
        linetoggle[i] = XtCreateWidget("", xmToggleButtonWidgetClass, panel, wargs, n);
        XtAddCallback(linetoggle[i],        XmNvalueChangedCallback, change_showline,     data);

		/*attach the HU label number, i, to the Widget thru XmNuserData,
		 *so that it can be passed with the Widget into set_current_color
		 *Set the label color to data.pixelno[i], which was set in create_gc()
		 *in animator.c, and is used to keep track of the pixel no of the
		 *associated GC for the hidden unit. */
        n=0;
        XtSetArg(wargs[n], XtNbackground, data->pixelno[i]); n++;
        XtSetArg(wargs[n], XmNuserData, i);n++;

        sprintf(name, "HU%d",i);

        legend[i] = XtCreateWidget(name, xmLabelWidgetClass,
                                panel, wargs, n);

        XtAddEventHandler(legend[i],ButtonPressMask,FALSE,
                        set_current_color, data);
     }
     
     init_showline();	/*in prefchanges.c initialize all ShowLine to true.  Default for the toggles
			 *created is TRUE.
			 */

/*************************Make a new row for Training Points ***********************/
/*similar to code above*/

   XtCreateManagedWidget("sep2", xmSeparatorWidgetClass, parent, NULL, 0);

   XtSetArg(wargs[0], XmNorientation,   XmHORIZONTAL);
   panel= XtCreateManagedWidget( "colorpanel", xmRowColumnWidgetClass, parent, wargs, 1);


/*for easier reading, keep handy a copy of create_gc() in animator.c,
 *which is where the GCs are created, and where the pixel no is assigned 
 */ 
						 
      for (i=MaxHu; i< MaxHu+MaxClasses; i++)   /*num_classes: number of classes
						      *of TP */
      {					              	
        if ((i- MaxHu) % TP_DISPLAYCOLUMNS == 0)  {
                XtSetArg(wargs[0], XmNorientation,   XmHORIZONTAL);  n++;
                panel= XtCreateManagedWidget( "colorpanel", 
					xmRowColumnWidgetClass, parent, wargs, 1);
        }

        n=0;
        XtSetArg(wargs[n], XtNbackground, data->pixelno[i]); n++;
        XtSetArg(wargs[n], XmNuserData, i);n++;

	j = i-MaxHu;
        sprintf(name, "Train Pt%d  ",j);

        legend[i] = XtCreateWidget(name, xmLabelWidgetClass,
                               panel, wargs, n);

        XtAddEventHandler(legend[i],ButtonPressMask,FALSE,
                        set_current_color, data);
     }
/***************************************bars for Axes and Background***************/
XtSetArg(wargs[0], XmNorientation,   XmHORIZONTAL);
panel= XtCreateManagedWidget( "colorpanel", xmRowColumnWidgetClass, parent, wargs, 1);

	/*AXpixel is defined const*/  
 
n=0;
XtSetArg(wargs[n], XtNbackground, data->pixelno[AXpixel]); n++;
XtSetArg(wargs[n], XmNuserData, AXpixel);n++;

sprintf(name, "    AXES    ");
legend[AXpixel] = XtCreateWidget(name, xmLabelWidgetClass,
                                panel, wargs, n);

XtManageChild(legend[AXpixel]);


XtAddEventHandler(legend[AXpixel],ButtonPressMask,FALSE,
                  set_current_color, data);

n=0;
XtSetArg(wargs[n], XtNbackground, data->pixelno[BGpixel]); n++;
XtSetArg(wargs[n], XmNuserData, BGpixel);n++;

sprintf(name, "  BACKGROUND  ");
legend[BGpixel] = XtCreateWidget(name, xmLabelWidgetClass,
                                panel, wargs, n);

XtManageChild(legend[BGpixel]);


XtAddEventHandler(legend[BGpixel],ButtonPressMask,FALSE,
                        set_current_color, data);

return panel;  /*not used*/
}

/***********************************************************************************
 		SET COLOR and SET PIXEL to HU or TP
***********************************************************************************/
void set_current_color(w, data, event)
	Widget	 	w;
	line_data	*data;
	XEvent		*event;

{
   Arg	wargs[10];
   int	i;

XtSetArg(wargs[0], XmNuserData, &i); /*see p 272 expl of userdata */
XtGetValues(w, wargs, 1);

   current_color.flags = DoRed | DoGreen | DoBlue;
   
   /* get the current color components of the selected button. */
   
   current_color.pixel = data->pixelno[i];

	/*altered, to hold current HU or TP.
	 *if a color label is clicked on, set_pixel_to_current_label() (below),
	 *replaces the pixel of the current_label  
	 */
   current_label     = i;
 
  XQueryColor (dpy, my_colormap, &current_color);
    
   /* Use each color component to as the new position
    of the corresponding slider. */
   
   XtSetArg(wargs[0], XmNvalue, current_color.red);
   XtSetValues(red_slider, wargs, 1);
   
   XtSetArg(wargs[0], XmNvalue, current_color.green);
   XtSetValues(green_slider, wargs, 1);
   
   XtSetArg(wargs[0], XmNvalue, current_color.blue);
   XtSetValues(blue_slider, wargs, 1);
   }
/*******************************************************
 *	SET PIXEL TO CURRENT LABEL
The last HU or TP label which was clicked on was stored in
current_label by routine set_current_color()
When a color label is clicked on, the pixel num for that label is
placed into the appropriate HU or TP label.  If axes or background was last
clicked on, routine will change nothing (axes and background may be adjusted
manually w/ sliders, but not w/ "pick and click"  
 ********************************************************/
void set_pixel_to_currentlabel(w, data, event)
		Widget   	w;
		line_data	*data;
		XEvent  	*event;
{
		Arg	wargs[5];
		int	i;
		XGCValues gcvals;

XtSetArg(wargs[0], XmNuserData, &i);	/*retrieve HU or TP number, passed in userdata*/ 
XtGetValues(w, wargs, 1);

			/* if an HU label was last label clicked on. 
			 * current_label was globally set in set_current_color() above */
if (current_label < MaxHu)
   {
			/*set foreground for the last label which was clicked on */
     gcvals.foreground = i;
     XChangeGC(cdpy, data->gc[current_label], GCForeground, &gcvals);

     data->pixelno[current_label] = i;   /*duplicate foreground info in pixelno*/

                   /*set the color of the background of the label */
     XtSetArg(wargs[0], XtNbackground, i);
     XtSetValues(legend[current_label], wargs, 1);
   }
   else if (current_label < AXpixel) 	/* if a TP label was last clicked on */
	{
				/*set foreground for the last label which was clicked on */
          gcvals.foreground = i;
          XChangeGC(cdpy, data->train_gc[current_label-MaxHu], GCForeground, &gcvals);
			/*duplicate foreground info in pixelno*/
	  data->pixelno[current_label] = i;


                   /*set the color of the background of the label */
     	  XtSetArg(wargs[0], XtNbackground, i);
          XtSetValues(legend[current_label], wargs, 1);
	}
}
