/********************************************************
* coloredit.h header file for  coloreditor
**********************************************************/
#include <varargs.h>
#include <stdio.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <X11/Xutil.h>
#include <X11/Core.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/BulletinB.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/Separator.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ToggleB.h>
#include <X11/Xlib.h>
#include <sys/time.h>
#include <limits.h>
#include <math.h>
#include <Xm/MessageB.h>

/********************************************************
Screen and Display Choice constants, which may be changed 	
*********************************************************/	
#define MAXCOLORS         256			/*used in coloredit() */
#define MAXCOLORCHOICE    64			/*used in coloredit() */

#define SCREEN  400			

#define COMPFACT 10				/*used in draw_one_epoch() & draw_train 
						*compression factor = used-defined val / COMPFACT
						*user-defined val is set in change_compress*/ 
						
#define INTERVALPERCENT 10		/*used in update_showepoch() to control how often
					 *epochs are updated */

#define TP_PIXELINIT 30		/* Used in create_gc().  These may be set to any value < 256        */
#define LINE_PIXELINIT 40	/* They're used to load an initial pixel value in the GCs           */ 
#define PIXELBLACK 60

#define HU_DISPLAYCOLUMNS 5	/*Used in coloredit, create_colorbar() and create_legend_colorbar() */ 
#define TP_DISPLAYCOLUMNS 4	/*to set number of HU, TP and CP(Color Pixels) for one row          */
#define CP_DISPLAYCOLUMNS 15	/*Color pixel, HU and TP length of display columns 		    */

/********************************************************
		Constants
********************************************************/
#define MaxClasses 10           /*Max number of different classes for training data*/
#define MaxHu 32		/*Max number of hidden units			   */
#define MaxPts 1000		/*Max number of training points			   */
#define numEndPts 64  		/* always 2*MaxHu */
#define MaxEpochs 5000		/*Max number of epochs				  */

#define AXpixel MaxHu+MaxClasses
#define BGpixel MaxHu+MaxClasses+1


/********************************************************
                GC  Structure
line_data is the MAIN DATA STRUCTURE for ALL GC info.
Passed in most Callbacks and EventHandlers
********************************************************/
                        /* Holds GC data for lines and training points */
typedef struct  {
        Widget  w;

        int     pixelno[MaxHu+MaxClasses+2];	/*holds copy of foreground pixel for GCs for
						 *HUs,  TPs ,  axes, and pixel for  background*/

        GC      axesgc;					/*Graphics Context for axes           */
        GC      holdgc[MaxHu];				/*not currently used                  */
        GC      gc[MaxHu], erasegc[MaxHu];              /*Graphics Context for hidden units   */
        GC      train_gc[MaxClasses];                   /*Graphics Context for training points*/
        int     delay;					/*delay used w/ XtAddTimeout()        */
        XtIntervalId    id;
} line_data;
							/*holdgc is intended for use w/ toggle
							 *button, so user can toggle between
							 *one color and multiple colors       */

/********************************************************
		Vars for the Colormap creation 
********************************************************/
Display	 *dpy, *cdpy;
Colormap my_colormap;
WidgetList legend, linetoggle;		
				/*holds all legend labels - HU, TP, Background and Axes.  */
				/*See create_legend_color_bar in Coloredit.c and show_colors in Animator.c */
XColor	 current_color;
int	ncolors;
int	current_label;

Widget	red_slider,
	blue_slider,
	green_slider,
	color_display_panel,
	hu_color_display_panel,  /* hidden unit color display */
	tp_color_display_panel; /* training point color display*/
Widget          canvas, toplevel, colorshell, epshell, prefshell, moreprefshell, creditshell, eplabel;
Arg             args[10];
int             n;
/*********************************************************************************************
 * ENDPOINT  and TRAINPTS[]    are the MAIN DATA STRUCTURES for HU & TP data
 * EndPts stores the endpoints of the lines to be drawn for the hidden units.
 * It is referenced globally through the procedure generate_endpoints(), which calls find_endPts().
 * Also referenced in draw_one_epoch().

 * TrainPts[] array holds coordinates for training data, created in generate_points.
 * Also referenced in draw_training().
 ********************************************************************************************/

 /*Endpoints of every hidden unit line read in from file*/
/*
XPoint endPts[MaxEpochs][numEndPts];      
*/

struct EndPoints
{
  float x;
  float y;
} endPts[MaxEpochs][numEndPts];

struct coords
{
  float x;                        /*coords of training point                */
  float y;
  char result[5];               /*name of class of training point        */
  int  result_class;            /*class of training point, as an integer */
  int reslength;                /*length of class string, set in generate_points(), used in draw_train()*/
} TrainPts[MaxPts]; /* stores coordinates to draw the training data */


int	totalClasses;
int	totalHU;
