/* Main program for the Hyperplane Animator */


#include "animator.h"
#include "prefchanges.h"

/*declarations for proc's used internally */
		/*Callbacks for menu choices              */
void init();
void start();
void pause();
void resume();
void quit();
void newfile();
void filechoice();
void file_read();
void create_gc();

		/*File read, data conversion, draw routines*/
void draw_one_epoch();
void draw_all_epochs();
void draw_training();
void generate_endPts();
void generate_points();

		/*Preferences menu, epochs box */
void make_prefs();
void make_epochshow();
void show_prefs();
void show_more();
void show_color();
void show_credits();
void update_epochshow();

void redisplay();
void change_screensize();

void	redraw();

/* Vars set during file read, or used during screen draws*/
int     epochN = 1;                             /*current epoch number*/
int     previousEpoch=1;
int     totalEpoch = 0;
int     totalTP = 0;                            /*total num of TPs in file                          */
int     totalHU = 0;                            /*total num of HUs in file                          */

/**************************************************************************
				MAIN
 *************************************************************************/
main(argc, argv)
        int     argc;
        char   *argv[];
{
        Widget  framework, commands, 
		quitbutton, startbutton, pausebutton, contbutton, 
		filebutton, colorbutton, prefsbutton,creditsbutton, 
		separator1;
	line_data	data;	
        int 		n = 0;
	int	 	junk = 5;
        Arg     args[10];

/***********************init and size toplevel widget********************/

toplevel = XtInitialize (argv[0], "Main", NULL, 0, &argc, argv);
n=0;
XtSetArg(args[n], XtNwidth,  800); n++;
XtSetArg(args[n], XtNheight, 800); n++;
XtSetValues(toplevel, args, n);

/************************form, drawing area and place to put command buttons***************************/

framework = XtCreateManagedWidget("framework", xmFormWidgetClass, toplevel, args, n);

canvas  = XtCreateManagedWidget("canvas", xmDrawingAreaWidgetClass,
                                framework, NULL, 0);
commands = XtCreateManagedWidget("Commands", xmRowColumnWidgetClass, framework, NULL, 0);

				/*command "menu" buttons*/
filebutton  = XtCreateManagedWidget("FILE",    xmPushButtonWidgetClass, commands, NULL, 0);
quitbutton =  XtCreateManagedWidget("QUIT",    xmPushButtonWidgetClass, commands, NULL, 0);
startbutton = XtCreateManagedWidget("START/REPEAT",   xmPushButtonWidgetClass, commands, NULL, 0);
pausebutton=  XtCreateManagedWidget("PAUSE",   xmPushButtonWidgetClass, commands, NULL, 0);
contbutton =  XtCreateManagedWidget("RESUME",  xmPushButtonWidgetClass, commands, NULL, 0);
colorbutton = XtCreateManagedWidget("COLORS",  xmPushButtonWidgetClass, commands, NULL, 0);
prefsbutton = XtCreateManagedWidget("PREFS",   xmPushButtonWidgetClass, commands, NULL, 0);
creditsbutton=XtCreateManagedWidget("CREDITS", xmPushButtonWidgetClass, commands, NULL, 0);


/*packing and arranggement for commands widget*/
n=0;
XtSetArg(args[n], XmNorientation,       XmHORIZONTAL);          n++;
XtSetArg(args[n], XmNpacking,           XmPACK_TIGHT);          n++;
XtSetArg(args[n], XmNtopAttachment,     XmATTACH_FORM);         n++;
XtSetArg(args[n], XmNleftAttachment,    XmATTACH_FORM);         n++;
XtSetArg(args[n], XmNrightAttachment,   XmATTACH_FORM);         n++;
XtSetArg(args[n], XmNspacing,		20	     );		n++;
XtSetValues(commands, args, n);

separator1 = XtCreateManagedWidget("separator", xmSeparatorWidgetClass, framework, NULL, 0);
n=0;
XtSetArg(args[n], XmNtopAttachment,     XmATTACH_WIDGET);       n++;
XtSetArg(args[n], XmNtopWidget,         commands       );       n++;
XtSetArg(args[n], XmNleftAttachment,    XmATTACH_FORM);         n++;
XtSetArg(args[n], XmNrightAttachment,   XmATTACH_FORM);         n++;
XtSetValues(separator1, args, n);

		/*Finally, set the canvas in place */
n = 0;
XtSetArg(args[n], XmNtopAttachment,     XmATTACH_WIDGET);       n++;
XtSetArg(args[n], XmNtopWidget,         separator1);            n++;
XtSetArg(args[n], XmNbottomAttachment,  XmATTACH_FORM);         n++;
XtSetArg(args[n], XmNleftAttachment,    XmATTACH_FORM);         n++;
XtSetArg(args[n], XmNrightAttachment,   XmATTACH_FORM);         n++;
XtSetValues(canvas, args, n);

/**************************CALLBACKS *********************************/
XtAddCallback(filebutton,    XmNactivateCallback, newfile,    &data);
XtAddCallback(quitbutton,    XmNactivateCallback, quit,       &data);
XtAddCallback(startbutton,   XmNactivateCallback, start,      &data);
XtAddCallback(contbutton,    XmNactivateCallback, resume,     &data);
XtAddCallback(colorbutton,   XmNactivateCallback, show_color, &data);
XtAddCallback(prefsbutton,   XmNactivateCallback, show_prefs, &data);
XtAddCallback(creditsbutton, XmNactivateCallback, show_credits,&data);

XtAddCallback(canvas, 	     XmNexposeCallback,   redisplay,            &data);
XtAddCallback(canvas,        XmNresizeCallback,   change_screensize, &data);

XtAddEventHandler(pausebutton, ButtonPressMask, FALSE, pause, &data);
				/*pause added as event handler but may be changed back to callback*/

create_gc(canvas, &data);	/*create all Graphic Contexts (GCs) used by HUs, TP, axes */
make_prefs(&data);		/*Create preferences widget, and all children for it      */
make_credits();			/*Create credits widget, in extern file credits           */
make_epochshow();
make_coloredit(&data);

XtManageChild(commands);
XtManageChild(separator1);
XtManageChild(canvas);
cdpy = XtDisplay(canvas);

XtRealizeWidget(toplevel);

XSetWindowColormap(dpy, XtWindow(toplevel), my_colormap);       /*set colormap for main app   */

change_screensize(canvas, &data);		/*not really changing, initializing ScreenSize */

XtMainLoop();
}

/***********************************************************************
 *		START and QUIT, INIT,  NEWFILE
 ***********************************************************************/
/*START does file read and begins animation.  Probably the file reads and
 *conversion of data should be done in newfile()
 */
void start(w, data, call_data)
        Widget          w;
        line_data       *data;
        XmAnyCallbackStruct *call_data;
{
init(data);
Pause = FALSE;
							/*place draw_all_epochs on Timeout Queue */
XtAddTimeOut(data->delay, draw_all_epochs, data);
}

void init(data)
	line_data	*data;
{
epochN = 1;
previousEpoch = 0;
updatenext = 0;
redraw(data);

}
void quit(w, data, call_data)
        Widget          w;
        line_data       *data;
        XmAnyCallbackStruct *call_data;
{
XtCloseDisplay(XtDisplay(w));
exit(0);
}
			/*NEWFILE creates FileSelectionDialog and calls filechoice() directly below */
void newfile(w, data, call_data)
	Widget			w;
	line_data        	*data;
	XmAnyCallbackStruct	*call_data;
{
	Widget	bb, okbutton, filenametext;

bb         = XmCreateFileSelectionDialog(toplevel,"File",NULL, 0);
n=0;
XtSetArg(args[n], XmNautoUnmanage, TRUE);	n++;
XtSetValues(bb, args, n);

XtAddCallback(bb, XmNokCallback, filechoice, data);   /*last arg not used*/ 
XtManageChild(bb);
}
void filechoice(w, data, call_data)
       Widget          				w;
       line_data				*data;
       XmFileSelectionBoxCallbackStruct 	*call_data;
{
	char *fname;
if (call_data->reason==XmCR_OK)
        {
	XmStringGetLtoR(call_data->value, XmSTRING_DEFAULT_CHARSET, &fname);

	XtUnmanageChild(w);
	XFlush(cdpy);

file_read (fname, &totalEpoch, &totalHU, &totalTP);
init(data);

}
}


/************************************************************************
 *		PAUSE , RESUME and REPEAT
 ************************************************************************/
void pause(w, data, event)
	Widget		w;
	line_data	*data;
	XEvent		*event;
{
Pause = TRUE;
}
		
void resume(w, data, call_data)
	Widget		w;
	line_data		*data;
	XmAnyCallbackStruct  *call_data;
{
Pause = FALSE;
XtAddTimeOut(data->delay, draw_all_epochs, data);
}

/************************************************************************
 *		DRAW_ALL_EPOCHS
 *Draws the current epoch, by: drawing previous line w/ background color,
			       drawing training data
			       drawing new line. 
If not done yet, places draw_all_epochs back on Timeout Queue. 
 ************************************************************************/
void draw_all_epochs(data)
        line_data       *data;
{
	int	i, curHU; 
	static XEvent	event;
			
			/*this was inserted only because w/ some demos, we had problems getting the
			 *processors attention to Pause, Quit, or perform some preference option 
			 *If ANY other event in queue, put self back on timeout queue, end routine */
if(XtPending())
{
	XtNextEvent(&event);
	XtDispatchEvent (&event);
	 XtAddTimeOut(data->delay, draw_all_epochs, data);
}
else
{

if (epochN <= totalEpoch) {

	draw_one_epoch(data);

	update_epochshow();		/*update the "Epochs" window showing current epoch */

	previousEpoch = epochN;

	if (epochN < totalEpoch) 	/* if not done yet */
        {				/* inc by one, or inc by user-requested interval */
	   if (epochN < beginskip) epochN++;
               else       epochN = epochN + skipinterval;

					/*if overshot the total, set to total */
	   if (epochN > totalEpoch) epochN = totalEpoch;

	   if (!Pause)	
		XtAddTimeOut(data->delay, draw_all_epochs, data);
	}
				/*else epoch=totalEpoch and we're done.  If in demo-mode
				 *pause a little, and start again */
	else if (DemoMode)
		{
		init(data);
		XtAddTimeOut(1000, draw_all_epochs, data); 
		}
}
}
}

/************************************************************************
 *            REDRAW 
 ************************************************************************/
void redraw(data)
        line_data       *data;
{
XClearWindow(XtDisplay(canvas), XtWindow(canvas));
if (Pause || epochN==totalEpoch || epochN==1);
   {                              /*if currently running animation, do nothing */
   epochN=previousEpoch;          /*otherwise, redraw current epoch            */
   draw_one_epoch(data, NULL);
   draw_one_epoch(data);
}
}

/************************************************************************
 *              DRAW_ONE_EPOCH
 *Simple line-draw.  Erases previous line, draws new one.
 ************************************************************************/
void draw_one_epoch(data)
	line_data	*data;
{
	int	curHU, i,j;

curHU = 0;
for ( i=0,j=0 ; i < 2 * totalHU ; j++)
        {
	XDrawLine(cdpy, XtWindow(canvas),     data->erasegc[curHU],
                translate('x', endPts[previousEpoch][i].x   ),
                translate('y', endPts[previousEpoch][i].y   ),
                translate('x', endPts[previousEpoch][i+1].x ),
                translate('y', endPts[previousEpoch][i+1].y ));

	if (ShowLine[j])
	   {
	   XDrawLine(cdpy, XtWindow(canvas), data->gc[curHU],
                translate('x', endPts[epochN][i].x   ),
                translate('y', endPts[epochN][i].y   ),
                translate('x', endPts[epochN][i+1].x ),
                translate('y', endPts[epochN][i+1].y ));
	   }
	i = i+2;
	curHU++ ;       /* i+2 because each endPts[ ][ ] holds only one endpt */
	}

	draw_training(data);

}

/************************************************************************
 *		DRAW TRAINING POINTS 
 ************************************************************************/
void draw_training(data)
	line_data	*data;
{
	int i;
			/*draw X and Y axes*/
			/*CHANGE hard-code numbers to XSCREEN & YSCREEN */
   XDrawLine(cdpy, XtWindow(canvas), data->axesgc, 
				translate('x', -1.0), translate('y', 0.0), 
				translate('x', 1.0),  translate('y', 0.0));
   XDrawLine(cdpy, XtWindow(canvas), data->axesgc, 
				translate('x', 0.0), translate('y', 1.0), 
				translate('x', 0.0), translate('y', -1.0));

for (i = 0; i < totalTP; i++)	/*totalTP: total num of Training Points read from file */
				/*Each TP uses a GC corresponding to its class: result_class */
   {
   if (ShowPoints)
	{
	XFillRectangle(cdpy, XtWindow(canvas),  data->train_gc[TrainPts[i].result_class], 
		translate('x', TrainPts[i].x)  - pointsize ,   
		translate('y', TrainPts[i].y)  - pointsize ,   
		             2*pointsize,                2*pointsize );
	}
   else
	{
        XDrawString(cdpy, XtWindow(canvas), data->train_gc[TrainPts[i].result_class], 
			       translate('x', TrainPts[i].x),
			       translate('y', TrainPts[i].y),
                		TrainPts[i].result, TrainPts[i].reslength); 
	}
	
   }
}


/*****************************************************************
 * TRANSLATES  points to relative locations on the screen         *
 *****************************************************************/ 
			/*  Y_SCREEN and X_SCREEN are #defined at top to be 1/2 of the total screen size */
int translate(axis, ptvalue)
     char axis;
     float ptvalue;
{
  if (axis == 'x') return(ScreenSize + ScreenSize * ptvalue * compress + x_offset);
   else            return(ScreenSize - ScreenSize * ptvalue * compress + y_offset);
}

/*****************************************************************************************
 *                Create an ARRAY of  simple GC
 *Create MaxHu GCs for HU lines, MaxClasses GC for TP, and GC for axes
 *****************************************************************************************/
void create_gc(w, data)
        Widget  	w;
	line_data	*data;
{
        XGCValues       values;
	Display		*wdpy;
        Arg             wargs[10];
	int		i, j ;
wdpy = XtDisplay(w);

				/*Get current values for the widget */
XtSetArg(wargs[0], XtNforeground, &values.foreground); 
XtSetArg(wargs[1], XtNbackground, &values.background); 
XtGetValues(w, wargs, 2);			

data->pixelno[BGpixel] = values.background;  /* BGpixel is #defined as 2 greater than 
					      * MaxHU + MaxClasses
					      */

/***************************************************************************
			GC for HU LINES
****************************************************************************/
		/* VARIOUS colors for the GCs */

				/*Starting at LINE_PIXELINIT, #defined high enough to avoid low pix no's,
 				 *eg 30, load GC w/ different pix no.
				 *VARIOUS colors NOT currently used */
for (i = 0 ; i < MaxHu; i++ )
{
values.foreground = i+LINE_PIXELINIT ; 
values.line_style = LineSolid;
data->holdgc[i] =  XCreateGC(wdpy, DefaultRootWindow(wdpy), 
                        GCForeground | GCBackground | GCLineStyle, &values);
}

		/*ONE color for all GCs */
						/*load all w/ same color. data.gc is MAIN
						 *GC used for HU lines */ 
for (i = 0 ; i < MaxHu; i++ )
{
values.foreground = LINE_PIXELINIT ;
values.line_style = LineSolid;
data->pixelno[i]=LINE_PIXELINIT ;
data->gc[i] = XCreateGC(wdpy, DefaultRootWindow(wdpy), 
			GCForeground | GCBackground | GCLineStyle, &values);
}
						
	/*get second GC  w/ foreground set to background, for erasing line */
for (i=0 ; i < MaxHu; i++)
{
XtSetArg(wargs[1], XtNbackground, &values.background);
XtGetValues(w, wargs, 2);
values.foreground = values.background;
data->erasegc[i] = XCreateGC(wdpy, DefaultRootWindow(wdpy), 
			GCForeground | GCBackground | GCLineStyle, &values); 
}


/***************************************************************************
                       GC for TRAINING POINTS 
****************************************************************************/
					/*Load w/ pixel no beginning at TP_PIXELINIT
					 *data.train_gc is MAIN array for TP GCs */
for (i = 0 ; i < MaxClasses; i++)
{
values.foreground = i+TP_PIXELINIT;
values.line_style = LineSolid;
data->pixelno[MaxHu+i]= i+TP_PIXELINIT;
data->train_gc[i] =  XCreateGC(wdpy, DefaultRootWindow(wdpy), 
			GCForeground | GCBackground | GCLineStyle, &values); 
}

/***************************************************************************
                    GC for AXES 
****************************************************************************/
					/*Arbitrary init PIXELBLACK, which is NOT black */
values.foreground = PIXELBLACK ;
values.line_style = LineSolid;
data->pixelno[AXpixel] = PIXELBLACK;
data->axesgc =       XCreateGC(wdpy, DefaultRootWindow(wdpy), 
				GCForeground | GCBackground | GCLineStyle, &values); 
}


/**********************************************************************
	 CREATE EPOCHSHOW,   UPDATE SHOWEPOCH	and   RAISE WINDOW 
 * CREATE_EPOCHSOW 
 * Creates stand-alone window to show epochs.
 * The show Widget is updated from draw_all_epochs
 * update_epochshow writes to label widget
************************************************************************/
void make_epochshow()
{
		/*make & size "Epochs" shell */
n = 0;
XtSetArg(args[n], XmNtitle,     "Epochs" );  	n++;
XtSetArg(args[n], XtNwidth,         200  );	n++;
XtSetArg(args[n], XtNheight,         30  );     n++;
epshell = XmCreateBulletinBoardDialog(toplevel, "Epochs", args, n);
eplabel = XtCreateManagedWidget("Display", xmLabelWidgetClass, epshell, NULL, 0);
}
void update_epochshow()
			/*write epoch num & percent completed to label widget */
{
	int	percentdone;
percentdone = (100*epochN) / totalEpoch ;
							/*use #define INTERVALPERCENT to update only at */
 if (percentdone > updatenext || epochN==totalEpoch)	/*regular intervals.  Update at end also	*/
                {
                xs_wprintf(eplabel, "Epoch %i   %i percent completed", epochN, percentdone);
                updatenext = updatenext + INTERVALPERCENT;
                }

}   

