
/*
 *	ROXANNE - Read only X ANN emulator.
 */

#include <stdio.h>
#include <math.h>
#include <X11/Intrinsic.h>	/* Include standard Toolkit Header file. */
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include "map.h"

extern	int	open_new_window();
extern	void	create_widgets();

void	set_gc_and_attributes();
Widget	toplevel;
XStuff	X;

main(argc, argv)
int argc;
char **argv;
{
	XtAppContext	app_con;

	XtToolkitInitialize();
	app_con = XtCreateApplicationContext();
	X.dpy = XtOpenDisplay(app_con, NULL, "Xhm", "Kohonen Map", NULL, 0, &argc, argv);
	if (argc != 1) {
		XtDestroyApplicationContext(app_con);
		fprintf(stderr, "Usage: %s\n", argv[0]);
		exit(1);
	}
	toplevel = XtAppCreateShell(NULL, "Kohonen Map", applicationShellWidgetClass, X.dpy, NULL, 0);
	X.scr = DefaultScreenOfDisplay(X.dpy);
	X.gc = XCreateGC(X.dpy, RootWindowOfScreen(X.scr), 0, (XGCValues *)NULL);
	X.gcd = XCreateGC(X.dpy, RootWindowOfScreen(X.scr), 0, (XGCValues *)NULL);
	set_gc_and_attributes(toplevel);
	create_widgets(toplevel);
	XtRealizeWidget(toplevel);
	open_new_window();
	XtAppMainLoop(app_con);
	exit(0);
}

/*
 *	Finds the user-specified foreground and background by querying
 *	the resource manager, and sets state accordingly.
 */
void
set_gc_and_attributes(w)
Widget		w;
{
	static	char	dash_list[] = {12, 6};
	static	XtResource resources[] = {
		XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
		XtOffset(XStuff *, foreground), XtRString, XtDefaultForeground,
		XtNbackground, XtCBackground, XtRPixel, sizeof(Pixel),
		XtOffset(XStuff *, background), XtRString, XtDefaultBackground
	};

	XtGetApplicationResources(w, (caddr_t) &X, resources, XtNumber(resources), NULL, 0);
	X.gcv.foreground = X.foreground;
	X.gcv.background = X.background;
	XSetBackground(X.dpy, X.gc, X.background);
	XSetForeground(X.dpy, X.gc, X.foreground);
	XSetBackground(X.dpy, X.gcd, X.foreground);
	XSetForeground(X.dpy, X.gcd, X.background);
	XSetLineAttributes(X.dpy, X.gcd, 0, LineDoubleDash, CapButt, JoinMiter);
	XSetDashes(X.dpy, X.gcd, 0, dash_list, 2);
}
